<?php

class ProjectController extends Controller
{

    public function accessRules()
    {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'ChangeSubCategory', 'GetProductList', 'LabourDetails', 'ProposalcostDetails', 'GetList',
                    'Save', 'GetProductList', 'LabourDetails', 'ProposalcostDetails', 'GetProjectNames', 'ActualLabourDetails', 'deleteProposals', 'ActualMaterialDetails', 'ActualTotalCostDetails',
                    'GetProjectDetails', 'GetProjectPhase', 'GettaskSubCategories', 'GetMemberTaskVariance', 'GetJobs', 'GetCust', 'GetJobs1', 'GetJobDet', 'Deleteproj', 'addPhase', 'GetEstimationProductList',
                    'Gethourlytaskrate', 'PrintProjectEstimationReportPDF', 'PrintProjectActicity', 'Deleteuploadedfile', 'RemovelineItem', 'RemoveExpense', 'RemovequipmentlineItem', 'Createnew', 'Savenew', 'RemoveInductionlineItem', 'RemoveMemolineItem', 'Removedailyschedule', 'Createsubmitedschedule', 'SaveSubmiteddetails', 'PrintProjectInductionDailySchedule', 'RemoveRework', 'GetProducts', 'UploadMemopic', 'DownloadProjectMemoDoc', 'GetProjectActivities', 'RemoveActivitylineItem', 'Reloadactivity', 'AddActivity', 'Removeshedule', 'PrintSubmittedSchedule'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex()
    {
 
        $this->render('index');
    }


    public function filters()
    {

        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList()
    {

        $model = new WsProject();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(
            // datatable column index  => database column name

            0 => 't.id',
            1 => 'project_name',
            2 => 'project_date',
            3 => 'location',
            4 => 'manager_name'
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        //   $condition = '1=1';

        $condition = 't.isActive="Y"';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " and (project_name LIKE '%" . $searchString . "%' OR manager_name LIKE '%" . $searchString . "%' OR location LIKE '%" . $searchString . "%')";
        }

        $count = $model->with('employeedetails')->count(array('condition' => $condition));

        $model = $model->with('employeedetails')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;


        foreach ($model as $row) {
            $rowData[] = array($row['id'],
                $row['project_name'],
                date("d/m/Y", strtotime($row['project_date'])),
                $row['location'],
                $row['employeedetails']['employeefullname'],
                array('id' => $row['id'], 'code' => $row['project_name']));
            $m++;
        }

        //$scheduledType_list = WsMasterSubmittedSheduleType::getScheduledType();
        // $rowData1 = array();
        // $modelWsMasterSubmittedSheduleType = new WsMasterSubmittedSheduleType();
        // $conditionx = 'is_active="Y"';
        // $modelWsMasterSubmittedSheduleType_list = $modelWsMasterSubmittedSheduleType->findAll(array('condition' => $conditionx));

        // $m1 = 1;
        // foreach ($modelWsMasterSubmittedSheduleType_list as $scheduledType) {
        //     $rowData1[] = 
        //         array('scheduled_type_id' => $scheduledType['id'],'scheduled_type' => $scheduledType['scheduled_type']);
        //     $m1++;
        // }

       //$data['datax'] = $rowData1;

        $data['data'] = $rowData;
      

       // $data['data'] = array_merge($rowData1,$rowData);

        echo json_encode($data);
    }

    // code updated By Nisha on 25-04-2022
    // added material cost tab
    // tables ws_project_phase,ws_project_phase_details

    public function actionCreate()
    {
        $model = new WsProject();
        $modelTaskBreakup = array(new WsProjectTaskBreakup());
        $modelTimesheet = array(new WsProjectTimeSheet());
        $model_phase = array(new WsProjectPhase());
        $modal_phase_details = new WsProjectPhaseDetails();
        $modal_estimation_details = array(new WsProjectEstimationDetails());
        $modelCostDetails = new WsProjectPhaseCostDetails();
        $modelLabourTime = array(new WsProjectLabourTime());
        $modelTimesheetStaff = array(new WsProjectWorkTime());
        $modelJobSheet = array(new WsProjectJobSheet());
        $cost_phase_details= array(new WsProjectEstimationDetails());
        $project_id = (int)Yii::app()->request->getParam('project_id');
        $page='';
        if ($project_id > 0) {
            $model = $model->findByPk($project_id);
            $modelTaskBreakup = WsProjectTaskBreakup::model()->findAll(array('condition' => 'project_id=' . $project_id));
            if (empty($modelTaskBreakup)) {
                $modelTaskBreakup = array(new WsProjectTaskBreakup());
            }
            $modelJobSheet = WsProjectJobSheet::model()->findAll(array('condition' => 'project_id=' . $project_id));
            if (empty($modelJobSheet)) {
                $modelJobSheet = array(new WsProjectJobSheet());
            }
            $modelTimesheet = WsProjectTimeSheet::model()->findAll(array('condition' => 'project_id=' . $project_id));
            if (empty($modelTimesheet)) {
                $modelTimesheet = array(new WsProjectTimeSheet());
            }

            $modelCostDetails = WsProjectPhaseCostDetails::model()->find(array('condition' => 'project_id=' . $project_id));
            if (empty($modelCostDetails)) {
                $modelCostDetails = new WsProjectPhaseCostDetails();
            }
            $modelLabourTime = WsProjectLabourTime::model()->findAll(array('condition' => 'project_id=' . $project_id));
            if (empty($modelLabourTime)) {
                $modelLabourTime = array(new WsProjectLabourTime());
            }
            $modelTimesheetStaff = WsProjectWorkTime::model()->findAll(array('condition' => 'project_id=' . $project_id, 'group' => 'project_id,work_date', 'order' => 'work_date desc'));
            $modal_phase_details = WsProjectPhaseDetails::model()->find(array('condition' => 'project_id=' . $project_id));
            if (empty($modal_phase_details)) {
                $modal_phase_details = new WsProjectPhaseDetails();
            } else {

                /*  THIS CODE USED FOR ALL DATA GET IN BOM TAB. So uswed store model used with this */

                $model_store = Store::model()->findAll(array('condition' => 'generic_id="' . $modal_phase_details->category_id . '"'));
                foreach ($model_store as $i => $eachStore) {
                    $modal_estimation_details[$i] = new WsProjectEstimationDetails();
                    $model_enquiry_details = WsProjectEstimationDetails::model()->find(array('condition' => 'project_id="' . $project_id . '" 
                                                                                         and product_id=' . $eachStore->id . ''));

                    if (!empty($model_enquiry_details)) {
                        $modal_estimation_details[$i]->id = $model_enquiry_details['id'];
                        $modal_estimation_details[$i]->description = $model_enquiry_details['description'];
                        $modal_estimation_details[$i]->project_id = $model_enquiry_details['project_id'];
                        $modal_estimation_details[$i]->product_id = $model_enquiry_details['product_id'];
                        $modal_estimation_details[$i]->phase_id = $model_enquiry_details['phase_id'];
                        $modal_estimation_details[$i]->size = $model_enquiry_details['size'];
                        $modal_estimation_details[$i]->brand = $model_enquiry_details['brand'];
                        $modal_estimation_details[$i]->brand_name = $eachStore->brand_detail->product_class;
                        $modal_estimation_details[$i]->quantity = $model_enquiry_details['quantity'];
                        $modal_estimation_details[$i]->unit = $model_enquiry_details['unit'];
                        $modal_estimation_details[$i]->unit_price = $model_enquiry_details['unit_price'];
                        $modal_estimation_details[$i]->total_material_cost = $model_enquiry_details['total_material_cost'];
                    } else {
                        $modal_estimation_details[$i]->description = $eachStore['description'];
                        $modal_estimation_details[$i]->product_id = $eachStore['id'];
                        $modal_estimation_details[$i]->brand = $eachStore->brand_detail->id;
                        $modal_estimation_details[$i]->brand_name = $eachStore->brand_detail->product_class;
                        //  $model_details->quantity = $value['quantity'];
                        $modal_estimation_details[$i]->unit = $eachStore->unit->unit_name;
                        $modal_estimation_details[$i]->unit_price = $eachStore->rate;
                        $modal_estimation_details[$i]->phase_id = $modal_phase_details->phase_id;
                        $modal_estimation_details[$i]->quantity = 0;
                        $modal_estimation_details[$i]->total_material_cost = 0;
                    }
                }
            }

            $cost_phase_details = WsProjectEstimationDetails::model()->findAll(array('condition' => 'project_id="' . $model->id . '"', 'group' => '`phase_id`'));


            // $modal_estimation_details         = WsProjectEstimationDetails::model()->findAll(array('condition'=>'project_id='.$project_id));
            if (empty($modal_estimation_details)) {
                $modal_estimation_details = array(new WsProjectEstimationDetails());
            }
        }
       
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model, 'modelTaskBreakup' => $modelTaskBreakup, 'model_phase' => $model_phase, 'modal_phase_details' => $modal_phase_details, 'modal_estimation_details' => $modal_estimation_details, 'modelTimesheet' => $modelTimesheet, 'modelJobSheet' => $modelJobSheet, 'cost_phase_details' => $cost_phase_details, 'modelCostDetails' => $modelCostDetails, 'modelLabourTime' => $modelLabourTime, 'modelTimesheetStaff' => $modelTimesheetStaff, 'project_id' => $project_id,'page'=>$page), false, false);
    }

    public function actionSave17_08_2022()
    {
        $flag = 0;
        $model = new WsProject();
        $other = array();
        if (isset($_POST['WsProject'])) {
            if ((int)$_POST['WsProject']['id'] > 0) {
                $id = $_POST['WsProject']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $flag = 1;
            }
            $validate = TRUE;
            $model->attributes = $_POST['WsProject'];
            $model->admin_percentage = $_POST['WsProject']['admin_percentage'];
            $model->profit_percentage = $_POST['WsProject']['profit_percentage'];
            $model->customer_id = $_POST['WsProject']['customer_id'];
            if ($_POST['WsProject']['project_date'] != '') {
                $model->project_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['WsProject']['project_date'])));
            }
            if ($_POST['WsProject']['project_type'] != '') {
                $model->project_type = $_POST['WsProject']['project_type'];
            }
            if ($_POST['WsProject']['notes'] != '') {
                $model->notes = $_POST['WsProject']['notes'];
            }
            if ($_POST['WsProject']['engineer_notes'] != '') {
                $model->engineer_notes = $_POST['WsProject']['engineer_notes'];
            }
            if ($_POST['WsProject']['status'] != '') {
                $model->status = $_POST['WsProject']['status'];
            }
            if ($_POST['WsProject']['project_manager_notes'] != '') {
                $model->project_manager_notes = $_POST['WsProject']['project_manager_notes'];
            }


            $validate = $model->validate();
            //Modified by Dikson R on 13/5/2022
            if (isset($_POST['WsProjectTaskBreakup'])) {
                $i = 0;
                foreach ($_POST['WsProjectTaskBreakup'] as $l => $items) {
                    if ($items['task_category_id'] > 0) {
                        if ($items['id'] > 0) {
                            $modelTaskBreakup[$i] = WsProjectTaskBreakup::model()->findByPK($items['id']);
                            $modelTaskBreakup[$i]->updated_by = Yii::app()->user->id;
                            $modelTaskBreakup[$i]->updated_date_time = date('Y-m-d H:i:s');
                        } else {
                            $modelTaskBreakup[$i] = new WsProjectTaskBreakup();
                            $modelTaskBreakup[$i]->created_by = Yii::app()->user->id;
                            $modelTaskBreakup[$i]->created_date_time = date('Y-m-d H:i:s');
                        }
                        $modelTaskBreakup[$i]->task_category_id = $items['task_category_id'];
                        if ($items['task_subcategory_id'] > 0) {
                            $modelTaskBreakup[$i]->task_subcategory_id = $items['task_subcategory_id'];
                        } else {
                            $modelTaskBreakup[$i]->task_subcategory_id = 0;
                        }
                        $modelTaskBreakup[$i]->assigned_person = $items['assigned_person'];
                        $modelTaskBreakup[$i]->budget_task_hours = $items['budget_task_hours'];
                        $modelTaskBreakup[$i]->task_actual_hours = $items['task_actual_hours'];
                        $modelTaskBreakup[$i]->variance = $items['variance'];
                        $modelTaskBreakup[$i]->task_cost = $items['task_cost'];
                        $modelTaskBreakup[$i]->variance_notes = $items['variance_notes'];
                        $modelTaskBreakup[$i]->percent_of_completion = 0;
                        if ($items['task_start_date'] != '00/00/0000' && $items['task_start_date'] != '') {
                            $modelTaskBreakup[$i]->task_start_date = date("Y-m-d H:i", strtotime(str_replace('/', '-', $items['task_start_date'])));
                        }
                        if ($items['task_end_date'] != '00/00/0000' && $items['task_end_date'] != '') {
                            $modelTaskBreakup[$i]->task_end_date = date("Y-m-d H:i", strtotime(str_replace('/', '-', $items['task_end_date'])));
                        }
                        $validate = $modelTaskBreakup[$i]->validate() && $validate;
                        $i++;
                    }
                }
            }
            $p = 0;
            if (is_array($_POST['WsProjectJobSheet'])) {

                foreach ($_POST['WsProjectJobSheet'] as $i => $item) {


                    if ((int)$item['id'] > 0) {

                        $modelJobSheet[$p] = WsProjectJobSheet::model()->findByPk((int)$item['id']);
                    } else {

                        $modelJobSheet[$p] = new WsProjectJobSheet;


                        $modelJobSheet[$p]->created_by = Yii::app()->user->id;

                        $modelJobSheet[$p]->created_date_time = date("Y-m-d H:i:s");
                    }

                    $modelJobSheet[$p]->attributes = $_POST['WsProjectJobSheet'][$i];


                    $modelJobSheet[$p]->job_id = $item['job_id'];

                    $modelJobSheet[$p]->customer_id = $item['customer_id'];

                    $modelJobSheet[$p]->status = $item['status'];

                    if ($item['job_date'] != '') {

                        $modelJobSheet[$p]->job_date = str_replace('/', '-', $item['job_date']);

                        $modelJobSheet[$p]->job_date = date("Y/m/d", strtotime($modelJobSheet[$p]->job_date));
                    }


                    $validate = $modelJobSheet[$p]->validate();

                    $p++;
                }
            }


            if (isset($_POST['WsProjectTimeSheet'])) {

                foreach ($_POST['WsProjectTimeSheet'] as $i => $items) {


                    $modelTimesheet[$i] = new WsProjectTimeSheet();


                    if ((int)$items['id'] > 0) {

                        $modelTimesheet[$i] = WsProjectTimeSheet::model()->findByPk((int)$items['id']);
                    } else {

                        $modelTimesheet[$i]->created_by = Yii::app()->user->id;

                        $modelTimesheet[$i]->created_date_time = date("Y-m-d H:i:s");
                    }


                    if ($items['project_task_hours'] != '0') {

                        $modelTimesheet[$i]->project_task_hours = $items['project_task_hours'];
                    }
                }
            }
            /* ------------------------------------------------------------------------------
              Code Added By Nisha  on 03/05/2022
              For labour working hours
              save to table erp_ws_project_labour_time
              ------------------------------------------------------------------------------- */
            if (isset($_POST['WsProjectLabourTime'])) {
                foreach ($_POST['WsProjectLabourTime'] as $i => $items) {
                    $modelLabourTime[$i] = new WsProjectLabourTime();
                    if ((int)$items['id'] > 0) {
                        $modelLabourTime[$i] = WsProjectLabourTime::model()->findByPk((int)$items['id']);
                        $modelLabourTime[$i]->updated_by = Yii::app()->user->id;
                        $modelLabourTime[$i]->updated_date_time = date('Y-m-d h:i:s');
                    } else {
                        $modelLabourTime[$i]->created_by = Yii::app()->user->id;
                        $modelLabourTime[$i]->created_date_time = date('Y-m-d h:i:s');
                    }
                    $modelLabourTime[$i]->total_years = $items['total_years'];
                    $modelLabourTime[$i]->total_days = $items['total_days'];
                    $modelLabourTime[$i]->total_months = $items['total_months'];
                    $modelLabourTime[$i]->total_hours = $items['total_hours'];
                    $modelLabourTime[$i]->phase_id = $items['phase_id'];
                }
            }


            /* ------------------------------------------------------------------------------
              Code Added By Nisha  on 26/04/2022
              For phase estimation  save
              save to table erp_ws_project_phase_details  and ws_project_estimation_details
              ------------------------------------------------------------------------------- */
            $model_phase = new WsProjectPhaseDetails();
            if (isset($_POST['WsProjectPhaseDetails'])) {
                $phase_ids = $_POST['WsProjectPhaseDetails']['phase_id'];
                $category_ids = $_POST['WsProjectPhaseDetails']['category_id'];
                $model_phase_count = WsProjectPhaseDetails::model()->find(array('condition' => 'phase_id="' . $phase_ids . '" and 
                                                                        category_id="' . $category_ids . '"'));
                if ($model_phase_count->id > 0) {
                    $phase_id = $model_phase_count->id;
                    $model_phase = WsProjectPhaseDetails::model()->findByPk($phase_id);
                    $model_phase->updated_by = Yii::app()->user->id;
                    $model_phase->updated_date_time = date('Y-m-d h:i:s');
                } else {
                    // $modal_details = new WsProjectEstimationDetails();
                    $model_phase->created_by = Yii::app()->user->id;
                    $model_phase->created_date_time = date('Y-m-d h:i:s');
                }

                $model_phase->attributes = $_POST['WsProjectPhaseDetails'];
                $model_phase->phase_id = $phase_ids;
                $model_phase->category_id = $category_ids;
                if (!$model->isNewRecord) {
                    $validate = $model_phase->validate() && $validate;
                }
            }

            if (isset($_POST['WsProjectEstimationDetails'])) {
                $i = 0;
                foreach ($_POST['WsProjectEstimationDetails'] as $j => $items) {
                    if ($items['product_id'] > 0 && $items['quantity'] > 0) {
                        if ($items['id'] > 0) {
                            $modal_details[$i] = WsProjectEstimationDetails::model()->findByPK($items['id']);
                            $modal_details[$i]->updated_by = Yii::app()->user->id;
                            $modal_details[$i]->updated_date_time = date('Y-m-d h:i:s');
                        } else {
                            $modal_details[$i] = new WsProjectEstimationDetails();
                            $modal_details[$i]->created_by = Yii::app()->user->id;
                            $modal_details[$i]->created_date_time = date('Y-m-d h:i:s');
                        }
                        $modal_details[$i]->description = $items['description'];
                        $modal_details[$i]->product_id = $items['product_id'];
                        $modal_details[$i]->size = $items['size'];
                        $modal_details[$i]->brand = $items['brand'];
                        $modal_details[$i]->quantity = $items['quantity'];
                        $modal_details[$i]->unit = $items['unit'];
                        $modal_details[$i]->total_material_cost = $items['total_material_cost'];
                        $modal_details[$i]->unit_price = $items['unit_price'];
                        $validate = $modal_details[$i]->validate() && $validate;
                        $i++;
                    }
                }
            }
            /* -------------------------------------------------------------------------------
              code End save  erp_ws_project_phase_details and ws_project_estimation_details
              --------------------------------------------------------------------------------- */


            if ($validate) {

                $model->save();


                /*Modified by Dikson R to Remove entry deletion code on 13/5/2022 */
                if (!empty($modelTaskBreakup)) {
                    foreach ($modelTaskBreakup as $eachTaskBreakup) {
                        $eachTaskBreakup->project_id = $model->id;
                        $eachTaskBreakup->save();
                    }
                }
                /**********End****/


                if (!empty($modelJobSheet)) {

                    foreach ($modelJobSheet as $eachJobSheet) {

                        $eachJobSheet->project_id = $model->id;

                        $eachJobSheet->save(false);
                    }
                }


                if (!empty($modelTimesheet)) {

                    //WsProjectTimeSheet::model()->deleteAll('project_id=:refer_id', array(':refer_id' => $model->id));

                    foreach ($modelTimesheet as $eachModel) {

                        $eachModel->project_id = $model->id;

                        $eachModel->save(false);
                    }
                }
                /* ------------------------------------------------------------------------------
                  Code Added By Nisha  on 26/04/2022
                  For phase estimation  save
                  save to table erp_ws_project_phase_details  and ws_project_estimation_details
                  ------------------------------------------------------------------------------- */
                if (!empty($model_phase)) {
                    if ($phase_ids > 0) {
                        $model_phase->project_id = $model->id;
                        $model_phase->save(false);
                    }
                }


                if (!empty($modal_details)) {
                    foreach ($modal_details as $eachModel) {
                        $eachModel->project_id = $model->id;
                        $eachModel->phase_id = $model_phase->phase_id;
                        $eachModel->category_id = $model_phase->category_id;
                        $eachModel->save(false);
                    }
                }

                /* ------------------------------------------------------------------------------
                  save to table erp_ws_project_phase_details  and ws_project_estimation_details
                  End Code
                  ------------------------------------------------------------------------------- */

                /*  Code added by nisha on 03/05/2022 */

                if (!empty($modelLabourTime)) {
                    foreach ($modelLabourTime as $eachModel) {
                        $eachModel->project_id = $model->id;
                        $eachModel->save(false);
                    }
                }


                $jsonData['status'] = 'success';

                $jsonData['id'] = $model->id;

                echo CJSON::encode($jsonData);
            } else {

                $error = json_decode(CActiveForm::validate($model, '', false), true);


                $error1 = array();

                if (!empty($modelTaskBreakup)) {

                    $error1 = json_decode(CActiveForm::validate($modelTaskBreakup, '', false), true);
                }


                $error2 = array();


                $error3 = array();

                if (!empty($modelJobSheet)) {

                    $error3 = json_decode(CActiveForm::validate($modelJobSheet, '', false), true);
                }


                $error4 = array();

                if (!empty($modelLabourTime)) {

                    $error4 = json_decode(CActiveForm::validate($modelLabourTime, '', false), true);
                }


                $error5 = array();

                if (!empty($model_phase)) {
                    if (!$model->isNewRecord) {
                        $error5 = json_decode(CActiveForm::validate($model_phase, '', false), true);
                    }
                }


                $error6 = array();

                if (!empty($modal_details)) {

                    $error6 = json_decode(CActiveForm::validate($modal_details, '', false), true);
                }


                $error = CJSON::encode(array_merge_recursive($error, $error1, $error4, $error3, $error2, $error5, $error6));

                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionSave18_08_2022()
    {
        $flag = 0;
        $model = new WsProject();
        $other = array();
        if (isset($_POST['WsProject'])) {
            if ((int)$_POST['WsProject']['id'] > 0) {
                $id = $_POST['WsProject']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $flag = 1;
            }
            $validate = TRUE;
            $model->attributes = $_POST['WsProject'];
            $model->admin_percentage = $_POST['WsProject']['admin_percentage'];
            $model->profit_percentage = $_POST['WsProject']['profit_percentage'];


            $model->customer_id = $_POST['WsProject']['customer_id'];
            if ($_POST['WsProject']['project_date'] != '') {
                $model->project_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['WsProject']['project_date'])));
            }
            if ($_POST['WsProject']['project_type'] != '') {
                $model->project_type = $_POST['WsProject']['project_type'];
            }
            if ($_POST['WsProject']['notes'] != '') {
                $model->notes = $_POST['WsProject']['notes'];
            }
            if ($_POST['WsProject']['engineer_notes'] != '') {
                $model->engineer_notes = $_POST['WsProject']['engineer_notes'];
            }
            if ($_POST['WsProject']['status'] != '') {
                $model->status = $_POST['WsProject']['status'];
            }
            if ($_POST['WsProject']['project_manager_notes'] != '') {
                $model->project_manager_notes = $_POST['WsProject']['project_manager_notes'];
            }


            $validate = $model->validate();
            //Modified by Dikson R on 13/5/2022
            if (isset($_POST['WsProjectTaskBreakup'])) {
                $i = 0;
                foreach ($_POST['WsProjectTaskBreakup'] as $l => $items) {
                    if ($items['task_category_id'] > 0) {
                        if ($items['id'] > 0) {
                            $modelTaskBreakup[$i] = WsProjectTaskBreakup::model()->findByPK($items['id']);
                            $modelTaskBreakup[$i]->updated_by = Yii::app()->user->id;
                            $modelTaskBreakup[$i]->updated_date_time = date('Y-m-d H:i:s');
                        } else {
                            $modelTaskBreakup[$i] = new WsProjectTaskBreakup();
                            $modelTaskBreakup[$i]->created_by = Yii::app()->user->id;
                            $modelTaskBreakup[$i]->created_date_time = date('Y-m-d H:i:s');
                        }
                        $modelTaskBreakup[$i]->task_category_id = $items['task_category_id'];
                        if ($items['task_subcategory_id'] > 0) {
                            $modelTaskBreakup[$i]->task_subcategory_id = $items['task_subcategory_id'];
                        } else {
                            $modelTaskBreakup[$i]->task_subcategory_id = 0;
                        }
                        $modelTaskBreakup[$i]->assigned_person = $items['assigned_person'];
                        $modelTaskBreakup[$i]->budget_task_hours = $items['budget_task_hours'];
                        $modelTaskBreakup[$i]->task_actual_hours = $items['task_actual_hours'];
                        $modelTaskBreakup[$i]->variance = $items['variance'];
                        $modelTaskBreakup[$i]->task_cost = $items['task_cost'];
                        $modelTaskBreakup[$i]->variance_notes = $items['variance_notes'];
                        $modelTaskBreakup[$i]->percent_of_completion = 0;
                        if ($items['task_start_date'] != '00/00/0000' && $items['task_start_date'] != '') {
                            $modelTaskBreakup[$i]->task_start_date = date("Y-m-d H:i", strtotime(str_replace('/', '-', $items['task_start_date'])));
                        }
                        if ($items['task_end_date'] != '00/00/0000' && $items['task_end_date'] != '') {
                            $modelTaskBreakup[$i]->task_end_date = date("Y-m-d H:i", strtotime(str_replace('/', '-', $items['task_end_date'])));
                        }
                        $validate = $modelTaskBreakup[$i]->validate() && $validate;
                        $i++;
                    }
                }
            }
            $p = 0;
            if (is_array($_POST['WsProjectJobSheet'])) {

                foreach ($_POST['WsProjectJobSheet'] as $i => $item) {


                    if ((int)$item['id'] > 0) {

                        $modelJobSheet[$p] = WsProjectJobSheet::model()->findByPk((int)$item['id']);
                    } else {

                        $modelJobSheet[$p] = new WsProjectJobSheet;


                        $modelJobSheet[$p]->created_by = Yii::app()->user->id;

                        $modelJobSheet[$p]->created_date_time = date("Y-m-d H:i:s");
                    }

                    $modelJobSheet[$p]->attributes = $_POST['WsProjectJobSheet'][$i];


                    $modelJobSheet[$p]->job_id = $item['job_id'];

                    $modelJobSheet[$p]->customer_id = $item['customer_id'];

                    $modelJobSheet[$p]->status = $item['status'];

                    if ($item['job_date'] != '') {

                        $modelJobSheet[$p]->job_date = str_replace('/', '-', $item['job_date']);

                        $modelJobSheet[$p]->job_date = date("Y/m/d", strtotime($modelJobSheet[$p]->job_date));
                    }


                    $validate = $modelJobSheet[$p]->validate();

                    $p++;
                }
            }


            if (isset($_POST['WsProjectTimeSheet'])) {

                foreach ($_POST['WsProjectTimeSheet'] as $i => $items) {


                    $modelTimesheet[$i] = new WsProjectTimeSheet();


                    if ((int)$items['id'] > 0) {

                        $modelTimesheet[$i] = WsProjectTimeSheet::model()->findByPk((int)$items['id']);
                    } else {

                        $modelTimesheet[$i]->created_by = Yii::app()->user->id;

                        $modelTimesheet[$i]->created_date_time = date("Y-m-d H:i:s");
                    }


                    if ($items['project_task_hours'] != '0') {

                        $modelTimesheet[$i]->project_task_hours = $items['project_task_hours'];
                    }
                }
            }
            /* ------------------------------------------------------------------------------
              Code Added By Nisha  on 03/05/2022
              For labour working hours
              save to table erp_ws_project_labour_time
              ------------------------------------------------------------------------------- */
            if (isset($_POST['WsProjectLabourTime'])) {
                foreach ($_POST['WsProjectLabourTime'] as $i => $items) {
                    $modelLabourTime[$i] = new WsProjectLabourTime();
                    if ((int)$items['id'] > 0) {
                        $modelLabourTime[$i] = WsProjectLabourTime::model()->findByPk((int)$items['id']);
                        $modelLabourTime[$i]->updated_by = Yii::app()->user->id;
                        $modelLabourTime[$i]->updated_date_time = date('Y-m-d h:i:s');
                    } else {
                        $modelLabourTime[$i]->created_by = Yii::app()->user->id;
                        $modelLabourTime[$i]->created_date_time = date('Y-m-d h:i:s');
                    }
                    $modelLabourTime[$i]->total_years = $items['total_years'];
                    $modelLabourTime[$i]->total_days = $items['total_days'];
                    $modelLabourTime[$i]->total_months = $items['total_months'];
                    $modelLabourTime[$i]->total_hours = $items['total_hours'];
                    $modelLabourTime[$i]->phase_id = $items['phase_id'];
                }
            }


            /* ------------------------------------------------------------------------------
              Code Added By Nisha  on 26/04/2022
              For phase estimation  save
              save to table erp_ws_project_phase_details  and ws_project_estimation_details
              ------------------------------------------------------------------------------- */
            $model_phase = new WsProjectPhaseDetails();
            if (isset($_POST['WsProjectPhaseDetails'])) {
                $phase_ids = $_POST['WsProjectPhaseDetails']['phase_id'];
                $category_ids = $_POST['WsProjectPhaseDetails']['category_id'];
                $model_phase_count = WsProjectPhaseDetails::model()->find(array('condition' => 'phase_id="' . $phase_ids . '" and 
                                                                        category_id="' . $category_ids . '"'));


                if ($model_phase_count->id > 0) {
                    $phase_id = $model_phase_count->id;
                    $model_phase = WsProjectPhaseDetails::model()->findByPk($phase_id);

                    $model_phase->updated_by = Yii::app()->user->id;
                    $model_phase->updated_date_time = date('Y-m-d h:i:s');
                } else {
                    // $modal_details = new WsProjectEstimationDetails();
                    $model_phase->created_by = Yii::app()->user->id;
                    $model_phase->created_date_time = date('Y-m-d h:i:s');
                }

                $model_phase->attributes = $_POST['WsProjectPhaseDetails'];
                $model_phase->phase_id = $phase_ids;
                $model_phase->category_id = $category_ids;
                if (!$model->isNewRecord) {
                    $validate = $model_phase->validate() && $validate;
                }
            }


            if (isset($_POST['WsProjectEstimationDetails'])) {


                $i = 0;

                foreach ($_POST['WsProjectEstimationDetails'] as $j => $items) {


                    if ($items['product_id'] > 0 && $items['quantity'] > 0) {
                        if ($items['id'] > 0) {
                            $modal_details[$i] = WsProjectEstimationDetails::model()->findByPK($items['id']);
                            $modal_details[$i]->updated_by = Yii::app()->user->id;
                            $modal_details[$i]->updated_date_time = date('Y-m-d h:i:s');
                        } else {
                            $modal_details[$i] = new WsProjectEstimationDetails();
                            $modal_details[$i]->created_by = Yii::app()->user->id;
                            $modal_details[$i]->created_date_time = date('Y-m-d h:i:s');
                        }
                        $modal_details[$i]->description = $items['description'];
                        $modal_details[$i]->product_id = $items['product_id'];
                        $modal_details[$i]->size = $items['size'];


                        $modal_details[$i]->brand = $items['brand'];
                        $modal_details[$i]->quantity = $items['quantity'];
                        $modal_details[$i]->unit = $items['unit'];
                        $modal_details[$i]->total_material_cost = $items['total_material_cost'];
                        $modal_details[$i]->unit_price = $items['unit_price'];
                        $validate = $modal_details[$i]->validate() && $validate;
                        $i++;
                    }
                }
            }

            /* -------------------------------------------------------------------------------
              code End save  erp_ws_project_phase_details and ws_project_estimation_details
              --------------------------------------------------------------------------------- */


            if ($validate) {

                $model->save();


                /*Modified by Dikson R to Remove entry deletion code on 13/5/2022 */
                if (!empty($modelTaskBreakup)) {
                    foreach ($modelTaskBreakup as $eachTaskBreakup) {
                        $eachTaskBreakup->project_id = $model->id;
                        $eachTaskBreakup->save();
                    }
                }
                /**********End****/


                if (!empty($modelJobSheet)) {

                    foreach ($modelJobSheet as $eachJobSheet) {

                        $eachJobSheet->project_id = $model->id;

                        $eachJobSheet->save(false);
                    }
                }


                if (!empty($modelTimesheet)) {

                    //WsProjectTimeSheet::model()->deleteAll('project_id=:refer_id', array(':refer_id' => $model->id));

                    foreach ($modelTimesheet as $eachModel) {

                        $eachModel->project_id = $model->id;

                        $eachModel->save(false);
                    }
                }
                /* ------------------------------------------------------------------------------
                  Code Added By Nisha  on 26/04/2022
                  For phase estimation  save
                  save to table erp_ws_project_phase_details  and ws_project_estimation_details
                  ------------------------------------------------------------------------------- */
                if (!empty($model_phase)) {
                    if ($phase_ids > 0) {
                        $model_phase->project_id = $model->id;
                        $model_phase->save(false);
                    }
                }


                if (!empty($modal_details)) {

                    //WsProjectEstimationDetails::model()->deleteAll('project_id=:refer_id', array(':refer_id' => $model->id));

                    foreach ($modal_details as $eachModel) {


                        $eachModel->project_id = $model->id;
                        $eachModel->phase_id = $_POST['WsProjectPhaseDetails']['phase_id'];
                        $eachModel->category_id = $_POST['WsProjectPhaseDetails']['category_id'];
                        $eachModel->save(false);
                    }
                }

                /* ------------------------------------------------------------------------------
                  save to table erp_ws_project_phase_details  and ws_project_estimation_details
                  End Code
                  ------------------------------------------------------------------------------- */

                /*  Code added by nisha on 03/05/2022 */

                if (!empty($modelLabourTime)) {
                    foreach ($modelLabourTime as $eachModel) {
                        $eachModel->project_id = $model->id;
                        $eachModel->save(false);
                    }
                }


                $jsonData['status'] = 'success';

                $jsonData['id'] = $model->id;

                echo CJSON::encode($jsonData);
            } else {

                $error = json_decode(CActiveForm::validate($model, '', false), true);


                $error1 = array();

                if (!empty($modelTaskBreakup)) {

                    $error1 = json_decode(CActiveForm::validate($modelTaskBreakup, '', false), true);
                }


                $error2 = array();


                $error3 = array();

                if (!empty($modelJobSheet)) {

                    $error3 = json_decode(CActiveForm::validate($modelJobSheet, '', false), true);
                }


                $error4 = array();

                if (!empty($modelLabourTime)) {

                    $error4 = json_decode(CActiveForm::validate($modelLabourTime, '', false), true);
                }


                $error5 = array();

                if (!empty($model_phase)) {
                    if (!$model->isNewRecord) {
                        $error5 = json_decode(CActiveForm::validate($model_phase, '', false), true);
                    }
                }


                $error6 = array();

                if (!empty($modal_details)) {

                    $error6 = json_decode(CActiveForm::validate($modal_details, '', false), true);
                }


                $error = CJSON::encode(array_merge_recursive($error, $error1, $error4, $error3, $error2, $error5, $error6));

                if ($error != '[]')
                    echo $error;
            }
        }
    }


    public function actionSave()
    {
        $flag = 0;
        $model = new WsProject();
        $other = array();
        if (isset($_POST['WsProject'])) {
            if ((int)$_POST['WsProject']['id'] > 0) {
                $id = $_POST['WsProject']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $flag = 1;
            }
            $validate = TRUE;
            $model->attributes = $_POST['WsProject'];
            $model->admin_percentage = $_POST['WsProject']['admin_percentage'];
            $model->profit_percentage = $_POST['WsProject']['profit_percentage'];


            $model->customer_id = $_POST['WsProject']['customer_id'];

            if ($_POST['WsProject']['project_date'] != '') {
                $model->project_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['WsProject']['project_date'])));
            }

            if ($_POST['WsProject']['actual_end_date'] != '') {
                $model->actual_end_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['WsProject']['actual_end_date'])));
            }

            if ($_POST['WsProject']['project_type'] != '') {
                $model->project_type = $_POST['WsProject']['project_type'];
            }
            if ($_POST['WsProject']['notes'] != '') {
                $model->notes = $_POST['WsProject']['notes'];
            }
            if ($_POST['WsProject']['engineer_notes'] != '') {
                $model->engineer_notes = $_POST['WsProject']['engineer_notes'];
            }
            if ($_POST['WsProject']['status'] != '') {
                $model->status = $_POST['WsProject']['status'];
            }
            if ($_POST['WsProject']['project_manager_notes'] != '') {
                $model->project_manager_notes = $_POST['WsProject']['project_manager_notes'];
            }


            $validate = $model->validate();





            if (is_array($_POST['WsProjectTaskBreakup'])) {
                foreach ($_POST['WsProjectTaskBreakup'] as $i => $items) {
                        if ($items['id'] > 0) {
                            $modelTaskBreakup[$i] = WsProjectTaskBreakup::model()->findByPK($items['id']);
                            $modelTaskBreakup[$i]->updated_by = Yii::app()->user->id;
                            $modelTaskBreakup[$i]->updated_date_time = date('Y-m-d H:i:s');
                        } else {
                            $modelTaskBreakup[$i] = new WsProjectTaskBreakup();
                            $modelTaskBreakup[$i]->created_by = Yii::app()->user->id;
                            $modelTaskBreakup[$i]->created_date_time = date('Y-m-d H:i:s');
                        }
                        $modelTaskBreakup[$i]->attributes = $items;
                        $modelTaskBreakup[$i]->task_category_id = $items['task_category_id'];
                        if ($items['task_subcategory_id'] > 0) {
                            $modelTaskBreakup[$i]->task_subcategory_id = $items['task_subcategory_id'];
                        } else {
                            $modelTaskBreakup[$i]->task_subcategory_id = 0;
                        }
                        $modelTaskBreakup[$i]->assigned_person = $items['assigned_person'];
                        $modelTaskBreakup[$i]->budget_task_hours = $items['budget_task_hours'];
                        $modelTaskBreakup[$i]->task_actual_hours = $items['task_actual_hours'];
                        $modelTaskBreakup[$i]->variance = $items['variance'];
                        $modelTaskBreakup[$i]->task_cost = $items['task_cost'];
                        $modelTaskBreakup[$i]->variance_notes = $items['variance_notes'];
                        $modelTaskBreakup[$i]->percent_of_completion = 0;
                        if ($items['task_start_date'] != '00/00/0000' && $items['task_start_date'] != '') {
                            $modelTaskBreakup[$i]->task_start_date = date("Y-m-d H:i", strtotime(str_replace('/', '-', $items['task_start_date'])));
                        }
                        if ($items['task_end_date'] != '00/00/0000' && $items['task_end_date'] != '') {
                            $modelTaskBreakup[$i]->task_end_date = date("Y-m-d H:i", strtotime(str_replace('/', '-', $items['task_end_date'])));
                        }

                        $validate = $modelTaskBreakup[$i]->validate() && $validate;

                }
            }

       




            

            $p = 0;
            if (is_array($_POST['WsProjectJobSheet'])) {

                foreach ($_POST['WsProjectJobSheet'] as $i => $item) {
                    if ((int)$item['id'] > 0) {
                        $modelJobSheet[$p] = WsProjectJobSheet::model()->findByPk((int)$item['id']);
                    } else {
                        $modelJobSheet[$p] = new WsProjectJobSheet;
                        $modelJobSheet[$p]->created_by = Yii::app()->user->id;

                        $modelJobSheet[$p]->created_date_time = date("Y-m-d H:i:s");
                    }

                    $modelJobSheet[$p]->attributes = $_POST['WsProjectJobSheet'][$i];
                    $modelJobSheet[$p]->job_id = $item['job_id'];
                    $modelJobSheet[$p]->customer_id = $item['customer_id'];
                    $modelJobSheet[$p]->status = $item['status'];
                    if ($item['job_date'] != '') {
                        $modelJobSheet[$p]->job_date = str_replace('/', '-', $item['job_date']);
                        $modelJobSheet[$p]->job_date = date("Y/m/d", strtotime($modelJobSheet[$p]->job_date));
                    }
                    $validate = $modelJobSheet[$p]->validate();
                    $p++;
                }
            }



            if (isset($_POST['WsProjectTimeSheet'])) {
                foreach ($_POST['WsProjectTimeSheet'] as $i => $items) {

                    $modelTimesheet[$i] = new WsProjectTimeSheet();


                    if ((int)$items['id'] > 0) {

                        $modelTimesheet[$i] = WsProjectTimeSheet::model()->findByPk((int)$items['id']);
                    } else {

                        $modelTimesheet[$i]->created_by = Yii::app()->user->id;

                        $modelTimesheet[$i]->created_date_time = date("Y-m-d H:i:s");
                    }


                    if ($items['project_task_hours'] != '0') {

                        $modelTimesheet[$i]->project_task_hours = $items['project_task_hours'];
                    }
                }
            }
            /* ------------------------------------------------------------------------------
              Code Added By Nisha  on 03/05/2022
              For labour working hours
              save to table erp_ws_project_labour_time
              ------------------------------------------------------------------------------- */
            if (isset($_POST['WsProjectLabourTime'])) {
                foreach ($_POST['WsProjectLabourTime'] as $i => $items) {
                    $modelLabourTime[$i] = new WsProjectLabourTime();
                    if ((int)$items['id'] > 0) {
                        $modelLabourTime[$i] = WsProjectLabourTime::model()->findByPk((int)$items['id']);
                        $modelLabourTime[$i]->updated_by = Yii::app()->user->id;
                        $modelLabourTime[$i]->updated_date_time = date('Y-m-d h:i:s');
                    } else {
                        $modelLabourTime[$i]->created_by = Yii::app()->user->id;
                        $modelLabourTime[$i]->created_date_time = date('Y-m-d h:i:s');
                    }
                    $modelLabourTime[$i]->total_years = $items['total_years'];
                    $modelLabourTime[$i]->total_days = $items['total_days'];
                    $modelLabourTime[$i]->total_months = $items['total_months'];
                    $modelLabourTime[$i]->total_hours = $items['total_hours'];
                    $modelLabourTime[$i]->phase_id = $items['phase_id'];
                }
            }


            /* ------------------------------------------------------------------------------
              Code Added By Nisha  on 26/04/2022
              For phase estimation  save
              save to table erp_ws_project_phase_details  and ws_project_estimation_details
              ------------------------------------------------------------------------------- */
            $model_phase = new WsProjectPhaseDetails();
            if (isset($_POST['WsProjectPhaseDetails'])) {
                $phase_ids = $_POST['WsProjectPhaseDetails']['phase_id'];
                $category_ids = $_POST['WsProjectPhaseDetails']['category_id'];
                $model_phase_count = WsProjectPhaseDetails::model()->find(array('condition' => 'phase_id="' . $phase_ids . '" and 
                                                                        category_id="' . $category_ids . '"'));


                if ($model_phase_count->id > 0) {
                    $phase_id = $model_phase_count->id;
                    $model_phase = WsProjectPhaseDetails::model()->findByPk($phase_id);

                    $model_phase->updated_by = Yii::app()->user->id;
                    $model_phase->updated_date_time = date('Y-m-d h:i:s');
                } else {
                    // $modal_details = new WsProjectEstimationDetails();
                    $model_phase->created_by = Yii::app()->user->id;
                    $model_phase->created_date_time = date('Y-m-d h:i:s');
                }

                $model_phase->attributes = $_POST['WsProjectPhaseDetails'];
                $model_phase->phase_id = $phase_ids;
                $model_phase->category_id = $category_ids;
                if (!$model->isNewRecord) {
                    $validate = $model_phase->validate() && $validate;
                }
            }


            if (isset($_POST['WsProjectEstimationDetails'])) {
              
                foreach ($_POST['WsProjectEstimationDetails'] as $i => $items) {
 

                    if ($items['product_id'] > 0 && $items['quantity'] > 0) {
                        if ($items['id'] > 0) {
                            $modal_details[$i] = WsProjectEstimationDetails::model()->findByPK($items['id']);
                            $modal_details[$i]->updated_by = Yii::app()->user->id;
                            $modal_details[$i]->updated_date_time = date('Y-m-d h:i:s');
                        } else {
                            $modal_details[$i] = new WsProjectEstimationDetails();
                            $modal_details[$i]->created_by = Yii::app()->user->id;
                            $modal_details[$i]->created_date_time = date('Y-m-d h:i:s');
                        }
                        $modal_details[$i]->attributes = $items;

                        $modal_details[$i]->description = $items['description'];
                        $modal_details[$i]->product_id = $items['product_id'];
                        $modal_details[$i]->size = $items['size'];

                        $modal_details[$i]->brand = $items['brand'];
                        $modal_details[$i]->quantity = $items['quantity'];
                        $modal_details[$i]->unit = $items['unit'];
                        $modal_details[$i]->total_material_cost = $items['total_material_cost'];
                        $modal_details[$i]->unit_price = $items['unit_price'];
                       // print_r($modal_details[$i]);exit;
                        $validate = $modal_details[$i]->validate() && $validate;
                     
                    }
                }
            }

            /* -------------------------------------------------------------------------------
              code End save  erp_ws_project_phase_details and ws_project_estimation_details
              --------------------------------------------------------------------------------- */


            if ($validate) {

                $model->save();


                /*Modified by Dikson R to Remove entry deletion code on 13/5/2022 */
                if (!empty($modelTaskBreakup)) {
                    foreach ($modelTaskBreakup as $eachTaskBreakup) {
                        $eachTaskBreakup->project_id = $model->id;
                        $eachTaskBreakup->save();
                    }
                }
                /**********End****/


                if (!empty($modelJobSheet)) {

                    foreach ($modelJobSheet as $eachJobSheet) {

                        $eachJobSheet->project_id = $model->id;

                        $eachJobSheet->save(false);
                    }
                }


                if (!empty($modelTimesheet)) {

                    //WsProjectTimeSheet::model()->deleteAll('project_id=:refer_id', array(':refer_id' => $model->id));

                    foreach ($modelTimesheet as $eachModel) {

                        $eachModel->project_id = $model->id;

                        $eachModel->save(false);
                    }
                }
                /* ------------------------------------------------------------------------------
                  Code Added By Nisha  on 26/04/2022
                  For phase estimation  save
                  save to table erp_ws_project_phase_details  and ws_project_estimation_details
                  ------------------------------------------------------------------------------- */
                if (!empty($model_phase)) {
                    if ($phase_ids > 0) {
                        $model_phase->project_id = $model->id;
                        $model_phase->save(false);
                    }
                }


                if (!empty($modal_details)) {

                    //WsProjectEstimationDetails::model()->deleteAll('project_id=:refer_id', array(':refer_id' => $model->id));

                    foreach ($modal_details as $eachModel) {
                        // $modelWsProjectEstimationDetails = WsProjectEstimationDetails::model()->find(array('condition' => 'product_id="' .  $eachModel->product_id . '" and  project_id ="' . $model->id. '"   '));
                        $modelWsProjectEstimationDetails = WsProjectEstimationDetails::model()->find(array('condition' => 'product_id="' . $eachModel->product_id . '" and  project_id ="' . $model->id . '" and  phase_id ="' . $model_phase->phase_id . '"  and  category_id ="' . $model_phase->category_id . '" '));

                        if (!empty($modelWsProjectEstimationDetails)) {
                            WsProjectEstimationDetails::model()->updateAll(array('brand' => $eachModel->brand, 'quantity' => $eachModel->quantity, 'unit' => $eachModel->unit, 'size' => $eachModel->size, 'unit_price' => $eachModel->unit_price, 'total_material_cost' => $eachModel->total_material_cost, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d h:i:s')), 'id =' . $modelWsProjectEstimationDetails->id);
                        } else {
                            $eachModel->project_id = $model->id;
                            $eachModel->phase_id = $model_phase->phase_id;
                            $eachModel->category_id = $model_phase->category_id;
                            $eachModel->save(false);

                        }
                    }
                }

                /* ------------------------------------------------------------------------------
                  save to table erp_ws_project_phase_details  and ws_project_estimation_details
                  End Code
                  ------------------------------------------------------------------------------- */

                /*  Code added by nisha on 03/05/2022 */

                if (!empty($modelLabourTime)) {
                    foreach ($modelLabourTime as $eachModel) {
                        $eachModel->project_id = $model->id;
                        $eachModel->save(false);
                    }
                }


                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                $jsonData['project_name'] = $model->project_name;
                echo CJSON::encode($jsonData);
            } else {

                $error = json_decode(CActiveForm::validate($model, '', false), true);


                $error1 = array();

                if (!empty($modelTaskBreakup)) {

                    $error1 = json_decode(CActiveForm::validateTabular($modelTaskBreakup, '', false), true);
                }


                $error2 = array();


                $error3 = array();

                if (!empty($modelJobSheet)) {

                    $error3 = json_decode(CActiveForm::validate($modelJobSheet, '', false), true);
                }


                $error4 = array();

                if (!empty($modelLabourTime)) {

                    $error4 = json_decode(CActiveForm::validate($modelLabourTime, '', false), true);
                }


                $error5 = array();

                if (!empty($model_phase)) {
                    if (!$model->isNewRecord) {
                        $error5 = json_decode(CActiveForm::validate($model_phase, '', false), true);
                    }
                }


                $error6 = array();

                if (!empty($modal_details)) {

                    $error6 = json_decode(CActiveForm::validate($modal_details, '', false), true);
                }


                $error = CJSON::encode(array_merge_recursive($error, $error1, $error4, $error3, $error2, $error5, $error6));

                if ($error != '[]')
                    echo $error;
            }
        }
    }


    public function actionDeleteProposals()
    {

        $id = $_POST['id'];

        if ($id > 0) {

            $model = new Proposal();

            $model->deleteByPk($id);

            ProposalDetails::model()->deleteAll('project_proposal_id=:refer_id', array(':refer_id' => $id));

            echo "success";
        } else {

            echo "fail";
        }
    }

    public function actionGetProductList()
    {


        $category = Yii::app()->request->getParam('category');

        $phase_id = Yii::app()->request->getParam('Phase_id');

        $estimate_id = Yii::app()->request->getParam('enquiry_id');


        $model_phase = EstimationPhaseDetails::model()->find(array('condition' => 'project_estimation_id="' . $estimate_id . '" 

                                                                                    and category_id="' . $category . '" 

                                                                                    and sub_category_id="' . $sub_category . '" 

                                                                                    and phase_id="' . $phase_id . '"'));


        if (empty($model_phase->id)) {

            $model_phase = new EstimationPhaseDetails();
        }


        $model_enquiry_details = EstimationDetails::model()->findAll(array('condition' => 'project_estimation_id="' . $estimate_id . '" 

                                                                                            and estimation_phase_id="' . $model_phase->id . '" 

                                                                                            and quantity > 0',
            'order' => 'description ASC'));


        $modelProposal = Proposal::model()->find(array('condition' => 'project_estimation_id="' . $estimate_id . '"'));

        $proposal_id = $modelProposal->id;

        if ($proposal_id > 0) {


            $modelProVarPhase = ProposalVariencePhaseDetails::model()->find(array('condition' => 'proposal_id="' . $proposal_id . '" 

                                                                                    and category_id="' . $category . '" 

                                                                                    and sub_category_id="' . $sub_category . '" 

                                                                                    and phase_id="' . $phase_id . '"'));

            $model_pro_phase_id = $modelProVarPhase->id;


            //echo "ok = ".$proposal_id." = ".$model_pro_phase_id;


            $model_proposal_variance_details = ProposalVarianceDetails::model()->findAll(array('condition' => 'proposal_id="' . $proposal_id . '" 

                                                                                            and proposal_phase_id="' . $model_pro_phase_id . '" 

                                                                                            and quantity > 0',
                'order' => 'description ASC'));
        }

        //die();                                                                                  

        $this->render('material_product_old_details', array('model' => $model_enquiry,
            'modal_details' => $model_enquiry_details, 'category' => $category, 'sub_category' => $sub_category,
            'phase_id' => $phase_id, 'model_enquiry' => $model_enquiry, 'model_details' => $model_details,
            'enquiry_id' => $enquiry_id, 'model_phase' => $model_phase,
            'model_proposal_variance_details' => $model_proposal_variance_details,
            'modelProVarPhase' => $modelProVarPhase));
    }

    public function actionActualMaterialDetails()
    {

        $category = Yii::app()->request->getParam('category');

        $phase_id = Yii::app()->request->getParam('phase_id');

        $sub_category = Yii::app()->request->getParam('sub_category');

        $project_id = Yii::app()->request->getParam('project_id');


        $model_phase = PhaseDetails::model()->find(array('condition' => 'phase_id=' . $phase_id . ' and 

                                                                            category_id=' . $category . ' and 

                                                                            sub_category_id=' . $sub_category));


        if (empty($model_phase->id)) {

            $model_phase = new PhaseDetails();
        }


        // echo "ok = ".$model_phase->id;


        $modelProjectActualMaterialDetails = ActualMaterialDetails::model()->findAll(array('condition' => 'project_id="' . $project_id . '" 

                                                                                            and project_phase_id="' . $model_phase->id . '" 

                                                                                            and quantity > 0', 'order' => 'description ASC'));


        $this->render('actual_material_cost_details', array('modelProjectActualMaterialDetails' => $modelProjectActualMaterialDetails, 'project_id' => $project_id, 'model_phase' => $model_phase));
    }

    public function actionLabourDetails()
    {

        $category = Yii::app()->request->getParam('category');

        $phase_id = Yii::app()->request->getParam('Phase_id');

        $sub_category = Yii::app()->request->getParam('sub_category');

        $estimate_id = Yii::app()->request->getParam('enquiry_id');


        $model_phase = EstimationPhaseDetails::model()->find(array('condition' => 'phase_id=' . $phase_id . ' and 

                                                                            category_id=' . $category . ' and 

                                                                            sub_category_id=' . $sub_category));


        if (empty($model_phase->id)) {

            $model_phase = new EstimationPhaseDetails();
        }


        $model_estimation_details = EstimationDetails::model()->findAll(array('condition' => 'project_estimation_id="' . $estimate_id . '" 

                                                                                            and estimation_phase_id="' . $model_phase->id . '" 

                                                                                            and quantity > 0', 'order' => 'description ASC'));


        $modelProposal = Proposal::model()->find(array('condition' => 'project_estimation_id="' . $estimate_id . '"'));

        $proposal_id = $modelProposal->id;

        if ($proposal_id > 0) {


            $modelProVarPhase = ProposalVariencePhaseDetails::model()->find(array('condition' => 'proposal_id="' . $proposal_id . '" 

                                                                                    and category_id="' . $category . '" 

                                                                                    and sub_category_id="' . $sub_category . '" 

                                                                                    and phase_id="' . $phase_id . '"'));

            $model_pro_phase_id = $modelProVarPhase->id;


            $model_proposal_variance_details = ProposalVarianceDetails::model()->findAll(array('condition' => 'proposal_id="' . $proposal_id . '" 

                                                                                            and proposal_phase_id="' . $model_pro_phase_id . '" 

                                                                                            and quantity > 0',
                'order' => 'description ASC'));
        }


        $this->render('labour_old_details', array('model' => $model_estimation_details, 'model_enquiry' => $model_enquiry,
            'model_details' => $model_details, 'estimate_id' => $estimate_id, 'model_phase' => $model_phase,
            'model_proposal_variance_details' => $model_proposal_variance_details,
            'modelProVarPhase' => $modelProVarPhase));
    }

    public function actionActualLabourDetails()
    {

        $category = Yii::app()->request->getParam('category');

        $phase_id = Yii::app()->request->getParam('phase_id');

        $sub_category = Yii::app()->request->getParam('sub_category');

        $project_id = Yii::app()->request->getParam('project_id');


        $model_phase = PhaseDetails::model()->find(array('condition' => 'phase_id=' . $phase_id . ' and 

                                                                            category_id=' . $category . ' and 

                                                                            sub_category_id=' . $sub_category));


        if (empty($model_phase->id)) {

            $model_phase = new PhaseDetails();
        }


        $modelProjectActualLabourDetails = ActualLabourDetails::model()->findAll(array('condition' => 'project_id="' . $project_id . '" 

                                                                                            and project_phase_id="' . $model_phase->id . '" 

                                                                                            and no_of_workers > 0', 'order' => 'description ASC'));


        $this->render('actual_labour_cost_details', array('modelProjectActualLabourDetails' => $modelProjectActualLabourDetails, 'project_id' => $project_id, 'model_phase' => $model_phase));
    }

    public function actionProposalcostDetails()
    {


        $category = Yii::app()->request->getParam('category');

        $sub_category = Yii::app()->request->getParam('sub_category');

        $phase_id = Yii::app()->request->getParam('Phase_id');

        $estimate_id = Yii::app()->request->getParam('enquiry_id');

        $model = Store::model()->findAll(array('condition' => 'generic_id="' . $category . '" and type_id="' . $sub_category . '"', 'order' => 'description ASC'));

        $model_details = new EstimationDetails();


        $model_phase = EstimationPhaseDetails::model()->find(array('condition' => 'phase_id=' . $phase_id . ' and 

                                                                            category_id=' . $category . ' and 

                                                                            sub_category_id=' . $sub_category));


        $model_enquiry_details = EstimationDetails::model()->findAll(array('condition' => 'project_estimation_id="' . $estimate_id . '" 

                                                                                            and estimation_phase_id="' . $model_phase->id . '"

                                                                                            and quantity > 0', 'order' => 'description ASC'));


        $this->render('cost_old_details', array('model' => $model_enquiry_details, 'model_enquiry' => $model_enquiry, 'model_details' => $model_details, 'enquiry_id' => $enquiry_id));
    }

    public function actionActualTotalCostDetails()
    {

        $category = Yii::app()->request->getParam('category');

        $phase_id = Yii::app()->request->getParam('phase_id');

        $sub_category = Yii::app()->request->getParam('sub_category');

        $project_id = Yii::app()->request->getParam('project_id');

        $proposalid = Yii::app()->request->getParam('proposalid');

        $estimation_id = Yii::app()->request->getParam('estimation_id');


        /*         * ************************** Estimate  ********************************************************************** */


        $model_estimate_phase = EstimationPhaseDetails::model()->find(array('condition' => 'project_estimation_id="' . $estimation_id . '" 

                                                                                    and category_id="' . $category . '" 

                                                                                    and sub_category_id="' . $sub_category . '" 

                                                                                    and phase_id="' . $phase_id . '"'));


        $total_estimate_mc = EstimationDetails::model()->find(array('select' => '(SUM(total_material_cost)) AS total_material_cost', 'condition' => 'project_estimation_id="' . $estimation_id . '" 

                                                                                            and estimation_phase_id="' . $model_estimate_phase->id . '" 

                                                                                            and quantity > 0'))->total_material_cost;


        $total_estimate_labour_cost = EstimationDetails::model()->find(array('select' => '(SUM(total_cost_for_labour)) AS total_cost_for_labour', 'condition' => 'project_estimation_id="' . $estimation_id . '" 

                                                                                            and estimation_phase_id="' . $model_estimate_phase->id . '" 

                                                                                            and quantity > 0'))->total_cost_for_labour;


        /*         * ************************** Proposal varience  ********************************************************************** */


        $model_proposal_phase = ProposalVariencePhaseDetails::model()->find(array('condition' => 'phase_id="' . $phase_id . '" and 

                                                                        category_id="' . $category . '" and 

                                                                        sub_category_id="' . $sub_category . '"'));


        $total_proposal_varience_mc = ProposalVarianceDetails::model()->find(array('select' => '(SUM(total_material_cost)) AS total_material_cost',
            'condition' => 'proposal_phase_id="' . $model_proposal_phase->id . '" 

                                                                                            and proposal_id="' . $proposalid . '" 

                                                                                            and quantity > 0'))->total_material_cost;


        $total_proposal_varience_lc = ProposalVarianceDetails::model()->find(array('select' => '(SUM(total_cost_for_labour)) AS total_cost_for_labour',
            'condition' => 'proposal_phase_id="' . $model_proposal_phase->id . '" 

                                                                                            and proposal_id="' . $proposalid . '" 

                                                                                            and quantity > 0'))->total_cost_for_labour;


        /*         * ************************** Actual  ********************************************************************** */


        $model_actual_mc_phase = PhaseDetails::model()->find(array('condition' => 'phase_id=' . $phase_id . ' and 

                                                                            category_id=' . $category . ' and 

                                                                            sub_category_id=' . $sub_category));


        $total_actual_estimate_mc = ActualMaterialDetails::model()->find(array('select' => '(SUM(total_material_cost)) AS total_material_cost',
            'condition' => 'project_id="' . $project_id . '" 

                                                                                            and project_phase_id="' . $model_actual_mc_phase->id . '" 

                                                                                            and quantity > 0'))->total_material_cost;


        $total_actual_labour_cost = ActualLabourDetails::model()->find(array('select' => '(SUM(total_cost_for_labour)) AS total_cost_for_labour',
            'condition' => 'project_id="' . $project_id . '" 

                                                                                            and project_phase_id="' . $model_actual_mc_phase->id . '"'))->total_cost_for_labour;


        $this->render('actual_total_cost_details', array('total_estimate_mc' => $total_estimate_mc,
            'total_estimate_labour_cost' => $total_estimate_labour_cost,
            'total_proposal_varience_mc' => $total_proposal_varience_mc,
            'total_proposal_varience_lc' => $total_proposal_varience_lc,
            'total_actual_estimate_mc' => $total_actual_estimate_mc,
            'total_actual_labour_cost' => $total_actual_labour_cost));
    }

    public function actionChangeSubCategory()
    {

        $id = $_POST['id'];

        $model = new PhaseDetails;

        $models_category = MasCategoryFirstLevel::getCategoryL1($id);


        $sub_category .= CHtml::activedropDownList($model, 'sub_category_id', $models_category, array('class' => 'tooltipster', 'title' => 'Sales Coordinator',
            'prompt' => '--select--', 'data-label' => 'Sub Category', 'onchange' => ' getproductlist();'));


        $status = array("drop" => $sub_category);

        echo CJSON::encode($status);
    }

    public function actionGetProjectNames()
    {

        $from = $_GET['frm'];

        $searchTerm = $_GET['term'];

        $condition = 't.project_name LIKE "%' . $searchTerm . '%"';

        $model = new WsProject();

        $model = $model->findAll(array('condition' => $condition, 'order' => 'project_name'));

        $i = 0;

        foreach ($model as $eachModel) {


            $data[$i]['value'] = $eachModel->id;

            $data[$i]['label'] = $eachModel->project_name;

            $data[$i]['location'] = $eachModel->location;

            $data[$i]['estimationid'] = $eachModel->project_estimation_id;

            //$data[$i]['phase'] = CHtml::dropDownList('phase_id','', Phase::getPhase($eachModel->id), array('data-label'=>'Phase <span style="color:red"></span>'));

            $i++;
        }
        echo CJSON::encode($data);

        Yii::app()->end();
    }

    public function actionGetProjectPhase()
    {
        $project_id = $_POST['estimationid'];
        $data = array();
        $data['phase'] = CHtml::dropDownList('phase_id', '', Phase::getPhase($project_id), array('data-label' => 'Phase <span style="color:red"></span>', 'prompt' => 'select'));
        echo CJSON::encode($data);
    }

    public function actionGetProjectDetails()
    {


        $project_id = $_POST['project_id'];

        $model = new WsProject();

        if ($project_id > 0) {

            $model = $model->findByPk($project_id);

            $projectdate = "";

            if ($model->project_date != '0000-00-00' and $model->project_date != '1970-01-01') {

                $projectdate = date("d/m/Y", strtotime($model->project_date));
            }


            $data['projecttype'] = $model->project_type;

            $data['location'] = $model->location;

            $data['projectdate'] = $projectdate;

            $data['manager'] = $model->manager_name;

            $data['notes'] = $model->notes;

            $data['engineernotes'] = $model->engineer_notes;

            $data['managernotes'] = $model->project_manager_notes;
        }

        echo CJSON::encode($data);
    }

    public function actionGettaskSubCategories()
    {

        $id = $_POST['id'];

        $category = $_POST['category'];

        //$model = WsMasterTaskSubCategory::model()->findAll(array('condition' => 'task_category_id=' . $category));
        $model = WsMasterTaskSubCategory::model()->findAll(array('condition' => 'is_active="Y" AND task_category_id=' . $category));

        $list = CHtml::listData($model, 'id', 'subcategory_name');

        $jsonData['type'] = CHtml::dropDownList($id, '', $list, array('data-label' => 'Project Type *', 'empty' => 'Select'));

        echo CJSON::encode($jsonData);
    }

    public function actionGetMemberTaskVariance()
    {

        $condition = 'project_id = "' . $_POST['project_id'] . '" AND task_subcategory_id="' . $_POST['task_id'] . '"';


        $project_timesheet = WsProjectTimeSheet::model()->find(array('condition' => $condition));


        $timesheet_hr = $project_timesheet->project_task_hours;


        $data['hr'] = $timesheet_hr;


        echo CJSON::encode($data);
    }

    /*  Function added By Nisha on 27/04/2022
      getting hourly rate based on subcategory
     */

    public function actionGethourlytaskrate()
    {


        $condition = 'id="' . $_POST['task_id'] . '"';


        $project_subcategory = WsMasterTaskSubCategory::model()->find(array('condition' => $condition));


        $hr_rate = $project_subcategory->hourly_rate;

        $data['rate'] = $hr_rate;

        echo CJSON::encode($data);
    }

    public function actionGetJobs()
    {


        $searchTerm = Yii::app()->request->getParam('term');

        $model = new JoborderHeader();


        $model = $model->with('customer_details')->findByPk($searchTerm);

        $i = 0;

        $data = array();

        if (!empty($model)) {


            $data[$i]['value'] = $model->id;

            $data[$i]['label'] = $model->id . ' : ' . $model->customer_details->customer_name;

            $data[$i]['customer_id'] = $model->customer_id;

            $data[$i]['customer_name'] = $model->customer_details->customer_name;

            $data[$i]['other'] = date('d/m/Y', strtotime($model->job_date));

            $data[$i]['msg'] = $model->status;

            $i++;
        }

        echo CJSON::encode($data);

        Yii::app()->end();
    }

    public function actionGetCust()
    {

        $row = $_POST['row_field'];

        $customer = $_POST['customer_id'];

        $type = $_POST['type'];

        $drop = array();


        if ($customer > 0) {

            $modelIssue->cust_name = Customer::GetCustomerName($customer);

            $drop['drop'] = CHtml::activetextField($modelIssue, "[" . $row . "]cust_name", array('class' => 'unit go'));
        }

        echo CJSON::encode($drop);
    }

    public function actionGetJobs1()
    {


        $searchTerm = Yii::app()->request->getParam('term');

        $id = Yii::app()->request->getParam('id');

        $model = new JoborderHeader();

        $modelJobSheet = array(new WsProjectJobSheet());

        $modelJobSheet = WsProjectJobSheet::model()->with('customer')->findAll(array('condition' => 'project_id=' . $id . ' AND (job_id LIKE "%' . $searchTerm . '%")'));

        $i = 0;

        $data = array();


        foreach ($modelJobSheet as $eachItem) {

            $data[$i]['value'] = $eachItem->job_id;

            $data[$i]['label'] = $eachItem->job_id . ' : ' . $eachItem->customer->customer_name;

            $data[$i]['customer_id'] = $eachItem->customer_id;

            $data[$i]['customer_name'] = $eachItem->customer->customer_name;

            //$data[$i]['other'] = date('d/m/Y',strtotime($eachItem->job_date));
            //$data[$i]['msg']=$model->status;

            $i++;
        }


        echo CJSON::encode($data);

        Yii::app()->end();
    }

    public function actionGetJobDet()
    {

        $job_id = Yii::app()->request->getParam('job_id');

        $modelJobSheet = array(new WsProjectJobSheet());

        $modelJobSheet = WsProjectJobSheet::model()->find(array('condition' => 'job_id=' . $job_id));

        if (!empty($modelJobSheet)) {

            echo "Job " . $job_id . " has been already added to this project.Please add another job";
        }
    }

    public function actionDeleteproj()
    {

        $id = $_POST['id'];

        $model = new WsProjectJobSheet();

        $model->deleteByPk($id);

        echo "success";
    }

    /* Code Added By  Nisha on 25-04-2022
      For Phase details
     */


    public function actionAddPhase()
    {
        $from = $_POST['from'];

        $name = $_POST['name'];
        $projectid = $_POST['projectid'];

        if ($name != '' && $projectid != '') {
            $Phase = new WsProjectPhase;

            $Phase->phase_name = $name;
            $Phase->project_id = $projectid;

            if ($Phase->save()) {
                $data = WsProjectPhase::getPhase($Phase->project_id);
                $model = new WsProjectPhaseDetails;
                $drop = CHtml::activedropDownList($model, 'phase_id', $data, array('class' => 'tooltipster', 'prompt' => '--select--', 'data-label' => 'Phase <span style="color:red;"></span>', 'options' => array($Phase->id => array('selected' => true))));
                $status = array("status" => "success", "drop" => $drop);
                echo CJSON::encode($status);
            } else {


                $error = CActiveForm::validate($modelCountry, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }

    }

    public function actionAddPhase12_09_2022()
    {
        $from = $_POST['from'];


        if ($from == 'projectactivity') {

            $name = $_POST['name'];
            $projectid = $_POST['projectid'];

            if ($name != '' && $projectid != '') {
                $Phasex = new WsProjectActivityPhase;
                $Phasex->phase_name = $name;
                $Phasex->project_id = $projectid;
                if ($Phasex->save()) {
                    $datax = WsProjectActivityPhase::getPhase($Phasex->project_id);
                    $modelx = new WsProjectActivityPhaseDetails;
                    $drop1 = CHtml::activedropDownList($modelx, 'phase_id', $datax, array('class' => 'tooltipster', 'onchange' => ' getproductlist_activity();', 'prompt' => '--select--', 'data-label' => 'Phase<span style="color:red;"></span>', 'options' => array($Phasex->id => array('selected' => true))));


                    //   $drop1 = CHtml::activedropDownList($modelx, 'phase_id', $datax, array('class' => 'tooltipster', 'title' => 'Phase', 'data-label' => 'Phase', 'empty' => '--Select--', 'onchange' => 'getproductlist_activity();','options' => array($Phasex->id => array('selected' => true))));


                    $status = array("status" => "success", "drop" => $drop1);
                    echo CJSON::encode($status);
                } else {


                    $error = CActiveForm::validate($modelx, '', false);
                    if ($error != '[]')
                        echo $error;
                }
            }


        } else {

            $name = $_POST['name'];
            $projectid = $_POST['projectid'];

            if ($name != '' && $projectid != '') {
                $Phase = new WsProjectPhase;

                $Phase->phase_name = $name;
                $Phase->project_id = $projectid;

                if ($Phase->save()) {
                    $data = WsProjectPhase::getPhase($Phase->project_id);
                    $model = new WsProjectPhaseDetails;
                    $drop = CHtml::activedropDownList($model, 'phase_id', $data, array('class' => 'tooltipster', 'prompt' => '--select--', 'data-label' => 'Phase <span style="color:red;"></span>', 'options' => array($Phase->id => array('selected' => true))));
                    $status = array("status" => "success", "drop" => $drop);
                    echo CJSON::encode($status);
                } else {


                    $error = CActiveForm::validate($modelCountry, '', false);
                    if ($error != '[]')
                        echo $error;
                }
            }
        }
    }


    public function actionAddActivity()
    {
        $from = $_POST['from'];

        $name = $_POST['name'];
        $projectid = $_POST['projectid'];

        if ($name != '' && $projectid != '') {
            $Phase = new WsProjectActivityPhase;
            $Phase->phase_name = $name;
            $Phase->project_id = $projectid;
            if ($Phase->save()) {
                $data = WsProjectActivityPhase::getPhase($Phase->project_id);
                $model = new WsProjectActivityPhaseDetails;
                // $drop = CHtml::activedropDownList($model, 'phase_id', $data, array('class' => 'tooltipster','onchange' => ' getproductlist_activity();', 'prompt' => '--select--', 'data-label' => 'Phase<span style="color:red;"></span>', 'options' => array($Phase->id => array('selected' => true))));

                $drop = CHtml::activedropDownList($model, 'phase_id', $data, array('class' => 'tooltipster', 'onchange' => ' getproductlist_activity();', 'prompt' => '--select--', 'data-label' => 'Phase<span style="color:red;"></span>'));

                // $drop = CHtml::activedropDownList($model, 'phase_id', $data, array('class' => 'tooltipster', 'prompt' => '--select--', 'data-label' => 'Phase <span style="color:red;"></span>', 'options' => array($Phase->id => array('selected' => true))));

                //   $drop1 = CHtml::activedropDownList($modelx, 'phase_id', $datax, array('class' => 'tooltipster', 'title' => 'Phase', 'data-label' => 'Phase', 'empty' => '--Select--', 'onchange' => 'getproductlist_activity();','options' => array($Phase->id => array('selected' => true))));


                $status = array("status" => "success", "drop" => $drop);
                echo CJSON::encode($status);
            } else {


                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }


    }

    /* Code Added By  Nisha on 25-04-2022
      For BOM productlists
     */

    public function actionGetEstimationProductList()
    {
        $category = Yii::app()->request->getParam('category');
        $phase_id = Yii::app()->request->getParam('phase_id');
        $project_id = Yii::app()->request->getParam('project_id');

        $model_store = Store::model()->findAll(array('condition' => 'generic_id="' . $category . '"'));
        $model_phase = WsProjectPhaseDetails::model()->find(array('condition' => 'phase_id=' . $phase_id . ' and 
                                                                        category_id=' . $category . ' and project_id="' . $project_id . '"'));
        if (!empty($model_phase)) {
            $model_enquiry_details = WsProjectEstimationDetails::model()->findAll(array('condition' => 'project_id="' . $project_id . '" 
                                                                                        and phase_id="' . $phase_id . '" and category_id="' . $category . '"'));
        } else {
            $model_enquiry_details = array();
        }
        $model_phase = new WsProjectPhaseDetails;
        $this->render('material_product_details', array('model_store' => $model_store, 'category' => $category, 'phase_id' => $phase_id, 'project_id' => $project_id, 'model_phase' => $model_phase, 'model_enquiry_details' => $model_enquiry_details));
    }


    public function actionReloadactivity()
    {

        $phase_id = Yii::app()->request->getParam('phase_id');
        $project_id = Yii::app()->request->getParam('project_id');


        $model_WsProjectActivities_details = WsProjectActivities::model()->findAll(array('condition' => 'project_id="' . $project_id . '" 
        and phase_id="' . $phase_id . '"'));

        if (!empty($model_WsProjectActivities_details)) {
            foreach ($model_WsProjectActivities_details as $val) {

                WsProjectActivities::model()->updateAll(array('reload_activity' => 'Y', 'previous_work_progress' => $val->total_value, 'present_work_progress' => '0', 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d h:i:s')), 'id =' . $val->id);


                $jsonData['status'] = 'success';
            }
        } else {
            $jsonData['status'] = 'failed';
        }
        echo CJSON::encode($jsonData);


    }


    public function actionPrintProjectEstimationReportPDF()
    {

        $model = new Order();
        $id = Yii::app()->request->getParam('id');


        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $page_name = "project_estimation_list_individual";
        //}
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.' . $page_name, array('model' => $model, 'id' => $id, 'mpdf' => $mPDF1), true));
        $mPDF1->Output("PROJECT_ESTIMATION_" . $id . ".pdf", 'I');


    }

    public function actionPrintProjectActicity()
    {


        $model = new WsProjectActivities();
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $page_name = "project_activity";
        //}
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.' . $page_name, array('model' => $model, 'id' => $id, 'mpdf' => $mPDF1), true));
        $mPDF1->Output("PROJECT_ACTIVITY_" . $id . ".pdf", 'I');


    }


    //To delete task breakup
    public function actionRemovelineItem()
    {
        $id = $_POST['id'];
        if ($id > 0) {
            $model_time = WsProjectWorkTime::model()->find(array('condition' => 'task_id="' . $id . '"'));
            if ($model_time->id > 0) {
                $status['status'] = 'errror';
            } else {
                WsProjectTaskBreakup::model()->deleteByPk($id);
                $status['status'] = 'success';
            }
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }


    // code added By indhu 01-09-2022

    public function actionRemovequipmentlineItem()
    {

        $id = $_POST['id'];
        if ($id > 0) {
            WsProjectEquipments::model()->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }


    public function actionRemoveExpense()
    {

        $id = $_POST['id'];
        if ($id > 0) {
            WsProjectExpense::model()->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionCreatenew()
    {
        $project_id = (int)Yii::app()->request->getParam('project_id');


        //   $modelWsProjectInduction = new WsProjectInduction();
        $modelWsProjectInduction = WsProjectInduction::model()->with('employeedetail')->findAll(array('condition' => ' project_id="' . $project_id . '"'));
        if (empty($modelWsProjectInduction)) {
            $modelWsProjectInduction = array(new WsProjectInduction());
        }


       // $modelWsProjectDailyschedule = WsProjectDailyschedule::model()->findAll(array('condition' => ' project_id="' . $project_id . '"'));
        $modelWsProjectDailyschedule = WsProjectDailyschedule::model()->findAll(array('condition' => ' project_id="' . $project_id . '"','order' => 'schedule_date desc'));

        
      
        if (empty($modelWsProjectDailyschedule)) {
            $modelWsProjectDailyschedule = array(new WsProjectDailyschedule());
        }

        $modelWsProjectRework = WsProjectRework::model()->findAll(array('condition' => ' project_id="' . $project_id . '"'));
        if (empty($modelWsProjectRework)) {
            $modelWsProjectRework = array(new WsProjectRework());
        }

        $modelWsProjectEquipments = WsProjectEquipments::model()->findAll(array('condition' => ' project_id="' . $project_id . '"'));
        if (empty($modelWsProjectEquipments)) {
            $modelWsProjectEquipments = array(new WsProjectEquipments());
        }

        $modelWsProjectMemos = WsProjectMemos::model()->findAll(array('condition' => ' project_id="' . $project_id . '"'));
        if (empty($modelWsProjectMemos)) {
            $modelWsProjectMemos = array(new WsProjectMemos());
        }

        $modelWsProjectExpense = WsProjectExpense::model()->findAll(array('condition' => ' project_id="' . $project_id . '"'));
        if (empty($modelWsProjectExpense)) {
            $modelWsProjectExpense = array(new WsProjectExpense());
        }


        $modelWsProjectActivities = WsProjectActivities::model()->findAll(array('condition' => ' project_id="' . $project_id . '"'));
        if (empty($modelWsProjectActivities)) {
            $modelWsProjectActivities = array(new WsProjectActivities());
        }


        $modal_activity_phase_details = WsProjectActivityPhaseDetails::model()->find(array('condition' => 'project_id=' . $project_id));
        if (empty($modal_activity_phase_details)) {
            $modal_activity_phase_details = new WsProjectActivityPhaseDetails();
        }


        if ($project_id > 0) {

            $model = new WsProject();
            $model = $model->findByPk($project_id);


        }


        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('createnew', array('modelWsProjectActivities' => $modelWsProjectActivities, 'modal_activity_phase_details' => $modal_activity_phase_details, 'model_phase' => $model_phase, 'WsProjectExpense' => $modelWsProjectExpense, 'WsProjectMemos' => $modelWsProjectMemos, 'WsProjectEquipments' => $modelWsProjectEquipments, 'WsProjectRework' => $modelWsProjectRework, 'WsProjectDailyschedule' => $modelWsProjectDailyschedule, 'WsProjectInduction_list' => $modelWsProjectInduction, 'model' => $model, 'project_id' => $project_id, 'arr_employee' => $arr_employee,), false, false);
    }


    public function actionSavenew()
    {
       
        $valid = true;
        
        if (is_array($_POST['WsProjectInduction'])) {
            foreach ($_POST['WsProjectInduction'] as $i => $induction) {
                    if ($induction['id'] > 0) {
                        $modelinduction[$i] = WsProjectInduction::model()->findByPK($induction['id']);
                        $modelinduction[$i]->updated_by = Yii::app()->user->id;
                        $modelinduction[$i]->updated_date_time = date('Y-m-d H:i:s');
                    } else {
                        $modelinduction[$i] = new WsProjectInduction();
                        $modelinduction[$i]->created_by = Yii::app()->user->id;
                        $modelinduction[$i]->created_date_time = date('Y-m-d H:i:s');
                    }
                    $modelinduction[$i]->attributes = $induction;
                    $modelinduction[$i]->employee_id = $induction['employee_id'];
                    $modelinduction[$i]->project_id = $_POST['WsProject']['id'];
                    $valid = $modelinduction[$i]->validate() && $valid;
            }
        }



        if (is_array($_POST['WsProjectDailyschedule'])) {
            foreach ($_POST['WsProjectDailyschedule'] as $i => $Dailyschedule) {
                    if ($Dailyschedule['id'] > 0) {
                        $modeldailyschedule[$i] = WsProjectDailyschedule::model()->findByPK($Dailyschedule['id']);
                        $modeldailyschedule[$i]->updated_by = Yii::app()->user->id;
                        $modeldailyschedule[$i]->updated_date_time = date('Y-m-d H:i:s');
                    } else {
                        $modeldailyschedule[$i] = new WsProjectDailyschedule();
                        $modeldailyschedule[$i]->created_by = Yii::app()->user->id;
                        $modeldailyschedule[$i]->created_date_time = date('Y-m-d H:i:s');
                    }
                    $modeldailyschedule[$i]->attributes = $Dailyschedule;
                    if ($Dailyschedule['schedule_date'] != '') {
                        $modeldailyschedule[$i]->schedule_date = date("Y-m-d", strtotime(str_replace('/', '-', $Dailyschedule['schedule_date'])));
                    }
                    $modeldailyschedule[$i]->schedule_description = $Dailyschedule['schedule_description'];
                    $modeldailyschedule[$i]->project_id = $_POST['WsProject']['id'];
                    $valid = $modeldailyschedule[$i]->validate() && $valid;
            }
        }

        if (is_array($_POST['WsProjectRework'])) {
            foreach ($_POST['WsProjectRework'] as $i => $rework) {
                    if ($rework['id'] > 0) {
                        $modelrework[$i] = WsProjectRework::model()->findByPK($rework['id']);
                        $modelrework[$i]->updated_by = Yii::app()->user->id;
                        $modelrework[$i]->updated_date_time = date('Y-m-d H:i:s');
                    } else {
                        $modelrework[$i] = new WsProjectRework();
                        $modelrework[$i]->created_by = Yii::app()->user->id;
                        $modelrework[$i]->created_date_time = date('Y-m-d H:i:s');
                    }
                    $modelrework[$i]->attributes = $rework;

                    if ($rework['rework_date'] != '') {
                        $modelrework[$i]->rework_date = date("Y-m-d", strtotime(str_replace('/', '-', $rework['rework_date'])));
                    }
                    $modelrework[$i]->rework_description = $rework['rework_description'];
                    $modelrework[$i]->qty = $rework['qty'];
                    $modelrework[$i]->cost = $rework['cost'];
                    $modelrework[$i]->selling_price = $rework['selling_price'];
                    $modelrework[$i]->employee_id = $rework['employee_id'];

                    if ($modelrework[$i]->cost > 0 && $modelrework[$i]->qty > 0) {
                        $modelrework[$i]->cost_amt = $modelrework[$i]->cost * $modelrework[$i]->qty;
                    }

                    if ($modelrework[$i]->selling_price > 0 && $modelrework[$i]->qty > 0) {
                        $modelrework[$i]->total_amt = $modelrework[$i]->selling_price * $modelrework[$i]->qty;
                    }

                    $modelrework[$i]->project_id = $_POST['WsProject']['id'];
                    $valid = $modelrework[$i]->validate() && $valid;
            }
        }



       if (is_array($_POST['WsProjectEquipments'])) {
            foreach ($_POST['WsProjectEquipments'] as $i => $equipments) {
                    if ($equipments['id'] > 0) {
                        $modelequipments[$i] = WsProjectEquipments::model()->findByPK($equipments['id']);
                        $modelequipments[$i]->updated_by = Yii::app()->user->id;
                        $modelequipments[$i]->updated_date_time = date('Y-m-d H:i:s');
                    } else {
                        $modelequipments[$i] = new WsProjectEquipments();
                        $modelequipments[$i]->created_by = Yii::app()->user->id;
                        $modelequipments[$i]->created_date_time = date('Y-m-d H:i:s');
                    }
                    $modelequipments[$i]->attributes = $equipments;
                    $modelequipments[$i]->stock_item_id = $equipments['stock_item_id'];
                    $modelequipments[$i]->stock_item_quantity = $equipments['stock_item_quantity'];
                    $modelequipments[$i]->stock_item_name = $equipments['stock_item_name'];
                    $modelequipments[$i]->stock_item_description = $equipments['stock_item_description'];
                    $modelequipments[$i]->stock_item_unit = $equipments['stock_item_unit'];
                    $modelequipments[$i]->stock_item_rate = $equipments['stock_item_rate'];
                    $modelequipments[$i]->amount = $equipments['amount'];
                    if ($equipments['to_date'] != '') {
                        $modelequipments[$i]->to_date = date("Y-m-d", strtotime(str_replace('/', '-', $equipments['to_date'])));
                    }
                    if ($equipments['from_date'] != '') {
                        $modelequipments[$i]->from_date = date("Y-m-d", strtotime(str_replace('/', '-', $equipments['from_date'])));
                    }
                    $modelequipments[$i]->project_id = $_POST['WsProject']['id'];
                    $valid = $modelequipments[$i]->validate() && $valid;
            }
        }


        if (is_array($_POST['WsProjectMemos'])) {
            foreach ($_POST['WsProjectMemos'] as $i => $Memos) {
                    if ($Memos['id'] > 0) {
                        $modelMemos[$i] = WsProjectMemos::model()->findByPK($Memos['id']);
                        $modelMemos[$i]->updated_by = Yii::app()->user->id;
                        $modelMemos[$i]->updated_date_time = date('Y-m-d H:i:s');
                    } else {
                        $modelMemos[$i] = new WsProjectMemos();
                        $modelMemos[$i]->created_by = Yii::app()->user->id;
                        $modelMemos[$i]->created_date_time = date('Y-m-d H:i:s');
                    }
                    $modelMemos[$i]->attributes = $Memos;
                    if ($Memos['memo_date'] != '') {
                        $modelMemos[$i]->memo_date = date("Y-m-d", strtotime(str_replace('/', '-', $Memos['memo_date'])));
                    }
                    if (!empty($Memos['document_file'])) {
                        $document_file1 = explode(",", $Memos['document_file']);
                        $final_doc = end($document_file1);
                        $key = key($document_file1);
                        if (!empty($final_doc)) {
                            $modelMemos[$i]->document_file = $final_doc;
                        }
                    }
                    $modelMemos[$i]->employee_id = $Memos['employee_id'];
                    $modelMemos[$i]->memo_category_id = $Memos['memo_category_id'];
                    $modelMemos[$i]->project_id = $_POST['WsProject']['id'];
                    $valid = $modelMemos[$i]->validate() && $valid;
            }
        }


        if (is_array($_POST['WsProjectExpense'])) {
            foreach ($_POST['WsProjectExpense'] as $i => $Expense) {
                    if ($Expense['id'] > 0) {
                        $modelExpense[$i] = WsProjectExpense::model()->findByPK($Expense['id']);
                        $modelExpense[$i]->updated_by = Yii::app()->user->id;
                        $modelExpense[$i]->updated_date_time = date('Y-m-d H:i:s');
                    } else {
                        $modelExpense[$i] = new WsProjectExpense();
                        $modelExpense[$i]->created_by = Yii::app()->user->id;
                        $modelExpense[$i]->created_date_time = date('Y-m-d H:i:s');
                    }
                    $modelExpense[$i]->attributes = $Expense;
                    if ($Expense['expense_date'] != '') {
                        $modelExpense[$i]->expense_date = date("Y-m-d", strtotime(str_replace('/', '-', $Expense['expense_date'])));
                    }
                    $modelExpense[$i]->expense_details = $Expense['expense_details'];
                    $modelExpense[$i]->amount = $Expense['amount'];
                    $modelExpense[$i]->project_id = $_POST['WsProject']['id'];
                    $valid = $modelExpense[$i]->validate() && $valid;
            }
        }


        if (is_array($_POST['WsProjectActivities'])) {
            
            foreach ($_POST['WsProjectActivities'] as $i => $Activities) {
                    if ($Activities['id'] > 0) {
                        $modelActivities[$i] = WsProjectActivities::model()->findByPK($Activities['id']);
                        $modelActivities[$i]->updated_by = Yii::app()->user->id;
                        $modelActivities[$i]->updated_date_time = date('Y-m-d H:i:s');
                    } else {
                        $modelActivities[$i] = new WsProjectActivities();
                        $modelActivities[$i]->created_by = Yii::app()->user->id;
                        $modelActivities[$i]->created_date_time = date('Y-m-d H:i:s');
                    }
                    $modelActivities[$i]->attributes = $Activities;
                    $modelActivities[$i]->activities_details = $Activities['activities_details'];
                    $modelActivities[$i]->previous_work_progress = $Activities['previous_work_progress'];
                    $modelActivities[$i]->present_work_progress = $Activities['present_work_progress'];
                    if ($Activities['previous_work_progress'] > 0 && $Activities['present_work_progress'] > 0) {
                        $modelActivities[$i]->total_value = $Activities['previous_work_progress'] + $Activities['present_work_progress'];

                    }
                    $modelActivities[$i]->project_id = $_POST['WsProject']['id'];
                    $modelActivities[$i]->phase_id = $_POST['WsProjectActivityPhaseDetails']['phase_id'];
                    $valid = $modelActivities[$i]->validate() && $valid;
            }
        }



            if(!empty($_POST['WsProjectActivityPhaseDetails'])){
            $model_phase = new WsProjectActivityPhaseDetails();
            if (isset($_POST['WsProjectActivityPhaseDetails'])) {

                
                $phase_ids = $_POST['WsProjectActivityPhaseDetails']['phase_id'];

                $model_phase_count = WsProjectActivityPhaseDetails::model()->find(array('condition' => 'phase_id="' . $phase_ids . '" '));
                if ($model_phase_count->id > 0 && $_POST['WsProjectActivityPhaseDetails']['phase_id'] > 0) {
                    $phase_id = $model_phase_count->id;
                    $model_phase = WsProjectActivityPhaseDetails::model()->findByPk($phase_id);
                    $model_phase->updated_by = Yii::app()->user->id;
                    $model_phase->updated_date_time = date('Y-m-d h:i:s');
                } else {
                    // $modal_details = new WsProjectEstimationDetails();
                    $model_phase->created_by = Yii::app()->user->id;
                    $model_phase->created_date_time = date('Y-m-d h:i:s');
                }
                $model_phase->attributes = $_POST['WsProjectActivityPhaseDetails'];
                $model_phase->phase_id = $phase_ids;
                $model_phase->project_id = $_POST['WsProject']['id'];

             if (!$model_phase->isNewRecord) {
                $valid = $model_phase->validate() && $valid;
                 }
            }
        }

        if ($valid) {

          
            if (!empty($modelinduction)) {
                foreach ($modelinduction as $eachModelind) {
                    $eachModelind->save(false);
                }
            }


            if (!empty($modeldailyschedule)) {
                foreach ($modeldailyschedule as $eachModelschedule) {
                    $eachModelschedule->save(false);
                }
            }

            if (!empty($modelrework)) {
                foreach ($modelrework as $eachModelrework) {
                    $eachModelrework->save(false);
                }
            }

            if (!empty($modelequipments)) {
                foreach ($modelequipments as $eachModelequipments) {
                    $eachModelequipments->save(false);
                }
            }


            if (!empty($modelMemos)) {
                foreach ($modelMemos as $eachMemos) {
                    $eachMemos->save(false);
                }
            }

            if (!empty($modelExpense)) {
                foreach ($modelExpense as $eachExpense) {
                    $eachExpense->save(false);
                }
            }

            if (!empty($modelActivities)) {
                foreach ($modelActivities as $modelActivities) {
                    $modelActivities->save(false);
                }
            }

            if (!empty($model_phase)) {
                if ($phase_ids > 0) {
                    $model_phase->project_id = $_POST['WsProject']['id'];;
                    $model_phase->save(false);
                }
            }
           


            $jsonData['status'] = 'success';
            $jsonData['id'] = $_POST['WsProject']['id'];
            $WsProject = WsProject::model()->findByPK($_POST['WsProject']['id']);
            $jsonData['project_name'] = $WsProject->project_name;
            echo CJSON::encode($jsonData);
        } else {
            $error1 = json_decode(CActiveForm::validateTabular($modelinduction, '', false), true);
            $error2 = json_decode(CActiveForm::validateTabular($modeldailyschedule, '', false), true);
            $error3 = json_decode(CActiveForm::validateTabular($modelrework, '', false), true);
            $error4 = json_decode(CActiveForm::validateTabular($modelequipments, '', false), true);
            $error5 = json_decode(CActiveForm::validateTabular($modelMemos, '', false), true);
            $error6 = json_decode(CActiveForm::validateTabular($modelExpense, '', false), true);
            $error7 = json_decode(CActiveForm::validateTabular($modelActivities, '', false), true);
            $error8 = json_decode(CActiveForm::validateTabular($model_phase, '', false), true);

             $error = CJSON::encode(array_merge_recursive($error1,$error2,$error3,$error4,$error5,$error6,$error7,$error8));
            if ($error != '[]')
                echo $error;
          
        }
    }


    public function actionRemoveInductionlineItem()
    {
        $id = $_POST['id'];
        if ($id > 0) {
            WsProjectInduction::model()->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }


    public function actionRemoveMemolineItem()
    {
        $id = $_POST['id'];
        if ($id > 0) {
            WsProjectMemos::model()->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }


    public function actionRemoveActivitylineItem()
    {
        $id = $_POST['id'];
        if ($id > 0) {
            WsProjectActivities::model()->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionRemoveshedule()
    {
        $id = $_POST['id'];
        if ($id > 0) {
            WsMasterMaterialSubmitedScheduledDetails::model()->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }


    public function actionRemoveRework()
    {
        $id = $_POST['id'];
        if ($id > 0) {
            WsProjectRework::model()->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionRemovedailyschedule()
    {
        $id = $_POST['id'];
        if ($id > 0) {
            WsProjectDailyschedule::model()->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionPrintProjectInductionDailySchedule()
    {


        $model = new WsProjectInduction();
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        //$page_name = "project_induction_dailyschedule";
        $page_name = "project_details";
        //}
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.' . $page_name, array('model' => $model, 'id' => $id, 'mpdf' => $mPDF1), true));
        // $mPDF1->Output("PROJECT_INDUCTION_DAILYSCHEDULE_" . $id . ".pdf", 'I');
        $mPDF1->Output("PROJECT_DETAILS_" . $id . ".pdf", 'I');


    }

    public function actionPrintSubmittedSchedule()
    {


        $model = new WsProjectInduction();
        $id = Yii::app()->request->getParam('id');

        $type_id = Yii::app()->request->getParam('type_id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        //$page_name = "project_induction_dailyschedule";
        $page_name = "project_submitted_schedule";
        //}
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.' . $page_name, array('model' => $model, 'id' => $id,'type_id'=>$type_id, 'mpdf' => $mPDF1), true));
        // $mPDF1->Output("PROJECT_INDUCTION_DAILYSCHEDULE_" . $id . ".pdf", 'I');
        $mPDF1->Output("PROJECT_SUBMITTED_SCHEDULE_" . $id . ".pdf", 'I');


    }



//end 
    // code added By rahul 01-09-2022


    public function actionCreatesubmitedschedule()
    {
             $type_id = Yii::app()->request->getParam('type_id');
           

        $project_id = Yii::app()->request->getParam('project_id');
        // if ($type_id > 0 ) {
        //             //$scheduledType_list = WsMasterSubmittedSheduleType::getScheduledType();

        //     $SubmittedSheduleType_detils = WsMasterSubmittedSheduleType::model()->findByPk((int)$type_id);
        //     SubmittedSheduleType_detils
        //     print_r($SubmittedSheduleType_detils->id); exit;

        // }
       
        if ($project_id > 0 ) {
           
            $order_by = 'main_id ASC';
            $condition = 't.project_id ="' . $project_id . '"';
            //$condition .= 't.type_id ="' . $type_id . '"';
            $condition .= " AND t.type_id = " . $type_id;

            $modelmaterialsubmited = WsMasterMaterialSubmitedScheduledDetails::model()->findAll(array('condition' => $condition, 'order' => $order_by));
          
           
            if (empty($modelmaterialsubmited)) {
                $modelmaterialsubmited = array(new WsMasterMaterialSubmitedScheduledDetails());
            }
        }


        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create_submited_schedule', array('modelmaterialsubmited' => $modelmaterialsubmited, 'project_id' => $project_id,'type_id'=>$type_id), false, false);
    }


    public function actionSaveSubmiteddetails()
    {

       
        if (isset($_POST['WsMasterMaterialSubmitedScheduledDetails'])) {
            $valid = true;
            $p = 0;
            if ((isset($_POST['WsMasterMaterialSubmitedScheduledDetails']))) {

                foreach ($_POST['WsMasterMaterialSubmitedScheduledDetails'] as $i => $items) {

                    $modelSubmittedItem[$p] = new WsMasterMaterialSubmitedScheduledDetails;

                    if ((int)$items['id'] > 0) {
                        $modelSubmittedItem[$p] = WsMasterMaterialSubmitedScheduledDetails::model()->findByPk((int)$items['id']);
                        $modelSubmittedItem[$p]->updated_by = Yii::app()->user->id;
                        $modelSubmittedItem[$p]->updated_date_time = date("Y-m-d H:i:s");
                        // $modelSubmittedItem[$p]->main_id_status = 0 ;

                    } else {
                        $modelSubmittedItem[$p]->created_by = Yii::app()->user->id;
                        $modelSubmittedItem[$p]->created_date_time = date("Y-m-d H:i:s");
                    }


                    $modelSubmittedItem[$p]->attributes = $items;
                 
                    $modelSubmittedItem[$p]->type_id = $_POST['type_id'];

                    $modelSubmittedItem[$p]->project_id = $_POST['hid_job_order_id'];
                    $modelSubmittedItem[$p]->main_id = $items['main_id'];


                    if ($items['planned_submission_date'] != '' && $items['planned_submission_date'] != '0000-00-00') {
                        $items['planned_submission_date'] = str_replace('/', '-', $items['planned_submission_date']);
                        $modelSubmittedItem[$p]->planned_submission_date = date("Y-m-d", strtotime($items['planned_submission_date']));
                    }
                    if ($items['actual_submission_date'] != '' && $items['actual_submission_date'] != '0000-00-00') {
                        $items['actual_submission_date'] = str_replace('/', '-', $items['actual_submission_date']);
                        $modelSubmittedItem[$p]->actual_submission_date = date("Y-m-d", strtotime($items['actual_submission_date']));
                    }

                    if ($items['returned_date'] != '' && $items['returned_date'] != '0000-00-00') {
                        $items['returned_date'] = str_replace('/', '-', $items['returned_date']);
                        $modelSubmittedItem[$p]->returned_date = date("Y-m-d", strtotime($items['returned_date']));
                    }
                    $valid = $modelSubmittedItem[$p]->validate() && $valid;
                    $p++;
                }
            }
            if ($valid) {
                //SaveDetails


                if (!empty($modelSubmittedItem)) {
                    foreach ($modelSubmittedItem as $eachModel) {

                        $submitedScheduled_Details = WsMasterMaterialSubmitedScheduledDetails::model()->findByPk($eachModel->main_id);
                        $main_ideach = $submitedScheduled_Details->main_id;

                        if (!empty($main_ideach)) {
                            $eachModel->main_id = $main_ideach;
                           

                        }

                        $eachModel->save();
                      
                        if ($eachModel->main_id == '' ) {

                            WsMasterMaterialSubmitedScheduledDetails::model()->updateAll(array('main_id' => $eachModel->id, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d h:i:s')), 'id =' . $eachModel->id);

                        } else {
                          //  $condition = '  id != ' . $eachModel->id;
                            $condition = "  id !=   ".$eachModel->id;
                            $condition .= " AND main_id = " . $eachModel->main_id;

                          
                           // $condition .= ' AND main_id = ' . $eachModel->main_id;

                          //  $add = Yii::app()->db->createCommand('UPDATE  erp_ws_master_material_submited_scheduled_details SET main_id_status=0  WHERE ' . $condition . ' ')->queryScalar();

                    $sql = "UPDATE  erp_ws_master_material_submited_scheduled_details SET main_id_status=0  WHERE  ".$condition." ";
      

                    Yii::app()->db->createCommand($sql)->execute();

                  //$command = Yii::app()->db->createCommand($sql)->queryAll();

                 

                        }
                    }
                }
               

                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                Yii::app()->end();
            } else {
                $error1 = array();
                if ($modelSubmittedItem[0]->type_id > 0) {
                    $error1 = json_decode(CActiveForm::validateTabular($modelSubmittedItem, '', false), true);
                }

                $error = CJSON::encode($error1);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    //end

// -------indhu-02-09-2022-------------------------------


    public function actionGetProducts()
    {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'isActive = "Y" AND ( inventory_item_type=4) AND (part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%")';
        $model = new Store();
        $model = $model->findAll(array('condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number . ' : ' . $eachModel->description;
            $data[$i]['part_number'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->unit->id;
            $data[$i]['unit_name'] = $eachModel->unit->symbol;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }


    public function actionUploadMemopic($folder, $filename)
    {

        Yii::import("ext.EAjaxUpload.qqFileUploader");


        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';

// make the directory to store the pic:

        if (empty($filename)) {
            $filename = 'memodoc';
        }


        if (!is_dir($folder)) {

            mkdir($folder, 0777, TRUE);

//chmod($folder, 0755);

        }

        $allowedExtensions = array();

        $sizeLimit = 8 * 1024 * 1024; // maximum file size in bytes

        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder, FALSE, $filename);

        // $result = $uploader->handleUpload($folder);


        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);

        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);


        $fileName = $result['filename']; //GETTING FILE NAME

        //$this->CropIfImage($folder, $fileName, 100, 100);

        echo $return; // it's array

    }


    public function actionDownloadProjectMemoDoc()
    {
        $file_name = Yii::app()->request->getParam('file_name');


        $arr_doc_val = explode(',', $file_name);
        $path = Yii::getPathOfAlias('webroot') . "/uploads/projectmemos/" . $file_name;
        header("Content-type:application/octet-stream");
        header("Content-Type: application/download");
        header('Content-Disposition: attachment; filename="' . basename($path) . '"');
        header('Content-Length: ' . filesize($path));
        readfile($path);
        Yii::app()->end();
    }

    public function actionDeleteuploadedfile()
    {
        $id = $_POST['id'];
        $file_name = $_POST['file_name'];
        $i = $_POST['row_field'];
        $document_detail = new WsProjectMemos();
        $model_documents = WsProjectMemos::model()->findByPk($id);
        $document_file_array = explode(',', $model_documents->document_file);
        if (($key = array_search($file_name, $document_file_array)) !== false) {
            unset($document_file_array[$key]);
            $files = implode(',', $document_file_array);
            WsProjectMemos::model()->updateByPK($id, array('document_file' => $files));
            $div_file = '<span id=spanfile_"' . $i . '">';
            foreach ($document_file_array as $value_file) {
                $f_name = "'" . $value_file . "'";
                $div_file .= $value_file . '&nbsp;<a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete this file" onclick="deleteuploadedfile(' . $i . ',' . $id . ',' . $f_name . ');"><i class="fa fa-trash"></i></a><br>';
            }
            $div_file .= '</span>';
            $div_file .= CHtml::activeHiddenField($document_detail, "[" . $i . "]document_file", array('value' => $files));
            echo $div_file;
        }
    }


    public function actionGetProjectActivities()
    {
        $phase_id = Yii::app()->request->getParam('phase_id');
        
        $project_id = Yii::app()->request->getParam('project_id');
        
        $model_activity_details = WsProjectActivities::model()->findAll(array('condition' => 'project_id="' . $project_id . '" 
		and phase_id="' . $phase_id . '" '));

        if (empty($model_activity_details)) {
            $model_activity_details = array(new WsProjectActivities());
        }

        $WsProjectActivities_list = WsProjectActivities::model()->findAll(array('condition' => ' project_id ="' . $project_id . '"'));

        $this->render('project_activity_list', array('phase_id' => $phase_id, 'project_id' => $project_id, 'model_activity_details' => $model_activity_details, 'WsProjectActivities_list' => $WsProjectActivities_list));

    }


}
