<?php

class MasterinspectioncatitemController extends Controller
{
        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetList','Save','Disable'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	
	public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
        public function actionIndex()
	{
		$this->render('index');
	}
	
        public function actionGetList()
        {
                $model = new MasterInspectionCategoryItem();
                $draw   = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'t.id',
                   1 => 'task_cat_details.category_name',
                   2 => 't.subcategory_name',
                   3=>  't.id'
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '1=1';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" and (task_cat_details.category_name LIKE '%".$searchString."%' OR  t.subcategory_name LIKE '%".$searchString."%')";
                }
                $count = $model->with('task_cat_details')->count(array('condition'=>$condition));
                $model=$model->with('task_cat_details')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                 foreach ($model as $row)
                {
                    
                    $rowData[]=array($m,
                    $row['task_cat_details']['category_name'],
                    $row['subcategory_name'],
                    array('id'=>$row['id'],'status' => $row['is_active']));
                
                    $m++;
                    
                }
                $data['data'] = $rowData;
                echo json_encode($data);
        }
        public function actionCreate()
        {
            $model = new MasterInspectionCategoryItem();         
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);               
            }
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('create', array('model' => $model), false);
        }
       
  
        public function actionSave()
        {
            $model  = new MasterInspectionCategoryItem();     
            if (isset($_POST['MasterInspectionCategoryItem']))
            {
    		if (!empty($_POST['MasterInspectionCategoryItem']['id']))
                { 
                        $id= (int) @$_POST['MasterInspectionCategoryItem']['id'];
                        $model=$model->findByPk($id); 
                        $model->updated_by = Yii::app()->user->id; 
                        $model->updated_date_time = date('Y-m-d h:i:s');                  
                }else{
                        $model->created_by = Yii::app()->user->id; 
                        $model->created_date_time = date('Y-m-d h:i:s');
                }
            
                $model->attributes=$_POST['MasterInspectionCategoryItem'];
                
                if ($model->save())
                {
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['category_form'];
                        $jsonData['id'] = $model->id;
                       
	                echo CJSON::encode($jsonData);
                }
                else
                {
					
					
				
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            }
        }
    public function actionDisable() 
    {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
       
        $model  = new MasterInspectionCategoryItem();   
        $model = $model->findByPk($id);
        $model->is_active = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
        
    }
}