<?php

class MasterinspectioncatController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','Create','GetList','Save','deleteCategory'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function actionGetList()
        {
                $model = new MasterInspectionCategory();
                $draw   = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'t.id',
                   1 => 'category_name',
                   2 => 't.id',
                   
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '1=1';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" and category_name LIKE '%".$searchString."%'";
                }
                
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                 foreach ($model as $row)
                {
                    $div = '';
                   
                   
                    //if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["taskcategory_edit"])){
                        $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'workshop/masterinspectioncat/create&id='.$row['id'].'\',\'Edit Inspection Category\',\'lg\')"><i class="fa fa-pencil"></i></button> ';
                    //}
                    $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deleteTaskCategory('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>';
                    $rowData[]=array($m,
                    $row['category_name'],
                    array('id'=>$row['id'],'status' => $row['is_active']));
                
                    $m++;
                    
                }
                $data['data'] = $rowData;
                echo json_encode($data);
        }
        
        
     public function actionCreate()
        {
            $model = new MasterInspectionCategory();         
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);               
            }
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('create', array('model' => $model), false);
        }
       
  
        public function actionSave()
        {
            $model  = new MasterInspectionCategory();   
            
            if (isset($_POST['MasterInspectionCategory']))
            {
    		    if (!empty($_POST['MasterInspectionCategory']['id']))
                { 
                        $id= (int) @$_POST['MasterInspectionCategory']['id'];
                        $model=$model->findByPk($id); 
                        $model->updated_by = Yii::app()->user->id; 
                        $model->updated_date_time = date('Y-m-d h:i:s');                  
                }else{
                        $model->created_by = Yii::app()->user->id; 
                        $model->created_date_time = date('Y-m-d h:i:s');
                }
            
                $model->attributes=$_POST['MasterInspectionCategory'];
                
                if ($model->save())
                {
                        $jsonData['status'] = 'success';
                        //$jsonData['frm'] = $_POST['category_form'];
                        $jsonData['id'] = $model->id;
                       
	                echo CJSON::encode($jsonData);
                }
                else
                {
				       $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            }
        }
        
        public function actionDeleteCategory(){
            $id = $_POST['id'];
            $status = Yii::app()->request->getparam('status');
            $model  = new MasterInspectionCategory();  
            $model = $model->findByPk($id);
            $model->is_active = ($status == "Y" ) ? "N" : "Y";
            $model->save();
            echo json_encode(array("status" => "success"));
        
        }
}