<?php
//Created on 09/5/2022 by Dikson R
class ExternallabourController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetLabourList','Create','SaveLabour','Edit','UpdateLabour','BlockLabour','UnblockLabour','EditAll'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionIndex() {
    Yii::app()->clientScript->scriptMap = array(
        '*jquery.js' => false,
        '*jquery.min.js' => false,
        'jquery.min.js' => false,
        '*jquery-ui.js' => false,
        '*jquery-ui.min.js' => false,
    );

    if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['projects_mas_external_labour_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['projects_mas_external_labour_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');
        Yii::app()->end(); // Prevent further execution
    }
}
    public function actionGetLabourList(){
        $model=new ProjectExternalLabour();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            0 =>'id',
            1 =>'id',
            2 =>'company_name',
            3 =>'employee_name',
            4 =>'designation',
            5=>'isActive'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = '1=1';

        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
          $searchString = $_POST['search']['value'];
          $searchString_en=$this->ciphertext($searchString,"e");
          $condition.=" and (company_name LIKE '%".$searchString."%' OR employee_name LIKE '%".$searchString."%' OR designation LIKE '%".$searchString."%')";      
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'company_name ASC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=$offset;
        foreach ($model as $row)
        {
            $button_string="";
            if (isset(Yii::app()->user->havePermissionOn['projects_mas_external_labour_edit'])  || Yii::app()->user->authorised_user == 1) {
                $button_string .= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'workshop/externallabour/editall&id='.$row['id'].'\',\''.$row['employee_name'].' \',\'lg\')"><i class="fa fa-edit"></i></button>';
            }
            if (isset(Yii::app()->user->havePermissionOn['projects_mas_external_labour_block'])  || Yii::app()->user->authorised_user == 1) {
                if($row['isActive']!='B'){
                    $button_string .=' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Block" onclick="blocklabour(' . $row['id'] . ')"><i class="fa fa-ban "></i></a>' ;
                }else{
                    $button_string .=' <a href ="javascript:void(0);" class="btn btn-success btn-xs" title="UnBlock" onclick="unblocklabour(' . $row['id'] . ')"><i class="fa fa-retweet"></i></a>' ;
                }
            }
            $vendor = Vendor::model()->findByPk($row['company_name']);
            if ($vendor !== null) {
                $vendorName = $vendor->vendor_name; // Or $vendor->vendor_name depending on your DB column
            } else {
                $vendorName = 'Unknown Vendor';
            }
            $rowData[]=array(++$m,
            // $row['id'],
            $vendorName,
            $row['employee_name'],
            $row['designation'],
            array('id' => $row['id'],'code'=>$row['employee_name'],'isActive'=>$row['isActive']),
        );
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate(){
        $model=new ProjectExternalLabour(); 
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);                                   
    }
    public function actionEditAll(){
        $id=(int) Yii::app()->request->getParam('id');
        $model=new ProjectExternalLabour();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($id>0){
            $model=$model->findByPk($id);
            $model=$model->findAll(array('condition'=>'company_name="'.$model->company_name.'" AND isActive="Y"'));
        }
         $this->renderPartial('editall', array('model' => $model), false, true);                                     
    }
    public function actionSaveLabour() {        
        if (isset($_POST['ProjectExternalLabour'])) {
            $validate=true;
            date_default_timezone_set("Asia/Dubai");
            $j=0;
            foreach ($_POST['ProjectExternalLabour'] as $i => $items) {
                if ($items['id'] > 0) {
                    $model[$i] = ProjectExternalLabour::model()->findByPK($items['id']);
                    $model[$i]->updated_by = Yii::app()->user->id;
                    $model[$i]->updated_date_time = date('Y-m-d H:i:s');
                } else {
                    $model[$i] = new ProjectExternalLabour();
                    $model[$i]->created_by = Yii::app()->user->id;
                    $model[$i]->created_date_time = date('Y-m-d H:i:s');
                }
                $model[$i]->company_name = $_POST['labour_company_name'];
                $model[$i]->employee_name = $items['employee_name'];
                $model[$i]->designation = $items['designation'];
                $model[$i]->emirated_id = $items['emirated_id'];
                $validate = $model[$i]->validate() && $validate; 
            }
            if(empty($model)){
                $validate=false;
            }
            if ($validate) {
                foreach ($model as $eachModel) {
                    $eachModel->save();
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error_array = json_decode(CActiveForm::validate($model, '', false), true);
                $error = CJSON::encode($error_array);
                if ($error != '[]') {
                    echo $error;
                }
            }
        }
    }
    public function actionEdit(){
        $model=new ProjectExternalLabour(); 
        $id=(int) Yii::app()->request->getParam('id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($id>0){
            $model=$model->findByPk($id);
        }
        $this->renderPartial('edit', array('model' => $model), false, true);                                   
    }
    public function actionUpdateLabour() {
        if (isset($_POST['ProjectExternalLabour'])) {
            date_default_timezone_set("Asia/Dubai");
            $model = new ProjectExternalLabour();
            if ((int) @$_POST['ProjectExternalLabour']['id'] > 0) {                
                $model = ProjectExternalLabour::model()->findByPK($_POST['ProjectExternalLabour']['id']);
                $model->id = (int) $_POST['ProjectExternalLabour']['id'];       
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_by= Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['ProjectExternalLabour'];
            $model->emirated_id=$_POST['ProjectExternalLabour']['emirated_id'];
            if($model->validate()){
                $model->save();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData); 
            }else{
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionBlockLabour() {
        $id = $_POST['id'];
        $model = ProjectExternalLabour::model()->findByPk($id);
        $model->isActive="N";
        $model->save();
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);    
    }
    public function actionUnblockLabour() {
        $id = $_POST['id'];
        $model = ProjectExternalLabour::model()->findByPk($id);
        $model->isActive="Y";
        $model->save();
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);        
    }
}
