<?php

class CompressorController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Getlist', 'Create', 'Save', 'Disable','Documentupload','GetDocumentList','downloaddocument','DeleteDocument','UploadDocuments','DeleteStageDetails',
                'DeleteAdditionalDetails','GetProducts','getStageDetails','PrintCompressorDetailsPDF'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $this->render('index');
    }
    public function actionGetList() {

        $model = new CompressorHeader();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'customer_id',
            2 => 'compressor_name',
            3 => 'make',
            4 => 'model',
            5 => 'manufacture_year',
            6 => 'serial_no',
            7 => 'capacity',
            8 => 'no_of_stages',
            9 => 'sort_order'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy        = $filterColumn . " " . $filterOrder;
       
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
           // $condition      = 't.is_active= "Y"';
            $condition.="customer_id LIKE '%" . $searchString .
                    "%' OR compressor_name LIKE '%" . $searchString . "%' OR make LIKE '%" . $searchString . "%'  OR model LIKE '%" . $searchString .
                    "%'OR manufacture_year LIKE '%" . $searchString . "%' OR serial_no LIKE '%" . $searchString . "%' OR capacity LIKE '%" . $searchString . 
                    "%' OR no_of_stages LIKE '%" . $searchString . "%' ";
        }
        else { $condition      = '1=1';   }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $rowData[] = array($m,
                $row['customer_det']['customer_name'],
                $row['compressor_name'],
                $row['make'],
                $row['model'],
                $row['manufacture_year'],
                $row['serial_no'],
                $row['capacity'],
                $row['no_of_stages'],
                
                
                array('id'=>$row['id'],'code' => $row['compressor_name'])
            );

            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }
     public function actionCreate() {
        $model = new CompressorHeader();
        $id = (int) Yii::app()->request->getParam('id');
        $modelStageDetails = array(new CompressorStageDetails());
        $modelOtherDetails = array(new CompressorOtherDetails());
        $modelCompressorTime = array(new CompressorTime);
        if ($id > 0) 
        {
            $model = $model->findByPk($id);
            /*$stage_no = $model->no_of_stages;
                        
            for($a =1; $a <= $stage_no ; $a++) 
            {
                $condition = 'compressor_id=' . (int) $id.' AND stage_no='.$a;*/
                $condition = 'compressor_id=' . (int) $id;
                $modelStageDetails = CompressorStageDetails::model()->with('compressor_stages')->findAll(array('condition' => $condition,'order' => 'stage_no,compressor_stages.sort_order asc'));
                if (empty($modelStageDetails)) {
                    $modelStageDetails = array(new CompressorStageDetails());
                }
            //}
            /*$modelStageDetails = CompressorStageDetails::model()->findAll(array('condition' => 'compressor_id=' . (int) $id));
            if (empty($modelStageDetails)) 
            {
                $arr_masterCompressorStages = MasterCompressorStages::model()->findAll(array('order' =>'sort_order asc'));
                if(!empty($arr_masterCompressorStages)){
                    foreach($arr_masterCompressorStages as $k=>$eachmaster){
                        $modelStageDetails[$k]=new CompressorStageDetails();
                        $modelStageDetails[$k]->stage_type_id=$eachmaster->id;
                        $modelStageDetails[$k]->created_date_time= "0000-00-00 00:00:00";
                    }
                }else{
                    $modelStageDetails = array(new CompressorStageDetails());
                }
            }*/
            
            $modelOtherDetails = CompressorOtherDetails::model()->findAll(array('condition' =>'compressor_id=' . (int) $id));
            if (empty($modelOtherDetails)) {
                $modelOtherDetails = array(new CompressorOtherDetails());
            }
            
            
            
            $modelCompressorTime = CompressorTime::model()->with('compressor_stages')->findAll(array('condition' =>'compressor_id=' . (int) $id,'order' => 'stage_no,compressor_stages.sort_order asc'));
            $k = 0;
            if (empty($modelCompressorTime)) {
                if (!empty($modelStageDetails)) 
                {
                    foreach($modelStageDetails as $k=>$eachdetail)
                    {
                        $modelCompressorTime[$k] = new CompressorTime();
                        $modelCompressorTime[$k]->stage_id = $eachdetail->id;
                        $modelCompressorTime[$k]->stage_no = $eachdetail->stage_no;
                        $modelCompressorTime[$k]->type = $eachdetail->type;
                        $modelCompressorTime[$k]->description = $eachdetail->stage_type_id;
                        $modelCompressorTime[$k]->part_number = $eachdetail->part_no;
                        $k++;
                    }
                }
            }
            
        }else{
            $arr_masterotherdetails=MasterCompressorInformation::model()->findAll(array('order' =>'sort_order asc'));
            if(!empty($arr_masterotherdetails)){
                foreach($arr_masterotherdetails as $k=>$eachmaster){
                    $modelOtherDetails[$k]=new CompressorOtherDetails();
                    $modelOtherDetails[$k]->compressor_type_id=$eachmaster->id;
                }
            }
            
            $arr_masterStagesdetails=MasterCompressorStages::model()->findAll(array('condition'=>'is_active="Y"','order' =>'sort_order asc'));
            if(!empty($arr_masterStagesdetails)){
                foreach($arr_masterStagesdetails as $k=>$eachmasters){
                    $modelStageDetails[$k]=new CompressorStageDetails();
                    $modelStageDetails[$k]->stage_type_id=$eachmasters->id;
                }
            }
        }
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model,'no_of_stages'=> $no_of_stages,'modelStageDetails' => $modelStageDetails,'modelOtherDetails' => $modelOtherDetails,'modelCompressorTime' => $modelCompressorTime), false, true);
    }
    public function actionSave() 
    {
        $model = new CompressorHeader();
        $other=array();
        if (isset($_POST['CompressorHeader'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date("Y-m-d H:i:s");
            if ((int) @$_POST['CompressorHeader']['id'] > 0) {
                $id = (int) @$_POST['CompressorHeader']['id'];
                $model = $model->findByPk($id);
                
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date("Y-m-d H:i:s");
            }

            $model->attributes = $_POST['CompressorHeader'];
            if($_POST['CompressorHeader']['manufacture_year'] != '')
            {
                $model->manufacture_year = $_POST['CompressorHeader']['manufacture_year'];
            }
            $model->no_of_stages = $_POST['CompressorHeader']['no_of_stages'];
            
            $valid = $model->validate();
            
            
            $p=0;
            if (is_array($_POST['CompressorOtherDetails'])) 
            {
                foreach ($_POST['CompressorOtherDetails'] as $i => $item) 
                {
                    if($item['compressor_type_id']>0){
                        $modelOtherDetails[$p] = new CompressorOtherDetails;
                        if((int)$item['id']>0){
                            $modelOtherDetails[$p] = CompressorOtherDetails::model()->findByPk((int)$item['id']);
                        }else{
                            $modelOtherDetails[$p]->created_by = Yii::app()->user->id;
                            $modelOtherDetails[$p]->created_date_time = date("Y-m-d H:i:s");
                        }
                        $modelOtherDetails[$p]->attributes = $item;
                        $modelOtherDetails[$p]->compressor_id = 0;
                        $modelOtherDetails[$p]->updated_by = Yii::app()->user->id;
                        $modelOtherDetails[$p]->updated_date_time = date("Y-m-d H:i:s");
                        $valid = $modelOtherDetails[$p]->validate() && $valid;
                        $p++;
                    }
                }
            }
            
            //echo '<pre>'; print_r($_POST['CompressorStageDetails']); exit;
            $p=0;
            if (is_array($_POST['CompressorStageDetails'])) 
            {
              foreach ($_POST['CompressorStageDetails'] as $i => $item) 
                {
                    if($item['quantity'] > 0)
                    {
                        $modelStageDetails[$p] = new CompressorStageDetails;
                        if((int)$item['id']>0){
                            $modelStageDetails[$p] = CompressorStageDetails::model()->findByPk((int)$item['id']);
                        }else{
                            $modelStageDetails[$p]->created_by = Yii::app()->user->id;
                            $modelStageDetails[$p]->created_date_time = date("Y-m-d H:i:s");
                        }
                        $modelStageDetails[$p]->attributes = $item;
                        
                        $modelStageDetails[$p]->compressor_id = 0;
                        $modelStageDetails[$p]->updated_by = Yii::app()->user->id;
                        $modelStageDetails[$p]->updated_date_time = date("Y-m-d H:i:s");
                        $valid = $modelStageDetails[$p]->validate() && $valid;
                        $p++;
                    }
                    
                }
                
             }
             
             $p=0;
             if (is_array($_POST['CompressorTime'])) 
             {
                foreach ($_POST['CompressorTime'] as $i => $item) 
                {
                    $modelCompressorTime[$p] = new CompressorTime;
                    if((int)$item['id']>0){
                        $modelCompressorTime[$p] = CompressorTime::model()->findByPk((int)$item['id']);
                    } else{
                        $modelCompressorTime[$p]->created_by = Yii::app()->user->id;
                        $modelCompressorTime[$p]->created_date_time = date("Y-m-d H:i:s");
                    }
                    $modelCompressorTime[$p]->attributes = $item;
                    $modelCompressorTime[$p]->compressor_id = 0;
                    $modelCompressorTime[$p]->stage_id = $item['stage_id'];
                    $modelCompressorTime[$p]->stage_no = $item['stage_no'];
                    $modelCompressorTime[$p]->type = $item['type'];
                    $modelCompressorTime[$p]->description = $item['description'];
                    $modelCompressorTime[$p]->part_number = $item['part_number'];
                    $modelCompressorTime[$p]->service_time = $item['service_time'];
                    $modelCompressorTime[$p]->production_setup =$item['production_setup'];
                    $modelCompressorTime[$p]->production_time = $item['production_time'];
                    
                    
                    $valid = $modelCompressorTime[$p]->validate() && $valid;
                    $p++;
                }
            }
             
             if ($valid) {
                $model->save();    
                if(!empty($modelOtherDetails)){
                    foreach ($modelOtherDetails as $eachModel) {
                        $eachModel->compressor_id = $model->id;
                        $eachModel->save(false);
                    }
                }
                if(!empty($modelStageDetails)){
                    foreach ($modelStageDetails as $eachModel) {
                        $eachModel->compressor_id = $model->id;
                        $eachModel->save(false);
                    }
                }
                if(!empty($modelCompressorTime)){
                    foreach ($modelCompressorTime as $eachTime) {
                        $eachTime->compressor_id = $model->id;
                        $eachTime->save(false);
                    }
                }
                $jsonData['status'] = 'success';
                //$jsonData['frm'] = $_POST['Song'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error1 = $error2 =$error3 = $error4= array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($modelOtherDetails))
                $error2 = json_decode(CActiveForm::validateTabular($modelOtherDetails, '', false), true);
                if (!empty($modelStageDetails))
                $error3 = json_decode(CActiveForm::validateTabular($modelStageDetails, '', false), true);
                else
                $error3[] = "Please add atleast one schedule";
                if (!empty($modelCompressorTime))
                $error4 = json_decode(CActiveForm::validateTabular($modelCompressorTime, '', false), true);
                else
                $error4[] = "Please add atleast one Time";
                $error = CJSON::encode(array_merge_recursive($error1, $error2,$error3,$error4,$other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
  public function actionDisable() 
    {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
       
        $model = new CompressorHeader();
        $model = $model->findByPk($id);
        $model->is_active = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
        
    }
     public function actionDeleteStageDetails(){
        $id = $_POST['id'];
        if($id>0){
            CompressorStageDetails::model()->deleteByPk($id);
            $status['status'] = 'success';
        }else{
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
     
    }   
    public function actionDeleteAdditionalDetails(){
        $id = $_POST['id'];
        if($id>0){
            CompressorOtherDetails::model()->deleteByPk($id);
            $status['status'] = 'success';
        }else{
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
     
    }   
    public function actionDocumentupload() {
        $type_id = Yii::app()->request->getparam("type_id");
        $modelDocument = Documents::model()->find(array('condition' => 'type_id = "' . $type_id . '" AND document_type="COMPRESSOR"'));
        if (empty($modelDocument)) {
            $modelDocument = new Documents();
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->renderPartial('document_index', array('modelDocument' => $modelDocument, 'type_id' => $type_id), false, true);
    }
    public function actionGetDocumentList() {

        $model = new Documents();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.type_id',
            1 => 't.document_name',
            2 => 't.created_by',
            3 => 't.created_datetime',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.type_id > 0 AND t.document_type="COMPRESSOR" and t.type_id = "' . $_POST['type_id'] . '"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (document_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $model2 = User::model()->find(array('condition' => 't.id = "' . $row['created_by'] . '"'));
           // if (isset(Yii::app()->user->havePermissionOn['allow_delete_document'])) {
                $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteCompressorDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a> &nbsp;';
            //}
            $button_string .= ' <a href ="' . Yii::app()->createUrl('workshop/compressor/downloaddocument&id=' . $row['id']) . '" class=" btn btn-primary btn-xs"><i class="fa fa-download"></i></a>';
            $rowData[] = array($m, $row['document_name'], $model2->username, date("d/m/Y H:i:s", strtotime($row['created_date_time'])), '<div class="btn-wrap text-center">' . $button_string . '</div>');
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actiondownloaddocument() {
        $id = (int) Yii::app()->request->getParam('id'); 
        $arr_compressor_doc = Documents::model()->findByPk($id);
        $file = $arr_compressor_doc->file_name;
        $arr_doc_val = explode(',', $arr_compressor_doc->file_name);
        if (count($arr_doc_val) > 1) {
            $zip = new ZipArchive();
            $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $arr_compressor_doc->file_name . "_" . date('d-m-Y') . ".zip";
            if ($zip->open($zip_file_path, 1 ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) === TRUE) {
                for ($i = 0; $i < count($arr_doc_val); $i++) {
                    $path = "images/attachment/" . $arr_doc_val[$i];
                    // Add the files to the .zip file
                    $zip->addFile($path, $arr_doc_val[$i]);
                }
                // Closing the zip file
                $zip->close();
            }
            header("Content-type:application/zip"); //for pdf file
            //if you want to read text file using text/plain header
            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
            header('Content-Length: ' . filesize($zip_file_path));
            readfile($zip_file_path);
            Yii::app()->end();
        } else {
            $file = $arr_compressor_doc->file_name;
            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            //header('Content-Type:text/plain; charset=ISO-8859-15');
            //if you want to read text file using text/plain header
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
    }
    public function actionDeleteDocument() {
        $id = $_POST['id'];
        $modelDocument = new FmDocuments();
        $model_doc = Documents::model()->findbyPK($id);
        $document_details = explode(',', $model_doc->file_name);
        foreach ($document_details as $value) {
            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $value;
            unlink($path);
        }
        $modelDocument->deleteByPk($id);
        echo "success";
    }
  public function actionGetProducts() 
    {
        $term = Yii::app()->request->getParam('term'); 
        $condition = '(part_number LIKE "' . $term . '%" OR description LIKE "' . $term . '%") and t.isActive="Y"';
        
        $model = new Store();
        $model = $model->with('tax')->findAll(array('select' => 'id,part_number,description,unit_id,inventory_item_type,purchase_from,rate', 'condition' => $condition, 'limit' => 200));
        $i = 0;
        $data = array();
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number;
            $data[$i]['part_number'] = $eachModel->part_number;
            
            
                       
            $data[$i]['part_no'] = $eachModel->part_number;           
            $data[$i]['other'] = $eachModel->inventory_item_type;
            $data[$i]['purchasefrm']=$eachModel->purchase_from;
            $data[$i]['rate']=$eachModel->rate;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    
     public function actiongetStageDetails()
	 {
	     $stage_no = (int) Yii::app()->request->getparam("stage_no"); 
	     $compressor_id = (int) Yii::app()->request->getparam("compressor_id"); 
	     $condition = 'stage_no = "' . $stage_no . '" AND compressor_id = "' . $compressor_id . '"';
	     $modelStageDetails = CompressorStageDetails::model()->with('store_details','compressor_stages')->findAll(array('condition' => $condition));
	     
	     $this->renderPartial('load_stage_details', array('modelStageDetails' => $modelStageDetails,'stage_no'=>$stage_no,'compressor_id'=>$compressor_id));
	    
	 }
	 
	 public function actionPrintCompressorDetailsPDF()
	 {
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.workshop.views.compressor.print_compressor_card_pdf', array('id' => $id),true));
        $mPDF1->Output("Quotation.pdf", 'I');
    }
      
}  