<?php

class BillofmaterialController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetBill', 'Create','GetProducts','Getunitdrop','SaveBill','PrintBillofmaterialReportPDF','DeleteBMItem'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $this->render('index');
    }
    
    public function actionGetBill() {
        $model = new Billofmaterial();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'product.part_number',
            2 => 'product.description',
            3 => 'quantity',
            
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (product.part_number LIKE '%" . $searchString . "%' OR product.description LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('product')->count(array('condition' => $condition));
        $model = $model->with('product')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $current = strtotime(date('y-m-d'));
        
        
        
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
           
            
           
           $rowData[] = array($row['id'],
                $row['product']['part_number'],
                $row['product']['description'],
                $row['quantity'],
                $row['id'],
                array('id' => $row['id'],'part_number' => $row['product']['part_number'],'code'=>'Edit bill of material'));


            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    
    }
    
    public function actionDeleteBMItem(){
        $id = $_POST['id'];
        if($id>0){
            BillofmaterialItem::model()->deleteByPk($id);
            $status['status'] = 'success';
        }else{
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
     
    }  
    
    
    public function actionSaveBill() {
        $model = new Billofmaterial();
        $modelItem = array(new BillofmaterialItem());
        $other_errors=array();$model_his=array();
        if (isset($_POST['Billofmaterial'])) {
            if((int) @$_POST['Billofmaterial']['id'] > 0){
                $model = $model->findByPK($_POST['Billofmaterial']['id']);
                
            }else{
                
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime = date('Y-m-d h:i:s');
                $model->bm_date=date("Y-m-d");
                if((int)$_POST['Billofmaterial']['product_id']>0){
                    $prod_id =(int)$_POST['Billofmaterial']['product_id'];
                    $model_his=$model->findAll(array('condition'=>'product_id = "'.$prod_id.'"'));
                }
            }
            $model->attributes  = $_POST['Billofmaterial'];
            $model->notes       = $_POST['Billofmaterial']['notes'];
            
            $model->updated_by  = Yii::app()->user->id;
            $model->updated_datetime = date('Y-m-d h:i:s');
            $valid = $model->validate();
            if(!empty($model_his)){
                $valid=FALSE;
                $other_errors[]='Product Already Taken';
            }
            if (!empty($_POST['BillofmaterialItem'])) {
                foreach ($_POST['BillofmaterialItem'] as $k => $rowItem) {
                    if(empty($rowItem['id']))
                    {
                         $modelItem[$k] = new BillofmaterialItem();
                         
                         $modelItem[$k]->created_by = Yii::app()->user->id;
                         $modelItem[$k]->created_datetime = date('Y-m-d h:i:s');
                    }else{
                        $modelItem[$k] = BillofmaterialItem::model()->findByPk($rowItem['id']);
                    }
                    $modelItem[$k]->billofmaterial_id = 0;
                    $modelItem[$k]->attributes = $_POST['BillofmaterialItem'][$k];
                    $modelItem[$k]->std_or_nstd = $_POST['BillofmaterialItem'][$k]['std_or_nstd'];
                    $modelItem[$k]->updated_by  = Yii::app()->user->id;
                    $modelItem[$k]->updated_datetime = date('Y-m-d h:i:s');
                    $valid = $modelItem[$k]->validate() && $valid;                     
                }
            }
            
            if ($valid){
                if($model->save())
                {
                    if (!empty($modelItem)) {
                        foreach ($modelItem as $eachItem) {
                            $eachItem->billofmaterial_id = $model->id;
                            $qty  = $eachItem['quantity']/$_POST['Billofmaterial']['quantity'];
                            $eachItem->quantity = $qty;
                            
                            $eachItem->save(false);
                        }
                    }
                   

                    $jsonData['id'] = $model->id;
                    $jsonData['bm'] = $model->findByPk($model->id);
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                }
            }
            else
            {
                $error1 = array();$error2 =array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($modelItem[0]->product_id > 0)
                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                else
                    $error2[] = "Please add atleast one item";
                $error = CJSON::encode(array_merge_recursive($error2,$error1,$other_errors));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    
    
     public function actionCreate() {
        
        $id = (int) Yii::app()->request->getParam('id');
        $modelBillofmaterial = new Billofmaterial();
        $modelBillofmaterialItem = array(new BillofmaterialItem());
        if ($id > 0) {
            $modelBillofmaterial = $modelBillofmaterial->findByPk($id);
            $condition = 'billofmaterial_id="' . $id . '"';
            $modelBillofmaterialItem = BillofmaterialItem::model()->findAll(array('condition' => $condition));
            if (empty($modelBillofmaterialItem)) 
            {
                $modelBillofmaterialItem = array(new BillofmaterialItem());
            }
        }
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('billcreate', array('modelBillofmaterial' => $modelBillofmaterial,'modelBillofmaterialItem' => $modelBillofmaterialItem), false, true);
    }
    
    public function actionGetProducts() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $id = $_GET['id'];
        $condition = '(part_number LIKE "' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%")';
        if($id>0){
            $condition .= ' AND id != '.$id;        
        }
        $model = new Store();
        $model = $model->findAll(array('select' => 'id,part_number,description,unit_id,rate', 'condition' => $condition, 'limit' => 200));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['other'] = $eachModel->part_number;
            $data[$i]['label'] = $eachModel->part_number.':'.$eachModel->description;
            $data[$i]['part_number'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->unit->id;
            $data[$i]['rate'] = $eachModel->rate;
             $data[$i]['unit_name'] = $eachModel->unit->symbol;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    
    public function actionGetunitdrop() {
        $row = $_POST['row_field'];
        $product = $_POST['product_id'];
        $type = $_POST['type'];
        $drop = array();
        $modelBillofmaterialItem = new BillofmaterialItem;

        if ($product > 0) {
            $modelBillofmaterialItem->unit = UnitOfMeasurement::getBaseunit($product);
            $drop['drop'] = CHtml::activedropdownlist($modelBillofmaterialItem, "[" . $row . "]unit", UnitOfMeasurement::getUnits($product), array('class' => 'unit go'));
        }
        echo CJSON::encode($drop);
    }
    
    public function actionPrintBillofmaterialReportPDF() {

        $model = new Billofmaterial();
        $id = Yii::app()->request->getParam('id');
       
        if ($id > 0) {
            $model = new Billofmaterial();
        }
      
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
       
            $mPDF1->WriteHTML($this->renderPartial('application.modules.workshop.views.billofmaterial.print_bill_of_material_pdf', array('model' => $model, 'id' => $id, 'title' => $title, 'title' => $title), true));
        
        $mPDF1->Output("BillOfMaterial.pdf", 'I');
    }
    
      
}  