<div class="table-responsive">
    <table class="table table-hover table-bordered personal-task" id="service_item_table">
        <thead>
            <tr>
                <th>No</th>
                <th>Maintenance Type</th>
                <th>Service Notes</th>
                <th>Total Cost</th> <!-- ✅ Single Column -->
                <th class="text-center">
                    <a class="btn btn-sm btn-theme" href="javascript:void(0);" onclick="addServiceRow($('#service_item_table')); return false;">
                        <i class="fa fa-plus"></i>
                    </a>
                </th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($model_details as $i => $item): ?>
                <tr>
                    <td><label><?php echo $i + 1; ?></label></td>
                    <td>
                        <?php echo $form->hiddenField($item, "[$i]id"); ?>
                        <?php echo $form->dropDownList($item, "[$i]maintainance_master_id", MasMaintainance::getMaintainanceTypes(), [
                            'class' => 'form-control',
                            'title' => 'Maintenance Type',
                            'empty' => '--Select--'
                        ]); ?>
                    </td>
                    <td>
                        <?php echo $form->textArea($item, "[$i]service_notes", [
                            'class' => 'form-control',
                            'placeholder' => 'Enter notes'
                        ]); ?>
                    </td>
                    <td>
                        <?php echo $form->textField($item, "[$i]service_cost", [
                            'class' => 'form-control cost-field',
                            'placeholder' => '0.00','style'=>'text-align:right',
                            'value' => number_format((float)$item->service_cost, 2, '.', '')
                        ]); ?>
                    </td>
                    <td class="text-center">
                        <a href="javascript:void(0);" class="btn btn-sm btn-danger" onclick="removeServiceRow($('#service_item_table'), this)">
                            <i class="fa fa-times"></i>
                        </a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
        <tfoot>
    <tr>
        <td colspan="3" class="text-right" style="font-weight:bold;">Total Cost:</td>
        <td colspan="">
            <?php echo $form->textField($model, 'total_cost', [
                'id' => 'total_cost_display',
                'class' => 'form-control',
                'readonly' => true,'style'=>'text-align:right',
            ]); ?>
            <?php echo $form->error($model, 'total_cost'); ?>
        </td><td></td>
    </tr>
</tfoot>

    </table>
</div>

<?php
$cs = Yii::app()->clientScript;

// ✅ Add Row
$cs->registerScript("addServiceRow", <<<JS
function addServiceRow(jQtable) {
    var lastRow = jQtable.find('tbody tr:last');
    var newRow = lastRow.clone();
    var lastIndex = jQtable.find('tbody tr').length - 1;
    var newIndex = lastIndex + 1;

    newRow.find('label').html(newIndex + 1);

    newRow.find('input, select, textarea').each(function() {
        var oldName = $(this).attr('name');
        var oldId = $(this).attr('id');

        if (oldName && oldName.indexOf('[id]') !== -1) {
            $(this).remove(); // Remove hidden ID field
            return;
        }

        if (oldName) {
            var newName = oldName.replace(/\\[\\d+\\]/g, '[' + newIndex + ']');
            $(this).attr('name', newName);
        }

        if (oldId) {
            var newId = oldId.replace(/_\\d+_/g, '_' + newIndex + '_');
            $(this).attr('id', newId);
        }

        if ($(this).is('select')) {
            $(this).prop('selectedIndex', 0);
        } else {
            $(this).val('');
        }
    });

    newRow.find('.cost-field').off('input').on('input', calculateTotalCost);

    jQtable.find('tbody').append(newRow);
    calculateTotalCost();
}
JS
, CClientScript::POS_END);

// ✅ Remove Row
$cs->registerScript("removeServiceRow", <<<JS
function removeServiceRow(jQtable, btn) {
    var rows = jQtable.find('tbody tr');
    if (rows.length > 1) {
        $(btn).closest('tr').remove();

        jQtable.find('tbody tr').each(function(rowIndex) {
            $(this).find('label').html(rowIndex + 1);
            $(this).find('input, select, textarea').each(function() {
                var name = $(this).attr('name');
                var id = $(this).attr('id');

                if (name) $(this).attr('name', name.replace(/\\[\\d+\\]/g, '[' + rowIndex + ']'));
                if (id) $(this).attr('id', id.replace(/_\\d+_/g, '_' + rowIndex + '_'));
            });
        });

        calculateTotalCost();
    } else {
        alert('At least one service detail is required.');
    }
}
JS
, CClientScript::POS_END);

// ✅ Calculate Total Cost
$cs->registerScript("calculateTotalCost", <<<JS
function calculateTotalCost() {
    var total = 0;
    $('.cost-field').each(function() {
        var val = parseFloat($(this).val());
        if (!isNaN(val)) total += val;
    });
    $('#total_cost_display').val(total.toFixed(2));
    $('#MasMaintainanceService_estimated_cost').val(total.toFixed(2));
}

$(document).ready(function() {
    $('.cost-field').on('input', calculateTotalCost);
    calculateTotalCost();
});
JS
, CClientScript::POS_END);
?>
