<?php

class VehicleallotmentController extends Controller
{
	public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','getVehicleAllotmentlist','SaveVehicleAllotment','Disable','GetVehicleEmployeeDetails','CreateVehicleFilter','LoadVehicleDetails'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
    //     if (Yii::app()->user->authorised_user == 1 ||
    //     (
    //         isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
    //         isset(Yii::app()->user->havePermissionOn['VehicleAllotment_view']) &&
    //         Yii::app()->user->havePermissionOn['masters_menu_view'] && 
    //         Yii::app()->user->havePermissionOn['VehicleAllotment_view']
    //     )
    // ) {
        $this->render('index');
    // } else {
    //     $this->layout = false;
    //     $this->render('/site/unauthorised');
    //     Yii::app()->end(); // Prevent further execution
    // }
    }

    public function actionCreate()
    {
        $model=new VehicleAllotment();
        $id = (int) Yii::app()->request->getParam('id');
        $from =  Yii::app()->request->getParam('from');
        if($id>0){
            $model=$model->findByPk($id);
        }
     Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);   
    $this->render('create', array('model' => $model,'from' =>$from), false, true);
    }

    public function actiongetVehicleAllotmentlist()
        {
            
                $model=new VehicleAllotment();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $vehicle_id = $_POST['vehicle_id'];
                $employee_id = $_POST['employee_id'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'t.id',
				   1 =>'t.vehicle_id',
				   2 =>'t.employee_id',
				   3 =>'from_date',
				   4 =>'to_date'
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '1=1';
                // $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $searchString_en = $this->ciphertext($searchString, "e");
                  $condition ="  (vehicle.vehicle_make LIKE '%".$searchString."%' OR vehicle.vehicle_model LIKE '%".$searchString."%' OR  employee.first_name LIKE '%".$searchString_en."%')";
                }
                if ((int) $vehicle_id > 0) {
                    $condition .= ' AND (t.vehicle_id = ' . (int) $vehicle_id . ')';
                }
                if ((int) $employee_id > 0) {
                    $condition .= ' AND (t.employee_id = ' . (int) $employee_id. ' )';
                }
                 
                $count = $model->with('vehicle','employee')->count(array('condition'=>$condition));
                $model = $model->with('vehicle','employee')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $rowData[]=array($m,
                        $row->vehicle->vehicle_make.'-'.$row->vehicle->vehicle_model,
                        $row->employee->employeefullname,//$row['isDefault'],
                        ($row['from_date']!="0000-00-00 00:00:00")?date('d/m/Y h:i A',strtotime($row['from_date'])):"",
                         ($row['to_date']!="0000-00-00 00:00:00")?date('d/m/Y h:i A',strtotime($row['to_date'])):"",
                        array('id' => $row['id'],'code'=>$row['vehicle_id'], 'status' => ''));

                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
      
    }
    public function actionSaveVehicleAllotment()
    {
    $model = new VehicleAllotment();
        if (isset($_POST['VehicleAllotment']))
        {
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time =date('Y-m-d h:i:s');
            if ((int) @$_POST['VehicleAllotment']['id'] > 0)
            {   $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time =date('Y-m-d h:i:s');
                $id= (int) @$_POST['VehicleAllotment']['id'];
                $model=$model->findByPk($id);
                $audit_type = 'UPDATED';
            }else{
                $audit_type = 'CREATED';
            }
            $model->attributes=$_POST['VehicleAllotment'];
            
           if (isset($_POST['VehicleAllotment']['from_date']) && $_POST['VehicleAllotment']['from_date']!= '0000-00-00' && $_POST['VehicleAllotment']['from_date'] != '') {
                $model->from_date = date("Y-m-d H:i:s", strtotime(str_replace('/', '-', $_POST['VehicleAllotment']['from_date'])));
            } 
            
            if (isset($_POST['VehicleAllotment']['to_date']) && $_POST['VehicleAllotment']['to_date']!= '0000-00-00' && $_POST['VehicleAllotment']['to_date'] != '') {
                $model->to_date = date("Y-m-d H:i:s", strtotime(str_replace('/', '-', $_POST['VehicleAllotment']['to_date'])));
            } 
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $modelVehicleEmployee = array();
            if($_POST['VehicleAllotment']['vehicle_id']>0 && $_POST['VehicleAllotment']['employee_id']>0)
            $modelVehicleEmployee=VehicleAllotment::model()->find(array('condition'=>'vehicle_id='.$_POST['VehicleAllotment']['vehicle_id'],'order'=>'id DESC'));
             $flag=0;
            if(!empty($modelVehicleEmployee))
            {
                // if((int)$_POST['VehicleAllotment']['employee_id']!=(int)$modelVehicleEmployee->employee_id)
                // {
                    
                    $modelVehicleEmployee->to_date = date("Y-m-d H:i:s", strtotime($model->from_date . " -1 minute"));
                    $flag=1;
                //}
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
         	 if($model->validate())
               
            {
                 $model->save();
                 if(!empty($modelVehicleEmployee) && $flag==1 &&  $audit_type == 'CREATED')
                 $modelVehicleEmployee->save(false);
                 
                 MasMaintainanceService::model()->updateAll(
                    array('current_employee_id' => (int)$model->employee_id),
                    'vehicle_name = :vehicle_name',
                    array(':vehicle_name' => $model->vehicle_id)
                );

                  // inserting to audit log
                //   AuditLog::saveAuditLogs(
                //     'MAINTAINANACE',
                //     Yii::app()->user->id,
                //     $audit_type,
                //     " with name: - {$model->maintainance_type}  "
                // );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['status-form'];
                $jsonData['from'] = $_POST['from'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            }
            else
            {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
            echo $error;
            }
        }
    }
        public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new VehicleAllotment();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
    
    
     public function actionGetVehicleEmployeeDetails() {
        $vehicle_id = (int)Yii::app()->request->getParam('vehicle_id');
        $employee_id =(int) Yii::app()->request->getParam('employee_id');
        $from_date = date('d/m/Y h:i a');
        $to_min_date="";
        if($vehicle_id>0 && $employee_id >0)
        {
            // //$modelVehicleAllotment = VehicleAllotment::model()->find(array('condition'=>'vehicle_id='.$vehicle_id.' AND employee_id='.$employee_id,'order'=>'id DESC'));
            // $modelVehicleAllotment = VehicleAllotment::model()->find(array('condition'=>'vehicle_id='.$vehicle_id.'','order'=>'id DESC'));
            //     if (isset($modelVehicleAllotment->to_date) && $modelVehicleAllotment->to_date!= '0000-00-00' && $modelVehicleAllotment->to_date!= '') {
            //       $from_date = date("d/m/Y h:i a", strtotime($modelVehicleAllotment->to_date . " +1 minute"));
            //      // $to_min_date = date("d/m/Y h:i a", strtotime($modelVehicleAllotment->to_date . " +30 minute"));
            //   }
            //   else
              $from_date = date('d/m/Y h:i a');
        }
         echo json_encode(["from_date" => $from_date ,'to_min_date'=>$to_min_date, "status" => "success"]);
    }
     public function actionCreateVehicleFilter()
    {
       
     Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);   
    $this->render('filter_vehicle_details', array(), false, true);
    }
    
    public function actionLoadVehicleDetails()
    {
     
        $vehicle_id = $_POST['vehicle_id']; 

        $employee_id = $_POST['employee_id']; 

         Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false); 

        $this->render('print_vehicle_details', array( 'employee_id' => $employee_id,'vehicle_id' => $vehicle_id ), false, true);
  }
   
}