<?php

class MasMaintainanceServiceController extends Controller
{
	public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','getmasMaintainanceServicelist','SavemasMaintainanceService','Disable','Print'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['masMaintainanceService_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['masMaintainanceService_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
    }

public function actionCreate()
{
    $id = (int) Yii::app()->request->getParam('id');
 
    // ✅ Get model properly
    $model = ($id > 0) 
        ? MasMaintainanceService::model()->findByPk($id) 
        : new MasMaintainanceService();
 
    if ($id > 0 && !$model) {
        throw new CHttpException(404, 'Record not found.');
    }
 
    // ✅ Get service details as an array
    $model_details = ($id > 0) 
        ? ServiceDetails::model()->findAll([
            'condition' => 'service_id = :sid',
            'params' => [':sid' => $id],
        ]) 
        : [];
 
    // ✅ Always make sure model_details is an array (for new record or no details found)
    if (empty($model_details)) {
        $model_details = [new ServiceDetails()];
    }
 
    // ✅ Prevent duplicate jQuery loading for AJAX requests
    Yii::app()->clientScript->scriptMap = [
        '*jquery.js' => false,
        '*jquery.min.js' => false,
        'jquery.min.js' => false,
        '*jquery-ui.js' => false,
        '*jquery-ui.min.js' => false,
    ];
 
    // ✅ Render partial
    $this->renderPartial('create', [
        'model' => $model,
        'model_details' => $model_details,
    ], false, true);
}
public function actionSavemasMaintainanceService()
{
    if (!Yii::app()->request->isPostRequest || !isset($_POST['MasMaintainanceService'])) {
        echo CJSON::encode(['status' => 'invalid_request']);
        Yii::app()->end();
    }

    $id = (int)$_POST['MasMaintainanceService']['id'];
    if ($id > 0) {
        // Load existing record
        $model = MasMaintainanceService::model()->findByPk($id);
        if (!$model) {
            echo CJSON::encode(['status' => 'error', 'message' => 'Record not found']);
            Yii::app()->end();
        }
    } else {
        // Create only when ID is NOT passed
        $model = new MasMaintainanceService();
    }

    $model->attributes = $_POST['MasMaintainanceService'];
    if (isset($_POST['MasMaintainanceService']['total_cost'])) {
        $model->total_cost = $_POST['MasMaintainanceService']['total_cost'];
    }


    $model->planned_date = (!empty($_POST['MasMaintainanceService']['planned_date']) && strtotime(str_replace('/', '-', $_POST['MasMaintainanceService']['planned_date'])) !== false)
    ? date("Y-m-d H:i:s", strtotime(str_replace('/', '-', $_POST['MasMaintainanceService']['planned_date'])))
    : null;

$model->sheduled_date_time = (!empty($_POST['MasMaintainanceService']['sheduled_date_time']) && strtotime(str_replace('/', '-', $_POST['MasMaintainanceService']['sheduled_date_time'])) !== false)
    ? date("Y-m-d H:i:s", strtotime(str_replace('/', '-', $_POST['MasMaintainanceService']['sheduled_date_time'])))
    : null;

    $model->vehicle_name = isset($_POST['MasMaintainanceService']['vehicle_name']) ? $_POST['MasMaintainanceService']['vehicle_name'] : null;

    $transaction = Yii::app()->db->beginTransaction();

    try {
        if (!$model->save()) {
            throw new CException("Master model validation failed");
        }

        $service_id = $model->id;

        // Fetch existing details for comparison
        $existingDetails = ServiceDetails::model()->findAllByAttributes(['service_id' => $service_id]);
        $existingIds = CHtml::listData($existingDetails, 'id', 'id');

        $submittedIds = [];
        $model_details = [];
        $valid = true;

        if (!empty($_POST['ServiceDetails'])) {
            foreach ($_POST['ServiceDetails'] as $items) {
                // Skip empty rows
                if (empty($items['maintainance_master_id']) && empty($items['service_notes']) && empty($items['service_cost'])) {
                    continue;
                }

                if (!empty($items['id']) && in_array($items['id'], $existingIds)) {
                    $detail = ServiceDetails::model()->findByPk($items['id']);
                    $detail->updated_by = Yii::app()->user->id;
                    $detail->updated_date_time = date('Y-m-d H:i:s');
                    $submittedIds[] = $items['id'];
                } else {
                    $detail = new ServiceDetails();
                    $detail->created_by = Yii::app()->user->id;
                    $detail->created_date_time = date('Y-m-d H:i:s');
                }

                $detail->service_id = $service_id;
                $detail->maintainance_master_id = $items['maintainance_master_id'];
                $detail->service_notes = $items['service_notes'];
                $detail->service_cost = $items['service_cost'];

                $model_details[] = $detail;

                if (!$detail->validate()) {
                    $valid = false;
                }
            }
        }

        if (!$valid) {
            throw new CException("Validation failed for service details");
        }

        foreach ($model_details as $detail) {
            if (!$detail->save(false)) {
                throw new CException("Failed to save detail record");
            }
        }

        // Delete removed rows
        $idsToDelete = array_diff($existingIds, $submittedIds);
        if (!empty($idsToDelete)) {
            ServiceDetails::model()->deleteAllByAttributes(['id' => $idsToDelete]);
        }

        $transaction->commit();
        echo CJSON::encode(['status' => 'success']);

    } catch (Exception $e) {
        $transaction->rollback();
        echo CJSON::encode([
            'status' => 'error',
            'message' => $e->getMessage(),
            'errors' => $model->getErrors(),
        ]);
    }

    Yii::app()->end();
}






    public function actiongetmasMaintainanceServicelist()
        {
            
                $model=new MasMaintainanceService();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $vehicle_id = $_POST['vehicle_id'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'id',
                   1 =>'vehicle_id',
				   2 =>'garage_name',
				   3 =>'planned_date',
				   4 =>'sheduled_date_time',
				   5 =>'estimated_cost',
                   6 =>'current_employee_id',

                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '1=1';
                // $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (garage_name LIKE '%".$searchString."%'OR description LIKE '%".$searchString."%')";
                }
                 if ((int) $vehicle_id > 0) {
                    $condition .= ' AND (t.vehicle_name= ' . (int) $vehicle_id . ')';
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'sheduled_date_time ASC'));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $vehicleType = '';
                    if ($row->vehicle) {
                        $vehicleType = $row->vehicle->vehicle_make . ' ' . $row->vehicle->vehicle_model;
                    }
                        $rowData[]=array($m,
                        $vehicleType,
                        $row['garage_name'],
                        date('d/m/Y h:i A', strtotime($row['planned_date'])),
                        date('d/m/Y h:i A', strtotime($row['sheduled_date_time'])),
                        number_format($row['total_cost'],2),
                        $row->employee->employeefullname,
                        array('id' => $row['id'],'code' => $vehicleType, 'status' => $row->isActive));

                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
      
    }
    // public function actionSavemasMaintainanceService()
    // {
    // $model = new MasMaintainanceService();
    //     if (isset($_POST['MasMaintainanceService']))
    //     {
    //         $model->created_by = Yii::app()->user->id;
    //         $model->created_date_time =date('Y-m-d h:i:s');
    //         if ((int) @$_POST['MasMaintainanceService']['id'] > 0)
    //         {   $model->updated_by = Yii::app()->user->id;
    //             $model->updated_date_time =date('Y-m-d h:i:s');
    //             $id= (int) @$_POST['MasMaintainanceService']['id'];
    //             $model=$model->findByPk($id);
    //             $audit_type = 'UPDATED';
    //         }else{
    //             $audit_type = 'CREATED';
    //         }
    //         $model->attributes=$_POST['MasMaintainanceService'];
    //         $model->service_notes = $_POST['MasMaintainanceService']['service_notes'];
    //         $model->total_cost = $_POST['MasMaintainanceService']['total_cost'];
    //         // $model->total_cost = $_POST['MasMaintainanceService']['total_cost'];
    //         $model->vehicle_name = $_POST['MasMaintainanceService']['vehicle_name'];
    //         $model->planned_date = (!empty($_POST['MasMaintainanceService']['planned_date']) && strtotime($_POST['MasMaintainanceService']['planned_date']) !== false)
    //         ? date("Y-m-d H:i:s", strtotime(str_replace('/', '-', $_POST['MasMaintainanceService']['planned_date'])))
    //         : '0000-00-00 00:00:00';
    //         $model->sheduled_date_time = (!empty($_POST['MasMaintainanceService']['sheduled_date_time']) && strtotime($_POST['MasMaintainanceService']['sheduled_date_time']) !== false)
    //         ? date("Y-m-d H:i:s", strtotime(str_replace('/', '-', $_POST['MasMaintainanceService']['sheduled_date_time'])))
    //         : '0000-00-00 00:00:00';

    //         if($model->validate())
    //         {
    //              $model->save();
    //               AuditLog::saveAuditLogs(
    //                 'VEHICLE',
    //                 Yii::app()->user->id,
    //                 $audit_type,
    //                 " with name: - {$model->garage_name}  "
    //             );
    //             // end audit log
    //             $jsonData['status'] = 'success';
    //             $jsonData['frm'] = $_POST['status-form'];
    //             $jsonData['from'] = $_POST['from'];
    //             $jsonData['id'] = $model->id;
    //             echo CJSON::encode($jsonData);
    //         }
    //         else
    //         {
    //             $error = CActiveForm::validate($model, '', false);
    //             if ($error != '[]')
    //         echo $error;
    //         }
    //     }
    // }
    



        public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasMaintainanceService();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
    
    public function actionPrint()
{
    $id = Yii::app()->request->getParam('id');
    $model = MasMaintainanceService::model()->findByPk($id);

    if ($model === null) {
        throw new CHttpException(404, 'The requested service does not exist.');
    }

    // Fetch service detail rows
    $model_details = ServiceDetails::model()->findAllByAttributes(['service_id' => $id]);

    // Load mPDF via ePdf
    $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

    // Optional: load your custom stylesheet
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mPDF1->WriteHTML($stylesheet, 1);

    // Render PDF view
    $html = $this->renderPartial(
        'application.views.front.pdf.print_service_pdf',
        array(
            'model' => $model,
            'model_details' => $model_details
        ),
        true
    );

    $mPDF1->WriteHTML($html);

    // Output PDF inline
    $mPDF1->Output("Service_Report_" . $model->id . ".pdf", "I");
}


}