<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'stockcountfile-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
        <li class="col-sm-3">
             <?php 
             if($model->id > 0){
                 $model->lock_transaction_date = date('d/m/Y',strtotime($model->lock_transaction_date));
             }
             
             echo $form->textField($model, 'lock_transaction_date', array('class'=>'datepicker','title' => 'Transaction Lock Date ','data-label'=>'Transaction Lock Date <span style="color:red">*</span>')); ?>
           </li>
            <li class="col-sm-6">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->textField($model, 'file_name', array('data-label' => 'Description <span style="color:red">*</span>')); ?>
            </li>
            <li class="col-sm-3">
            <?php 
            echo $form->dropDownList($model, 'active_stock_count', array('Y'=>'Yes','N'=>'No'), array('data-label'=>'Active Stock Count')); 
           
            ?>
        </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger " id="stockcountfile_close" data-dismiss="modal">Close</button>
<?php
$url = Yii::app()->createUrl('/stockcount/StockCountFile/SaveStockCountFile');
echo CHtml::ajaxsubmitButton('Save', $url, array(
    'dataType' => 'json',
    'type' => 'post',
    'success' => 'function(data) {
            $("#loader").hide();
            if(data.status=="success"){  
                 t8.success("Stock Transactions Saved Successfully!");
                 $("#stockcountfile_close").click();
                reloadTable("#tbl_stockcountfile_details");

            } else { 
                $("#stockcountfile-form .stockcountfile-save-btn").prop("disabled", false);
                $("#stockcountfile-form .stockcountfile-save-btn").addClass("btn-theme").removeClass("btn_loding");
                $.each(data, function(key, val) {
                        t8.error(""+val+""); 
                }); 
            } 
    }',
    'beforeSend' => 'function(){
        $("#loader").show();
        $(".toast8-error").hide(); 
        $("#stockcountfile-form .stockcountfile-save-btn").prop("disabled", true);
        $("#stockcountfile-form .stockcountfile-save-btn").addClass("btn_loding").removeClass("btn-theme");
    }'
        ), array('id' => 'mybtn' . rand(), 'class' => 'stockcountfile-save-btn btn btn-theme'));
?>
</div>

<?php $this->endWidget(); ?>










