<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        <p>Schedule List</p>
        <div class="pull-right">
            <div class="filter_details">
            
            <?php
                if($from_date!=''){
                    ?>
                        <div class="filter-item">
                            <label>From Date :</label>
                            <?php echo $from_date; ?>
                        </div>
                    <?php
                }
                if($to_date!=''){
                    ?>
                        <div class="filter-item">
                            <label>To Date :</label>
                            <?php echo $to_date; ?>
                        </div>
                    <?php
                }
                if($customer_id!=''){
                    ?>
                        <div class="filter-item">
                            <label>Customer Name :</label>
                            <?php echo Customer::model()->findByPk($customer_id)->customer_name; ?>
                        </div>
                    <?php
                }
                if($employee_id!=''){
                    ?>
                        <div class="filter-item">
                            <label>Employee Name :</label>
                            <?php echo Employee::model()->findByPk($employee_id)->employeecode; ?>
                        </div>
                    <?php
                }
                if($contract_id!=''){
                    ?>
                        <div class="filter-item">
                            <label>Contract No :</label>
                            <?php echo $contract_id; ?>
                        </div>
                    <?php
                }
                if($status!=''){
                    ?>
                        <div class="filter-item">
                            <label>Status :</label>
                            <?php echo ($status=='C')?'Done':Pending; ?>
                        </div>
                    <?php
                }
            ?>
            
            </div>
        </div>
    </div>
    <div class="panel-body"> 
        <div class="table-responsive"> 
        <input type="hidden" id="product_id" name="product_id" value="<?php echo $product_id;?>" />
        <input type="hidden" id="brand_id" name="brand_id" value="<?php echo $brand_id;?>" />
       
        <table id="tbl_reorder_level_table" class="table table-fixed table-bordered table-primary dataTable">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Date</th>  
                    <th>Contract No</th>  
                    <th>Customer</th>  
                    <th>Employee</th>  
                    <th>Description</th>  
                    <th>Status</th>
                </tr>
            </thead>
            <tbody> 
                <?php 
                $condition = '1=1'; 
                if($from_date != ''){    
                    $fromdate=date('Y-m-d', strtotime(str_replace('/', '-', $from_date)));
                    $condition .= ' AND t.scheduled_date >= "'.$fromdate.'"';
                }
                if($to_date != ''){    
                    $condition .= ' AND t.scheduled_date <="'.date('Y-m-d', strtotime(str_replace('/', '-', $to_date))).'"';
                }
                if($customer_id>0){    
                    $condition .= ' AND order_det.customer_id ="'.$customer_id.'"';
                }
                if($employee_id>0){    
                    $condition .= ' AND '.$employee_id.' IN (t.employee_ids)';
                }
                if($contract_id>0){    
                    $condition .= ' AND order_det.contract_no ='.$contract_id;
                }
                if($status!=''){    
                    $condition .= ' AND t.status ="'.$status.'"';
                }
                $model_schedules = ServiceSchedules::model()->with('order_det')->findAll(array('condition'=>$condition,'order'=>'scheduled_date asc'));
                foreach ($model_schedules as $i => $each) {
                    $schedule_date='-';
                    if($each->scheduled_date!='0000-00-00')
                        $schedule_date=date('d/m/Y', strtotime($each->scheduled_date));
                    $status='-';
                    if($each->status=='A')
                        $status='Pending';
                    else if($each->status=='C')
                        $status='Done';
                    ?>
                <tr>
                    <td><?php echo $i+1;?></td>
                    <td><?php echo $schedule_date;?></td>
                    <td><?php echo $each->order_det->contract_no;?></td>
                    <td><?php echo $each->order_det->customer->customer_name;?></td>
                    <td><?php echo $each->EmployeeNames.'('.$each->EmployeeCodes.')';?></td>
                    <td><?php echo $each->description;?></td>
                    <td><?php echo $status;?></td>
                </tr>
            <?php 
                }
            ?>
            </tbody>
        </table>
            <br>
<!--             <div class="btn-wrap text-center">    
              <?php 
              echo CHtml::link('Export PDF',array('reports/PrintMinimumOrderPdf','brand_id' => $brand_id, 'part_no' => $part_no), array('title'=>'Print Lead List','target'=>'_blank','class' =>  'btn btn-theme'));
              //echo CHtml::link('Export PDF',array('reports/PrintInventoryReportPDF','part_number'=>$part_number,'generic_name'=>$generic_name), array('title'=>'Print Lead List','target'=>'_blank','class' =>  'btn btn-theme')); 
              ?>    
              <button type="button" class="btn btn-theme" onclick="MinimumOrderExcel();">Export Excel</button>
        </div>    -->
           
        </div>
    </div>
</div>

<?php $cs = Yii::app()->getClientScript(); 

/*$cs->registerScript("MinimumOrderExcel", "function MinimumOrderExcel(id){

    var url= '" . Yii::app()->createUrl('reports/PrintEnquiryExcelId') . "';

    var brand_id = $('#minimumorderqty_brand_name').val();

    var part_no = $('#minimumorderqty_part_no').val();

    window.open($('#liveSite').val()+'index.php?r=reports/PrintMinimumOrderExcel&part_no='+part_no+'&brand_id='+brand_id , '_blank');

}", CClientScript::POS_HEAD);*/