<table border="1">
    <thead>
        <tr><td colspan="8">Schedule List</td></tr>
        <?php
        if ($from_date != '') {
            ?>
            <tr>
                <th colspan="3">From Date</th> 
                <td colspan="5"><?php echo $from_date; ?>
                </td> </tr>
            <?php
        }
        if ($to_date != '') {
            ?>
            <tr>
                <th colspan="3">To Date</th>                 
                <td colspan="5">
                    <?php echo $to_date; ?>
                </td> </tr>
            <?php
        }
        if ($customer_id != '') {
            ?>
            <tr>
                <th colspan="3">Customer Name</th>                 
                <td colspan="5">
                    <?php echo Customer::model()->findByPk($customer_id)->customer_name; ?>
                </td> </tr>
            <?php
        }
        if ($employee_id != '') {
            ?>
            <tr>
                <th colspan="3">Employee Name</th>                 
                <td colspan="5">
                    <?php echo Employee::model()->findByPk($employee_id)->employeecode; ?>
                </td> </tr>
            <?php
        }
        if ($contract_id != '') {
            ?>
            <tr>
                <th colspan="3">Contract No</th>                 
                <td colspan="5">
                    <?php echo $contract_id; ?>
                </td> </tr>
            <?php
        }
        if ($status != '') {
            ?>
            <tr>
                <th colspan="3">Status</th>                 
                <td colspan="5">
                    <?php echo ($status == 'C') ? 'Done' : Pending; ?>
                </td> </tr>
            <?php
        }
        ?>
        <tr>
            <th>No</th>
            <th>Date</th>  
            <th>Contract No</th>  
            <th>Customer</th>  
            <th>Service</th>  
            <th>Employee</th>  
            <th>Description</th>  
            <th>Status</th>
        </tr>
    </thead>
    <tbody> 
        <?php
        $condition = '1=1';
        if ($from_date != '') {
            $condition .= ' AND t.scheduled_date >= "' . date('Y-m-d', strtotime(str_replace('/', '-', $from_date))) . '"';
        }
        if ($to_date != '') {
            $condition .= ' AND t.scheduled_date <="' . date('Y-m-d', strtotime(str_replace('/', '-', $to_date))) . '"';
        }
        if ($customer_id > 0) {
            $condition .= ' AND order_det.customer_id ="' . $customer_id . '"';
        }
        if ($employee_id > 0) {
            $condition .= ' AND ' . $employee_id . ' IN (t.employee_ids)';
        }
        if ($contract_id > 0) {
            $condition .= ' AND order_det.contract_no =' . $contract_id;
        }
        if ($status != '') {
            $condition .= ' AND t.status ="' . $status . '"';
        }
        $model_schedules = ServiceSchedules::model()->with('order_det')->findAll(array('condition' => $condition, 'order' => 'scheduled_date asc'));
        foreach ($model_schedules as $i => $each) {
            $schedule_date='-';
            if($each->scheduled_date!='0000-00-00')
                $schedule_date=date('d/m/Y', strtotime($each->scheduled_date));
            $status = '-';
            if ($each->status == 'A')
                $status = 'Pending';
            else if ($each->status == 'C')
                $status = 'Done';
            ?>
            <tr>
                <td><?php echo $i + 1; ?></td>
                <td><?php echo $schedule_date;?></td>
                <td><?php echo $each->order_det->contract_no; ?></td>
                <td><?php echo $each->order_det->customer->customer_name; ?></td>
                <td><?php echo $each->product_det->part_number; ?></td>
                <td><?php echo $each->EmployeeNames . '(' . $each->EmployeeCodes . ')'; ?></td>
                <td><?php echo $each->description; ?></td>
                <td><?php echo $status; ?></td>
            </tr>
            <?php
        }
        ?>
    </tbody>
</table>