<!DOCTYPE html>
<html>
    <?php
    $crm_login_company_id = Yii::app()->user->master_user_company_id;
    $model = Order::model()->findByPk($id);
    $approvecondition = 't.file_id = "' . $model->file_id . '"';
    $approvemodel = new ApprovalHistory();
    $approvemodel = $approvemodel->with('approvedby')->find(array('condition' => $approvecondition, 'order' => 't.id desc'));
    $approved_date = date("d/m/Y", strtotime($approvemodel->created_datetime));
    ?>
    <head>
        <title>CONTRACT</title>
        <style>
            .contract_text{
                font-family: Arial, sans-serif;
                font-size: 13px;
                color: black;

            }
            .contractlogo {
                height: 50px;
                padding: 5px 20px 5px;
                float: left;
                width: 100%;
                line-height: 40px;
            }
            body {
                background: rgb(204,204,204); 
            }
            page {
                background: white;
                display: block;
                margin: 0 auto;
                margin-bottom: 0.5cm;
                box-shadow: 0 0 0.5cm rgba(0,0,0,0.5);
            }
            page[size="A4"] {  
                width: 21cm;
                height: 29.7cm; 
            }
            /*page[size="letter"] {
                width: 21.59cm;
                height: 27.94cm;  
            }*/
            @media print {
                body, page {
                    margin: 0;
                    box-shadow: 0;
                }
            }
        </style>

    </head>
    <?php
    
    $mpdf->use_kwt = true;
    function ordinalSuffix($num) {

        $suffixes = array("st", "nd", "rd");
        $lastDigit = $num % 10;
        if (($num < 20 && $num > 9) || $lastDigit == 0 || $lastDigit > 3)
            return "th";
        return $suffixes[$lastDigit - 1];
    }

    function convert_number_to_words($number) {

        $hyphen = ' ';
        $conjunction = ' and ';
        $separator = ' ';
        $negative = 'negative ';
        $decimal = ' point ';

        $dictionary = array(
            0 => 'Zero', 1 => 'One',
            2 => 'Two', 3 => 'Three',
            4 => 'Four', 5 => 'Five',
            6 => 'Six', 7 => 'Seven',
            8 => 'Eight', 9 => 'Nine',
            10 => 'Ten', 11 => 'Eleven',
            12 => 'Twelve', 13 => 'Thirteen',
            14 => 'Fourteen', 15 => 'Fifteen',
            16 => 'Sixteen', 17 => 'Seventeen',
            18 => 'Eighteen', 19 => 'Nineteen',
            20 => 'Twenty', 30 => 'Thirty',
            40 => 'Fourty', 50 => 'Fifty',
            60 => 'Sixty', 70 => 'Seventy',
            80 => 'Eighty', 90 => 'Ninety',
            100 => 'Hundred', 1000 => 'Thousand',
            1000000 => 'Million', 1000000000 => 'Billion',
            1000000000000 => 'Trillion', 1000000000000000 => 'Quadrillion',
            1000000000000000000 => 'Quintillion'
        );

        if (!is_numeric($number)) {

            return false;
        }

        if (($number >= 0 && (int) $number < 0) || (int) $number < 0 - PHP_INT_MAX) {

            // overflow

            trigger_error(
                    'convert_number_to_words only accepts numbers between -' . PHP_INT_MAX . ' and ' . PHP_INT_MAX, E_USER_WARNING
            );

            return false;
        }

        if ($number < 0) {

            return $negative . convert_number_to_words(abs($number));
        }

        $string = $fraction = null;

        if (strpos($number, '.') !== false) {

            list($number, $fraction) = explode('.', $number);
        }

        switch (true) {

            case $number < 21:

                $string = $dictionary[$number];

                break;

            case $number < 100:

                $tens = ((int) ($number / 10)) * 10;

                $units = $number % 10;

                $string = $dictionary[$tens];

                if ($units) {

                    $string .= $hyphen . $dictionary[$units];
                }

                break;

            case $number < 1000:

                $hundreds = $number / 100;

                $remainder = $number % 100;

                $string = $dictionary[$hundreds] . ' ' . $dictionary[100];

                if ($remainder) {

                    $string .= $conjunction . convert_number_to_words($remainder);
                }

                break;

            default:

                $baseUnit = pow(1000, floor(log($number, 1000)));

                $numBaseUnits = (int) ($number / $baseUnit);

                $remainder = $number % $baseUnit;

                $string = convert_number_to_words($numBaseUnits) . ' ' . $dictionary[$baseUnit];

                if ($remainder) {

                    $string .= $remainder < 100 ? $conjunction : $separator;

                    $string .= convert_number_to_words($remainder);
                }

                break;
        }

        if (null !== $fraction && is_numeric($fraction)) {

            $string .= $decimal;

            $words = array();

            foreach (str_split((string) $fraction) as $number) {

                $words[] = $dictionary[$number];
            }

            $string .= implode(' ', $words);
        }

        return strtolower($string);
    }

    $first_party = 'Diatech Medical Equipment Trading and Maintenance';
    $second_party = $model->customer->customer_name;
    $order_date = date('d/m/Y', STRTOTIME($model->order_date));
    $futureDate = date('Y-m-d', strtotime('+1 year', strtotime($model->order_date)));
    $futureDate = date('Y-m-d', strtotime('-1 days', strtotime($futureDate)));
    $start_date = date('M d, Y', STRTOTIME($model->order_date));
    $end_date = date('M d, Y', STRTOTIME($futureDate));
    if ($model->billing_address != '') {
        $add = $model->billing_address;
    }
    $add = str_replace("\r\n", " , ", $add);
    $customer_add = trim($add);
    $grand_total = $model->grand_total;
    $total_tax_amount = $model->total_tax_amount;
    $currency = $model->currencyname->currency_code;
    $total = $grand_total - $total_tax_amount;

    $currencydetails = '(Price ' . round($total, 2) . '+5% VAT ' . $total_tax_amount . ' )';
    $arr_scheduleitems = array();
    $tot_qty = 1;
    $condition = ' t.order_id ="' . $id . '"';
    $serviceschedules = ServiceSchedules::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));
    if (!empty($serviceschedules)) {
        foreach ($serviceschedules as $i => $each) {
            if ($i == 0) {
                $schedule_start_date = $each->scheduled_date;
            } else {
                $arr_scheduleitems[$i - 1] = $each->scheduled_date;
                $tot_qty+=1;
            }
        }
    } else {
        $schedule_start_date = $model->order_date;
        $arr_scheduleitems = '';
    }
    $tot_qty_var = convert_number_to_words(abs($tot_qty));
    $formated_schedule_start_date = date('M d, Y', STRTOTIME($schedule_start_date));
    $contactcondition = 't.customer_id = "' . $model->customer->id . '" AND t.isActive="Y"';
    $modelcustomercontact = CustomerContact::model()->with('customer')->findAll(array('condition' => $contactcondition));
    ?>
    <body>
    <page size="A4">
        <div class="contract_text">
            <div  style="width:100%;float: left;margin-top: 10px;font-size:12px;font-family:'Times New Roman', Times, serif;"> 
                <htmlpageheader name="firstpage" style="display:none">
                </htmlpageheader>

                <htmlpageheader name="otherpages" style="display:none">
                    <div style="text-align:left;">
                        <b><?php echo "Serial No: " . $model->contract_no; ?></b>
                    </div>
                </htmlpageheader>
                <sethtmlpageheader name="firstpage" value="off" show-this-page="1" />
                <sethtmlpageheader name="otherpages" value="on" />
            </div>
            <div class="col-12">
                <img src="<?php echo 'images/logo/contract_pdf_logo.png'; ?>" class="logo">
            </div>


            <div  style="text-align: left;">
                <b><?php echo "Serial No: " . $model->contract_no; ?></b>
            </div>
            <div  style="text-decoration: underline;text-align: center;">
                <b><?php echo "MAINTENANCE AGREEMENT"; ?></b>
            </div>

            <p>
                This contract is made and entered into on <b><?php echo $start_date; ?></b> and end on <b><?php echo $end_date; ?></b> by and between <b><?php echo $first_party; ?> (first party)</b>, whose address is PO Box 97122 and <b><?php echo $second_party; ?>(Second Party)</b>,whose address is <b><?php echo $customer_add; ?></b>
            </p>
            <p>
                Whereas <b><?php echo $first_party; ?> (first party)</b> is engaged in the business of servicing and maintaining and is willing to provide such services to <b><?php echo $second_party; ?>(Second Party)</b> as per the terms herein.
            </p>
            <p>
                Whereas <b>Client (Second Party)</b> desires to have <b><?php echo $first_party; ?>(First Party)</b> furnish maintenance on the following:
            </p>
            <p>
                Now, Therefore, in consideration of the mutual covenants and promises hereinafter set forth, the parties hereto agree as follows.
            </p>
            <div>
                <b> 1. Maintenance Services.</b><br/>
                <p style="margin-left: 3px;">Diatech (First Party) shall carry out <b><?php echo $tot_qty_var; ?> preventive maintenances only</b>, excluding any repair jobs, spare parts or accessories, for following list of Equipment: </p>  
                <?php echo $model->schedule_terms; ?>
                <div>
                    <b>1.1 1st Inspection on <?php echo $formated_schedule_start_date; ?>.</b>
                    <ul>
                        <li>Examine the exterior of the unit for cleanliness and general physical condition.</li>
                        <li>Confirm the presence and condition of all accessories, which includes cables, cords, tubes, hoses, fittings, connectors and others. Inspect for any sign of damage.</li>
                        <li>Examine all controls, valves and switches for physical condition, secure mounting and correct motion. Confirm the operation of all lights, indicators, meters, gauges, and visual displays on the unit.</li>
                        <li>Verify that the remote alarm indicator functions properly. Induce alarm condition to activate audible and visual alarms.</li>
                        <li>Perform self-test and necessary testing to verify readiness of operation.</li>
                    </ul>
                </div>
                <br/>
                <?php
                if (!empty($arr_scheduleitems)) {
                    foreach ($arr_scheduleitems as $i => $each1) {
                        $k = ($i + 2);
                        $var = '1.' . $k . ' ' . $k . ordinalSuffix($k) . ' Inspection on ' . date('M d, Y', STRTOTIME($each1));
                        ?>
                        <div>
                            <b><?php echo $var; ?></b>
                            <ul>
                                <li>Above stated procedures in 1.1 .</li>
                                <li>Replacement of part assessed and recommended by the Diatech (First Party) engineer after the approval on the replacement and the cost once applicable.</li>
                            </ul>
                        </div>
                        <br/>
                        <?php
                    }
                }
                ?>


                <div>
                    <b>Note: The Spare parts needed for repair or maintenance or requested by the client(Second Party) are subjected to availability and its cost and labor charges are NOT included in this offered contract and will be charged to the client (Second Party) after approval from the Client (Second Party).</b>
                </div>
                <br/><br/>
                <div>
                    <b>INSPECTION CARE SERVICE COVERS THE FOLLOWING:</b>
                    <ul>
                        <li>Checking operational readiness</li>					
                        <li>Verification Test (general equipment performance with electrical safety test if agreed officially between both parties to add the same to the scope of service (This Contract First and Second Parties)</li>
                        <li>Technical Documentation.</li>
                        <li>Sticker Label.</li>
                    </ul>
                </div>
                <p>First Party shall provide scheduled preventive maintenance during regular basis with the schedule to be based on the specific needs of the equipment as determined by Diatech (First Party) or as agreed with the client (Second Party). </p>

            </div>
            <div><b>2. Excluded Services</b><br/>
                <p>
                    Repairing jobs during the preventive maintenance or before / after the same. Any repairing jobs will be charged separately to the client (Second Party) on cash basis, unless agreed officially otherwise by the first party.
                </p>
                <p>
                    If the Engineer suspected life or health threatening issues on the time of the Maintenance for the following “but not limited to”
                </p>
                <p>
                    1.      Infection control issues in both facility or the Equipments<br/>
                    2.	Any natural Disasters or pandemic locally or internationally <br/>
                    3.	Any other reasons related to the equipment or facility that might cause a risk on the Engineer.
                </p>
                <p>
                    In case of Annual Maintenance Contracts which includes both repairing the Client (second party)  equipment and carrying out preventive maintenance, any correction of disturbances/defects which
                </p>
                <div><ul>
                        <li>   Any repair or PPM after the expiration of this agreement validity</li><br/>
                        <li>   Are caused by modifications of the equipment carried out by the Client (second party) or third parties.</li><br/>
                        <li>   Are caused by improper repairs carried out by the Client (second party) or third parties,</li><br/>
                        <li>   Are caused by the use of third parties equivalent/duplicate spare parts and accessories other than the original specified parts or proposed by Diatech (First Party) engineer.</li><br/>
                        <li>   Have been caused by improper handling of the respective apparatus.</li><br/>
                        <li>   Customer refused or delayed or didn’t carry the PPM on the PPM agreed time for any reason without official approval by diatech.</li>

                    </ul></div>
                <br/>
                <p>
                    If the services described in the provision are authorized/requested to be performed by the Client (second party), and if Diatech (first party) agrees to perform the requested service, an additional charge will be made for the requested services and will be Paid Cash by the client (second party) to Diatech (first party) (any charges occurring for the same is not included in the agreed contract price and will be considered and additional charges).
                </p>
            </div>
            <div>
                <b>3. Warranty </b><br/>
                <p>
                    Diatech (First Party) agrees that the service engineer will be qualified and will use reasonable care performing his duties.
                </p>
                <p>
                    Diatech (First Party) warrants that the inspection cares (as agreed in the scope of service in point 1) will be carried out as per the highest standards and as per Diatech (First Party) standards and rules for agreed contract period. Upon the expiration or termination of this contract, or in the event of any due payment from the client (second party) to Diatech (First Party), all service calls will be charged at the standard rate set by Diatech (First Party).
                </p>
            </div>
            <div><b>4. Working Hours</b><br/>
                <p>
                    <b>(a)</b>	The agreed services on this Contract, shall be performed during the regular working hours of its regular working days, consisting from 9:00 am to 1:00 pm and/or 4:00 pm to 6: 00 pm from Saturday to Thursday only.
                    <br/>
                    <b>(b)</b>	If the Client (second party) requests Diatech (First Party)to perform any of its services at times other than the mentioned timings stated in point 4 (a), the Client (second party) shall be charge 300AED per hour as adjusted periodically to compensate for changes in the cost of labor.

                </p>
            </div>

            <div><b>5. Contract Price</b><br/>
                <p>
                    <b>5.1. </b>	The Client (second party) shall pay <b>Current Dated Cheque /Cash on</b> the same date <b><?php echo $start_date; ?></b> at the rate of <b><?php echo $grand_total; ?> <?php echo $currency; ?> <?php echo $currencydetails; ?></b> from regular services to be performed under this Contract.
                </p>
                <p>
                    <b>5.2. </b>	The amount specified in (a) shall be adjusted annually to reflect any changes in the costs of labor charges, parts, equipment, and materials supplied by the Service Company (first party) under this Contract
                </p>
            </div>
            <div><b>6. Term of Contract</b><br/>
                <p>
                    The term of this contract shall commence from <b><?php echo $start_date; ?> to <?php echo $end_date; ?></b> and can be renewed as mutually agreed and contracted for by both parties. Either party may terminate this contract by giving one month’s notice in writing, however, the client (second party) shall pay all the contract agreed amount considering that Diatech (first party) had reserved its variety of its resources and time to service and honor this contract.
                </p>
                <p>
                    The Client (second party) will make the equipment requested for PM or repair and stated in this contract available on scheduled date of service or else on the agreed date and time of Diatech (first party). Furthermore, the Client (second party) will make sure that all facilities and requirements needed in the time of servicing the client (second party) contracted items, which including consumables such us pads, IV sets, testing kits, tubing, gloves, or any other consumables necessary to test the unit for the agreed services will be available/provided to Diatech (first part) staff at no cost.
                </p>
                <p>    
                    In the event that the date specified by Diatech (first party) to carry the agreed services in this contract, does not suit the Client (second party), the Client (second party) will immediately inform Diatech (first party).
                </p>
                <p>    
                    Diatech (first party) reserves the right to stop repair service, preventive maintenance or any of the agreed services in this contract and terminate this contract immediately, if the Client (second party) does not settle the payment of this contract as agreed in point 5 in this contract, where the payment due will still be valid and must be paid by the client (second party) even after terminating the contract by any party due to any reason. In case of any delay for the payment by the client (second party) or if the client (second party) didn’t pay the contract dues as agreed in point 5 in this contract, Diatech (First party) reserve the right to charge the client (second party) delay payment fees of 10% on monthly basis of the agreed amount of this contract stated in point 5 starting from day 1 of the first due payment stated in point 5 of this contract. In addition, Diatech (first party) reserve the right to follow the legal procedures against the client (second party) at any point in the event of any unpaid balance or pending payments by the client (second party).
                </p>
                <p>
                    This contract is for general inspection (Preventive Maintenance) and excluding any repair jobs (unless stated otherwise in this contract). In case Diatech (first party) engineer finds any defect in the unit, he will be “if possible” informing the client (second party) what is that defect. In case any repair jobs requirements during the preventive maintenance or after thatwhich is authorized/requested to be performed by the client (second party), and if Diatech (first party) agrees to perform the requested service, an additional charge will be made for the requested services and will be Paid Cash by the client (second party) to Diatech (first party) (any charges occurring for the same is not included in the agreed contract price and will be considered and additional charges).
                </p>
                <p>
                    Diatech (first party) will not be responsible on any damages/claims or any legal responsibility related to any of the provided services agreed in this contract or provided to the Client (second party) by any means which includes the equipment performance, equipment quality, spare parts, consumables, accessories or any other issues occurring after signing the service report or accepting the delivery of the item/service (depend on the provided service and as per Diatech (first party) documentation process) submitted by Diatech (first party) to the client (second Party).
                </p>
                <p>
                    Client (second Party) will be handing the unit in working condition and with full functionality and with full accessories for Diatech (first party) engineer to carry out the preventive maintenance. In case of any defect for the unit or for its accessories before the preventive maintenance is carried out, Diatech (first party) will not be repairing it and will not be reimbursing anything for the Client (second party) which includes all accessories and consumables defects or missing and the service will be considered completed by Diatech (first party) were client (second party) are requested to pay for it.
                </p>
                <br/>


            </div>
            <div><b>7. Miscellaneous Provision </b><br/>
                <p>
                    (a)Parties Bound: This contract shall be binding on and inure to the benefit of the parties to this contract and their respective heirs, executors, administrators legal representatives, successors and assigns as permitted by this contract.
                    <br/>(b)Legal Construction: In the event any one or more of the provision is contained in this contract shall for any reason be held invalid, illegal or, unenforceable in any respect, that invalidity, illegality, or unenforceability shall not affect any other provision. This contract shall be construed as if the invalid, illegal, or unenforced provision had never been contained in it.
                    <br/>(c)Amendments. This contract may be amended by the parties only by a written contract signed by both parties.

                </p>
            </div>
            <div><b>8. Liability</b>
                <p>
                    The total aggregate liability of both parties Client (second party)&the Service Provider (first party) arising out of or in connection with this Agreement whether arising from contract, tort, negligence or otherwise shall in no event exceed the total Remuneration payable to the Service Provider pursuant to this Agreement. The only event excluding this point is mentioned in point 6 in this contract which is related to the event of delay in payment from client (second party) side.
                </p>
                <?php echo $model->liability; ?>
            </div>
            <div><b>9. Signatures</b><br/>
                <p>
                    This contract shall be signed on behalf of <b><?php echo $first_party; ?> (First Party)</b> by Eng.Mohammed Assad, and on behalf of <b><?php echo $second_party; ?>(Second Party)</b>
                </p>
                <br/>
                <table class="table_box" >
                    <tr>
                        <td>
                            <h5>SERVICE COMPANY (First Party)<br/>
                                <b>Date : <?php echo $approved_date; ?></b><br/>
                                <b><?php echo $first_party; ?></b>
                            </h5><br/>
                            <div class="h5sub-details">

                                <b>For Eng.Mohammed Assad its</b><br/>
                                <img src="<?php echo 'images/logo/muhammed_sign.jpeg'; ?>" height="50" class="logo">
                                <br/>
                                ____________________________<br/>
                                <b>Stamp of the Company</b>
                            </div>
                        </td>
                    </tr>
                </table>
                <br/>
                <table class="table_box" >
                    <tr>
                        <td>
                            <h5>Client (Second Party)<br/>
                                <b>Date : <?php echo $approved_date; ?></b><br/>
                                <b><?php echo $second_party; ?></b>
                            </h5><br/>
                            <div class="h5sub-details">  
                                <?php
                                echo '<br/>' . 'By its : ';
                                foreach ($modelcustomercontact as $row) {
                                    if (strtoupper(trim($row['person_name'])) != 'SALES/ACCOUNT') {
                                        echo '<br/><b>' . $row['person_name'] . '</b><br/>' . $row['designation'] . '.<br/>' . '<br/>' . '<br/>';
                                    }
                                    echo '_____________________________' . '<br/>';
                                }
                                echo '<br/><b>Stamp of the Company</b>' . '<br/>';
                                ?>
                            </div>
                        </td>
                    </tr>
                </table>    

            </div>            
            <htmlpagefooter name="myfooter">
                <div style="border-top: 1px dotted #000000; font-size: 14px; padding-top: 10px; text-decoration: black;">
                    <div class="row">
                        <div class="col-4" style="text-align: left;font-weight: bold">&nbsp;</div>
                        <div class="col-2" style="font-weight: bold"><img src="<?php echo 'images/logo/first_party_sign.png'; ?>" height="30" class="logo"></div>
                        <div class="col-6" style="text-align: right;font-weight: bold">&nbsp;</div>
                    </div>
                    <div class="row">
                        <div class="col-6" style="text-align: left;font-weight: bold"> Service Provider (First Party) …………….</div>
                        <div class="col-6" style="text-align: right;font-weight: bold">Client (Second Party) ...……………. </div>
                    </div>
                    <div class="row">
                        <div style="text-align:left;"><?php echo "Serial No: " . $model->contract_no; ?></div>
                    </div>
                    <div style="text-align:center;width:100%">Page {PAGENO} / {nb} </div>
                </div>
            </htmlpagefooter>
        </div>
    </page>
    <style type="text/css">
        .table_box{
            margin-left: 200px;
            page-break-inside:avoid;
            padding: 5px;
            border: 1px solid #000000;
            text-align: center;
            margin-top: 15px;
            border-radius: 5px;
            width: 60%;
        }
        .table_box h5{
            margin-top:0px;
            color: #000000;
        }

    </style>
</body>
</html>
