<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("cancelhiringinvoice", "function cancelhiringinvoice(invoice_id) {
    jConfirm('Confirm Cancellation of Invoice No- '+invoice_id+' ?', 'Confirmation Dialog', function(r) {
        if (r == true) {
                jQuery.ajax({
                    'dataType':'json',
                    'data' :{'id':invoice_id},
                    'type':'post',
                    'url': '" . Yii::app()->createUrl('service/invoice/cancelhiringinvoice') . "',
                    'cache': false,
                    'success': function(data) {
                        if(data.status=='success'){
                            t8.success('Invoice Cancelled!');  
                            reloadTable('#tble_invoice'); 
                        }else{
                            $.each(data, function(key, val) { 
                                t8.error('Error In Cancellation'); 
                            }); 
                        }
                    }, 
                    'beforeSend':function(){
                        $('#loader').show();
                    },
                    'complete':function(){
                        $('#loader').hide();   
                    }
                });     
            }
        }); 
};", CClientScript::POS_HEAD);
?>
<script type="text/javascript">
    $(document).ready(function() {

    var table_id = "#tble_invoice";
    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
    data.invoice_type = $("#invoice_type").val();
    data.frm = $("#frm").val();
    return data;
    }).DataTable({
    scrollY         : "645px",
            pageLength      : 100,
            processing: true,
            columns: [
            {className: "sl col-max-1"},
            {className: "sl col-max-1"},
            {className: "sl col-max-1"},
            {className: "sl col-max-1"},
            {className: "sl col-max-1" },
            {className: "sl col-max-3" },
            {className: "sl col-max-1" },
            {className: "sl col-max-1" },
            {className: "sl col-max-1 text-right"},
            {className: "sl col-max-1 text-right"},
            {className: "sl col-max-1"},
            {className: "sl col-max-1"},
            {className: "sl col-max-1"},
            {className: "sl col-max-1"},
            {className: "sl col-max-1"},
            {className: "sl col-max-1"},
            {className: ""},
            {className: "sl col-max-1"},
            ],
            "columnDefs": [
            {
            "targets": [12, 13, 14, 15, 16],
                    "visible": false,
            },
            ],
            ajax: {
            url: "<?php echo Yii::app()->createUrl('service/invoice/getlist'); ?>",
                        data: {"frm":<?php echo $frm; ?>},
                        type: "POST",
                        cache : false,
                },
                serverSide:     true,
                fixedColumns:   true,
                processing: true,
                fixedHeader: {
                headerOffset: $("header.main").outerHeight()
                },
                "fnCreatedRow"  : function(nRow, aData, iDataIndex){
                $(nRow).addClass("context-menu");
                },
                "fnRowCallback" : function(nRow, aData, iDisplayIndex, iDisplayIndexFull){
                if (aData[20] == "C"){
                $("td", nRow).css("background-color", "#ffcccb");
                } else if (aData[16] == "H"){
                $("td", nRow).css("background-color", "#D6FCDA");
                } else if (aData[16] == "A"){
                $("td", nRow).css("background-color", "#FFFACD");
                }
                else if (aData[19] == "Y"){
                $("td", nRow).css("background-color", "#94EA9F");
                }
                $('#tble_invoice tbody').on('mouseover', 'tr', function () {
                $.contextMenu('destroy');
                });
                $('#tble_invoice tbody').on('click', 'tr', function () {
                var data = table.row(this).data();
                var invoice_nature = data[16];
                var invoice_status = data[20];
                var invoice_posted = data[21];
                var invoice_cancel = data[22];
                var direct_invoice = data[19];
                $.contextMenu({
                selector: '.context-menu',
                        callback: function(key, options) {
                        var action_id = key;
                        var data = table.row(this).data();
                        var file_id = data[0];
                        var id = data[12];
                        var customer_id = data[13];
                        var crm_user_id = data[14];
                        var is_hiring_invoice = data[15];
                        var customer_name = data[18];
                        if (action_id == "printpartnumber"){
                        window.open($('#liveSite').val() + "/index.php?r=service/invoice/PrintInvoiceReportPDF&id=" + id + "&c_id=" + crm_user_id + '&frm=tax&barcode=N', "_blank")
                        }
                        else if (action_id == "activity"){
                        loadPopupModal("activity/create&file_id=" + file_id + "&customer_id=" + customer_id, "Edit Activity", "xl");
                        } else if (action_id == "view"){
                        loadPopupModal("service/invoice/view&id=" + id, "View Invoice - " + file_id + "/" + id + "/" + customer_name, "xl");
                        }
                        else if(action_id == "uploaddocument"){
                            loadPopupModal("document/UploadERPDocument&frm=I&file_id=" + file_id, "Upload Document - " + file_id + "/" + id, "lg");
                        }
                        },
                        items: {

                <?php if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["hiring_invoice_view"])) && $frm == 1) { ?>
                            "view": {name: "View", icon: "fa-eye", disabled: function(key, opt) {
                            if (invoice_nature == 'A'){
                            return !this.data('viewDisabled');
                            }
                            }
                            },
                <?php } ?>

                <?php if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_activity"]))) { ?>
                            "activity": {name: "Activity", icon: "fa-certificate"},
                <?php } ?>
                <?php if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["invoice_print"]))) { ?>
                            "printpartnumber": {name: "Print", icon: "fa-print"
                            },
                <?php } ?>
                
                 <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["invoice_view"])) { ?>
                "uploaddocument": {name: "Upload Document", icon: "fa-upload"},
                <?php } ?>

                        }
                });
                });
                }
        });
        });
    </script>

<section class="panel">
    <input type="hidden" name="frm" id="frm" value="<?php echo $frm; ?>">
        <header class="panel-heading clearfix panel-theame-new">
            <i class="fa fa-user"></i> Invoice
            <div class="pull-right">
                <!--<div class="col-md-12">
                    <div class="col-md-8" width="100%">
                        <?php echo CHtml::dropdownlist('invoice_type', '', MasSalesGroup::getSalesGroup(), array('class' => 'form-control', 'onchange' => 'reloadTable("#tble_invoice");', 'prompt' => 'All')); ?>
                    </div>
                    
                </div>-->
            </div>
        </header>   
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tble_invoice">
                    <thead>
                        <tr>
                            <th>File</th>
                            <th>Type</th>
                            <th>Inv No</th>
                            <th>Order No</th>
                            <th>Inv Date</th>
                            <th>Customer</th>
                            <th>Lead Owner</th>
                            <th>Curr</th>
                            <th>VAT</th>
                            <th>Value</th>
                            <th>Status</th>
                            <th>CN</th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th>Created By</th>
                        </tr>
                    </thead>

                </table>
            </div>
            <div class="color-indicator">
                <span style="display: inline-block;width:30px;height:30px;background:#ffffff; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Sales</span>
                <span style="display: inline-block;width:30px;height:30px;background:#D6FCDA; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Hire</span>
                <span style="display: inline-block;width:30px;height:30px;background:#94EA9F; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Direct Invoice</span>
                <span style="display: inline-block;width:30px;height:30px;background:#FFFACD; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Advance</span>
                <span style="display: inline-block;width:30px;height:30px;background:#ffcccb; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Cancelled</span>
            </div>
        </div>
</section>






