<?php

/**
 * This is the model class for table "{{service_schedules}}".
 *
 * The followings are the available columns in table '{{service_schedules}}':
 * @property string $order_id
 * @property string $scheduled_date
 * @property string $description
 * @property string $status
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class ServiceSchedules extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{service_schedules}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('order_id, scheduled_date, description, status,order_item_id', 'required'),
			array('created_by,product_id, updated_by', 'numerical', 'integerOnly'=>true),
			array('order_id', 'length', 'max'=>20),
			array('status', 'length', 'max'=>1),
                        array('employee_ids', 'checkStatus'),
            
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('order_id, scheduled_date, description, status, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'order_det' => array(self::BELONGS_TO, 'ServiceOrder', 'order_id'),
                    'product_det' => array(self::BELONGS_TO, 'Store', 'product_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'order_id' => 'Order',
			'scheduled_date' => 'Scheduled Date',
                    'order_item_id'=>'Service',
			'description' => 'Description',
			'status' => 'Status',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}
        public function checkStatus($attribute, $params)
        {
            if ($this->status == 'C' && $this->employee_ids == '') {
                $this->addError('employee_ids', 'Employee cannot be blank');
            }
        }
	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('order_id',$this->order_id,true);
		$criteria->compare('scheduled_date',$this->scheduled_date,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ServiceSchedules the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public function getEmployeeNames()
        {
            $emp_name='';$arrnames=array();
            if ($this->employee_ids != '') {
                $arremployee_ids = explode(',',$this->employee_ids);
                foreach($arremployee_ids as $j=>$each){
                    $arrnames[]= Employee::model()->findByPK($each)->employeefullname;
                }
                if(!empty($arrnames)){
                    $emp_name =  implode(' , ', $arrnames);
                }
            }
            return $emp_name;
        }
        public function getEmployeeCodes()
        {
            $emp_name='';$arrnames=array();
            if ($this->employee_ids != '') {
                $arremployee_ids = explode(',',$this->employee_ids);
                foreach($arremployee_ids as $j=>$each){
                    $arrnames[]= Employee::model()->findByPK($each)->employeecode;
                }
                if(!empty($arrnames)){
                    $emp_name =  implode(' , ', $arrnames);
                }
            }
            return $emp_name;
        }
}
