<?php

/**
 * This is the model class for table "{{lead}}".
 *
 * The followings are the available columns in table '{{lead}}':
 * @property integer $id
 * @property integer $crm_user_id
 * @property integer $file_id
 * @property string $customer_id
 * @property integer $contact_id
 * @property string $enq_date
 * @property string $closing_date
 * @property string $title
 * @property string $remarks
 * @property string $status
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property User $crmUser
 * @property MasterFile $file
 * @property Company $company
 */
class ServiceLead extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $lead_owner_id;
    public $company_name;
    public $searchstartdate;
    public $searchenddate;
    public $value;
    public $country;
    public $exchange_rate;

    public function tableName() {
        return '{{lead}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('enq_date,closing_date,status,crm_user_id,lead_owner_id,remarks,contact_id,customer_id','required'),
            array('crm_user_id, file_id, contact_id, lead_owner_id,sales_group_id','numerical','integerOnly' => true),
            array('customer_id,lead_type', 'length','max' => 20),
            array('email,title', 'length','max' => 255),
            array('mobile', 'length','max' => 15),
            array('status,lead_status, isActive','length','max' => 1),
            //array('customer_id','required','message'=>'Unknown Customer.'),
            array(
                'closing_date',
                'compare',
                'compareAttribute' => 'enq_date',
                'operator' => '>=',
                'allowEmpty' => false,
                'message' => '{attribute} must be greater than "{compareValue}".'
            ),
            
            
            
            
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id,crm_user_id, file_id, customer_id, contact_id, enq_date, closing_date, title, remarks, status,lead_owner_id,currency,sales_group_id,value,isActive','safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'contact' => array(self::BELONGS_TO, 'CustomerContact', 'contact_id'),
            'crmUser' => array(self::BELONGS_TO, 'User', 'crm_user_id'),
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'customercontact' => array(self::BELONGS_TO, 'CustomerContact', 'contact_id'),
            'currency1' => array(self::BELONGS_TO, 'MasCurrency', 'currency'),
            'currencyname' => array(self::BELONGS_TO, 'MasCurrency', 'currency'),
            'salesgroup' => array(self::BELONGS_TO, 'MasSalesGroup', 'sales_group_id'),
            'leadowner' => array(self::BELONGS_TO, 'User', 'lead_owner_id'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            'sourceoflead'=> array(self::BELONGS_TO, 'MasSourceOfLead', 'source_of_lead'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'crm_user_id' => 'Crm User',
            'file_id' => 'File',
            'customer_id' => 'Customer',
            'contact_id' => 'Contact',
            'enq_date' => 'Enquiry Date',
            'closing_date' => 'Closing Date',
            'title' => 'File Title',
            'remarks' => 'Remarks',
            'status' => 'Status',
            'lead_owner_id' => 'Lead Owner',
            'isActive' => 'Is Active',
            'email' => 'E-mail',
            'mobile' => 'Phone',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search($searchterm = null) {
        $userModel = User::model()->findByPK(Yii::app()->user->id);
        $criteria = new CDbCriteria;
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('lead_search')) : $searchterm;
        $criteria->with = array('file', 'file.leadowner', 'customer');
        /*$criteria->addCondition('       file.own_customer_id=' . Yii::app()->user->master_user_customer_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        //$criteria->addCondition('file.lead_owner_id in (' . implode(',', $userModel->subordinates).')', 'AND');
        (int) Yii::app()->session['customer_id'] > 0 ? $criteria->addCondition('t.customer_id=' . Yii::app()->session['customer_id'], 'AND') : '';
        
        $user = User::model()->findByPK(Yii::app()->user->id);
        if((int) Yii::app()->user->havePermissionOn['sop_lead_viewall']==1 || Yii::app()->user->authorised_user == 1)
        {
            
        }
        else {
        $criteria->addCondition('t.crm_user_id=' . Yii::app()->user->id.' OR file.lead_owner_id='. Yii::app()->user->id, 'AND');    
        }
        
        if (!empty($searchterm)) {
            $criteria->addCondition('   t.id like "%' . $searchterm . '%" OR 
                                        t.file_id like "%' . $searchterm . '%" OR 
                                        t.title like "%' . $searchterm . '%" OR 
                                        company.customer_name like "%' . $searchterm . '%" OR 
                                        file.file_title like "%' . $searchterm . '%" OR
                                        leadowner.first_name like "%' . $searchterm . '%" OR
                                        leadowner.last_name like "%' . $searchterm . '%"
                                            ', 'AND');
        }
        if (empty($searchterm))
            $criteria->addCondition('status="Y" AND file.current_process_status="L"', 'AND');
        //if(Yii::app()->controller->id != "export")

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.enq_date DESC,t.id DESC,t.customer_id DESC',
            ),
             // 'pagination' => false
           'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false,
            
        ));
    }
    
    

    public function report() {
        $criteria = new CDbCriteria;
        $criteria->with = array('file', 'file.customer');
        if (!empty($this->customer_id))
            $condition[] = 't.customer_id="' . $this->customer_id . '"';
        if (!empty($this->sales_group))
            $condition[] = 'sales_group="' . $this->sales_group . '"';
        if (!empty($this->lead_owner_id))
            $condition[] = 'lead_owner_id="' . $this->lead_owner_id . '"';
        if (!empty($this->country))
            $condition[] = 'customer.billing_country="' . $this->country . '"';
        if (!empty($this->value))
            $condition[] = 'grand_total<="' . $this->value . '"';
        if (!empty($this->status)) {
            switch ($this->status) {
                case 'C':
                    $condition[] = 'file.current_process_status <> "L"';
                    break;
                case 'P':
                    $condition[] = 'file.current_process_status="L" AND status="Y" AND closing_date>=CURDATE()';
                    break;
                case 'CL':
                    $condition[] = 'file.current_process_status="L" AND status="C"';
                    break;
                case 'L':
                    $condition[] = 'file.current_process_status="L" AND status="L"';
                    break;
                case 'E':
                    $condition[] = 'file.current_process_status ="L" AND status="Y" AND closing_date<CURDATE()';
                    break;
            }
        }
        if (is_array($condition))
            $criteria->condition = implode(' AND ', $condition);
        if (!empty($this->searchstartdate) && !empty($this->searchenddate)) {
            $criteria->addBetweenCondition('enq_date', $this->searchstartdate, $this->searchenddate);
        }
        /*$criteria->addCondition('       file.own_customer_id=' . Yii::app()->user->master_user_customer_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC,t.customer_id,t.enq_date DESC',
            ),
            'pagination' => false
        ));
    }
    /*used in lead-getlist
     * modified jisha on 17-9-18
     */
    public function getStatusOfLead() {
        switch ($this->status) {
            case 'O':
                return "Open";
                break;
            case 'N':
                return "Not reachable";
                break;
            case 'F':
                return "FollowUp Calls";
                break;
            case 'S':
                return "Send Profile";
                break;
            case 'M':
                return "Meet in Person";
                break;
            case 'C':
                return "Closed";
                break;
            case 'OT':
                return "Others";
                break;
            case 'L':
                return "Lost";
                break;
        }
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
    public function leadFiles($lead_owner_id) {
        $model = MasterFile::model()->findAll(array('condition' => 'lead_owner_id=' . $lead_owner_id));
        $criteria = new CDbCriteria;
        $criteria->with = array('file');
        foreach($model as $eachItem){
        $criteria->addCondition('t.file_id=' . $eachItem->id, 'OR');
        } 
         $criteria->addCondition('status="Y" AND file.current_process_status="L"', 'AND');
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.enq_date ASC',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 20) : false,
        ));
    }
    public function getCreated_user() {
        $usermodel = User::model()->findByPK($this->created_by);
        return $usermodel->fullname;
    }

}
