<?php

class QuotationController extends Controller
{
    public $layout = 'layout';
    public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                    'users' => array('*'),
                ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetQuotationsList','Create','SaveQuotation','Approve',
                    'GetNotesList','CreateNote','SaveNote','DeleteNotes',
                    'DocumentUpload','GetDocumentList','UploadDocuments','DeleteDocument',
                    'MissingList','CreatePrint','PrintQuotationReportPDF','PrintQuotationWithoutDiscountPDF','PrintQuotationPdfVat','QuoteItemsview',
                    'GetProducts','Getunitdrop','GetAllDetailsForProduct','QuotationHelper','getSalesGroup',
                    'Fetchcontactdetails','getCustomerContactdetails','GetContextMenuItems',
                    'MaterialAllocation','GetAjaxQuotationDetails','PrintQuotationAvailableQtyPDF','GetApprovalHistory',
                    'GetApprovalHistoryList','GetOptionalProduct','Removeoptionalitem','PrintQuotation',//in controller
                    'GetPreviousCustomerRates','SendQuotationConversionMail','CreateSchedule','getServiceDesc','SaveSchedule','RemovelineItem'
                    ),
                    'expression' => '$user->isMember()',
                ),
                array('deny', // deny all users
                                'users' => array('*'),
                ),
            );
    }

    public function filters() {
            return array('accessControl'); // perform access control for CRUD operations
    }
    /*
     * function to list quotes
     * modified by jisha on 18-9-18. 
    */	
    public function actionIndex()
    {
            $frm = 1;
            $this->render('index',array('frm'=>$frm));
    }
     /*
     * function to list quotes in datatable 
     * modified by jisha on 18-9-18. 
    */
    public function actionGetQuotationsList()
    {
        $model=new ServiceQuotes();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $frm  = $_POST['frm'];
        $columns = array(
                // datatable column index  => database column name
                0 =>'t.id',
                1 =>'file_id',
                2 =>'t.id',
                3=> 'customer.customer_name',
                4=>'leadowner.first_name',
                5=> 't.qtn_start_date',
                6=> 't.qtn_validity',
                7=> 'currencyname.currency_code',
                8=> 't.grand_total',
                9=> 't.status',
                10=> 'file.current_process_status',
                17=>'t.created_by',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn." ".$filterOrder;
	    $condition = 't.isActive="Y" AND (file.current_process_status="Q") AND t.status = "Y" AND t.quotes_type="service"';
	    
	    
        if(!isset(Yii::app()->user->havePermissionOn["quotes_view_all"]) &&  Yii::app()->user->authorised_user != 1)
        {
            $condition.= ' AND (t.lead_owner_id= "'.Yii::app()->user->id.'" OR file.lead_owner_id="'.Yii::app()->user->id.'")';
        }            
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $condition = 't.isActive="Y"  AND t.quotes_type="service"';
            
            
            if(!isset(Yii::app()->user->havePermissionOn["quotes_view_all"]) &&  Yii::app()->user->authorised_user != 1)
            {
                $condition.= ' AND (t.lead_owner_id= "'.Yii::app()->user->id.'" OR file.lead_owner_id="'.Yii::app()->user->id.'")';
            }
            $searchString = $_POST['search']['value'];
            $condition.=" AND (file.file_title LIKE '%".$searchString."%' OR t.file_id LIKE '%".$searchString."%' OR t.id LIKE '%".$searchString."%' OR customer.customer_name LIKE '%".$searchString."%' OR leadowner.first_name LIKE '%".$searchString."%' OR leadowner.last_name LIKE '%".$searchString."%')";
	}
        if(isset($_POST['status']) && $_POST['status'] !="" && $_POST['status'] !="all"){
            $select_status = $_POST['status'];
            if($select_status=='N'){
            
            	$start_date = date('Y-m-d', strtotime('-7 days'));
            	$end_date = date('Y-m-d');
            	$condition.=" AND (t.qtn_start_date>='".$start_date."' AND t.qtn_start_date<='".$end_date."')";
            }
            else if($select_status=='M'){
            	$condition.= ' AND (t.lead_owner_id= "'.Yii::app()->user->id.'" OR file.lead_owner_id="'.Yii::app()->user->id.'")';
            }
            else{
            	$condition.="AND t.status='$select_status'";
            }
        }        
        $model_settings = MasCompanySettings::model()->find();
        $count = $model->with('customer','file','currencyname','leadowner')->count(array('condition'=>$condition));
        $model=$model->with('customer','file','currencyname','leadowner')->findAll(array('condition'=>$condition,'order'=>$orderBy,'limit'=>$limit,'offset'=>$offset));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
                
        foreach ($model as $row)
        {
            $state = 0;
            if(strtotime($row->qtn_validity) < strtotime(date('Y-m-d'))){
                $state = 1;
            }
            elseif($row->file->is_approved=='N' && $row->file->current_process_status=='Q'){
                    $state = 2;
            }
            $status = $row['StatusOfQuote'];
            $file_status=$row['file']['status'];
            /****************** Code added by mereena on 28/11/2017 for allocate material checking**************************/
            $allocate_count = 0;
            if(isset($row->file_id) && $row->file_id > 0){
                    $modelAllocate = new AllocatedMaterial();
                    $allocate_count = (int) $modelAllocate->count(array('condition'=>'file_id='.$row->file_id));
            }
           
            $modelQuotesItem = new ServiceQuotesItem();
            $countcheckedQuoteItems = (int) $modelQuotesItem->count(array('condition'=>'checked=1 AND quotes_id='.$row['id'])); 
            $rowData[]=array($state,$row['file_id'],$row['id'],$row['customer']['customer_name'],$row['leadowner']['first_name'].' '.$row['leadowner']['last_name'],date("d/m/Y",strtotime($row['qtn_start_date'])),date("d/m/Y",strtotime($row['qtn_validity'])),$row['currencyname']['currency_code'], Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'],""),
            Yii::app()->numberFormatter->formatCurrency($row['grand_total'],""),$status,$file_status,$row->file->current_process_status,$row->file->is_approved,$row['customer_id'],$countcheckedQuoteItems,$row->created_user);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    /*
     * function to create quotes
     * modified by jisha on 18-9-18. 
    */
    public function actionCreate()
    {
        $model=new ServiceQuotes();
        $modellead=new Lead();
        $modelDocument = new Document;
        $modelmasterfile=new MasterFile();
        $id = (int) Yii::app()->request->getParam('id');
        $leadid=(int) Yii::app()->request->getParam('lead_id');
        $type=(int) Yii::app()->request->getParam('type');
        $file_id=(int) Yii::app()->request->getParam('file_id');
        $duplicate=(int) Yii::app()->request->getParam('duplicate');
        $hireduplicate=(int) Yii::app()->request->getParam('hireduplicate');
        $frm=(int) Yii::app()->request->getParam('frm');
        $modelQuoteItems = array(new ServiceQuotesItem);
        $modelQuoteAdditions = array(new ServiceQuotesAddition);
        $modelQuoteDeductions = array(new ServiceQuotesDeduction);
        $modelNotes = new Activity();
        
        if($id > 0)
        {
            $model=$model->findByPk($id);
            $model->import_code = $model->customer->customer_shj_imp_code;
            $condition='quotes_id="'.$id.'"';//To fetch all
            $modelQuoteItems = ServiceQuotesItem::model()->findAll(array('condition'=>$condition,'order' => 'id ASC')); 
            if(empty($modelQuoteItems)){
                     $modelQuoteItems = array(new ServiceQuotesItem);
            }
            $modelQuoteAdditions = ServiceQuotesAddition::model()->findAll(array('condition'=>'quotes_id="'.$id.'"','order' => 'id ASC')); 
            if(empty($modelQuoteAdditions)){
                     $modelQuoteAdditions = array(new ServiceQuotesAddition);
            }
            $modelQuoteDeductions = ServiceQuotesDeduction::model()->findAll(array('condition'=>'quotes_id="'.$id.'"','order' => 'id ASC')); 
            if(empty($modelQuoteDeductions)){
                     $modelQuoteDeductions = array(new ServiceQuotesDeduction);
            }
            if($duplicate=='1'){
                $model->id='';
                $model->file_id='';
            }            
        }   
        if($leadid > 0)
        {
            $modellead=$modellead->findByPk($leadid);
            $model->enq_ref = $modellead->id;
            $model->import_code = $modellead->customer->customer_shj_imp_code;
            $model->currency = $modellead->currency;
            $model->exchange_rate = $modellead->currencyname->exchange_rate;
        }
        if($file_id > 0)
        {
            $model_lead=Lead::model()->find(array('condition'=>'file_id="'.$file_id.'"'));
            $modellead=$modellead->findByPk($model_lead->id);
            $modelmasterfile=$modelmasterfile->findByPk($file_id);
            $modelmasterfile->file_title=$modellead->title;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);
        $this->render('create',array('model'=>$model,
            'modelQuoteItems'=>$modelQuoteItems,
            'modelQuoteAdditions'=>$modelQuoteAdditions,
            'modelQuoteDeductions'=>$modelQuoteDeductions,
            'modellead'=>$modellead,
            'model_master'=>$modelmasterfile,
            'file_id'=>$file_id,
            'modelNotes'=>$modelNotes,
            'modelDocument'=>$modelDocument,
            'leadid'=>$leadid,
            'type'=>$type,
            'duplicate'=>$duplicate,
            'frm'=>$frm
        ));
    }
    public function actionCreateSchedule() {
        $id=Yii::app()->request->getParam('id');
        $modelSchedule =QuotationSchedules::model()->findAll(array('condition'=>'quotation_id='.$id));
        if(empty($modelSchedule)){
            $model_quotation_item=ServiceQuotesItem::model()->findAll(array('condition'=>'quotes_id='.$id));
            foreach ($model_quotation_item as $i=>$each){
                $modelSchedule[$i] =new QuotationSchedules();
                $modelSchedule[$i]->quotation_item_id=$each->id;
                $modelSchedule[$i]->product_id=$each->product_id;
                $modelSchedule[$i]->description=$each->description;
            }            
                  
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create_schedule', array('modelSchedule' => $modelSchedule,'quotation_id'=>$id));
    }
    public function actionSaveSchedule() {
        if (is_array($_POST['QuotationSchedules'])) {
            $p=0;$valid=true;
            $quotation_id=$_POST['quotation_id'];
            foreach ($_POST['QuotationSchedules'] as $i => $item) {
                if ((int) $_POST['QuotationSchedules'][$i]['id'] > 0) {
                    $modelQuotationSchedules[$p] = QuotationSchedules::model()->findByPk((int) $_POST['QuotationSchedules'][$i]['id']);
                    $modelQuotationSchedules[$p]->updated_by =Yii::app()->user->id;
                    $modelQuotationSchedules[$p]->updated_date_time =date('Y-m-d H:i:s');
                }else{
                    $modelQuotationSchedules[$p] = new QuotationSchedules;
                    $modelQuotationSchedules[$p]->created_by =Yii::app()->user->id;
                    $modelQuotationSchedules[$p]->created_date_time =date('Y-m-d H:i:s');
                }
                $modelQuotationSchedules[$p]->attributes = $_POST['QuotationSchedules'][$i];
                $modelQuotationSchedules[$p]->quotation_id   = $quotation_id;
                if ($_POST['QuotationSchedules'][$i]['scheduled_date'] != '0000-00-00' && $_POST['QuotationSchedules'][$i]['scheduled_date'] != '') {
                    $modelQuotationSchedules[$p]->scheduled_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['QuotationSchedules'][$i]['scheduled_date'])));
                }
                $valid = $modelQuotationSchedules[$p]->validate() && $valid;
                $p++;                        
            }
            if($valid){
                foreach ($modelQuotationSchedules as $eachModel) {
                    $eachModel->save(false);
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else{
                if (!empty($modelQuotationSchedules))
                    $error2 = json_decode(CActiveForm::validateTabular($modelQuotationSchedules, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                $error = CJSON::encode(array_merge_recursive($error2));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actiongetServiceDesc(){
        $id = $_POST['id'];
        if ($id > 0) {
            $model = ServiceQuotesItem::model()->findByPk($id);
            $status['desc'] = $model->description;
            $status['product_id'] = $model->product_id;
        }

        echo CJSON::encode($status);
    }
    public function actionRemovelineItem() {
        $id = $_POST['id'];
        $frm = $_POST['frm'];
        if ($id > 0) {
            $model = new QuotationSchedules();
            $model->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }

        echo CJSON::encode($status);
    }

    /*
     * function to save quotes
     * modified by jisha on 18-9-18. 
    */    
    public function actionSaveQuotation() {
        $valid=TRUE;
        $file_id = $_POST['hid_file_id'];
        $modelQuote = new ServiceQuotes;
        $other = array();
        $modelQuote->terms_and_conditions = MasTermsAndConditions::model()->findByPk(1)->terms;
        $modelQuoteItems = array(new ServiceQuotesItem);
        $modelQuoteAdditions = array(new ServiceQuotesAddition);
        $modelQuoteDeductions = array(new ServiceQuotesDeduction);
        $modelNotes = new Activity();
        $modelDocument = new Document();
        $quotes_id = (int) Yii::app()->request->getParam('id');
        $modelQuote->exchange_rate = 1;
        //$quotation_validity = MasValidity::model()->find()->quotation_validity;
        $quotation_validity=30;
        $modelQuote->qtn_validity = date('Y-m-d', strtotime('+ ' . $quotation_validity . 'day', strtotime(date('Y-m-d'))));
        if ($quotes_id > 0) {
            $modelQuote = $modelQuote->findByPK($quotes_id);
            $modelQuote->customer_id = $modelQuote->file->customer_id;
            $modelQuote->title = $modelQuote->file->file_title;
            $modelQuote->lead_owner_id = $modelQuote->file->lead_owner_id;
            $modelQuote->terms_and_conditions = $modelQuote->terms_and_conditions;
            $modelQuote->terms_id = $modelQuote->terms_id;
            $modelQuoteItems = $modelQuote->items;
            $modelQuoteAdditions = count($modelQuote->adItems) > 0 ? $modelQuote->adItems : $modelQuoteAdditions;
            $modelQuoteDeductions = count($modelQuote->dedItems) > 0 ? $modelQuote->dedItems : $modelQuoteDeductions;          
        }
        if (isset($_POST['ServiceQuotes'])) {
            $scenario='';
            if ((int) $_POST['ServiceQuotes']['id'] > 0) {
                $modelQuote = $modelQuote->findByPK($_POST['ServiceQuotes']['id']);
                $modelQuote->scenario = 'update';
                $scenario='update';
                $audit_type = 'UPDATED';
                $modelQuote->updated_by = Yii::app()->user->id;
    		$modelQuote->updated_date_time = date('y-m-d H:i:s');
            }else{
                $modelQuote->scenario = 'add';
                $scenario='add';
                $audit_type = 'CREATED';
                $modelQuote->created_by = Yii::app()->user->id;
                $modelQuote->created_date_time = date('Y-m-d H:i:s');
            }
            $modelQuote->attributes = $_POST['ServiceQuotes'];
            $modelQuote->currency = $_POST['ServiceQuotes']['currency'];
            $modelQuote->probability = $_POST['ServiceQuotes']['probability'];
            $modelQuote->revision = $_POST['ServiceQuotes']['revision'];
            $modelQuote->project_reference = $_POST['ServiceQuotes']['project_reference'];
            $modelQuote->project_id = $_POST['ServiceQuotes']['project_id'];
            $modelQuote->crm_user_id = Yii::app()->user->id;
            $modelQuote->materials_allocated = (isset($_POST['allocate_materials']) && $_POST['allocate_materials'] == "Y") ? "Y" : "N";
            
            if(($_POST['ServiceQuotes']['invoice_type'] =='1' OR $_POST['ServiceQuotes']['invoice_type'] =='2' ) AND ($_POST['customer_country_id'] =='143')){                    

                $modelQuote->emirates_id = $_POST['ServiceQuotes']['emirates_id'];
            }
            else{
                $modelQuote->emirates_id = "0";
            }
            
            
            
           
            
            //code added by mereena on 07/02/2020 for ckeditor content
            $modelQuote->terms_and_conditions =  $_POST['terms_conditions'];
            $modelQuote->schedule_terms =  $_POST['schedule_terms'];
            $modelQuote->liability =  $_POST['liability'];
            $modelQuote->quotes_type = 'service';
            
            $valid = $valid && $modelQuote->validate();
            $p=0;
            if (is_array($_POST['ServiceQuotesItem'])) {
                $prod_id=0;
                foreach ($_POST['ServiceQuotesItem'] as $i => $item) {                    
                    
                    if (($item['product_id'] > 0 && $item['product_name'] != 'memo') || $item['product_name'] == 'memo') {
                        $modelQuoteItems[$p] = new ServiceQuotesItem; 
                        $modelQuoteItems[$p]->attributes = $_POST['ServiceQuotesItem'][$i];
                        $modelQuoteItems[$p]->unit_id = $item['unit_id'];
                        $modelQuoteItems[$p]->description  = $item['description'];
                        $modelQuoteItems[$p]->brand_class_id=$item['brand_class_id'];
                        $modelQuoteItems[$p]->product_generic_name=$item['product_generic_name'];
                        $modelQuoteItems[$p]->tax_vat_percentage=$item['tax_vat_percentage'];
                        $modelQuoteItems[$p]->checked=  $item['checked'];
               
                        if($item['product_name'] == 'memo')
                            $modelQuoteItems[$p]->product_id = '999999';
                        $modelQuoteItems[$p]->checked=  $item['checked'];
                        if($item['product_name'] != 'memo')
                            $valid = $modelQuoteItems[$p]->validate() && $valid;
                        $p++;
                        //echo "1 = ".$item['product_id']."<br/>";
                    }
                }
            }  
           
            $valid = $valid && ($modelQuoteItems[0]->product_id > 0);           
                    $modelsToBeValidated = array($modelQuote, $modelQuoteItems);
            if (is_array($_POST['ServiceQuotesAddition'])) {
                foreach ($_POST['ServiceQuotesAddition'] as $i => $item) {
                    $modelQuoteAdditions[$i] = new ServiceQuotesAddition;
                    $modelQuoteAdditions[$i]->attributes = $_POST['ServiceQuotesAddition'][$i];
                    if($item['particular_value'] > 0 && $item['particular'] == ''){
                        $other[] = 'Addition description Cannot Blank';
                        $valid = false;
                    }
                }
                $modelsToBeValidated[] = $modelQuoteAdditions;
            }
            if (is_array($_POST['ServiceQuotesDeduction'])) {
                foreach ($_POST['ServiceQuotesDeduction'] as $i => $item) {
                    $modelQuoteDeductions[$i] = new ServiceQuotesDeduction;
                    $modelQuoteDeductions[$i]->attributes = $_POST['ServiceQuotesDeduction'][$i];
                     if($item['particular_value'] > 0 && $item['particular'] == ''){
                        $other[] = 'Deduction description Cannot Blank';
                        $valid = false;
                    }
                }
                $modelsToBeValidated[] = $modelQuoteDeductions;
            }
            
            if ($valid) {
                $grand_total = 0;
               

                if (isset($_POST['hid_file_id'])) {
                    $satus = MasterFile::model()->findByPk($_POST['hid_file_id']);
                    MasterFile::model()->updateByPk($_POST['hid_file_id'], array('is_approved' => "N",'current_process_status'=>'Q','date_of_approval'=>'0000-00-00'));
                    if($_POST['hid_action_type']==2){//To identify unapprove
                        date_default_timezone_set("Asia/Dubai");
                        $approval_history=new ApprovalHistory;
                        $approval_history->file_id          =   $_POST['hid_file_id'];
                        $approval_history->status           =   "N";
                        $approval_history->action_by        =   Yii::app()->user->id;
                        $approval_history->created_by       =   Yii::app()->user->id;
                        $approval_history->created_datetime =   date('Y-m-d h:i:s');
                        $approval_history->date             =   date('Y-m-d h:i:s');
                        $approval_history->state            =   'Q';
                        $approval_history->save();
                    }
                    
                    
                }
               $modelQuote->file_id = $_POST['hid_file_id'];
               if($_POST['ServiceQuotes']['qtn_start_date']!='00/00/0000')
                {
                        $modelQuote->qtn_start_date = str_replace('/', '-', $_POST['ServiceQuotes']['qtn_start_date']);
                        $modelQuote->qtn_start_date= date("Y-m-d", strtotime($modelQuote->qtn_start_date));
                }
                if($_POST['ServiceQuotes']['qtn_validity']!='00/00/0000')
                {
                        $modelQuote->qtn_validity = str_replace('/', '-', $_POST['ServiceQuotes']['qtn_validity']);
                        $modelQuote->qtn_validity= date("Y-m-d", strtotime($modelQuote->qtn_validity));
                }
                if($_POST['ServiceQuotes']['tender_closing_date']!='00/00/0000')
                {
                        $modelQuote->tender_closing_date = str_replace('/', '-', $_POST['ServiceQuotes']['tender_closing_date']);
                        $modelQuote->tender_closing_date= date("Y-m-d", strtotime($modelQuote->tender_closing_date));
                }
                $modelQuote->billing_address=  $_POST['ServiceQuotes']['billing_address'];
                
                if(!empty($_POST['ServiceQuotes']['pricing_terms'])){
                    $modelQuote->pricing_terms=  $_POST['ServiceQuotes']['pricing_terms'];
                }
                else{
                    $modelQuote->pricing_terms=  "0";
                }
                if(!empty($_POST['ServiceQuotes']['availability'])){
                    $modelQuote->availability=  $_POST['ServiceQuotes']['availability'];
                }
                else{
                    $modelQuote->availability=  "0";
                }            
                if( (int) $_POST['hid_file_id'] > 0 ){
                    $modelQuote->file_id = $_POST['hid_file_id'];
                }else{
                    $masterFile = new MasterFile;
                    $masterFile->crm_user_id =  Yii::app()->user->id;
                    $masterFile->customer_id =  $_POST['ServiceQuotes']['customer_id'];
                    $masterFile->file_title =  $_POST['ServiceQuotes']['title'];
                    $masterFile->start_from =  "Q";
                    $masterFile->current_process_status =  "Q";
                    $masterFile->lead_owner_id = $_POST['ServiceQuotes']['lead_owner_id'];
                    $masterFile->is_approved = "N";
                    $masterFile->save(false);
                    $modelQuote->file_id = $masterFile->id;
                }
                
                $modelQuote->save(false);
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'QUOTATIONS',
                    Yii::app()->user->id,
                    $audit_type,
                    " with QTN No - {$modelQuote->id}  "
                );
                // end audit log 
                $modelQuote->refresh();               
                $quotes_id = $modelQuote->id;
               
                ServiceQuotesItem::model()->deleteAll('quotes_id=:refer_id', array(':refer_id' => $modelQuote->id));
                ServiceQuotesAddition::model()->deleteAll('quotes_id=:refer_id', array(':refer_id' => $modelQuote->id));
                ServiceQuotesDeduction::model()->deleteAll('quotes_id=:refer_id', array(':refer_id' => $modelQuote->id));
                
                $total_tax_amount = 0;
                if(!empty($modelQuoteItems)){
                    foreach ($modelQuoteItems as $eachModel) {
                        if($eachModel->cost_rate=="0.00"){
                            $eachModel->cost_rate=$eachModel->actual_cost_rate;
                        }
                        $eachModel->quotes_id = $quotes_id;
                        $total_tax_amount+=$eachModel->tax_vat_amount;
                        $eachModel->save(false);
                        $grand_total += $eachModel->net_amount;
                    }
                }
                
                if(!empty($modelQuoteAdditions)){
                    foreach ($modelQuoteAdditions as $eachModel) {
                        $eachModel->quotes_id = $quotes_id;
                        $eachModel->save();
                        $grand_total += $eachModel->calculated_value;
                    }
                }
                if(!empty($modelQuoteDeductions)){
                    foreach ($modelQuoteDeductions as $eachModel) {
                        $eachModel->quotes_id = $quotes_id;
                        $eachModel->save();
                        $grand_total -= $eachModel->calculated_value;
                    }
                }
                if (!empty($_POST['Activity']['notes'])) 
                {   
                        $modelNotes->created_by = Yii::app()->user->id;
                        $modelNotes->created_date_time = date('Y-m-d h:i:s');
                        $modelNotes->notes=$_POST['Activity']['notes'];
                        $modelNotes->crm_user_id = Yii::app()->user->id;
                        $modelNotes->customer_id = $modelQuote->customer_id;
                        $modelNotes->contact_id = $modelQuote->contact_id;
                        $modelNotes->type_of_activity='N';
                        $modelNotes->added_from='Q';
                        $modelNotes->file_id=$modelQuote->file_id;
                        $modelNotes->save(false);           
                }
              
                if(isset($_POST['Icon']['file']) && $_POST['Icon']['file']!='')
                {
                    $doc_test=Document::model()->find(array('condition'=>'file_id='.$modelQuote->file_id.' AND document_name="'.$_POST['Icon']['file'].'"'));
                    if(empty($doc_test))
                    {
                        $modelDocument = new Document;
                        $modelDocument->uploaded_from =  "Q";
                        $modelDocument->file_id = $_POST['hid_file_id'];
                        $modelDocument->created_by = Yii::app()->user->id;
                        $modelDocument->created_datetime = date('Y-m-d h:i:s');
                        $modelDocument->document_name =$_POST['Icon']['file'];
                        $modelDocument->save(false);
                    }
                }
                
                $grand_total+=$total_tax_amount;
                $modelQuote->updateByPk($modelQuote->id, array('grand_total' => $grand_total,'total_tax_amount' => $total_tax_amount));
                /* if(count($modelDocument)>0){
                	$this->documents($modelQuote->file_id, 'Q');
                } */
                
                if($scenario=='add'){
                        Yii::import('application.controllers.front.MasternotificationController'); 
                        $model_mail_setting=Notification::model()->find(array('condition' => 'event_id="3"'));
                        if($model_mail_setting->mail_required=='Y'){                    
                            // MasternotificationController::sendmail(3,$modelQuote->id);
                        }
                        if($model_mail_setting->notification_required=='Y'){                    
                            // MasternotificationController::sendnotification(3,$modelQuote->id);
                        }
                        if($model_mail_setting->sms_required=='Y'){                    
                            // MasternotificationController::sendsms(3,$modelQuote->id);
                        }
                }
                
                $jsonData['file'] = $modelQuote->file;
                $jsonData['quotation'] = $modelQuote;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
   
            } else {
                $error5=array();
                $error1 = json_decode(CActiveForm::validate($modelQuote, '', false), true);
                if ($modelQuoteItems[0]->product_id > 0)
                    $error2 = json_decode(CActiveForm::validateTabular($modelQuoteItems, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                $error3 = json_decode(CActiveForm::validateTabular($modelQuoteAdditions, '', false), true);
                $error4 = json_decode(CActiveForm::validateTabular($modelQuoteDeductions, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4,$other));
                if ($error != '[]')
                    echo $error;
            }

        }else{
            echo 'error';
        }
    } 
    /*
     * function to aprove quotes
     * modified by jisha on 18-9-18. 
    */    
    public function actionApprove() {
        $valid=TRUE;
        $file_id = $_POST['hid_file_id'];
        $modelQuote = new ServiceQuotes;
        $other = array();
        $modelQuote->terms_and_conditions = MasTermsAndConditions::model()->findByPk(1)->terms;
        $modelQuoteItems = array(new ServiceQuotesItem);
        $modelQuoteAdditions = array(new ServiceQuotesAddition);
        $modelQuoteDeductions = array(new ServiceQuotesDeduction);
        $modelNotes = new Activity();
        $modelDocument = new Document();
        $quotes_id = (int) Yii::app()->request->getParam('id');
        $modelQuote->exchange_rate = 1;
        //$quotation_validity = MasValidity::model()->find()->quotation_validity;
        $quotation_validity=30;
        $modelQuote->qtn_validity = date('Y-m-d', strtotime('+ ' . $quotation_validity . 'day', strtotime(date('Y-m-d'))));
            
        if ($quotes_id > 0) {
            $modelQuote = $modelQuote->findByPK($quotes_id);
            $modelQuote->customer_id = $modelQuote->file->customer_id;
            $modelQuote->title = $modelQuote->file->file_title;
            $modelQuote->lead_owner_id = $modelQuote->file->lead_owner_id;
            $modelQuote->terms_and_conditions = $modelQuote->terms_and_conditions;
            $modelQuote->schedule_terms = $modelQuote->schedule_terms;
            $modelQuote->liability =  $modelQuote->liability;
            $modelQuote->terms_id = $modelQuote->terms_id;
            $modelQuoteItems = $modelQuote->items;
            $modelQuoteAdditions = count($modelQuote->adItems) > 0 ? $modelQuote->adItems : $modelQuoteAdditions;
            $modelQuoteDeductions = count($modelQuote->dedItems) > 0 ? $modelQuote->dedItems : $modelQuoteDeductions;
          
        }

        if (isset($_POST['ServiceQuotes'])) {
            if ((int) $_POST['ServiceQuotes']['id'] > 0) {
                $modelQuote = $modelQuote->findByPK($_POST['ServiceQuotes']['id']);
                $modelQuote->scenario = 'update';
                $modelQuote->updated_by = Yii::app()->user->id;
    		$modelQuote->updated_date_time = date('y-m-d H:i:s');
            }
            $modelQuote->attributes = $_POST['ServiceQuotes'];
            $modelQuote->currency = $_POST['ServiceQuotes']['currency'];
            $modelQuote->probability = $_POST['ServiceQuotes']['probability'];
            $modelQuote->revision = $_POST['ServiceQuotes']['revision'];
            $modelQuote->project_reference = $_POST['ServiceQuotes']['project_reference'];
            $modelQuote->materials_allocated = (isset($_POST['allocate_materials']) && $_POST['allocate_materials'] == "Y") ? "Y" : "N";
            if(($_POST['ServiceQuotes']['invoice_type'] =='1' OR $_POST['ServiceQuotes']['invoice_type'] =='2' ) AND ($_POST['customer_country_id'] =='143')){                    

                $modelQuote->emirates_id = $_POST['ServiceQuotes']['emirates_id'];
            }
            else{
                $modelQuote->emirates_id = "0";
            }
            //code added by mereena on 07/02/2020 for ckeditor content
            $modelQuote->terms_and_conditions =  $_POST['terms_conditions'];
            $modelQuote->schedule_terms =  $_POST['schedule_terms'];
            $modelQuote->liability =  $_POST['liability'];
            $modelQuote->quotes_type = 'service';
           $valid = $valid && $modelQuote->validate();
            $p=0;
            if (is_array($_POST['ServiceQuotesItem'])) {
                foreach ($_POST['ServiceQuotesItem'] as $i => $item) {
                    if (($item['product_id'] > 0 && $item['product_name'] != 'memo') || $item['product_name'] == 'memo') {
                        $modelQuoteItems[$p] = new ServiceQuotesItem; 
                        $modelQuoteItems[$p]->attributes = $_POST['ServiceQuotesItem'][$i];
                        $modelQuoteItems[$p]->unit_id = $item['unit_id'];
                        $modelQuoteItems[$p]->description  = $item['description'];
                        $modelQuoteItems[$p]->brand_class_id=$item['brand_class_id'];
                        $modelQuoteItems[$p]->product_generic_name=$item['product_generic_name'];
                        $modelQuoteItems[$p]->tax_vat_percentage=$item['tax_vat_percentage'];
                        if($item['product_name'] == 'memo')
                            $modelQuoteItems[$p]->product_id = '999999';
                        $modelQuoteItems[$p]->checked=  $item['checked'];
                        if($item['product_name'] != 'memo')
                            $valid = $modelQuoteItems[$p]->validate() && $valid;
                        $p++;
                    }
                }
            } 
            
            
            $valid = $valid && ($modelQuoteItems[0]->product_id > 0); 
            
            $modelsToBeValidated = array($modelQuote, $modelQuoteItems);
            if (is_array($_POST['ServiceQuotesAddition'])) {
                foreach ($_POST['ServiceQuotesAddition'] as $i => $item) {
                    $modelQuoteAdditions[$i] = new ServiceQuotesAddition;
                    $modelQuoteAdditions[$i]->attributes = $_POST['ServiceQuotesAddition'][$i];
                    if($item['particular_value'] > 0 && $item['particular'] == ''){
                        $other[] = 'Addition description Cannot Blank';
                        $valid = false;
                    }
                }
                $modelsToBeValidated[] = $modelQuoteAdditions;
            }
            if (is_array($_POST['ServiceQuotesDeduction'])) {
                foreach ($_POST['ServiceQuotesDeduction'] as $i => $item) {
                    $modelQuoteDeductions[$i] = new ServiceQuotesDeduction;
                    $modelQuoteDeductions[$i]->attributes = $_POST['ServiceQuotesDeduction'][$i];
                     if($item['particular_value'] > 0 && $item['particular'] == ''){
                        $other[] = 'Deduction description Cannot Blank';
                        $valid = false;
                    }
                }
                $modelsToBeValidated[] = $modelQuoteDeductions;
            }
            
            if ($valid) {
                $grand_total = 0;
               

                if (isset($_POST['hid_file_id'])) {
                    $satus = MasterFile::model()->findByPk($_POST['hid_file_id']);
                    MasterFile::model()->updateByPk($_POST['hid_file_id'], array('is_approved' => "Y",'current_process_status'=>'Q','date_of_approval'=>date('Y-m-d'), 'approved_by' => Yii::app()->user->id));
                    
                }
               $modelQuote->file_id = $_POST['hid_file_id'];
               if($_POST['ServiceQuotes']['qtn_start_date']!='00/00/0000')
                {
                        $modelQuote->qtn_start_date = str_replace('/', '-', $_POST['ServiceQuotes']['qtn_start_date']);
                        $modelQuote->qtn_start_date= date("Y-m-d", strtotime($modelQuote->qtn_start_date));
                }
                if($_POST['ServiceQuotes']['qtn_validity']!='00/00/0000')
                {
                        $modelQuote->qtn_validity = str_replace('/', '-', $_POST['ServiceQuotes']['qtn_validity']);
                        $modelQuote->qtn_validity= date("Y-m-d", strtotime($modelQuote->qtn_validity));
                }
                if($_POST['ServiceQuotes']['tender_closing_date']!='00/00/0000')
                {
                        $modelQuote->tender_closing_date = str_replace('/', '-', $_POST['ServiceQuotes']['tender_closing_date']);
                        $modelQuote->tender_closing_date= date("Y-m-d", strtotime($modelQuote->tender_closing_date));
                }
                $modelQuote->billing_address=  $_POST['ServiceQuotes']['billing_address'];
                
                if(!empty($_POST['ServiceQuotes']['pricing_terms'])){
                    $modelQuote->pricing_terms=  $_POST['ServiceQuotes']['pricing_terms'];
                }
                else{
                    $modelQuote->pricing_terms=  "0";
                }
                if(!empty($_POST['ServiceQuotes']['availability'])){
                    $modelQuote->availability=  $_POST['ServiceQuotes']['availability'];
                }
                else{
                    $modelQuote->availability=  "0";
                }            
                if( (int) $_POST['hid_file_id'] > 0 ){
                    $modelQuote->file_id = $_POST['hid_file_id'];
                }else{
                   $masterFile = new MasterFile;
                    $masterFile->crm_user_id =  Yii::app()->user->id;
                    $masterFile->customer_id =  $_POST['ServiceQuotes']['customer_id'];
                    $masterFile->file_title =  $_POST['ServiceQuotes']['title'];
                    $masterFile->start_from =  "Q";
                    $masterFile->current_process_status =  "Q";
                    $masterFile->lead_owner_id = $_POST['ServiceQuotes']['lead_owner_id'];
                    $masterFile->is_approved = "N";
                    $masterFile->save(false);
                    $modelQuote->file_id = $masterFile->id;
                }
                
                $modelQuote->save();
                $modelQuote->refresh();               
                $quotes_id = $modelQuote->id;
               
                ServiceQuotesItem::model()->deleteAll('quotes_id=:refer_id', array(':refer_id' => $modelQuote->id));
                ServiceQuotesAddition::model()->deleteAll('quotes_id=:refer_id', array(':refer_id' => $modelQuote->id));
                ServiceQuotesDeduction::model()->deleteAll('quotes_id=:refer_id', array(':refer_id' => $modelQuote->id));
                
                $total_tax_amount = 0;
                if(!empty($modelQuoteItems)){
                    foreach ($modelQuoteItems as $eachModel) {
                        $eachModel->quotes_id = $quotes_id;
                        $total_tax_amount+=$eachModel->tax_vat_amount;
                        $eachModel->save(false);
                        $grand_total += $eachModel->net_amount;
                    }
                }
                if(!empty($modelQuoteAdditions)){
                    foreach ($modelQuoteAdditions as $eachModel) {
                        $eachModel->quotes_id = $quotes_id;
                        $eachModel->save();
                        $grand_total += $eachModel->calculated_value;
                    }
                }
                if(!empty($modelQuoteDeductions)){
                    foreach ($modelQuoteDeductions as $eachModel) {
                        $eachModel->quotes_id = $quotes_id;
                        $eachModel->save();
                        $grand_total -= $eachModel->calculated_value;
                    }
                }
               
                if (!empty($_POST['Activity']['notes'])) 
                {   
                        $modelNotes->created_by = Yii::app()->user->id;
                        $modelNotes->created_date_time = date('Y-m-d h:i:s');
                        $modelNotes->notes=$_POST['Activity']['notes'];
                        $modelNotes->crm_user_id = Yii::app()->user->id;
                        $modelNotes->customer_id = $modelQuote->customer_id;
                        $modelNotes->contact_id = $modelQuote->contact_id;
                        $modelNotes->type_of_activity='N';
                        $modelNotes->added_from='Q';
                        $modelNotes->file_id=$modelQuote->file_id;
                        $modelNotes->save(false);           
                }
              
                if(isset($_POST['Icon']['file']) && $_POST['Icon']['file']!='')
                {
                    $doc_test=Document::model()->find(array('condition'=>'file_id='.$modelQuote->file_id.' AND document_name="'.$_POST['Icon']['file'].'"'));
                    if(empty($doc_test))
                    {
                        $modelDocument = new Document;
                        $modelDocument->uploaded_from =  "Q";
                        $modelDocument->file_id = $_POST['hid_file_id'];
                        $modelDocument->created_by = Yii::app()->user->id;
                        $modelDocument->created_datetime = date('Y-m-d h:i:s');
                        $modelDocument->document_name =$_POST['Icon']['file'];
                        $modelDocument->save(false);
                    }
                }
                
                $grand_total+=$total_tax_amount;
                $modelQuote->updateByPk($modelQuote->id, array('grand_total' => $grand_total,'total_tax_amount' => $total_tax_amount));
                
                /***************** START code added by mereena on 22-10-2019 for approval history********************/
                date_default_timezone_set("Asia/Dubai");
                $approval_history=new ApprovalHistory;
                $approval_history->file_id          =   $modelQuote->file_id;
                $approval_history->status           =   $modelQuote->file->is_approved;
                $approval_history->action_by        =   Yii::app()->user->id;
                $approval_history->created_by       =   Yii::app()->user->id;
                $approval_history->created_datetime =   date('Y-m-d h:i:s');
                $approval_history->date             =   date('Y-m-d h:i:s');
                $approval_history->state            =   'Q';
                $approval_history->save();
                
                /***************** End code added by mereena on 22-10-2019 for approval history********************/
                //$this->documents($modelQuote->file_id, 'Q');
                   Yii::import('application.controllers.front.MasternotificationController'); 
                    $model_mail_setting=Notification::model()->find(array('condition' => 'event_id="4"'));
                    if($model_mail_setting->mail_required=='Y'){ 
                        // MasternotificationController::sendmail(4,$modelQuote->id);
                    }
                    if($model_mail_setting->notification_required=='Y'){                    
                        // MasternotificationController::sendnotification(4,$modelQuote->id);
                    }
                    if($model_mail_setting->sms_required=='Y'){                    
                        // MasternotificationController::sendsms(4,$modelQuote->id);
                    }

                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'QUOTATIONS',
                    Yii::app()->user->id,
                    'UPDATED',
                    " with APRVL LVL 1 QTN No - {$modelQuote->id}  "
                );
                // end audit log 

                $jsonData['file'] = $modelQuote->file;
                $jsonData['quotation'] = $modelQuote;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
   
            } else {
                $error5=array();
                $error1 = json_decode(CActiveForm::validate($modelQuote, '', false), true);
                if ($modelQuoteItems[0]->product_id > 0)
                    $error2 = json_decode(CActiveForm::validateTabular($modelQuoteItems, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                $error3 = json_decode(CActiveForm::validateTabular($modelQuoteAdditions, '', false), true);
                $error4 = json_decode(CActiveForm::validateTabular($modelQuoteDeductions, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4,$other));
                if ($error != '[]')
                    echo $error;
            }

        }else{
            echo 'error';
        }
    } 
    /*
     * function to more button in quotes
     * modified by jisha on 18-9-18. 
    */
    public function actionCreatePrint(){
        $id = (int) Yii::app()->request->getParam('id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);
	$this->render('create_print',array('id'=>$id));
    }
    /*
     * function to print quotes
     * modified by jisha on 18-9-18. 
    */
    public function actionPrintQuotationReportPDF() {

        $model=new ServiceQuotes();
        $id = Yii::app()->request->getParam('id');
        $print_type = Yii::app()->request->getParam('print_type');
        $type = Yii::app()->request->getParam('type');
        if($id>0)
        {
            $model=new ServiceQuotes();
        }
        /*if($type=='1'){
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4-L'); 
        }else{*/
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        //}
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        if($type=='2'){
            $mPDF1->WriteHTML($this->renderPartial('application.modules.service.views.pdf.quotation_list_individual_without_part_no', array('model' => $model, 'id' => $id, 'title' => $title, 'title' => $title,'type'=>$type),true));
        }else {
            $mPDF1->WriteHTML($this->renderPartial('application.modules.service.views.pdf.quotation_list_individual', array('model' => $model, 'id' => $id, 'title' => $title, 'title' => $title,'type'=>$type),true));
        }
        $mPDF1->Output("Quotation.pdf", 'I');
    }
    /*
     * function to print quotes
     * modified by jisha on 18-9-18. 
    */
    public function actionPrintQuotationWithoutDiscountPDF() {

        $model=new ServiceQuotes();
        $id = Yii::app()->request->getParam('id');
        $type = Yii::app()->request->getParam('type');
        if($id>0)
        {
            $model=new ServiceQuotes();
        }
        if($type=='1'){
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4-L');
        }else{
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        }
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_without_discount', array('model' => $model, 'id' => $id, 'title' => $title),true));
        $mPDF1->Output($htmlTemplate, 'I');
    }
    /*
     * function to print quotes
     * modified by jisha on 18-9-18. 
    */
    public function actionPrintQuotationPdfVat() {

        $model=new ServiceQuotes();
        $id = Yii::app()->request->getParam('id');
        $type = Yii::app()->request->getParam('type');
        if($id>0)
        {
            $model=new ServiceQuotes();
        }
        if($type=='1'){
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4-L');
        }else{
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        }
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_with_vat', array('model' => $model, 'id' => $id, 'title' => $title),true));
        $mPDF1->Output($htmlTemplate, 'I');
    }
    /*
     * function to view itemdetails more in  quotes
     * modified by jisha on 18-9-18. 
    */
    public function actionQuoteItemsview(){
        $model=new ServiceQuotes();
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_items_list', array('model' => $model, 'id' => $id, 'title' => $title),true));
        $mPDF1->Output($htmlTemplate, 'I');
    }
    /*jisha for adding list of received itemneed to be ordered
    * modified by jisha on 18-9-18. 
    */
    public function actionMissingList(){
        $model=new ServiceQuotes();
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_received_list', array('model' => $model, 'id' => $id, 'title' => $title),true));
        $mPDF1->Output($htmlTemplate, 'I');
    }
    /*
     * function to Upload doc in  quotes
     * modified by jisha on 18-9-18. 
    */
    public function actionDocumentUpload() {
        $file_id = Yii::app()->request->getparam("file_id");
        $modelDocument = Document::model()->find(array('condition'=>'file_id = "'.$file_id.'"'));
        if(empty($modelDocument)){
            $modelDocument = new Document();   
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false,'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->renderPartial('document_index', array('modelDocument'=>$modelDocument,'file_id'=>$file_id), false, true);
    }
    /*
     * function to list note for datatable in  quotes
     * modified by jisha on 18-9-18. 
    */
    public function actionGetNotesList()
    {
        $id = $_POST['id'];
        $model=new Activity();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
            0 => 't.id',
            1 =>'t.notes',
            2 => 't.created_by'
           );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        if($id ==''){
            $id=0;
        }
        $condition = 't.file_id > 0 AND t.file_id="'.$id.'" and t.type_of_activity = "N"';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $condition.=" and (notes LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'date_of_activity DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m = 1;
        foreach ($model as $row)
        {
            $model2 = User::model()->find(array('condition'=>'t.id = "'.$row['created_by'].'"'));
            $rowData[]=array($m,$row->notes,$model2->username,date('d/m/Y',STRTOTIME($row->created_date_time)));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    /*
     * function to create note in  quotes
     * modified by jisha on 18-9-18. 
    */
    public function actionCreateNote()
    {
        $modelNotes=new Activity();
        $file_id = (int) Yii::app()->request->getParam('file_id');
        $id = (int) Yii::app()->request->getParam('id');
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $contact_id = (int) Yii::app()->request->getParam('contact_id');

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('quotes_note_form', array('modelNotes' => $modelNotes,'file_id' => $file_id,'id'=>$id,'customer_id'=>$customer_id,'contact_id'=>$contact_id));

    }
    /*
    public function actionDeleteNotes() {
            $id = $_POST['id'];
            $model = new FileNotes();
             $model->deleteByPk($id);
            echo "success";
    }*/
    /*
     * function to save note in  quotes
     * modified by jisha on 18-9-18. 
    */
    public function actionSaveNote()
    {

    	date_default_timezone_set("Asia/Dubai");
        $modelNotes = new Activity();
        if (!empty($_POST['Activity'])) 
        {   

            $modelNotes->created_by = Yii::app()->user->id;
            $modelNotes->created_date_time = date('Y-m-d h:i:s');
            $modelNotes->notes=$_POST['Activity']['notes'];
            $modelNotes->date_of_activity = date('Y-m-d h:i:s');
            
            $modelNotes->crm_user_id = Yii::app()->user->id;
            $modelNotes->customer_id = $_POST['customer_id'];
            $modelNotes->contact_id = $_POST['contact_id'];
            $modelNotes->file_id=$_POST['file_id'];
            $modelNotes->type_of_activity='N';
            $modelNotes->added_from='Q';
            $modelNotes->save(false);

            $modelNotes->attributes = $_POST['Activity'];
            $modelNotes->save(false); 
            $jsonData['status'] = 'success';
            $jsonData['customer_id'] = 'success';
            echo CJSON::encode($jsonData);    
        }  
    } 
    /*
     * function to list docs for datatable in  quotes
     * modified by jisha on 18-9-18. 
    */
    public function actionGetDocumentList()
    {
        $model=new Document();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
               0=>'t.file_id',                 
               1 =>'t.document_name',
               2=>'t.created_by',
               3=>'t.created_datetime',

               );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
         $condition = 't.isActive="Y" and t.file_id = "'.$_POST['file_id'].'" AND t.file_id > 0';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
          $searchString = $_POST['search']['value'];
          $condition.=" and (document_name LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {
            $button_string="";
            $model2 = User::model()->find(array('condition'=>'t.id = "'.$row['created_by'].'"'));
            if (isset(Yii::app()->user->havePermissionOn['allow_delete_document']) || Yii::app()->user->authorised_user == 1)
            {
                $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a> &nbsp;';
            }  
            $button_string .= '<a href ="'. Yii::app()->createUrl('lead/downloaddocument&id='.$row['id']).'" class=" btn btn-primary btn-xs"><i class="fa fa-download"></i></a>';
            $rowData[]=array($m,$row['document_name'],$model2->username,date("d/m/Y h:m:s",strtotime($row['created_datetime'])),'<div class="btn-wrap text-center">'.$button_string .'</div>');
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    } 
    /*
     * function to delete docs for datatable in  quotes
     * modified by jisha on 18-9-18. 
    */
    public function actionDeleteDocument() {
        $id = $_POST['id'];
        $modelDocument = new Document();
        $model_doc = Document::model()->findbyPK($id);
        $document_details = explode(',', $model_doc->document_name);
        foreach ($document_details as $value) {
            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $value;
            unlink($path);
        }
        $modelDocument->deleteByPk($id);
        echo "success";
        
    }
    /*
     * function to get product details in autocomplete in  quotes,order,ordersc
     * modified by jisha on 18-9-18. 
    */
    public function actionGetProducts() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = '(part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%") and t.isActive="Y"';
        $model = new Store();
        $model = $model->with('tax')->findAll(array('select' => 'id,part_number,description,unit_id,inventory_item_type,purchase_from,rate', 'condition' => $condition, 'limit' => 200));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number.' : '.$eachModel->description;
            $data[$i]['part_number'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->unit->id;
            $data[$i]['unit_name'] = $eachModel->unit->symbol;
            $data[$i]['tax_code'] = $eachModel->tax;            
            $data[$i]['part_no'] = $eachModel->part_number;           
            $data[$i]['other'] = $eachModel->inventory_item_type;
            $data[$i]['purchasefrm']=$eachModel->purchase_from;
            $data[$i]['rate']=$eachModel->rate;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    /*
     * function to get unit dropdwn in  quotes
     * modified by jisha on 18-9-18. 
    */
    public function actionGetunitdrop(){
        $row = $_POST['row_field'];
        $product = $_POST['product_id'];
        $type = $_POST['type'];
        $drop = array();
        $modelOrder = new ServiceQuotesItem;
        if($type==2){
            $modelOrder = new HiringServiceQuotesItem;
        }
        if($product > 0){
            $modelOrder->unit_id = UnitOfMeasurement::getBaseunit($product);
            $drop['drop'] = CHtml::activedropdownlist($modelOrder, "[" . $row . "]unit_id",UnitOfMeasurement::getUnits($product), array('class'=>'unit go'));
        }
        echo CJSON::encode($drop);
    }
    /*
     * function to get salesgroup dropdwn in  quotes
     * modified by jisha on 31-7-19. 
    */
    public function actionGetSalesGroup(){
        $frm = $_POST['frm'];
        $type = $_POST['type'];
        $drop = array();
        $model = new ServiceQuotes();
        if($frm=='quotes')
        $model = new ServiceQuotes();
        if($type =='H'){
            $drop['salesgrouplist'] = CHtml::activedropdownlist($model, "sales_group",MasSalesGroup::getHiringSalesGroup(), array('data-label'=>'Sales Group <span style="color:red">*</span>'));
        }
        else{
            $drop['salesgrouplist'] = CHtml::activedropdownlist($model, "sales_group",MasSalesGroup::getNonHiringSalesGroup(), array('data-label'=>'Sales Group <span style="color:red">*</span>'));
        }
        echo CJSON::encode($drop);
    }
    /*
     * function to get  quotes helper
     * modified by jisha on 18-9-18. 
    */
    public function actionQuotationHelper() {
        $product_id = (int) $_POST['id'];
        $customer_id = (int) $_POST['customer_id'];
        $this->renderPartial('quotation_helper',array('id'=>$product_id,'customer_id'=>$customer_id), false, true); 
    }
    /*
     * function to get  customer pricing for autocomplete in quotes details,order details
     * modified by jisha on 18-9-18. 
    */
    public function actionGetAllDetailsForProduct(){
        if($_GET['product_id']>0)
        $product_id     = $_GET['product_id'];
        else
        $product_id     = $_POST['product_id'];
        if($_GET['customer_id']>0)
        $customer_id    = $_GET['customer_id'];
        else
        $customer_id    = $_POST['customer_id'];
        $modelCustomer = new Customer();
        $arr_customer_pricing_details = $modelCustomer->findByPk($customer_id);
        $sales_pricing_group_id = (int) $arr_customer_pricing_details->default_pricing_group_id;        
        $model = new SalesPriceGroup();
        $arr_price_details = $model->find(array('condition'=>'product_id='.$product_id));     
        $price = 0;
        if($sales_pricing_group_id==1){
            $price = $arr_price_details->base_sales_price;
        }
        elseif($sales_pricing_group_id==2){
            $price = $arr_price_details->sales_price1;
        }
        elseif($sales_pricing_group_id==3){
            $price = $arr_price_details->sales_price2;
        }
        elseif($sales_pricing_group_id==4){
            $price = $arr_price_details->sales_price3;
        }
        elseif($sales_pricing_group_id==5){
            $price = $arr_price_details->sales_price4;
        }
        elseif($sales_pricing_group_id==6){
            $price = $arr_price_details->sales_price5;
        }
        elseif($sales_pricing_group_id==7){
            $price = $arr_price_details->sales_price6;
        }
        elseif($sales_pricing_group_id==8){
            $price = $arr_price_details->sales_price7;
        }
        else
        {
           $price = $arr_price_details->sales_price1; 
        }
        
        $jsonData['price'] = number_format(floatval($price), 2, '.', '');
        echo CJSON::encode($jsonData);
        Yii::app()->end();        
    }
    /*
     * function to get  customer contact in quotes add
     * modified by jisha on 18-9-18. 
    */
    public function actionFetchcontactdetails() {

        $data = CustomerContact::model()->find('id=:c_id', array(':c_id' => (int) $_POST['contact_id']));
        echo CJSON::encode($data);
    }
    /*
     * function to get  customer contact in quotes add
     * modified by jisha on 18-9-18. 
    */
    public function actiongetCustomerContactdetails()
    {
        $id=Yii::app()->request->getparam("id");  
        $models = CustomerContact::getCustomerContacts($id); 
        $drop='<li class="col-sm-4">';
        $model=new ServiceQuotes;
        $drop.=CHtml::activedropDownList($model,'contact_id' , $models,  array('empty'=>'Select','class' => 'tooltipster', 'title' => 'Please Select Contact','data-label'=>'Contact <span style="color:red">*</span>','data-search'=>true,'empty'=>'-select-','onchange'=>'getcontactdetails(this.value)'));   
        $drop.='</li>';
        $status=array("dt" => $drop);
        echo CJSON::encode($status);

    }
    
    
    public function  actionGetContextMenuItems(){
    	
    	/* $id=Yii::app()->request->getparam("id");
    	
    	$model = new ServiceQuotes(); */
    	
    	//echo '"edit": {name: "Edit", icon: "edit"},';
    	
    	/* $data=array();
    	
    	$data['items']='"edit": {name: "Edit", icon: "edit"}';
    	
    	echo CJSON::encode($data);  */
    	
    	//echo '"edit": {name: "Edit", icon: "edit"},';
    	
    	echo '{"\"edit\": {name: \"Edit\", icon: \"edit\"}"},';
    	 
    	
    }
    
    /***************** Code Added By mereena on 07/06/2019 ****************************/
    public function actionGetInventoryHiringProducts() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $customer_id = $_GET['customer_id'];
        $qtn_type = $_GET['qtn_type'];
        $application = $_GET['application'];
        $sales_group = (int)$_GET['sales_group'];
        if($sales_group>0){
            $model_salesgroup = MasSalesGroup::model()->findByPK($sales_group);
        }
        $condition = '(t.part_number LIKE "%' . $searchTerm . '%" OR t.description LIKE "%' . $searchTerm . '%" OR t.oem_number LIKE "%' . $searchTerm . '%") and t.isActive="Y"';
        if($qtn_type=='H'){
            if($from=='orderhireitem'||$from=='quoteshireitem'){
//                $condition = '(t.part_number LIKE "%' . $searchTerm . '%" OR t.description LIKE "%' . $searchTerm . '%" OR product.oem_number LIKE "%' . $searchTerm . '%")';
//                $modelHI = new HiringItems();
//                $model = $modelHI->with('product','unitdetails')->findAll(array( 'condition' => $condition,'group'=>'t.product_id', 'limit' => 200));
                $condition = '(t.hiring_part_number LIKE "%' . $searchTerm . '%" OR t.description LIKE "%' . $searchTerm . '%") and t.isActive="Y"';
                $model = new Store();
                $model = $model->findAll(array('condition' => $condition,'limit' => 200));
            }else{
                $condition = '(t.part_number LIKE "%' . $searchTerm . '%" OR t.description LIKE "%' . $searchTerm . '%" OR storedetails.oem_number LIKE "%' . $searchTerm . '%") and storedetails.isActive="Y"';
                if($application!='')
                $condition.= ' AND t.application_id="'.$application.'" AND storedetails.machine_type="M"';/*.'" AND 	hiring_status="IN"*/
                $model = new Hiring();
                $model = $model->with('storedetails','unitdetails')->findAll(array(/*'select' => 'id,part_number,description,unit_id,1 AS inventory_item_type',*/ 'condition' => $condition, 'limit' => 200));
            }
        }
        elseif(isset($model_salesgroup->type)&&$model_salesgroup->type=='P'){
            $condition = '(product.hiring_part_number LIKE "%' . $searchTerm . '%" OR product.description LIKE "%' . $searchTerm . '%" OR product.oem_number LIKE "%' . $searchTerm . '%") AND (t.transaction_type="HIRING_TRANSFER_IN" OR t.transaction_type="UPLOAD_HIRING_TRANSFER_IN") and product.isActive="Y"';//code chaged by mereena on 18/02/2020
            $model = new ProductLocationHiringDetails();
            $model = $model->with('product')->findAll(array('select' => 'product.id AS id,product.hiring_part_number AS part_number,product.description AS description,product.unit_id AS unit_id,product.inventory_item_type AS inventory_item_type', 'condition' => $condition,'group'=>'t.product_id','order'=>'product.part_number ASC', 'limit' => 200));
        }else{
            $condition = '(t.part_number LIKE "%' . $searchTerm . '%" OR t.description LIKE "%' . $searchTerm . '%" OR t.oem_number LIKE "%' . $searchTerm . '%") and t.isActive="Y"';
            $model = new Store();
            $model = $model->with('tax')->findAll(array('select' => 'id,part_number,description,unit_id,inventory_item_type', 'condition' => $condition, 'limit' => 200));
        }
        $i = 0;
        $data=array();
        foreach ($model as $eachModel) {
            
            if($qtn_type=='H'){
                if($from=='orderhireitem'||$from=='quoteshireitem'){
                    $model_avail_qty=ProductLocationHiringDetails::model()->with('warehouse')->find(array('select' => 'sum(quantity) as quantity','condition'=>'product_id="'.$eachModel->id.'" AND warehouse.warehouse_code!="DAM"'));
                    if(empty($model_avail_qty)||($model_avail_qty->quantity=='')){
                        $model_avail_qty->quantity=0;
                    }
                    $inventory_item_type = 1;//stock item
                    $hiring_id=0;
                    $quantity=1;
                    $condition_hiring='t.product_id="'.$eachModel->id.'"';
                    if($application!=''){
                        $condition_hiring.= ' AND hiringdetails.application_id="'.$application.'"';
                    }
                    $model_hiring_item = HiringItems::model()->with('hiringdetails')->find(array('condition' =>$condition_hiring));
                    if($model_hiring_item->id>0){
                        $hiring_id=$model_hiring_item->id;
                        $quantity=$model_hiring_item->quantity;
                    }
                    $data[$i]['value'] = $eachModel->id;
                    //$data[$i]['default_hour'] = $eachModel->default_hrs_per_day;
                    $data[$i]['part_number'] = $eachModel->hiring_part_number;
                    $data[$i]['description'] = $eachModel->description;
                    $data[$i]['unit_id'] = $eachModel->unit->id;
                    $data[$i]['unit_name'] = $eachModel->unit->symbol;
                    $data[$i]['tax_code'] = $eachModel->tax; 
                    $data[$i]['other'] = $inventory_item_type."##".$hiring_id;
                    $data[$i]['total_qty'] = $quantity; 
                    $data[$i]['label'] = $eachModel->hiring_part_number.'(Qty-'.(int)$model_avail_qty->quantity.')'.' : '.$eachModel->description;
                }else{
                    $model_avail_qty=ProductLocationHiringDetails::model()->with('warehouse')->find(array('select' => 'sum(quantity) as quantity','condition'=>'product_id="'.$eachModel->product_id.'" AND warehouse.warehouse_code!="DAM"'));
                    if($model_avail_qty->quantity==''){
                        $model_avail_qty->quantity=0;
                    }
                    $inventory_item_type = 1;//stock item
                    $hiring_id=$eachModel->id;
                    $data[$i]['value'] = $eachModel->product_id;
                    $data[$i]['default_hour'] = $eachModel->default_hrs_per_day;
                    $data[$i]['part_number'] = $eachModel->part_number;
                    $data[$i]['description'] = $eachModel->description;
                    $data[$i]['unit_id'] = $eachModel->unit_id;
                    $data[$i]['unit_name'] = $eachModel->unitdetails->symbol;
                    $data[$i]['tax_code'] = $eachModel->storedetails->tax; 
                    $data[$i]['other'] = $inventory_item_type."##".$hiring_id;
                    $data[$i]['total_qty'] = $eachModel->quantity; 
                    $data[$i]['label'] = $eachModel->part_number.'(Qty-'.(int)$model_avail_qty->quantity.')'.' : '.$eachModel->description;
                }
                $data[$i]['serialno'] = 'H';
            }
            else if(isset($model_salesgroup->type)&&$model_salesgroup->type=='P'){
                $model_avail_qty=ProductLocationHiringDetails::model()->with('warehouse')->find(array('select' => 'sum(quantity) as quantity','condition'=>'product_id="'.$eachModel->product->id.'" AND warehouse.warehouse_code!="DAM"'));
                if($model_avail_qty->quantity==''){
                    $model_avail_qty->quantity=0;
                }
                $data[$i]['value'] = $eachModel->product->id;
                $data[$i]['pdt_loc_hiring'] = $eachModel->id;
                $data[$i]['part_number'] = $eachModel->product->hiring_part_number;
                $data[$i]['description'] = $eachModel->product->description;
                $data[$i]['unit_id'] = $eachModel->product->unit->id;
                $data[$i]['unit_name'] = $eachModel->product->unit->symbol;
                $data[$i]['tax_code'] = $eachModel->product->tax;   
                $data[$i]['other'] = $eachModel->product->inventory_item_type;
                $data[$i]['total_qty'] = 1; 
                $data[$i]['serialno'] = $model_salesgroup->type; 
                $data[$i]['label'] = $eachModel->product->hiring_part_number.'(Qty-'.(int)$model_avail_qty->quantity.')'.' : '.$eachModel->product->description;    
            }
            else    {
                $total_available_product=ProductLocationDetails::model()->find(array('select' => 'IFNULL(sum(quantity),0) as quantity','condition'=>'product_id="'.$eachModel->id.'"')); 
                $allocated_product = AllocatedMaterial::model()->find(array('select' => 'IFNULL(sum(quantity),0) as quantity','condition'=>'product_id="'.$eachModel->id.'"')); 
                $stock_qty=$total_available_product->quantity-$allocated_product->quantity;  
                $data[$i]['value'] = $eachModel->id;
                $data[$i]['part_number'] = $eachModel->part_number;
                $data[$i]['description'] = $eachModel->description;
                $data[$i]['unit_id'] = $eachModel->unit->id;
                $data[$i]['unit_name'] = $eachModel->unit->symbol;
                $data[$i]['tax_code'] = $eachModel->tax;   
                $data[$i]['other'] = $eachModel->inventory_item_type;
                $data[$i]['total_qty'] = 1; 
                $data[$i]['label'] = $eachModel->part_number.'(Qty-'.$stock_qty.')'.' : '.$eachModel->description;
                $data[$i]['serialno'] = $model_salesgroup->type;
            }
            
            $data[$i]['part_no'] = $eachModel->part_number;  
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionGetAjaxQuotationDetails(){
        $model=new ServiceQuotes();
        $id = Yii::app()->request->getParam('id');
        $sales_group_id = Yii::app()->request->getParam('id');
        
        $condition='quotes_id="'.$id.'"';//To fetch master
            $modelQuoteItems = ServiceQuotesItem::model()->findAll(array('condition'=>$condition,'order' => 'id ASC')); 
            if(empty($modelQuoteItems)){
                     $modelQuoteItems = array(new ServiceQuotesItem);
            }
           $this->renderPartial('ajax_quotes_details',array('model'=>$model,'modelQuoteItems'=>$modelQuoteItems,'id'=>$id,'sales_group_id'=>$sales_group_id));
        
    }
    public function actionPrintQuotationAvailableQtyPDF(){
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_availability', array('id' => $id),true));
        $mPDF1->Output("Quotation.pdf", 'I');
    } 
    public function actionPrintHiringQuotationWord(){
        $model=new ServiceQuotes();
        $id = Yii::app()->request->getParam('id');
        if($id>0)
        {
            $model=new ServiceQuotes();
        }
        $filename = 'quotation'.$id.'.doc';
        header("Content-type: application/vnd.ms-word");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial("application.views.front..word.hiring_quotation_individual", array('model' => $model, 'id' => $id), false, true);
        Yii::app()->end();
    }
    //code added by mereena on 22/10/2019 -- To get approval history
    public function actionGetApprovalHistory(){
        $file_id = Yii::app()->request->getparam("file_id");
        $modelHistory = ApprovalHistory::model()->find(array('condition'=>'file_id = "'.$file_id.'"'));
        if(empty($modelHistory)){
            $modelHistory = new ApprovalHistory();   
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false,'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->renderPartial('approval_history', array('modelHistory'=>$modelHistory,'file_id'=>$file_id), false, true);
    }
    
    public function actionGetApprovalHistoryList(){
        $model=new ApprovalHistory();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
               0=>'t.action_by',                 
               1 =>'t.created_datetime',
               2=>'t.state',
               );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
         $condition = 't.file_id = "'.$_POST['file_id'].'"';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
          $searchString = $_POST['search']['value'];
          $condition.=" AND (approvedby.first_name LIKE '%".$searchString."%' OR approvedby.last_name LIKE '%".$searchString."%' OR state LIKE '%".$searchString."%')";
        }
        $count = $model->with('approvedby')->count(array('condition'=>$condition));
        $model=$model->with('approvedby')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'created_datetime DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {
            $button_string="";
            $status="Approved";
            if($row['status']=='N'){
                $status="Un Approved";
            }
            $state="Quotation";
            if($row['state']=='O'){
                $state="Order";
            }
            $rowData[]=array($m,$row['approvedby']['first_name']." ".$row['approvedby']['last_name'],date("d/m/Y h:i:s",strtotime($row['created_datetime'])),$status,$state);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    //end
    
    
    
    public function actionPrintQuotation() {
        $model=new ServiceQuotes();
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.pdf_quotation', array('model' => $model, 'id' => $id),true));        
        $mPDF1->Output("Quotation.pdf", 'I');
    }
    public function actionGetPreviousCustomerRates(){
        $product_id = $_POST['id'];
        $customer_id =$_POST['customer_id'];
        $model=new ServiceQuotesItem();
        $arr_prev_rates = $model->with('quotes')->findAll(array('condition'=>'quotes.customer_id='.$customer_id.' AND t.product_id='.$product_id,'order'=>'t.id DESC','limit'=>5));
        $table = '<table class="table table-primary">';
        if(!empty($arr_prev_rates)){
            foreach($arr_prev_rates as $each){
                $table .= '<tr>';
                $table .= '<td>'.$each->quotes->qtn_start_date.'</td>';
                $table .= '<td class="text-right">'.$each->rate.'</td>';
                $table .= '</tr>';
            }
        }else{
            $table .= '<tr>';
            $table .= '<td colspan="2">No Data</td>';
            $table .= '</tr>';
        }
        echo $table;
    }
    public function actionSendQuotationConversionMail(){
        $subject="Mail Regarding Open Quotations that were not Converted to Order";
        $view="lead_notification_mail";
        $from='john@mailbluesky.com';
        $to='jisha@mailbluesky.com';
        $content='';
        $applicant_name='Diatech ERP TEAM';
        $salutation='Dear Sir';
        //setting details
        $model_settings         = new MasCompanySettings();
        $crm_login_company_id   = Yii::app()->user->master_user_company_id;        
        $model_settings         = $model_settings->find(array('condition'=>'crm_company_id='.$crm_login_company_id));  
        $quotation_to_order_days = $model_settings->quotation_to_order_days;
        //quotation details
        $condition='t.status = "Y" AND t.isActive="Y"';
        if($quotation_to_order_days>0){
            $condition.=' AND TIMESTAMPDIFF(day,t.qtn_start_date,NOW())>'.$quotation_to_order_days;
        }
        $model_quotation = ServiceQuotes::model()->findAll(array('condition'=>$condition));
        //SELECT * FROM `erp_quotes` `t` WHERE t.status = "O" AND t.isActive="Y"AND TIMESTAMPDIFF(day,t.qtn_start_date,NOW())>1
        if(!empty($model_quotation )){
            $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;" width="10px">
                        File #
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;" width="10px">
                        Qtn #
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;" width="12px">
                        Customer
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;" width="12px">
                        Lead Owner
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;" width="10px">
                        Qtn Date
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;" width="10px">
                        Validity
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;" width="10px">
                        Qtn Value
                        </th>
                    </tr>';
            foreach($model_quotation as $value){
                $qtn_start_date='-';
                if($value->qtn_start_date!='' && $value->qtn_start_date!='0000-00-00'){
                    $qtn_start_date=date("d/m/Y", strtotime($value->qtn_start_date));
                }
                $qtn_validity='-';
                if($value->qtn_validity!='' && $value->qtn_validity!='0000-00-00'){
                    $qtn_validity=date("d/m/Y", strtotime($value->qtn_validity));
                }
                $qtn_value=Yii::app()->numberFormatter->formatCurrency($value['grand_total'],"");
                $content.='<tr>
                    <td style="border: 1px solid #666;padding: 4px 5px;">'.$value['file_id'].'</td>
                    <td style="border: 1px solid #666;padding: 4px 5px;">'.$value['id'].'</td>
                    <td style="border: 1px solid #666;padding: 4px 5px;text-align: left;">'.$value->customer->customer_name.'</td>
                    <td style="border: 1px solid #666;padding: 4px 5px;text-align: left;">'.$value->leadowner->first_name." ".$value->leadowner->last_name.'</td>
                    <td style="border: 1px solid #666;padding: 4px 5px;">'.$qtn_start_date.'</td>
                    <td style="border: 1px solid #666;padding: 4px 5px;">'.$qtn_validity.'</td>
                    <td style="border: 1px solid #666;padding: 4px 5px;text-align: right;">'.$qtn_value.'</td>
                    </tr>';
            }
                $content.='</tbody>
            </table>';
            $mailContent = array();   
            $mailContent['body'] = '
                <table cellpadding="0" cellspacing="0" align="left" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit">
                    <tbody>
                        <tr style="vertical-align: top">
                            <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">
                                <div>'.$salutation.',</div>                                              
                            </td>
                        </tr>                                      
                        <tr>
                            <td height="30"></td>
                        </tr>
                        <tr style="vertical-align: top">
                            <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">
                                <strong style="font-size: 15px">Sub: '.$subject.'</strong>
                            </td>
                        </tr>
                        <tr>
                            <td height="30"></td>
                        </tr>
                        <tr style="vertical-align: top">
                            <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">'                          
                                .$content.'<br>
                                <br>
                                <br>
                                Thanking you,
                                <br>
                                <br>
                                Yours sincerely,
                                <br>
                                <br>
                                '.$applicant_name.'
                            </td>
                        </tr>
                    </tbody>
                </table>';
            ////End Mail Content
            $message = new YiiMailMessage;
            $message->view = $view;
            $message->setBody(array('mailContent' => $mailContent), 'text/html');
            $message->subject =$subject; 
            $message->from =$from;
            $message->addTo($to);
            //$message->addCC($custom_mail_id);
            Yii::app()->mail->send($message);
            echo CJSON::encode(array('status'=>'success'));
        }
    }
}        