<?php

class OrderController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails', 'Updatedefaulthrs'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetOrderList', 'Create', 'SaveOrder', 'Approve', 'ShortClosure',
                    'GetNotesList', 'DeleteNotes', 'CreateNote', 'SaveNote', 'Getunitdrop', 'getCustomerContactdetails',
                    'documentupload', 'UploadDocuments', 'GetDocumentList', 'DeleteDocument',
                    'PrintProformaReportPDF', 'PrintOrderReportPDF', 'ChangeDate', 'SaveDate', 'Proformainvoice', 'MissingList',
                    'Createproformainvoice', 'PrintOrderAnnexureReportPDF',
                    'Saveprofomainvoice', 'GetFileid', 'Removeorderitem', 'finalApprove',
                    'RemovelineItem','PrintContractWord',
                    'PrintContractPDF','PrintContractNewPDF', 'createSchedule', 'SaveSchedule','getServiceDesc','ServicePaymentTracker','GetServicePaymentTrackerList'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndex() {
        $frm = (int) Yii::app()->request->getParam('frm');
        $this->render('index', array('frm' => $frm));
    }

    public function actionGetOrderList() {
        $model = new ServiceOrder();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $frm = $_POST['frm'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.id',
            2 => 'customer.customer_name',
            3 => 'crmUser.first_name',
            4 => 't.order_date',
            5 => 't.delivery_date',
            6 => 'currencyname.currency_code',
            7 => 't.total_tax_amount',
            8 => 't.grand_total',
            16 => 't.sales_group'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '(t.isActive="Y" AND (file.current_process_status="O" OR file.current_process_status="PD" OR file.current_process_status="PI" )) AND t.order_type="service" ';

        if (!isset(Yii::app()->user->havePermissionOn["order_view_all"]) && Yii::app()->user->authorised_user != 1) {
            $condition .= ' AND (t.lead_owner_id= "' . Yii::app()->user->id . '" OR file.lead_owner_id="' . Yii::app()->user->id . '")';
        }

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $condition = 't.isActive="Y" AND t.order_type="service"';

            if (!isset(Yii::app()->user->havePermissionOn["order_view_all"]) && Yii::app()->user->authorised_user != 1) {
                $condition .= ' AND (t.lead_owner_id= "' . Yii::app()->user->id . '" OR file.lead_owner_id="' . Yii::app()->user->id . '")';
            }
            $searchString = $_POST['search']['value'];

            $condition .= " AND ( t.total_tax_amount LIKE '%" . $searchString . "%' OR t.grand_total LIKE '%" . $searchString . "%' OR currencyname.currency_code LIKE '%" . $searchString . "%' OR crmUser.first_name LIKE '%" . $searchString . "%' OR customer.customer_name LIKE '%" . $searchString . "%' OR file.file_title LIKE '%" . $searchString . "%' OR t.file_id LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%')";
        }
        $model_settings = MasCompanySettings::model()->find();
        $count = $model->with('customer', 'file', 'currencyname', 'crmUser')->count(array('condition' => $condition));
        $model = $model->with('customer', 'file', 'currencyname', 'crmUser')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        //$settings=SalesSettings::model()->findByPk(1);
        foreach ($model as $s => $row) {
            $rt = $row->file_id;
            /*             * **************** Code added by mereena on 28/11/2017 for allocate material checking************************* */
            $allocate_count = 0;
            if (isset($row->file_id) && $row->file_id > 0) {
                $modelAllocate = new AllocatedMaterial();
                $allocate_count = (int) $modelAllocate->count(array('condition' => 'file_id=' . $row->file_id));
            }
            if ($allocate_count > 0) {
                $title = "Reallocate Material";
            } else {
                $title = "Allocate Material";
            }
            /*             * **************** End Code added by mereena on 28/11/2017 allocate material checking************************* */


            $short_closure = '';
            $action = '';
            $status = $row['file']['status'];
            if ($row['completed'] == 'C') {
                $status = 'Short Closure';
            }


            $state = 0;
            if (strtotime($row->delivery_date) < strtotime(date('Y-m-d'))) {
                $state = 1;
            } elseif ($row->file->is_approved == 'N') {
                $state = 2;
            }
            $model_delivery_note = DeliveryNote::model()->find(array('condition' => 'order_id = "' . $row['id'] . '" and status="CL"'));
            $delivery_note = 0;
            if (!empty($model_delivery_note)) {
                $delivery_note = 1;
            }

            $permission = 0;
            switch ($row->approved_level) {
                case 0:
                    if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["order_approve_level1"]))) {
                        $permission = 1;
                    } else {
                        $permission = 0;
                    }
                    break;
                case 1:
                    if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["order_approve_level2"]))) {
                        $permission = 1;
                    } else {
                        $permission = 0;
                    }
                    break;
                case 2:
                    if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["order_approve_level3"]))) {
                        $permission = 1;
                    } else {
                        $permission = 0;
                    }
                    break;
            }
            //Delivery Note button access
            $show_invoice_btn = 'N';
            $model_invoice_amount = Invoice::model()->find(array('select' => 'SUM(grand_total) as grand_total', 'condition' => 'order_id="' . $row['id'] . '"'));
            $balance_amt = $row['grand_total'] - $model_invoice_amount->grand_total;
            if ($balance_amt > 0) {
                $show_invoice_btn = 'Y';
            }
            //code added by mereena on 05/02/2020 
            $grand_total = $row['grand_total'];

            $order_item_net_amount = 0;
            foreach ($row->items as $orderItems) {
                //if($orderItems->checked==1){
                $order_item_net_amount+=($orderItems->net_amount + $orderItems->tax_vat_amount);
                //}
            }

            $grand_total = $order_item_net_amount;
            
           /* $SQL ="SELECT DATE_FORMAT(MIN(scheduled_date), '%d/%m/%Y') as scheduled_start_date,DATE_FORMAT(MAX(scheduled_date), '%d/%m/%Y') as scheduled_end_date FROM erp_service_schedules WHERE order_id=".$row['id'];
            
            $arr_schedule_contract_details = Yii::app()->db->createCommand($SQL)->queryRow();*/
            
   
            /*echo '<pre>';
            print_r($arr_schedule_contract_details);*/
            
            //$contract_start_date    = $arr_schedule_contract_details['scheduled_start_date'];
            //$contract_end_date      = $arr_schedule_contract_details['scheduled_end_date'];
            
            $contract_start_date = date("d/m/Y", strtotime($row['order_date']));
            $contract_end_date = date('Y-m-d', strtotime('+1 year', strtotime($row['order_date'])));
            $contract_end_date = date('d/m/Y', strtotime('-1 days', strtotime($contract_end_date)));
         
            $contract_date = $contract_start_date." - ".$contract_end_date;


            //end
            /*$rowData[] = array($row['file_id'], $row['id'],$row['contract_no'], $row['customer']['customer_name'], $row['leadowner']['first_name'] . " " . $row['leadowner']['last_name'], date("d/m/Y", strtotime($row['order_date'])), date("d/m/Y", strtotime($row['delivery_date'])), $row['currencyname']['currency_code'],
                Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'], ""), Yii::app()->numberFormatter->formatCurrency(($grand_total), ""), $status, $row->approved_level, $state, $row['file']['current_process_status'], $row->file->is_approved, $row['customer_id'], $row['completed'], $row['crm_user_id'], '', $row['final_approve'], $permission, $operator_menu, $show_delivery_btn, $row->Created_user);*/
                
                $rowData[] = array($row['file_id'], $row['id'],$row['contract_no'], $row['customer']['customer_name'], $row['leadowner']['first_name'] . " " . $row['leadowner']['last_name'], date("d/m/Y", strtotime($row['order_date'])), date("d/m/Y", strtotime($row['delivery_date'])), $contract_date,
                Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'], ""), Yii::app()->numberFormatter->formatCurrency(($grand_total), ""), $status, $row->approved_level, $state, $row['file']['current_process_status'], $row->file->is_approved, $row['customer_id'], $row['completed'], $row['crm_user_id'], '', $row['final_approve'], $permission, $operator_menu, $show_delivery_btn, $row->Created_user);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new ServiceOrder();
        $id = (int) Yii::app()->request->getParam('id');
        $quote_id = (int) Yii::app()->request->getParam('quote_id');
        $file_id = (int) Yii::app()->request->getParam('file_id');
        $type = Yii::app()->request->getParam('type');
        $duplicate = (int) Yii::app()->request->getParam('duplicate');
        $modelNotes = new Activity();
        $modelOrderItems = array(new ServiceOrderItem);
        $modelOrderAdditions = array(new ServiceOrderAddition);
        $modelOrderDeductions = array(new ServiceOrderDeduction);

        $blocked_min_date = '';
        if ($id > 0) {
            $quote_id=0;
            $model = $model->findByPk($id);
            $modelmasterfile = new MasterFile();
            $modelmasterfile = $modelmasterfile->findByPk($model->file_id);
            $condition = 'order_id="' . $id . '"'; //To fetch master
            $model_proforma = ServiceOrderProformaInvoice::model()->find(array('condition' => 'order_id="' . $id . '"'));
            if ($model_proforma->id == '') {
                $model_proforma = new ServiceOrderProformaInvoice();
            }
            $modelOrderItems = ServiceOrderItem::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));
            $modelOrderAdditions = ServiceOrderAddition::model()->findAll(array('condition' => 'order_id="' . $id . '"', 'order' => 'id ASC'));
            $modelOrderDeductions = ServiceOrderDeduction::model()->findAll(array('condition' => 'order_id="' . $id . '"', 'order' => 'id ASC'));
            if ($duplicate == '1') {
                $model->id = '';
                $model->file_id = '';
                $k = 0;
                foreach ($modelOrderItems as $eachItem) {
                    $Items[$k] = new ServiceOrderItem;
                    $Items[$k]->attributes = $eachItem->attributes;
                    $Items[$k]->id = '';
                    $k++;
                }
                foreach ($modelOrderAdditions as $i => $eachItem) {
                    $Additions[$i] = new ServiceOrderAddition;
                    $Additions[$i]->attributes = $eachItem->attributes;
                }
                foreach ($modelOrderDeductions as $i => $eachItem) {
                    $Deductions[$i] = new ServiceOrderDeduction;
                    $Deductions[$i]->attributes = $eachItem->attributes;
                }
                $modelOrderItems = $Items;
                $modelOrderAdditions = $Additions;
                $modelOrderDeductions = $Deductions;
            }
            if (empty($modelOrderItems)) {
                $modelOrderItems = array(new ServiceOrderItem);
            }
            if (empty($modelOrderAdditions)) {
                $modelOrderAdditions = array(new ServiceOrderAddition);
            }
            if (empty($modelOrderDeductions)) {
                $modelOrderDeductions = array(new ServiceOrderDeduction);
            }
        }
        if ($quote_id > 0) {//convert from quote to order
            $modelQuotes = ServiceQuotes::model()->findByPK($quote_id);
            $modelmasterfile = MasterFile::model()->findByPk($modelQuotes->file_id);
            $model->file_id = $modelQuotes->file_id;
            $model->customer_id = $modelQuotes->customer_id;
            $model->customer_name = $modelQuotes->customer->customer_name;
            if ($modelQuotes->lead_owner_id > 0) {
                $model->lead_owner_id = $modelQuotes->lead_owner_id;
            } else {
                $model->lead_owner_id = $modelQuotes->file->lead_owner_id;
            }
            $model->contact_id = $modelQuotes->contact_id;
            $model->billing_address = $modelQuotes->billing_address;
            $model->sales_group = $modelQuotes->sales_group;
            $model->currency = $modelQuotes->currency;
            $model->exchange_rate = $modelQuotes->exchange_rate;
            $model->payment_terms = $modelQuotes->payment_terms;
            $model->notes = $modelQuotes->notes;
            $model->remarks = $modelQuotes->remarks;
            $model->terms_id = $modelQuotes->terms_id;
            $model->terms_and_conditions = $modelQuotes->terms_and_conditions;
            $model->schedule_terms = $modelQuotes->schedule_terms;
            $model->liability =  $modelQuotes->liability;
            $model->file_title = $modelQuotes->file_title;
            $model->tender_file_id = $modelQuotes->id;
            $model->invoice_type = $modelQuotes->invoice_type;
            $k = 0;
            $conditionitems = 'quotes_id="' . $quote_id . '"';
            $modelQuotesItems = ServiceQuotesItem::model()->findAll(array('condition' => $conditionitems, 'order' => 't.id asc'));
            if (!empty($modelQuotesItems)) {
                foreach ($modelQuotesItems as $eachItem) {
                    if ($eachItem->checked == 1) {
                        $modelOrderItems[$k] = new ServiceOrderItem;
                        $modelOrderItems[$k]->attributes = $eachItem->attributes;
                        $modelOrderItems[$k]->unit_id = $eachItem->unit_id;
                        $k++;
                    }
                }
            }

            foreach ($modelQuotes->adItems as $i => $eachItem) {
                $modelOrderAdditions[$i] = new ServiceOrderAddition;
                $modelOrderAdditions[$i]->attributes = $eachItem->attributes;
            }
            foreach ($modelQuotes->dedItems as $i => $eachItem) {
                $modelOrderDeductions[$i] = new ServiceOrderDeduction;
                $modelOrderDeductions[$i]->attributes = $eachItem->attributes;
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model,
            'modelQuotesItems' => $modelQuotesItems,
            'modelQuotesAdditions' => $modelQuotesAdditions,
            'modelQuotesDeductions' => $modelQuotesDeductions,
            'modelQuotes' => $modelQuotes,
            'modelmasterfile' => $modelmasterfile,
            'modelOrderItems' => $modelOrderItems,
            'modelOrderAdditions' => $modelOrderAdditions,
            'modelOrderDeductions' => $modelOrderDeductions,
            'modelNotes' => $modelNotes,
            'quote_id' => $quote_id,
            'file_id' => $file_id,
            'id' => $id,
            'type' => $type,
        ));
    }

    public function actionDeleteNotes() {
        $id = $_POST['id'];
        $model = new Activity();
        $model->deleteByPk($id);
        echo "success";
    }

    public function actionGetNotesList() {
        $id = $_POST['id'];
        $model = new Activity();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'notes',
            2 => 'created_date_time',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        if ($id == '') {
            $id = 0;
        }
        $condition = 't.file_id > 0 AND t.file_id="' . $id . '" and type_of_activity ="N"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (notes LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $model2 = User::model()->find(array('condition' => 't.id = "' . $row['created_by'] . '"'));
            $rowData[] = array($m, $row->notes, $model2->username, date('d/m/Y', STRTOTIME($row->created_date_time)));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreateNote() {
        $modelNotes = new Activity();
        $file_id = (int) Yii::app()->request->getParam('file_id');
        $id = (int) Yii::app()->request->getParam('id');
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $contact_id = (int) Yii::app()->request->getParam('contact_id');

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('order_note_form', array('modelNotes' => $modelNotes, 'file_id' => $file_id, 'id' => $id, 'customer_id' => $customer_id, 'contact_id' => $contact_id));
    }

    public function actionSaveNote() {
        $modelNotes = new Activity();
        if (!empty($_POST['Activity'])) {
            $modelNotes->created_by = Yii::app()->user->id;
            $modelNotes->created_date_time = date('Y-m-d h:i:s');
            $modelNotes->notes = $_POST['Activity']['notes'];
            $modelNotes->crm_user_id = Yii::app()->user->id;
            $modelNotes->customer_id = $_POST['customer_id'];
            $modelNotes->contact_id = $_POST['contact_id'];
            $modelNotes->file_id = $_POST['file_id'];
            $modelNotes->type_of_activity = 'N';
            $modelNotes->added_from = 'O';
            $modelNotes->save(false);
            $jsonData['status'] = 'success';
            $jsonData['customer_id'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }

    /* jo */

    public function actionGetunitdrop() {
        $row = $_POST['row_field'];
        $product = $_POST['product_id'];
        $type = $_POST['type'];
        $drop = array();
        $modelOrder = new ServiceOrderItem;

        if ($product > 0) {
            $modelOrder->unit_id = UnitOfMeasurement::getBaseunit($product);
            $drop['drop'] = CHtml::activedropdownlist($modelOrder, "[" . $row . "]unit_id", UnitOfMeasurement::getUnits($product), array('class' => 'unit go'));
        }
        echo CJSON::encode($drop);
    }

    public function actiongetCustomerContactdetails() {
        $id = Yii::app()->request->getparam("id");
        $models = CustomerContact::getCustomerContacts($id);
        $customer = Customer::model()->findBypk($id);
        if ($customer->customer_address != '')
            $ads = $customer->customer_address . PHP_EOL;
        else
            $ads = '';
        if ($customer->customer_postal_code != '')
            $post = "PO Box : " . $customer->customer_postal_code . PHP_EOL;
        else
            $post = '';
        if ($customer->customer_city != '')
            $city = $customer->customer_city . PHP_EOL;
        else
            $city = '';
        $adds = $ads . $post . $city . $customer->country->country_name;
        $drop = '<li class="col-sm-3">';
        $model = new ServiceOrder;
        $drop .= CHtml::activedropDownList($model, 'contact_id', $models, array('empty' => 'Select', 'class' => 'tooltipster', 'title' => 'Please Select Contact', 'data-label' => 'Contact', 'data-search' => true, 'empty' => '-select-'));
        $drop .= '</li>';
        $status = array("dt" => $drop, 'adds' => $adds);
        echo CJSON::encode($status);
    }

    public function actionDocumentupload() {
        $file_id = Yii::app()->request->getparam("file_id");
        $modelDocument = Document::model()->find(array('condition' => 'file_id = "' . $file_id . '"'));
        if (empty($modelDocument)) {
            $modelDocument = new Document();
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->renderPartial('document_index', array('modelDocument' => $modelDocument, 'file_id' => $file_id), false, true);
    }

    public function actionGetDocumentList() {

        $model = new Document();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.document_name',
            2 => 't.created_by',
            3 => 't.created_datetime',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.file_id > 0 AND t.isActive="Y" and t.file_id = "' . $_POST['file_id'] . '"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (document_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $model2 = User::model()->find(array('condition' => 't.id = "' . $row['created_by'] . '"'));
            if (isset(Yii::app()->user->havePermissionOn['allow_delete_document']) || Yii::app()->user->authorised_user == 1) {
                $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a> &nbsp;';
            }
            $button_string .= ' <a href ="' . Yii::app()->createUrl('lead/downloaddocument&id=' . $row['id']) . '" class=" btn btn-primary btn-xs"><i class="fa fa-download"></i></a>';
            $rowData[] = array($m, $row['document_name'], $model2->username, date("d/m/Y h:m:s", strtotime($row['created_datetime'])), '<div class="btn-wrap text-center">' . $button_string . '</div>');
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionDeleteDocument() {
        $id = $_POST['id'];
        $modelDocument = new Document();
        $model_doc = Document::model()->findbyPK($id);
        $document_details = explode(',', $model_doc->document_name);
        foreach ($document_details as $value) {
            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $value;
            unlink($path);
        }
        $modelDocument->deleteByPk($id);
        echo "success";
    }

    public function actionSaveOrder() {
        $file_id = $_POST['hid_file_id'];
        $quote_id = $_POST['quote_id'];
        $modelOrder = new ServiceOrder;
        $other = array();
        $modelOrderItem = array(new ServiceOrderItem);

        $modelOrderAddition = array(new ServiceOrderAddition);

        $modelOrderDeduction = array(new ServiceOrderDeduction);

        $order_id = (int) Yii::app()->request->getParam('id');

        $modelOrder->exchange_rate = 1;

        $modelNotes = new Activity();
        if ($order_id > 0) {

            $modelOrder = $modelOrder->findByPK($order_id);
            $modelOrder->attributes = $_POST['ServiceOrder'];
            $modelOrderItem = $modelOrder->items;
            $modelOrderAddition = count($modelOrder->adItems) > 0 ? $modelOrder->adItems : $modelOrderAddition;
            $modelOrderDeduction = count($modelOrder->dedItems) > 0 ? $modelOrder->dedItems : $modelOrderDeduction;
        }
        if (isset($_POST['ServiceOrder'])) {

            $tax_type = 1;

            //$tax_type = $_POST['ServiceOrder']['tax_type'];
            $scenario = '';
            $flag = 0;
            if ((int) $_POST['ServiceOrder']['id'] > 0) {
                $modelOrder = $modelOrder->findByPK($_POST['ServiceOrder']['id']);
                $scenario = 'update';
                $modelOrder->scenario = 'update';
                $audit_type = 'UPDATED';
                $flag = 1;
                $modelOrder->updated_by = Yii::app()->user->id;
                $modelOrder->updated_datetime = date('Y-m-d H:i:s');
            } else {
                $file = new MasterFile;
                $file->crm_user_id = Yii::app()->user->id;
                $file->start_from = 'O';
                $file->current_process_status = 'O';
                $file->customer_id = $_POST['ServiceOrder']['customer_id'];
                $file->is_approved = 'N';
                $scenario = 'add';
                $audit_type = 'CREATED';
                $last_contract_no = ServiceOrder::model()->find(array('condition'=>'order_type="service"','order'=>'id desc'))->contract_no;
                if($last_contract_no<30000){
                    $last_contract_no=30000;
                }
                $modelOrder->contract_no=(int)$last_contract_no+1;
                $modelOrder->created_by = Yii::app()->user->id;
                $modelOrder->created_datetime = date('Y-m-d H:i:s');
            }

            $modelOrder->attributes = $_POST['ServiceOrder'];
            $modelOrder->terms_id = $_POST['ServiceOrder']['terms_id'];
            //$modelOrder->terms_and_conditions = $_POST['ServiceOrder']['terms_and_conditions'];
            $modelOrder->file_title = $_POST['ServiceOrder']['file_title'];
            $modelOrder->currency = $_POST['ServiceOrder']['currency'];
            $modelOrder->exchange_rate = $_POST['ServiceOrder']['exchange_rate'];
            $modelOrder->invoice_type = $_POST['ServiceOrder']['invoice_type'];
            $modelOrder->project_id = $_POST['ServiceOrder']['project_id'];
            $modelOrder->crm_user_id = Yii::app()->user->id;
            $modelOrder->order_type = 'service';
            // $modelOrder->approved_level=0;

            if ((int) $_POST['hid_file_id'] > 0) {
                $mod_mas_file = MasterFile::model()->findByPk((int) $_POST['hid_file_id']);
            }
            if ($mod_mas_file->current_process_status == 'O') {
                $modelOrder->approved_level = 0;
            } else {
                $modelOrder->approved_level = $_POST['ServiceOrder']['approved_level'];
            }

            if ($_POST['ServiceOrder']['lpo_date'] != '0000-00-00' && $_POST['ServiceOrder']['lpo_date'] != '') {
                $modelOrder->lpo_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['ServiceOrder']['lpo_date'])));
            }
            $modelOrder->materials_allocated = (isset($_POST['allocate_materials']) && $_POST['allocate_materials'] == "Y") ? "Y" : "N";

            //code added by mereena on 07/02/2020 for ckeditor content
            $modelOrder->terms_and_conditions = $_POST['terms_conditions'];
            $modelOrder->schedule_terms = $_POST['schedule_terms'];
            $modelOrder->liability =  $_POST['liability'];
            
            $valid = $modelOrder->validate();
            $p = 0;
            if (is_array($_POST['ServiceOrderItem'])) {
                foreach ($_POST['ServiceOrderItem'] as $i => $item) {
                    if (($item['product_id'] > 0 && $item['product_name'] != 'memo') || $item['product_name'] == 'memo') {
                        $modelOrderItem[$p] = new ServiceOrderItem;
                        $modelOrderItem[$p]->attributes = $_POST['ServiceOrderItem'][$i];
                        $modelOrderItem[$p]->brand_class_id = $item['brand_class_id'];
                        $modelOrderItem[$p]->product_generic_name = $item['product_generic_name'];
                        $modelOrderItem[$p]->description = $item['description'];
                        $modelOrderItem[$p]->unit_id = $item['unit_id'];
                        //CODE ADDED BY MEREENA ON 18/02/2020 TO GET ITEM FROM HIRE INVENTORY
                        $modelOrderItem[$p]->inventory_type = $item['inventory_type'];
                        //END
                        $delivery_date = '';
                        if ($flag == 0) {
                            if ($_POST['ServiceOrder']['delivery_date'] != '0000-00-00' && $_POST['ServiceOrder']['delivery_date'] != '') {
                                $delivery_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['ServiceOrder']['delivery_date'])));
                            }
                        } else {
                            if ($item['expected_delivery_date'] != '0000-00-00' && $item['expected_delivery_date'] != '') {
                                $delivery_date = date("Y-m-d", strtotime(str_replace('/', '-', $item['expected_delivery_date'])));
                            } else {
                                if ($_POST['ServiceOrder']['delivery_date'] != '0000-00-00' && $_POST['ServiceOrder']['delivery_date'] != '') {
                                    $delivery_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['ServiceOrder']['delivery_date'])));
                                }
                            }
                        }
                        $modelOrderItem[$p]->expected_delivery_date = $delivery_date;
                        $modelOrderItem[$p]->tax_vat_percentage = $item['tax_vat_percentage'];
                        $modelOrderItem[$p]->tax_vat_amount = $item['tax_vat_amount'];
                        if ($item['product_name'] == 'memo') {
                            $modelOrderItem[$p]->product_id = '999999';
                            $modelOrderItem[$p]->quantity = 0;
                            $modelOrderItem[$p]->amount = 0;
                            $modelOrderItem[$p]->net_amount = 0;
                        }
                        $modelOrderItem[$p]->order_id = 0;
                        $valid = $modelOrderItem[$p]->validate() && $valid;
                        $p++;
                    }
                }
            }

            $valid = $valid && !empty($modelOrderItem[0]->product_id);
            $modelsToBeValidated = array($modelOrder, $modelOrderItem);

            if (is_array($_POST['ServiceOrderAddition'])) {

                foreach ($_POST['ServiceOrderAddition'] as $i => $item) {

                    $modelOrderAddition[$i] = new ServiceOrderAddition;

                    $modelOrderAddition[$i]->attributes = $_POST['ServiceOrderAddition'][$i];

//                    $valid = $modelOrderAddition[$i]->validate() && $valid;
                    if ($item['particular_value'] > 0 && $item['particular'] == '') {
                        $other[] = 'Addition description Cannot Blank';
                        $valid = false;
                    }
                }
                $modelsToBeValidated[] = $modelOrderAddition;
            }



            if (is_array($_POST['ServiceOrderDeduction'])) {

                foreach ($_POST['ServiceOrderDeduction'] as $i => $item) {

                    $modelOrderDeduction[$i] = new ServiceOrderDeduction;

                    $modelOrderDeduction[$i]->attributes = $_POST['ServiceOrderDeduction'][$i];

//                    $valid = $modelOrderDeduction[$i]->validate() && $valid;
                    if ($item['particular_value'] > 0 && $item['particular'] == '') {
                        $other[] = 'Deduction description Cannot Blank';
                        $valid = false;
                    }
                }



                $modelsToBeValidated[] = $modelOrderDeduction;
            }

            if ($valid) {

                $grand_total = 0;

                if ($_POST['hid_file_id'] > 0) {
                    $mod_mas_file = MasterFile::model()->findByPk($_POST['hid_file_id']);
                    if (!empty($mod_mas_file)) {
                        $mod_mas_file->file_title = $_POST['ServiceOrder']['title'];
                        $mod_mas_file->save(false);
                    }
                    if ($flag == 0)
                        MasterFile::model()->updateByPk($_POST['hid_file_id'], array('is_approved' => "N", 'current_process_status' => 'O', 'date_of_approval' => '0000-00-00', 'approved_by' => ''));
                    else
                        MasterFile::model()->updateByPk($_POST['hid_file_id'], array('is_approved' => "N", 'current_process_status' => 'O', 'date_of_approval' => '0000-00-00', 'approved_by' => ''));

                    //code added by mereena on 22/10/2019 -- Approval history
                    if ($_POST['hid_action_type'] == 2) {//To identify unapprove
                        date_default_timezone_set("Asia/Dubai");
                        $approval_history = new ApprovalHistory;
                        $approval_history->file_id = $_POST['hid_file_id'];
                        $approval_history->status = "N";
                        $approval_history->action_by = Yii::app()->user->id;
                        $approval_history->created_by = Yii::app()->user->id;
                        $approval_history->created_datetime = date('Y-m-d h:i:s');
                        $approval_history->date = date('Y-m-d h:i:s');
                        $approval_history->state = 'O';
                        $approval_history->save();
                    }
                    //end
                }

                if ($_POST['ServiceOrder']['order_date'] != '00/00/0000') {

                    $modelOrder->order_date = str_replace('/', '-', $_POST['ServiceOrder']['order_date']);

                    $modelOrder->order_date = date("Y-m-d", strtotime($modelOrder->order_date));
                }

                if ($_POST['ServiceOrder']['delivery_date'] != '00/00/0000') {

                    $modelOrder->delivery_date = str_replace('/', '-', $_POST['ServiceOrder']['delivery_date']);

                    $modelOrder->delivery_date = date("Y-m-d", strtotime($modelOrder->delivery_date));
                }
                if ($_POST['hid_file_id'] > 0) {
                    $modelOrder->file_id = $_POST['hid_file_id'];
                } else {
                    $file->save(false);
                    $modelOrder->file_id = $file->id;
                    //code added by mereena on 16/03/2020
                    $modelOrder->approved_level = 0;
                    //end
                }



                $modelOrder->save(false);

                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'ORDERS', Yii::app()->user->id, $audit_type, " with No: - {$modelOrder->id}  "
                );
                // end audit log 

                $modelOrder->refresh();

                $order_id = $modelOrder->id;
                ServiceOrderItem::model()->deleteAll('order_id=:refer_id', array(':refer_id' => $modelOrder->id));
                ServiceOrderAddition::model()->deleteAll('order_id=:refer_id', array(':refer_id' => $modelOrder->id));
                ServiceOrderDeduction::model()->deleteAll('order_id=:refer_id', array(':refer_id' => $modelOrder->id));
                $total_tax_amount = 0;

                foreach ($modelOrderItem as $eachModel) {
                    $eachModel->order_id = $order_id;
                    $total_tax_amount += $eachModel->tax_vat_amount;
                    $eachModel->save(false);
                    $grand_total += $eachModel->net_amount;
                }
                foreach ($modelOrderAddition as $eachModel) {
                    $eachModel->order_id = $order_id;
                    $eachModel->save(false);
                    $grand_total += $eachModel->calculated_value;
                }
                foreach ($modelOrderDeduction as $eachModel) {
                    $eachModel->order_id = $order_id;
                    $eachModel->save(false);
                    $grand_total -= $eachModel->calculated_value;
                }

                if (!empty($_POST['Activity']['notes'])) {
                    $modelNotes->created_by = Yii::app()->user->id;
                    $modelNotes->created_date_time = date('Y-m-d h:i:s');
                    $modelNotes->notes = $_POST['Activity']['notes'];
                    $modelNotes->crm_user_id = Yii::app()->user->id;
                    $modelNotes->customer_id = $modelOrder->customer_id;
                    $modelNotes->contact_id = $modelOrder->contact_id;
                    $modelNotes->type_of_activity = 'N';
                    $modelNotes->added_from = 'O';
                    $modelNotes->file_id = $modelOrder->file_id;
                    $modelNotes->save(false);
                }

                if (isset($_POST['Icon']['file']) && $_POST['Icon']['file'] != '') {
                    $doc_test = Document::model()->find(array('condition' => 'file_id=' . $modelOrder->file_id . ' AND document_name="' . $_POST['Icon']['file'] . '"'));
                    if (empty($doc_test)) {
                        $modelDocument = new Document;
                        $modelDocument->uploaded_from = "O";
                        $modelDocument->file_id = $modelOrder->file_id;
                        $modelDocument->created_by = Yii::app()->user->id;
                        $modelDocument->created_datetime = date('Y-m-d h:i:s');
                        $modelDocument->document_name = $_POST['Icon']['file'];
                        $modelDocument->save(false);
                    }
                }
                
                $grand_total += $total_tax_amount;

                $modelOrder->updateByPk($modelOrder->id, array('grand_total' => $grand_total, 'total_tax_amount' => $total_tax_amount));
                if ($scenario == 'add') {
                    if($quote_id>0){
                        $model_quotation_item =QuotationSchedules::model()->findAll(array('condition'=>'quotation_id='.$quote_id));
                        if(!empty($model_quotation_item)){
                            foreach ($model_quotation_item as $i=>$each){
                                $modelSchedule[$i] =new ServiceSchedules();
                                $modelSchedule[$i]->product_id=$each->product_id;
                                $modelSchedule[$i]->description=$each->description;
                                $modelSchedule[$i]->order_id   = $order_id;
                                $modelSchedule[$i]->created_by =Yii::app()->user->id;
                                $modelSchedule[$i]->created_date_time =date('Y-m-d H:i:s');
                                $modelSchedule[$i]->save(false);
                            }            

                        }
                    }
                    /*Yii::import('application.controllers.front.MasternotificationController');
                    $model_mail_setting = Notification::model()->find(array('condition' => 'event_id="5"'));
                    if ($model_mail_setting->mail_required == 'Y') {
                        // MasternotificationController::sendmail(5,$modelOrder->id);
                    }
                    if ($model_mail_setting->notification_required == 'Y') {
                        // MasternotificationController::sendnotification(5,$modelOrder->id);
                    }
                    if ($model_mail_setting->sms_required == 'Y') {
                        // MasternotificationController::sendsms(5,$modelOrder->id);
                    }*/
                }
                $jsonData['file'] = $modelOrder->file;

                $jsonData['order'] = $modelOrder;

                $jsonData['status'] = 'success';

                echo CJSON::encode($jsonData);
            } else {
                $error5 = array();
                $error1 = json_decode(CActiveForm::validate($modelOrder, '', false), true);
//                if (!empty($modelOrderServiceItem)) {
//                    $error5 = json_decode(CActiveForm::validateTabular($modelOrderServiceItem, '', false), true);
//                }
                if (!empty($modelOrderItem[0]->product_id))
                    $error2 = json_decode(CActiveForm::validateTabular($modelOrderItem, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";

                $error3 = json_decode(CActiveForm::validateTabular($modelOrderAddition, '', false), true);

                $error4 = json_decode(CActiveForm::validateTabular($modelOrderDeduction, '', false), true);

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4, $error5, $other));

                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionApprove() {
        $file_id = $_POST['hid_file_id'];
        $modelOrder = new ServiceOrder;
        $other = array();
        $modelOrderItem = array(new ServiceOrderItem);
        $modelOrderAddition = array(new ServiceOrderAddition);
        $modelOrderDeduction = array(new ServiceOrderDeduction);
        $order_id = (int) Yii::app()->request->getParam('id');
        $modelOrder->exchange_rate = 1;
        $modelNotes = new Activity();
        if ($order_id > 0) {
            $modelOrder = $modelOrder->findByPK($order_id);
            $modelOrder->attributes = $_POST['ServiceOrder'];
            $modelOrderItem = $modelOrder->items;
            $modelOrderAddition = count($modelOrder->adItems) > 0 ? $modelOrder->adItems : $modelOrderAddition;
            $modelOrderDeduction = count($modelOrder->dedItems) > 0 ? $modelOrder->dedItems : $modelOrderDeduction;
        }
        if (isset($_POST['ServiceOrder'])) {
            $tax_type = 1;
            //$tax_type = $_POST['ServiceOrder']['tax_type'];
            $flag = 0;
            if ((int) $_POST['ServiceOrder']['id'] > 0) {
                $modelOrder = $modelOrder->findByPK($_POST['ServiceOrder']['id']);
                $modelOrder->scenario = 'update';
                $flag = 1;
                $modelOrder->updated_by = Yii::app()->user->id;
                $modelOrder->updated_datetime = date('Y-m-d H:i:s');
            } else {
                /* $file = new MasterFile;
                  $file->crm_user_id = Yii::app()->user->id;
                  $file->start_from = 'O';
                  $file->current_process_status = 'O';
                  $file->customer_id = $_POST['ServiceOrder']['customer_id'];
                  $file->is_approved = 'N'; */
                //$modelOrder->created_by = Yii::app()->user->id;
                //$modelOrder->created_datetime = date('Y-m-d H:i:s');                
            }
            $modelOrder->attributes = $_POST['ServiceOrder'];
            $modelOrder->terms_id = $_POST['ServiceOrder']['terms_id'];
            //$modelOrder->terms_and_conditions = $_POST['ServiceOrder']['terms_and_conditions'];
            $modelOrder->file_title = $_POST['ServiceOrder']['file_title'];
            $modelOrder->currency = $_POST['ServiceOrder']['currency'];
            $modelOrder->invoice_type = $_POST['ServiceOrder']['invoice_type'];
            $modelOrder->crm_user_id = Yii::app()->user->id;
            if ($_POST['ServiceOrder']['lpo_date'] != '0000-00-00' && $_POST['ServiceOrder']['lpo_date'] != '') {
                $modelOrder->lpo_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['ServiceOrder']['lpo_date'])));
            }
            $modelOrder->materials_allocated = (isset($_POST['allocate_materials']) && $_POST['allocate_materials'] == "Y") ? "Y" : "N";
            //code added by mereena on 07/02/2020 for ckeditor content
            $modelOrder->terms_and_conditions = $_POST['terms_conditions'];
            $modelOrder->schedule_terms = $_POST['schedule_terms'];
            $modelOrder->liability = $_POST['liability'];
            
            $modelOrder->order_type = 'service';
            $valid = $modelOrder->validate();
            $p = 0;
            if (is_array($_POST['ServiceOrderItem'])) {
                foreach ($_POST['ServiceOrderItem'] as $i => $item) {
                    if (($item['product_id'] > 0 && $item['product_name'] != 'memo') || $item['product_name'] == 'memo') {
                        $modelOrderItem[$p] = new ServiceOrderItem;
                        $modelOrderItem[$p]->attributes = $_POST['ServiceOrderItem'][$i];
                        $modelOrderItem[$p]->brand_class_id = $item['brand_class_id'];
                        $modelOrderItem[$p]->product_generic_name = $item['product_generic_name'];
                        $modelOrderItem[$p]->description = $item['description'];
                        $modelOrderItem[$p]->unit_id = $item['unit_id'];
                        //CODE ADDED BY MEREENA ON 18/02/2020 TO GET ITEM FROM HIRE INVENTORY

                        $modelOrderItem[$p]->inventory_type = $item['inventory_type'];
                        //END
                        $delivery_date = '';
                        if ($flag == 0) {
                            if ($_POST['ServiceOrder']['delivery_date'] != '00/00/0000' && $_POST['ServiceOrder']['delivery_date'] != '') {
                                $delivery_date = str_replace('/', '-', $_POST['ServiceOrder']['delivery_date']);
                                $delivery_date = date("Y-m-d", strtotime($delivery_date));
                            }
                        } else {
                            if ($item['expected_delivery_date'] != '00/00/0000' && $item['expected_delivery_date'] != '') {
                                $delivery_date = str_replace('/', '-', $item['expected_delivery_date']);
                                $delivery_date = date("Y-m-d", strtotime($delivery_date));
                            }
                        }
                        $modelOrderItem[$p]->expected_delivery_date = $delivery_date;
                        $modelOrderItem[$p]->tax_vat_percentage = $item['tax_vat_percentage'];
                        $modelOrderItem[$p]->tax_vat_amount = $item['tax_vat_amount'];
                        if ($item['product_name'] == 'memo') {
                            $modelOrderItem[$p]->product_id = '999999';
                            $modelOrderItem[$p]->quantity = 0;
                            $modelOrderItem[$p]->amount = 0;
                            $modelOrderItem[$p]->net_amount = 0;
                        }
                        $valid = $modelOrderItem[$p]->validate() && $valid;
                        $p++;
                    }
                }
            }
            $valid = $valid && !empty($modelOrderItem[0]->product_id);
            $modelsToBeValidated = array($modelOrder, $modelOrderItem);
            if (is_array($_POST['ServiceOrderAddition'])) {
                foreach ($_POST['ServiceOrderAddition'] as $i => $item) {
                    $modelOrderAddition[$i] = new ServiceOrderAddition;
                    $modelOrderAddition[$i]->attributes = $_POST['ServiceOrderAddition'][$i];
//                    $valid = $modelOrderAddition[$i]->validate() && $valid;
                    if ($item['particular_value'] > 0 && $item['particular'] == '') {
                        $other[] = 'Addition description Cannot Blank';
                        $valid = false;
                    }
                }
                $modelsToBeValidated[] = $modelOrderAddition;
            }
            if (is_array($_POST['ServiceOrderDeduction'])) {
                foreach ($_POST['ServiceOrderDeduction'] as $i => $item) {
                    $modelOrderDeduction[$i] = new ServiceOrderDeduction;
                    $modelOrderDeduction[$i]->attributes = $_POST['ServiceOrderDeduction'][$i];
//                    $valid = $modelOrderDeduction[$i]->validate() && $valid;
                    if ($item['particular_value'] > 0 && $item['particular'] == '') {
                        $other[] = 'Deduction description Cannot Blank';
                        $valid = false;
                    }
                }
                $modelsToBeValidated[] = $modelOrderDeduction;
            }
            if ($valid) {
                $grand_total = 0;
                if ($_POST['hid_file_id'] > 0) {
                    $mod_mas_file = MasterFile::model()->findByPk($_POST['hid_file_id']);
                    if (!empty($mod_mas_file)) {
                        $mod_mas_file->file_title = $_POST['ServiceOrder']['title'];
                        $mod_mas_file->save(false);
                    }
                    switch ($modelOrder->approved_level) {
                        case 0 :
                            if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["order_approve_level1"]))) {
                                $modelOrder->approved_level++;
                                $modelOrder->level1_approved_by = Yii::app()->user->id;
                                $modelOrder->level1_approved_time = date('Y-m-d h:i:s');
                            }
                            break;
                        case 1 :
                            if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["order_approve_level2"]))) {
                                $modelOrder->approved_level++;
                                $modelOrder->level2_approved_by = Yii::app()->user->id;
                                $modelOrder->level2_approved_time = date('Y-m-d h:i:s');
                            }
                            break;
                        case 2 :
                            if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["order_approve_level3"]))) {
                                $modelOrder->approved_level++;
                                $modelOrder->level3_approved_by = Yii::app()->user->id;
                                $modelOrder->level3_approved_time = date('Y-m-d h:i:s');
                            }
                            break;
                    }
                    if ($modelOrder->approved_level == 3) {
                        MasterFile::model()->updateByPk($_POST['hid_file_id'], array('is_approved' => "Y", 'date_of_approval' => date('Y-m-d'), 'approved_by' => Yii::app()->user->id));
                    }
                }

                if ($_POST['ServiceOrder']['order_date'] != '00/00/0000') {

                    $modelOrder->order_date = str_replace('/', '-', $_POST['ServiceOrder']['order_date']);

                    $modelOrder->order_date = date("Y-m-d", strtotime($modelOrder->order_date));
                }

                if ($_POST['ServiceOrder']['delivery_date'] != '00/00/0000') {

                    $modelOrder->delivery_date = str_replace('/', '-', $_POST['ServiceOrder']['delivery_date']);

                    $modelOrder->delivery_date = date("Y-m-d", strtotime($modelOrder->delivery_date));
                }
                if ($_POST['hid_file_id'] > 0) {
                    $modelOrder->file_id = $_POST['hid_file_id'];
                } else {
                    //$file->save(false);
                    //$modelOrder->file_id = $file->id;
                }

                $modelOrder->save(false);

                $modelOrder->refresh();

                $order_id = $modelOrder->id;
                ServiceOrderItem::model()->deleteAll('order_id=:refer_id', array(':refer_id' => $modelOrder->id));
                ServiceOrderAddition::model()->deleteAll('order_id=:refer_id', array(':refer_id' => $modelOrder->id));

                ServiceOrderDeduction::model()->deleteAll('order_id=:refer_id', array(':refer_id' => $modelOrder->id));
                $total_tax_amount = 0;

                foreach ($modelOrderItem as $eachModel) {

                    $eachModel->order_id = $order_id;

                    $total_tax_amount += $eachModel->tax_vat_amount;

                    $eachModel->save(false);

                    $grand_total += $eachModel->net_amount;
                }



                foreach ($modelOrderAddition as $eachModel) {

                    $eachModel->order_id = $order_id;

                    $eachModel->save(false);

                    $grand_total += $eachModel->calculated_value;
                }



                foreach ($modelOrderDeduction as $eachModel) {

                    $eachModel->order_id = $order_id;

                    $eachModel->save(false);

                    $grand_total -= $eachModel->calculated_value;
                }

                if (!empty($_POST['Activity']['notes'])) {
                    $modelNotes->created_by = Yii::app()->user->id;
                    $modelNotes->created_date_time = date('Y-m-d h:i:s');
                    $modelNotes->notes = $_POST['Activity']['notes'];
                    $modelNotes->crm_user_id = Yii::app()->user->id;
                    $modelNotes->customer_id = $modelOrder->customer_id;
                    $modelNotes->contact_id = $modelOrder->contact_id;
                    $modelNotes->type_of_activity = 'N';
                    $modelNotes->added_from = 'O';
                    $modelNotes->file_id = $modelOrder->file_id;
                    $modelNotes->save(false);
                }

                if (isset($_POST['Icon']['file']) && $_POST['Icon']['file'] != '') {
                    $doc_test = Document::model()->find(array('condition' => 'file_id=' . $modelOrder->file_id . ' AND document_name="' . $_POST['Icon']['file'] . '"'));
                    if (empty($doc_test)) {
                        $modelDocument = new Document;
                        $modelDocument->uploaded_from = "O";
                        $modelDocument->file_id = $modelOrder->file_id;
                        $modelDocument->created_by = Yii::app()->user->id;
                        $modelDocument->created_datetime = date('Y-m-d h:i:s');
                        $modelDocument->document_name = $_POST['Icon']['file'];
                        $modelDocument->save(false);
                    }
                }

                $grand_total += $total_tax_amount;

                $modelOrder->updateByPk($modelOrder->id, array('grand_total' => $grand_total, 'total_tax_amount' => $total_tax_amount));
                /*                 * *************** START code added by mereena on 22-10-2019 for approval history******************* */
                date_default_timezone_set("Asia/Dubai");
                $approval_history = new ApprovalHistory;
                $approval_history->file_id = $modelOrder->file_id;
                $approval_history->status = "Y";
                $approval_history->action_by = Yii::app()->user->id;
                $approval_history->created_by = Yii::app()->user->id;
                $approval_history->created_datetime = date('Y-m-d h:i:s');
                $approval_history->date = date('Y-m-d h:i:s');
                $approval_history->state = 'O';
                $approval_history->save();

                /*                 * *************** End code added by mereena on 22-10-2019 for approval history******************* */

                Yii::import('application.controllers.front.MasternotificationController');
                $model_mail_setting = Notification::model()->find(array('condition' => 'event_id="6"'));
                if ($model_mail_setting->mail_required == 'Y') {
                    // MasternotificationController::sendmail(6,$modelOrder->id);
                }
                if ($model_mail_setting->notification_required == 'Y') {
                    // MasternotificationController::sendnotification(6,$modelOrder->id);
                }
                if ($model_mail_setting->sms_required == 'Y') {
                    // MasternotificationController::sendsms(6,$modelOrder->id);
                }


                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'ORDERS', Yii::app()->user->id, 'UPDATED', " with APPRVL LVL " . $modelOrder->approved_level . " for No: - {$modelOrder->id} "
                );
                // end audit log 

                $jsonData['file'] = $modelOrder->file;

                $jsonData['order'] = $modelOrder;

                $jsonData['status'] = 'success';

                echo CJSON::encode($jsonData);
            } else {

                $error1 = json_decode(CActiveForm::validate($modelOrder, '', false), true);

                if (!empty($modelOrderItem[0]->product_id))
                    $error2 = json_decode(CActiveForm::validateTabular($modelOrderItem, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";

                $error3 = json_decode(CActiveForm::validateTabular($modelOrderAddition, '', false), true);

                $error4 = json_decode(CActiveForm::validateTabular($modelOrderDeduction, '', false), true);

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4, $other));

                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionShortClosure() {
        $id = $_POST['ServiceOrder']['id'];
        if ($id > 0) {
            $model = ServiceOrder::model()->findByPk($id);
            $model->completed = 'C';
            $model->convert_status = 'N';
            if ($model->save()) {
                AllocatedMaterial::model()->deleteAll('file_id=:refer_id', array(':refer_id' => $modelOrder->file_id));
                if (is_array($_POST['ServiceOrderItem'])) {
                    foreach ($_POST['ServiceOrderItem'] as $item) {
                        if ($item['id'] > 0) {
                            $modelItem = ServiceOrderItem::model()->findByPk($item['id']);
                            $modelItem->notes = $item['notes'];
                            $modelItem->received = $item['received'];
                            $modelItem->remaining_qty = $item['remaining_qty'];
                            $modelItem->save();
                        }
                    }
                }
            }
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

    public function actionPrintOrderReportPDF() {

        $model = new ServiceOrder();
        $id = Yii::app()->request->getParam('id');
        $c_id = Yii::app()->request->getParam('c_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.service.views.pdf.order_list_individual', array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title), true));
        $mPDF1->Output("orderreport.pdf", 'I');
    }

    public function actionPrintProformaReportPDF() {

        $model = new ServiceOrder();
        $id = Yii::app()->request->getParam('id');
        $c_id = Yii::app()->request->getParam('c_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.proforma_list_individual', array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionMissingList() {
        $model = new ServiceOrder();
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.order_received_list', array('model' => $model, 'id' => $id, 'title' => $title), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionChangeDate() {
        $id = Yii::app()->request->getParam('id');
        $frm = Yii::app()->request->getParam('frm');
        if ($id > 0) {
            $dateModel = ServiceOrderItem::model()->findBypk($id);
            $dateModel->expected_delivery_date = date("d/m/Y", strtotime($dateModel->expected_delivery_date));
            $order_date = $dateModel->order->order_date;
            $order_date = date("d/m/Y", strtotime($order_date));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('change_date', array('model' => $dateModel, 'frm' => $frm, 'order_date' => $order_date));
    }

    public function actionSaveDate() {
        $id = $_POST['ServiceOrderItem']['id'];
        if ($id > 0) {
            ServiceOrderItem::model()->updateByPk($id, array('expected_delivery_date' => date("Y-m-d", strtotime(str_replace('/', '-', $_POST['ServiceOrderItem']['expected_delivery_date'])))));
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionGetFileid() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'file_id LIKE "%' . $searchTerm . '%" AND t.isActive="Y"';
        $model = new ServiceOrder();
        $model = $model->findAll(array('select' => 't.id,t.file_id', 'condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {


            $data[$i]['file_id'] = $eachModel->file_id;
            $data[$i]['label'] = $eachModel->file_id;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionRemoveorderitem() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = new ServiceOrderItem();
            $model->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }

        echo CJSON::encode($status);
    }

    public function actionRemovelineItem() {
        $id = $_POST['id'];
        $frm = $_POST['frm'];
        if ($id > 0) {
            $model = new ServiceSchedules();
            $model->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }

        echo CJSON::encode($status);
    }

    public function actionPrintContractPDF() {

        $model = new ServiceOrder();
        $id = Yii::app()->request->getParam('id');
        $c_id = Yii::app()->request->getParam('c_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.service.views.pdf.contract_list_individual', array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title), true));
        $mPDF1->Output("orderreport.pdf", 'I');
    }
    public function actionPrintContractNewPDF() {

        $model = new ServiceOrder();
        $id = Yii::app()->request->getParam('id');
        $c_id = Yii::app()->request->getParam('c_id');
        //$this->renderPartial('application.modules.service.views.pdf.contract_new', array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title), true);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.service.views.pdf.contract_new', array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title), true));
        $mPDF1->Output("orderreport.pdf", 'I');
    }
    public function actionPrintContractWord() {

        $model = new ServiceOrder();
        $id = Yii::app()->request->getParam('id');
        $model = Order::model()->findByPk($id);
        $data['template_file'] = 'demo_contract.docx';
        $data['id'] = $id;
        $data['first_party'] = 'Diatech Medical Equipment Trading and Maintenance';
        $data['second_party'] = str_replace("&"," and ",$model->customer->customer_name);
        
        if($model->billing_address != '') {       
            $add= $model->billing_address;
        }
        $add= str_replace("\r\n"," , ",$add);
        $add = substr($add, 0, 107);

        /*$add= str_replace(":","-",$add);
        $add = preg_replace("~[^a-z0-9:,]~i", "", $add);*/
        
        $data['customer_add'] = trim($add) ;
        $data['order_date'] = $model->order_date;
        $data['grand_total'] = $model->grand_total;
        $data['total_tax_amount'] = $model->total_tax_amount;
        $data['currency'] = $model->currencyname->currency_code;
        $data['items']=array();
        $condition = ' t.order_id ="' . $id . '"';
        $invoice = OrderItem::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));
        $tot_qty=1;
        foreach ($invoice as $i => $each) {
            $data['items'][$i]=str_replace("&"," and ",$each->description);
            
        }
        $serviceschedules = ServiceSchedules::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));
        if(!empty($serviceschedules)){
            foreach ($serviceschedules as $i => $each) {
                if($i==0){
                    $data['schedule_start_date']=$each->scheduled_date;
                    
                }else{
                    $data['scheduleitems'][$i-1]=$each->scheduled_date;
                    $tot_qty+=1;
                }
            }
        }else{
            $data['schedule_start_date']=$model->order_date;
             $data['scheduleitems']='';
        }
        $data['tot_qty'] =$tot_qty;
        // API URL
        /*$url = 'https://diatech.cumuluserp.me/upload/msoffice/word/contract_demo.php';
        // Create a new cURL resource
        $ch = curl_init($url);
        // Setup request to send json via POST
        
        $payload = json_encode(array("data" => $data));

        // Attach encoded JSON string to the POST fields
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);

        // Set the content type to application/json
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));

        // Return response instead of outputting
        //curl_setopt($ch, CURLOPT_RETURNTRANSFER, false);

        // Execute the POST request
        curl_exec($ch);
        //print_r($result);
        // Close cURL resource
        curl_close($ch);*/
        $json_data = json_encode($data);        
       header("Location: https://diatech.cumuluserp.me/upload/msoffice/word/contract_demo.php?data=".$json_data);
    }
    
    public function actionCreateSchedule() {
        $id=Yii::app()->request->getParam('id');
        $modelSchedule =ServiceSchedules::model()->findAll(array('condition'=>'order_id='.$id));
        if(empty($modelSchedule)){
            $model_order_item=ServiceOrderItem::model()->findAll(array('condition'=>'order_id='.$id));
            foreach ($model_order_item as $i=>$each){
                $modelSchedule[$i] =new ServiceSchedules();
                $modelSchedule[$i]->order_item_id=$each->id;
                $modelSchedule[$i]->product_id=$each->product_id;
                $modelSchedule[$i]->description=$each->description;
            }            
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create_schedule', array('modelSchedule' => $modelSchedule,'order_id'=>$id));
    }

    public function actionSaveSchedule() {
        if (is_array($_POST['ServiceSchedules'])) {
            $p=0;$valid=true;
            $order_id=$_POST['order_id'];
            foreach ($_POST['ServiceSchedules'] as $i => $item) {
                if ((int) $_POST['ServiceSchedules'][$i]['id'] > 0) {
                    $modelServiceSchedules[$p] = ServiceSchedules::model()->findByPk((int) $_POST['ServiceSchedules'][$i]['id']);
                    $modelServiceSchedules[$p]->updated_by =Yii::app()->user->id;
                    $modelServiceSchedules[$p]->updated_date_time =date('Y-m-d H:i:s');
                }else{
                    $modelServiceSchedules[$p] = new ServiceSchedules;
                    $modelServiceSchedules[$p]->created_by =Yii::app()->user->id;
                    $modelServiceSchedules[$p]->created_date_time =date('Y-m-d H:i:s');
                }
                $modelServiceSchedules[$p]->attributes = $_POST['ServiceSchedules'][$i];
                $modelServiceSchedules[$p]->order_id   = $order_id;
                if(!empty($_POST['ServiceSchedules'][$i]['employee_ids'])){
                    $modelServiceSchedules[$p]->employee_ids   = implode(',',$_POST['ServiceSchedules'][$i]['employee_ids']);
                }
                if ($_POST['ServiceSchedules'][$i]['scheduled_date'] != '0000-00-00' && $_POST['ServiceSchedules'][$i]['scheduled_date'] != '') {
                    $modelServiceSchedules[$p]->scheduled_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['ServiceSchedules'][$i]['scheduled_date'])));
                }
                $valid = $modelServiceSchedules[$p]->validate() && $valid;
                $p++;                        
            }
            if($valid){
                foreach ($modelServiceSchedules as $eachModel) {
                    $eachModel->save(false);
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else{
                if (!empty($modelServiceSchedules))
                    $error2 = json_decode(CActiveForm::validateTabular($modelServiceSchedules, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                $error = CJSON::encode(array_merge_recursive($error2));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actiongetServiceDesc(){
        $id = $_POST['id'];
        if ($id > 0) {
            $model = ServiceOrderItem::model()->findByPk($id);
            $status['desc'] = $model->description;
            $status['product_id'] = $model->product_id;
        }

        echo CJSON::encode($status);
    }
     
    public function actionServicePaymentTracker() {
        $this->render('service_paymenttracker');
    }
    public function actionGetServicePaymentTrackerList() {

        $model=new Invoice();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
                // datatable column index  => database column name
                0 => '',
                1 => 't.id',
                2 => 'customer.customer_name',
                3 => 't.invoice_date',
                4 => 'currencyname.currency_code',
                5 => 'paymentTerm.payment_terms',
                6 => 't.invoice_date',
                7 => 't.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        //$orderBy = 't.id DESC';
        $orderBy      = $filterColumn." ".$filterOrder;
        $condition = 't.isActive="Y" AND invoice_nature="SR" ';
        if(!isset(Yii::app()->user->havePermissionOn["invoice_view_all"]) &&  Yii::app()->user->authorised_user != 1)
        {
            $condition.= ' AND (t.lead_owner_id= "'.Yii::app()->user->id.'" OR file.lead_owner_id="'.Yii::app()->user->id.'")';
        }    
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $condition.=" AND ( t.id LIKE '%".$searchString."%' OR customer.customer_name LIKE '%".$searchString."%' OR paymentTerm.payment_terms LIKE '%".$searchString."%' OR t.invoice_date LIKE '%".$searchString."%' OR currencyname.currency_code LIKE '%".$searchString."%')";
        }
        $count = $model->with('customer','paymentTerm','currencyname')->count(array('condition'=>$condition));
        $model=$model->with('customer','currencyname','paymentTerm')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
                $status='';$m=0;
        foreach ($model as $row)
        {
            if ((int)$row['paymentTerm']['no_of_days'] >0) {
                $receipt_date=date("d/m/Y", strtotime($row['invoice_date']."+".$row['paymentTerm']['no_of_days']." days")); 
            } else {
                $receipt_date=date("d/m/Y", strtotime($row['invoice_date']));
            } 
            $d1 = strtotime(date("Y-m-d"));
            $date_to=date("Y-m-d", strtotime($row['invoice_date']."+".$row['paymentTerm']['no_of_days']." days"));
            $d2 = strtotime($date_to);
            $datediff = $d1 - $d2;
            $diff = floor($datediff /(60*60*24));$m++;
            $file=$row['file_id'];
            $order=Order::model()->find(array('condition'=>'file_id='.$file));
            $rowData[]=array( $m,$order->contract_no,$row['id'],$row['customer']['customer_name'], date("d/m/Y",strtotime($row['invoice_date'])), '<div class="text-right">' .$row['currencyname']['currency_code'].' '.Yii::app()->numberFormatter->formatCurrency($row['grand_total'],"").'</div>',$row['paymentTerm']['payment_terms'],$receipt_date,$diff);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
}
