<?php

class InvoiceController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create','SaveInvoice','View','GetUnitDrop','PrintInvoiceReportPDF'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    /*
     * function to list quotes
     * modified by jisha on 18-9-18. 
     */

    public function actionIndex() {
        $frm = 1;
        $this->render('index', array('frm' => $frm));
    }

    /*
     * function to list quotes in datatable 
     * modified by jisha on 18-9-18. 
     */

    public function actionGetList() {
        $model = new ServiceInvoice();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $frm = $_POST['frm'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.sales_group',
            2 => 't.invoice_no',
            3 => 't.id',
            4 => 't.order_id',
            5 => 't.invoice_date',
            6 => 'customer.customer_name',
            7 => 'leadowner.first_name',
            8 => 'currencyname.currency_code',
            9 => 't.total_tax_amount',
            10 => 't.grand_total',
            11 => 'file.status',
            12 => 't.id',
            13 => 't.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        //$orderBy = 't.id DESC';
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" AND invoice_nature="SR" ';
        if ($_POST['invoice_type'] > 0) {
            $condition .= ' AND t.sales_group=' . (int) $_POST['invoice_type'];
        }
        if (!isset(Yii::app()->user->havePermissionOn["invoice_view_all"]) && Yii::app()->user->authorised_user != 1) {
            $condition.= ' AND (t.lead_owner_id= "' . Yii::app()->user->id . '" OR file.lead_owner_id="' . Yii::app()->user->id . '")';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" AND ( t.id LIKE '%" . $searchString . "%' OR t.custom_invoice_no LIKE '%" . $searchString . "%' OR customer.customer_name LIKE '%" . $searchString . "%' OR file.file_title LIKE '%" . $searchString . "%' OR t.file_id LIKE '%" . $searchString . "%' OR t.order_id LIKE '%" . $searchString . "%')";
        }

        $count = $model->with('customer', 'file', 'leadowner', 'currencyname')->count(array('condition' => $condition));
        $model = $model->with('customer', 'file')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $status = '';
        foreach ($model as $row) {
            $div = '';
            if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["invoice_print"]))) {
                $div .= '<a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=service/invoice/PrintInvoiceReportPDF&id=' . $row['id'] . '&c_id=' . $row['crm_user_id'] . '&frm=tax"><i class="fa fa-file-pdf-o"></i></a>';
            }

            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_activity"])) {
                $div .= ' <button class="btn btn-primary btn-xs" title ="Edit Activity" onclick="loadPopupModal(\'activity/create&customer_id=' . $row['customer']['id'] . '\',\'' . $row['customer']['id'] . ' : ' . $row['customer']['customer_name'] . ' - Activities ' . '\',\'lg\')"><i class="fa fa-certificate"></i></button>';
            }
            $creditnote = Creditnote::model()->find(array('condition' => 'invoice_id = ' . $row['id']));
            ( $creditnote->id > 0 ) ? $cn_state = 'Yes' : $cn_state = 'No';
            //Max invoice id
            $model_max_invoice = Invoice::model()->find(array('select' => 'max(id) as id', 'condition' => 'order_id ="' . $row['order_id'] . '" and invoice_nature="H"'));
            $show_invoice_cancel = 'N';
            if ($model_max_invoice->id == $row['id']) {
                $show_invoice_cancel = 'Y';
            }
            $rowData[] = array($row['file_id'], $row['salesgroup']['group_name'], $row['id'], $row['order_id'], date("d/m/Y", strtotime($row['invoice_date'])), $row['customer']['customer_name'], $row->leadowner->fullname, $row['currencyname']['currency_code'], Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'], ""), Yii::app()->numberFormatter->formatCurrency($row['grand_total'], ""), $row['file']['status'], $cn_state, $row['id'], $row['customer']['id'], $row['crm_user_id'], $row['is_hiring_invoice'], $row['invoice_nature'], $row->created_user, $row['customer']['customer_name'], $row['is_direct_invoice'], $row['invoice_status'], $row['posted'], $show_invoice_cancel);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    /*
     * function to create quotes
     * modified by jisha on 12-11-20. 
     */

    public function actionCreate() {
        $model = new ServiceInvoice();
        $id = (int) Yii::app()->request->getParam('id');
        $order_id = (int) Yii::app()->request->getParam('order_id');
        $modelItems = array(new ServiceInvoiceItem);
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelmasterfile = MasterFile::model()->findByPk($file_id);
            $modelOrderItems = ServiceInvoiceItem::model()->findAll(array('condition' => 'invoice_id="' . $id . '"','order'=>'id ASC'));
            if (empty($modelOrderItems)) {
                $modelOrderItems = array(new InvoiceItem);
            }
        }
        if ($order_id > 0) {//convert from quote to order
            $modelorder = ServiceOrder::model()->findByPK($order_id);
            $modelmasterfile = MasterFile::model()->findByPk($file_id);
            $model->file_id = $modelorder->file_id;
            $model->customer_id = $modelorder->file->customer_id;
            $model->order_id = $modelorder->id;
            $order_date = $modelorder->order_date;
            $order_date = date("d/m/Y", strtotime($order_date));
            $model->order_date = $order_date;
            $model->billing_address = $modelorder->billing_address;
            $model->shipping_address = $modelorder->shipping_address;
            $model->contact_id = $modelorder->contact_id;
            $model->sales_group = $modelorder->sales_group;
            $model->notes = $modelorder->notes;
            $model->terms_and_conditions = $modelorder->terms_and_conditions;
            $model->reference = $modelorder->lpo;
            $model->others = $modelorder->others;
            $model->currency = $modelorder->currency;
            $model->exchange_rate = $modelorder->exchange_rate;
            $model->payment_terms = $modelorder->payment_terms;
            $model->remarks = $modelorder->remarks;
            $model->terms_id = $modelorder->terms_id;
            $model->lead_owner_id = $modelorder->lead_owner_id;
            $modelItems = ServiceOrderItem::model()->findAll(array('condition' => 'order_id=' . $modelorder->id,'order'=>'id asc'));
            foreach ($modelItems as $i => $eachItem) {
                $pre_inv_total=Yii::app()->db->createCommand("Select IFNULL(SUM(amount),0)AS amount From {{invoice_item}} II
                                                            LEFT JOIN {{invoice}} SI ON SI.id=II.invoice_id
                                                            WHERE SI.order_id=".$modelorder->id." AND product_id=".$eachItem->product_id)->queryScalar();
                $order_inv_total=$eachItem->net_amount;
                $order_bal_total=  round($order_inv_total-$pre_inv_total,2);
                $modelInvoiceItems[$i] = new ServiceInvoiceItem;
                $modelInvoiceItems[$i]->product_id = $eachItem->product_id;
                $modelInvoiceItems[$i]->description = $eachItem->description;
                $modelInvoiceItems[$i]->quantity = $eachItem->quantity;
                $modelInvoiceItems[$i]->rate = $eachItem->rate;
                $modelInvoiceItems[$i]->unit_id = $eachItem->unit_id;
                $modelInvoiceItems[$i]->amount = $eachItem->amount;
                $modelInvoiceItems[$i]->addition_percentage = $eachItem->addition_percentage;
                $modelInvoiceItems[$i]->tax_vat_percentage=$eachItem->tax_vat_percentage;
                $modelInvoiceItems[$i]->addition_amount = $eachItem->addition_amount;
                $modelInvoiceItems[$i]->deduction_percentage = $eachItem->deduction_percentage;
                $modelInvoiceItems[$i]->deduction_amount = $eachItem->deduction_amount;
                $modelInvoiceItems[$i]->balance_amount = $order_bal_total;
                $modelInvoiceItems[$i]->net_amount = $eachItem->net_amount;                
            }
            $modelAdd = ServiceOrderAddition::model()->findAll(array('condition' => 'order_id=' . $modelorder->id));
            $modelDed = ServiceOrderDeduction::model()->findAll(array('condition' => 'order_id=' . $modelorder->id));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model, 'file_id' => $model->file_id, 'order_date' => $order_date,
            'modelInvoiceItems' => $modelInvoiceItems, 'modelAdd' => $modelAdd, 'modelDed' => $modelDed, 'modelmasterfile' => $modelmasterfile
        ));
    }
    public function actionSaveinvoice()
    {
            $modelInvoice = new ServiceInvoice;
            $tax_type = 1;
            $modelInvoice->scenario = 'add';
            $audit_type = 'CREATED';
            if ((int) @$_POST['ServiceInvoice']['id'] > 0) $audit_type = 'UPDATED';
                $modelInvoice->scenario = 'update';
            $modelInvoice->attributes = $_POST['ServiceInvoice'];
            $modelInvoice->lpo = $_POST['ServiceInvoice']['lpo'];
            $modelInvoice->delivery_ids=$_POST['ServiceInvoice']['delivery_ids'];
            $modelInvoice->project_id=$_POST['ServiceInvoice']['project_id'];
            $modelInvoice->invoice_date= ( count( explode('/', $_POST['ServiceInvoice']['invoice_date']) ) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['ServiceInvoice']['invoice_date']))) : date('Y-m-d');
            $modelInvoice->crm_user_id = Yii::app()->user->id;
            $modelInvoice->order_lpo_no=$_POST['ServiceInvoice']['order_lpo_no'];
            $modelInvoice->order_lpo_date=$_POST['ServiceInvoice']['order_lpo_date'];
            $modelInvoice->created_by= Yii::app()->user->id;
            $modelInvoice->created_datetime = date('Y-m-d H:i:s');
            $modelInvoice->invoice_nature='SR';
              //code added by mereena on 07/02/2020 for ckeditor content
            $modelInvoice->terms_and_conditions =  $_POST['terms_conditions'];
            $order_id=$_POST['ServiceInvoice']['order_id'];
            $mod_Order = ServiceOrder::model()->findByPK($order_id);
            $order_grand_total=$mod_Order->grand_total;
            $other_errors = $modelItem = $modelInvoiceAddition = $modelInvoiceDeduction = array();
            $old_inv_total=Yii::app()->db->createCommand("Select IFNULL(SUM(amount+tax_vat_amount),0)AS amount From {{invoice_item}} II
                                                            LEFT JOIN {{invoice}} SI ON SI.id=II.invoice_id
                                                            WHERE SI.order_id=".$order_id."")->queryScalar();
            $new_inv_total=0;
            $grand_total = 0;
            $valid = $modelInvoice->validate();
            $i =0;
            foreach ($_POST['ServiceInvoiceItem'] as $item) {
                if ( $item['product_id'] > 0 ) {
                    $modelItem[$i] = new ServiceInvoiceItem;
                    $modelItem[$i]->attributes = $item;
                    $modelItem[$i]->unit_id = $item['unit_id'];
                    $modelItem[$i]->invoice_item_type ='S';
                    //CODE ADDED BY MEREENA ON 24/02/2020
                    $modelItem[$i]->inventory_type = $item['inventory_type'];
                    //END
                    $valid = $modelItem[$i]->validate() && $valid;
                    $new_inv_total+=$item['amount'];
                    $new_inv_total+=$item['tax_vat_amount'];
                    $i++;
                    
                }
            }
            $i =0;
            if (is_array($_POST['ServiceOrderAddition'])) {
                foreach ($_POST['ServiceOrderAddition'] as $i => $item) {
                    if( $item['calculated_value'] > 0 ){
                        $modelInvoiceAddition[$i] = new ServiceInvoiceAddition;
                        $modelInvoiceAddition[$i]->attributes = $item;
                        $valid = $modelInvoiceAddition[$i]->validate() && $valid;
                        $i++;
                    }
                }
            }
            $i =0;
            if (is_array($_POST['ServiceOrderDeduction'])) {
                foreach ($_POST['ServiceOrderDeduction'] as $i => $item) {
                    if( $item['calculated_value'] > 0 ){
                        $modelInvoiceDeduction[$i] = new ServiceInvoiceDeduction;
                        $modelInvoiceDeduction[$i]->attributes = $_POST['ServiceOrderDeduction'][$i];
                        $valid = $modelInvoiceDeduction[$i]->validate() && $valid;
                        $i++;
                    }
                }
            }
            
            if(($new_inv_total+$old_inv_total)>$order_grand_total){
                $valid=false;
                $other_errors[]='Invoice Amount Should Be less than or Equal to Order Total';
            }
            if ( $valid && count($modelItem) > 0 ) {
                echo CJSON::encode(array('status'=>'success'));
     
                //$modelInvoice->generateInvoice();
                $modelInvoice->save();

                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'INVOICE',
                    Yii::app()->user->id,
                    $audit_type,
                    " with INV No: - {$modelInvoice->id}  "
                );
                // end audit log 
                
                $total_tax_amount=0;
                foreach ($modelItem as $eachItem) {
                    $eachItem->invoice_id = $modelInvoice->id;
                    $total_tax_amount+=$eachItem->tax_vat_amount;
                    $eachItem->cost_rate = Store::model()->findBypk($eachItem->product_id)->rate;
                    $eachItem->inventory_type = $eachItem->inventory_type;
                    $eachItem->save(false);
                    $grand_total += $eachItem->net_amount;
                }
                foreach ($modelInvoiceAddition as $eachModel) {
                    $eachModel->invoice_id = $modelInvoice->id;
                    $eachModel->save();
                    $grand_total += $eachModel->calculated_value;
                }
                foreach ($modelInvoiceDeduction as $eachModel) {
                    $eachModel->invoice_id =$modelInvoice->id;
                    $eachModel->save();
                    $grand_total -= $eachModel->calculated_value;
                }
                $grand_total+=$total_tax_amount;
                
                $modelInvoice->updateByPk($modelInvoice->id, array('grand_total' => $grand_total,'total_tax_amount' => $total_tax_amount));
                if(($new_inv_total+$old_inv_total)>=$order_grand_total){
                    ServiceOrder::model()->updateByPk($order_id,array('completed' =>'Y'));
                    MasterFile::model()->updateByPk($modelInvoice->file_id, array('is_approved' => "Y",'current_process_status'=>'I'));
                }else{
                    MasterFile::model()->updateByPk($modelInvoice->file_id, array('is_approved' => "Y",'current_process_status'=>'PI'));
                }
                /*if ($modelInvoice->file->invoicedQuantity >= $modelInvoice->file->order->netQuantity) {
                     ///need to check full delivey,status is not updating correctly
                }
                DeliveryNote::model()->updateByPk($_POST['Invoice']['delivery_ids'], array('invoiced' => "Y")); ///need to check full delivey,status is not updating correctly
                $model_mail_setting=Notification::model()->find(array('condition' => 'event_id="8"'));
                Yii::import('application.controllers.front.MasternotificationController'); 
                   if($model_mail_setting->mail_required=='Y'){                
                    //    MasternotificationController::sendmail(8,$modelInvoice->id);
                   }
                   if($model_mail_setting->notification_required=='Y'){                    
                        // MasternotificationController::sendnotification(8,$modelInvoice->id);
                    }
                    if($model_mail_setting->sms_required=='Y'){                    
                        // MasternotificationController::sendsms(8,$modelInvoice->id);
                    }*/
                
            } else {
                $error1 = json_decode(CActiveForm::validate($modelInvoice, '', false), true);
                if ( count($modelItem) > 0 )
                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                $error3 = json_decode(CActiveForm::validateTabular($modelInvoiceAddition, '', false), true);
                $error4 = json_decode(CActiveForm::validateTabular($modelInvoiceDeduction, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4,$other_errors));
                if ($error != '[]')
                    echo $error;
            }
        
    }
    public function actionView() {
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = Invoice::model()->findByPk($id);
            $model_items = InvoiceItem::model()->findAll(array('condition' => 'invoice_id="' . $id . '"', 'order' => 't.id ASC'));
            $model_additions=InvoiceAddition::model()->findAll(array('condition'=>'invoice_id="'.$id.'"'));
            $model_deductions=InvoiceDeduction::model()->findAll(array('condition'=>'invoice_id="'.$id.'"'));
            $model_advance_deductions=InvoiceAdvanceDeduction::model()->findAll(array('condition'=>'invoice_id="'.$id.'"'));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('view', array('model' => $model,'model_items' => $model_items,'model_additions'=>$model_additions,'model_deductions'=>$model_deductions,'model_advance_deductions'=>$model_advance_deductions));
    }
    public function actionGetunitdrop(){
        $row = $_POST['row_field'];
        $product = $_POST['product_id'];
        $drop = array();
        $modelInvoice = new ServiceInvoiceItem;
        if($product > 0){
            $modelInvoice->unit_id = UnitOfMeasurement::getBaseunit($product);
            $drop['drop'] = CHtml::activedropdownlist($modelInvoice, "[" . $row . "]unit_id",UnitOfMeasurement::getUnits($product), array('class'=>'unit go'));
        }
        echo CJSON::encode($drop);
    }
    public function actionPrintInvoiceReportPDF() {
        $model=new Invoice();
        $id = Yii::app()->request->getParam('id');
        $c_id = Yii::app()->request->getParam('c_id');
        $frm = Yii::app()->request->getParam('frm');
        $barcode=Yii::app()->request->getParam('barcode');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        if($frm=='tax'){//new invoice for ace//part number
            $mPDF1->WriteHTML($this->renderPartial('application.modules.service.views.pdf.invoice_list_individual_tax', array('model' => $model, 'id' => $id,'c_id'=>$c_id ,'title' => $title,'barcode'=>$barcode),true));
        }
        else{
            $mPDF1->WriteHTML($this->renderPartial('application.modules.service.views.pdf.invoice_list_individual', array('model' => $model, 'id' => $id,'c_id'=>$c_id ,'title' => $title,'barcode'=>$barcode),true));
        }
        
        $mPDF1->Output("InvoiceReport.pdf", 'I');
    }
}
