<?php /** @var CActiveForm $form */ ?>

<div class="table-responsive">
    <table class="table table-bordered table-striped" id="returnMachineTable">
        <thead>
            <tr>
                <th style="width:40px;">#</th>
                <th><input type="checkbox" id="selectAllMachines" /></th>
                <th>Machine</th>
                <th>Serial No</th>
                <th>Outlet</th>
                <th>Location</th>
                <th>Return Technician</th>
                <th>Return Remarks</th>
            </tr>
        </thead>
        <tbody>
            <?php $sl = 1; ?>
            <?php foreach ($machineList as $machine): ?>
                <?php
                $serialNo = $machine->serial_no ?: '-';
                $machine_name = $machine->machine_name ?: '-';
                $outletName = isset($machine->parent->customer_shiiping) && !empty($machine->parent->customer_shiiping->outlet_location)
                    ? $machine->parent->customer_shiiping->outlet_location
                    : '-';
                $locationName = isset($machine->customerlocation) && !empty($machine->customerlocation->location_name)
                    ? $machine->customerlocation->location_name
                    : '-';

                ?>
                <tr>
                    <td><?= $sl++; ?></td>

                    <td>
                        <input type="checkbox"
                            name="ServiceMasCustomerMachinesItem[<?= $machine->id; ?>][selected]"
                            value="<?= $machine->id; ?>"
                            class="machineSelect" />
                    </td>

                    <td><?= CHtml::encode($machine_name); ?></td>
                    <td><?= CHtml::encode($serialNo); ?></td>
                    <td><?= CHtml::encode($outletName); ?></td>
                    <td><?= CHtml::encode($locationName); ?></td>

                    <td>
                        <?= CHtml::dropDownList(
                            "ServiceMasCustomerMachinesItem[{$machine->id}][return_lead_owner_id]",
                            '', // default value
                            User::getUser(), // list of users
                            [
                                'prompt' => '-- Select Lead Owner --',
                                'class' => 'form-control returnLeadOwnerDropdown',
                            ]
                        ); ?>
                    </td>

                    <td>
                        <?= CHtml::textField(
                            "ServiceMasCustomerMachinesItem[{$machine->id}][return_remarks]",
                            '',
                            [
                                'class' => 'form-control',
                                'placeholder' => 'Enter remarks',
                            ]
                        ); ?>
                    </td>

                    <!-- Hidden fields for backend processing -->
                    <?= CHtml::hiddenField("ServiceMasCustomerMachinesItem[{$machine->id}][machine_id]", $machine->machine_id); ?>
                    <?= CHtml::hiddenField("ServiceMasCustomerMachinesItem[{$machine->id}][serial_no]", $machine->serial_no); ?>
                    <?= CHtml::hiddenField("ServiceMasCustomerMachinesItem[{$machine->id}][header_id]", $machine->header_id); ?>
                    <?= CHtml::hiddenField("ServiceMasCustomerMachinesItem[{$machine->id}][stock_ledger_id]", $machine->stock_ledger_id); ?>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<script>
    // Select/Deselect all checkboxes
    $('#selectAllMachines').on('click', function () {
        $('.machineSelect').prop('checked', this.checked);
    });
</script>
