<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'machines-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
$readonly = false;
$disabled = false;
$modMasIssueType = new MasIssueType();
$arr_MasIssueType = $modMasIssueType->getMachineIssueType();
?>

<?php echo $form->hiddenField($model, 'id'); ?>

<ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
    <li class="active"><a href="#general_tab" data-toggle="tab">General</a></li>
    <li><a href="#machine_tab" data-toggle="tab">Machine</a></li>
</ul>

<div class="tab-content">
    <div class="tab-pane fade in active" id="general_tab">
        <?php
        $this->renderPartial('general', array(
            'model' => $model,
            'form' => $form,
            'type' => $type,
        ));
        ?>
    </div>

    <div class="tab-pane fade" id="machine_tab">
        <?php
        $this->renderPartial('machine_list', array(
            'model' => $model,
            'form' => $form,
            'modelIssueItem' => $modelIssueItem,
            'type' => $type,
            'arr_MasIssueType' => $arr_MasIssueType,
            'readonly' => $readonly,
            'disabled' => $disabled
        ));
        ?>
    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="machine_close" data-dismiss="modal">Close</button>
    <?php
    if ($type != 'view') {
        $url = Yii::app()->createUrl('sales/servicecustomermachine/Save');
        echo CHtml::ajaxSubmitButton('Save', $url, array(
            'dataType' => 'json',
            'type' => 'post',
            'success' => 'function(data) {
                $("#loader").hide();                                         
                if(data.status=="success"){  
                    t8.success("Saved Successfully!");
                    $("#machine_close").click();
                    reloadTable("#tbl_machines_details");
                } else { 
                    $("#machines-form .machine-save-btn").prop("disabled", false);   
                    $("#machines-form .machine-save-btn").addClass("btn-theme").removeClass("btn_loding");
                    $.each(data, function(key, val) {
                        $("#machines-form #"+key+"_em_").text(val).show(); 
                        t8.error(""+val+""); 
                    }); 
                } 
            }',
            'beforeSend' => 'function(){
                $("#loader").show();
                $("#machines-form .machine-save-btn").prop("disabled", true);                      
                $("#machines-form .machine-save-btn").addClass("btn_loding").removeClass("btn-theme"); 
                $(".toast8-error").hide(); 
            }'
        ), array('id' => 'mybtn' . rand(), 'class' => 'machine-save-btn btn btn-theme'));
    }
    ?>
</div>

<?php $this->endWidget(); ?>

<?php

$cs = Yii::app()->getClientScript();

$cs->registerScript("leadownerMachinesInvoice", "
function leadownerMachinesInvoice(field_id, frm) {
    var lead_owner_id = $('#ServiceMasCustomerMachines_lead_owner_id').val();
    var customer_id = $('#ServiceMasCustomerMachines_customer_id').val();

    if ( customer_id=='') {
        t8.error('Please choose a Customer');
        $('#serial_no').val('');
        return false;
    } else {
        jQuery.ajax({
            data: { 'lead_owner_id': lead_owner_id, 'customer_id': customer_id, 'columnWidth': 4 },
            dataType: 'json',
            type: 'get',
            url: '" . Yii::app()->createUrl('sales/servicecustomermachine/GetInvoiceDropdown') . "',
            success: function(data) {
                $('#div_InvoiceFileList').html(data.dropdown);
                 window.salesGroupMap = data.sales_groups || {};

            }
        });
        return true;
    }
}
", CClientScript::POS_END);

$cs->registerScript("autoCompleteMachineCustomer", "
function autoCompleteMachineCustomer(field_id, frm) {
    var url = '" . Yii::app()->createUrl('customer/GetCustomerDetails') . "' + '&frm=' + frm;

    $('#' + field_id).autocomplete({
        minLength: 1,
        source: function (request, response) {
            autoCompleteSource(request, response, url);
        },
        select: function (event, ui) {
            event.preventDefault();
            var customer_id = ui.item.value;
            $('#ServiceMasCustomerMachines_customer_id').val(customer_id);
            $('#customer_name').val(ui.item.label);

            // Loop through each row in the table and update Outlet dropdowns
            $('#tbl_repair_request tbody tr').each(function (index, tr) {
                var row = $(tr);
                var rowIndex = row.data('index') || index;

                $.ajax({
                    type: 'POST',
                    dataType: 'json',
                    url: '" . Yii::app()->createUrl('sales/Servicecustomermachine/getCustomerShippingdetails') . "',
                    data: { id: customer_id, row_index: rowIndex },
                    success: function (data) {
                        $('#div_customershippimg').html(data.dtship);
                        getOutletLocationDetails();
                    }
                });
                leadownerMachinesInvoice(this);

            });
        }
    });
}
", CClientScript::POS_END);




$cs->registerScript("autoCompleteinvoicefileid", "
function autoCompleteinvoicefileid(field_id, frm){
    var customer_id = $('#ServiceMasCustomerMachines_customer_id').val();
    var lead_owner_id = $('#ServiceMasCustomerMachines_lead_owner_id').val();
    var type_of_invoice = 'service';

    if(customer_id==''){
        t8.error('Select Customer');
    } else {
        var url = '" . Yii::app()->createUrl('invoice/GetinvoicedetailsAjax') . "' + 
            '&frm=' + frm + '&customer_id=' + customer_id + '&type_of_invoice=' + type_of_invoice;

        $('#' + field_id).autocomplete({
            minLength: 1,
            source: function (request, response) {
                autoCompleteSource(request, response, url);
            },
            focus: function(event, ui) {
                $(this).val(ui.item.file_id);
                return false;
            },
            select: function(event, ui) {
                event.preventDefault();
                console.log(ui.item);
                $('#ServiceMasCustomerMachines_file_id').val(ui.item.file_id);
                $('#ServiceMasCustomerMachines_invoice_id').val(ui.item.value);
            }
        });
    }
}
", CClientScript::POS_END);
?>
<script>
    function getMachineDetailsList() {
        var leadOwnerId = $('#ServiceMasCustomerMachines_lead_owner_id').val();
        var customerId = $('#ServiceMasCustomerMachines_customer_id').val();
        var file_id = $('#ServiceMasCustomerMachines_file_id').val();
        var filterText = $('#machineFilter').val(); // Optional textbox for filtering

        $('#tbl_repair_request tbody tr').each(function (index, tr) {
            $.ajax({
                url: 'index.php?r=sales/servicecustomermachine/GetLeadownerMachineDetails',
                type: 'GET',
                dataType: 'json',
                data: {
                    lead_owner_id: leadOwnerId,
                    customer_id: customerId,
                    file_id: file_id,
                    row_index: index,
                    filter_text: filterText // <-- added
                },
                success: function (data) {
                    if (data.status === 'success') {
                        $('#div_leadownermachinesserialno_' + index).html(data.dt);
                        updateSerialDropdowns();
                    }
                }
            });
        });
    }

</script>
<script>
    function changeType(el) {
        console.log(window.salesGroupMap);

        if (typeof window.salesGroupMap === 'undefined') return;

        var selectedId = $(el).val();
        var salesGroupId = window.salesGroupMap[selectedId];
        var issueTypeField = $('#ServiceMasCustomerMachines_issue_type');

        // Reset selection first
        issueTypeField.multiselect('deselectAll', false).multiselect('refresh');

        if (salesGroupId == 7) {
            issueTypeField.multiselect('select', '6');
        } else if (salesGroupId == 8) {
            issueTypeField.multiselect('select', '5');
        } else {
            // leave blank — no selection
            issueTypeField.multiselect('refresh');
        }
    }


</script>