<div class="tab-content">

    <div class="tab-pane active">

        <ul class="clearfix form-ul material">

            <li class="col-sm-4">


                <?php echo $form->hiddenField($model, "id"); ?>
                <?php echo $form->hiddenField($model, 'customer_id'); ?>

                <?php echo $form->textField($model, 'customer_name', array('data-label' => 'Customer <span style="color:red">*</span>', ' onKeyup' => 'js:autoCompleteCustomer(this.id);')); ?>

                <?php echo $form->error($model, 'customer_name'); ?>

            </li>

            <div id="div_customershippimg">
                <li class="col-sm-3">
                    <?php
                    if ($model->customer_shipping_id > 0) {
                        echo $form->dropDownList(
                            $model,
                            'customer_shipping_id',
                            CustomerOutletLocation::getShippingLocation($model->customer_id),
                            array(
                                'prompt' => 'Select',
                                'data-label' => 'Outlet Location',
                               // 'onchange' => 'machinedetails()',
                            )
                        );
                    } else {
                        echo $form->dropDownList($model, 'customer_shipping_id', CustomerOutletLocation::getShippingLocation($model->customer_id), array('readonly' => true, 'data-label' => 'Outlet Location', 'prompt' => 'Select'
                        , 'onchange' => 'machinedetails()'
                        ));
                    }
                    ?>
                    <?php echo $form->error($model, 'customer_shipping_id'); ?>
                </li>
            </div>


            <?php if ($model->schedule_status != 'S') { ?>
                <li class="col-sm-3" style="display: none">

                    <?php

                    $model->request_date = empty($model->request_date) ? date('d/m/Y') : date('d/m/Y', strtotime($model->request_date));

                    echo $form->textField($model, 'request_date', array('data-label' => 'Request Date <span style="color:red">*</span>', 'class' => 'datepicker'));

                    ?>

                    <?php echo $form->error($model, 'request_date'); ?>

                </li>
            <?php } ?>
            <li class="col-sm-2">

                <?php

                $model->schedule_date = empty($model->schedule_date) ? date('d/m/Y') : date('d/m/Y', strtotime($model->schedule_date));
                echo $form->textField($model, 'schedule_date', array('data-label' => 'Planned Date <span style="color:red">*</span>', 'class' => 'datepicker'));
                ?>

                <?php echo $form->error($model, 'schedule_date'); ?>

            </li>

            <li class="col-sm-3">

                <?php
            if($frm==3)
                $model->service_id = MasServices::MIR;
                echo $form->dropDownList($model, "service_id", MasServices::getAll(), [
                    'class' => '',
                    'empty' => 'Select',
                    'style' => $event,
                    'data-label' => 'Service Type <span style="color:red">*</span>',
                    'onchange' => 'handleServiceTypeChange(this.value)'
                ]);
                ?>
            </li>

            <li class="col-sm-2" style="display:none">
                <?php //var_dump($model->assigned_id); ?>
                <?php echo $form->dropDownList($model, 'assigned_id', User::getUser(), array('data-label' => 'Assigned Technician<span style="color:red">*</span>', 'empty' => '--Select--')); ?>

                <?php echo $form->error($model, 'assigned_id'); ?>

            </li>

            <?php

            if ($model->isNewRecord) {

                $model->status_id = 3;

                $model->type_id = (int) $_REQUEST['type_id'];

                if (empty($model->type_id)) {

                    $model->type_id = 1;

                }



                echo $form->hiddenField($model, 'status_id');

                echo $form->hiddenField($model, 'type_id');

            }

            ?>
            <?php //var_dump($type) ?>
            <?php if ($type == 'C') { ?>
                <li class="col-sm-2 hidden">
                    <?php
                    echo $form->dropDownList(
                        $model,
                        'is_completed',
                        ['Y' => 'Yes', 'N' => 'No'],
                        [
                            'class' => '',
                            'prompt' => 'Select Status',
                            'data-label' => 'Is Completed?<span style="color:red">*</span>'
                        ]
                    );
                    ?>
                    <?php echo $form->error($model, 'is_completed'); ?>
                </li>
            <?php } ?>


            <?php if ($model->schedule_status != 'S') { ?>

                <li class="col-sm-3" style="display: none">

                    <?php

                    (empty($model->completed_date) || $model->completed_date == '0000-00-00') ? "" : date('d/m/Y', strtotime($model->completed_date));

                    echo $form->textField($model, 'completed_date', array('data-label' => 'Completed Date <span style="color:red">*</span>', 'class' => 'datepicker'));

                    ?>

                    <?php echo $form->error($model, 'completed_date'); ?>

                </li>

            <?php } ?>
            <li class="col-sm-3 hidden">

                <?php echo $form->dropDownList($model, 'submit_invoice', array("Y" => 'Yes', "N" => 'No'), array('class' => 'tooltipster', 'data-label' => 'Submit Invoice<span style="color:red;">*</span>', 'empty' => '--Select--')); ?>

                <?php echo $form->error($model, 'submit_invoice'); ?>

            </li>
            <?php if ($model->schedule_status != 'S') { ?>
                <li class="col-sm-3" style="display: none">

                    <?php echo $form->textArea($model, 'remark', array('data-label' => 'Remark', 'class' => '')); ?>

                    <?php echo $form->error($model, 'remark'); ?>

                </li>
            <?php } ?>






        </ul>

    </div>

</div>

<?php

$cs = Yii::app()->getClientScript('jquery.ui');

// 🔹 Auto-complete customer + load related data
$cs->registerScript("autoCompleteCustomer", "
function autoCompleteCustomer(field_id, frm) {
    var url = '" . Yii::app()->createUrl('customer/GetCustomerDetails') . "' + '&frm=' + frm;

    $('#' + field_id).autocomplete({
        minLength: 1,
        source: function (request, response) {
            autoCompleteSource(request, response, url);
        },
        focus: function (event, ui) {
            $(this).val(ui.item.label);
            return false;
        },
        select: function (event, ui) {
            event.preventDefault();

            var trigger_target_id = $(event.target).attr('id');
            var customer_id = ui.item.value;

            $('#customer_name').val(ui.item.label);
            $('#SaleRepairRequest_customer_id').val(customer_id);




            // 2️⃣ Load shipping details
            $.ajax({
                data: { id: customer_id },
                dataType: 'json',
                type: 'post',
                url: '" . Yii::app()->createUrl('sales/schedule/getCustomerShippingdetails') . "',
                success: function (data) {
                    $('#div_customershippimg').html(data.dt);
                    var outlet_id = $('#SaleRepairRequest_customer_shipping_id').val();

                    // 3️⃣ Load outlet locations (apply to all rows dynamically)
                    $.ajax({
                        data: { id: customer_id, outlet_id: outlet_id },
                        dataType: 'json',
                        type: 'post',
                        url: '" . Yii::app()->createUrl('sales/schedule/getLocationdetails') . "',
                        success: function (data) {
                            console.log(data.dt);

                            // Update ALL outlet location dropdowns, not just one
                            $('[id^=outlet_location_]').each(function() {
                                $(this).html(data.dt);
                            });
                        }
                    });
                }
            });
            var outlet_id = $('#SaleRepairRequest_customer_shipping_id').val();
            
            $.ajax({
                data: { id: customer_id,outlet_id:outlet_id },
                type: 'post',
                url: '" . Yii::app()->createUrl('sales/schedule/Getmachinedetails') . "',
                success: function (data) {
                    $('#tbl_repair_request').html(data);
                }
            });
        }
    });
}
", CClientScript::POS_HEAD);

// 🔹 Handle machine + outlet location change for specific row
$cs->registerScript("machinedetails", "
function machinedetails(element) {
    var customer_id = $('#SaleRepairRequest_customer_id').val();
    var outlet_id = $('#SaleRepairRequest_customer_shipping_id').val();
    var \$row = $(element).closest('tr');
    var \$outletCell = \$row.find('td[id^=\"outlet_location_\"]');

    // 1️⃣ Reload machine details table
    // $.ajax({
    //     data: { id: customer_id, outlet_id: outlet_id },
    //     type: 'post',
    //     url: '" . Yii::app()->createUrl('sales/schedule/Getmachinedetails') . "',
    //     success: function (data) {
    //         $('#tbl_repair_request').html(data);
    //     }
    // });

    // 2️⃣ Load location details for THIS specific row
    $.ajax({
        data: { id: customer_id, outlet: outlet_id },
        dataType: 'json',
        type: 'post',
        url: '" . Yii::app()->createUrl('sales/schedule/getLocationdetails') . "',
        success: function (data) {
            console.log(data.dt);
            \$outletCell.html(data.dt);
        }
    });
}
", CClientScript::POS_HEAD);

?>
<?php
$cs->registerScript("handleServiceTypeChange", "
    function handleServiceTypeChange(serviceId) {
        console.log('Service Type changed:', serviceId);

        // Case 1: If service type = 1 → check all checkboxes
        if (serviceId == 1) {
            $('.machine-check').prop('checked', true);
        } else {
            $('.machine-check').prop('checked', false);
        }

        // Case 2: If service type = 4 → show 'New Fragrance' column
        if (serviceId == 4) {
            $('.new_gragrance, .add_fragrance').removeClass('hidden').show();
            $('.fragrance_type_ddl').prop('disabled', false);
        } else {
            $('.new_gragrance, .add_fragrance').addClass('hidden').hide();
            $('.fragrance_type_ddl').val('').prop('disabled', true);
        }
    }
    ", CClientScript::POS_END);

?>