<style>
    .col-md-1 {
        width: 0.333333% !important;
    }

    .col-md-2 {
        width: auto;
    }
</style>
<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
?>

<script>
    $(document).ready(function () {
    var table = $("#tbl_customer").DataTable({
    scrollY: "645px",
            pageLength: 50,
            processing: true,
            serverSide: true,
            fixedColumns: true,
            order: [[0, "DESC"]],
            columnDefs: [
            {
            "targets": [8,10],
                    "visible": false,
            }],
            ajax: {
            url: "<?php echo Yii::app()->createUrl('sales/schedule/Getlist') ?>",
                    type: "POST",
                    cache: false,
                    data: function (d) {
                    d.customer_id = $("#customer").val();
                    d.user_id = $("#filter_user_id").val();
                    d.schedule_date = $("#schedule_date").val();
                    d.request_date = $("#request_date").val();
                    d.status_id = $("#status_id").val();
                    }
            },
            fnCreatedRow: function (nRow, aData) {
            $(nRow).addClass('context-menu').data('rowData', aData);
            }
    });
    $("#filter_user_id").change(function () {


    $("#tbl_customer").DataTable().ajax.reload(null, false);
    });
    // ✅ Define context menu ONCE globally
    $.contextMenu({
    selector: '.context-menu',
            build: function ($trigger) {
            var data = $trigger.data('rowData') || [];
            // var id = data[0] || 0;
            var customer_name = data[4] || '';
            var planned_date = data[6] || '';
            // var status = data[3] || '';


            var extra = {};
            try {
            extra = data[10] ? JSON.parse(data[10]) : {};
            } catch (e) {
            console.error("Invalid JSON in column 4", e);
            }

            var customer_id = extra.customer_id || 0;
            var type_id = extra.type_id || 0;
            var status = extra.status || 0;
            var id = extra.id || 0;
            var service_status = extra.service_status;
            var ref_no = extra.ref_no || '';
            var transfer_id = extra.transfer_id || 0;
            var transfer_status = extra.transfer_status || '';
            var transfers_type =data[11] ;
            return {
            callback: function (key) {
            if (key === 'edit') {
            loadPopupModal(
                    'sales/schedule/create&type_id=2&id=' + id + '&customer_id=' + customer_id,
                    'Edit Job Sheet: ' + customer_name,
                    'xl'
                    );
            }
            else if (key === 'view') {
            loadPopupModal(
                    'sales/schedule/create&type=view&type_id=2&id=' + id + '&customer_id=' + customer_id,
                    'View Job Sheet: ' + customer_name,
                    'xl'
                    );
            }
            else if (key === 'complete') {
                updateStatus(id, customer_id, customer_name);
            }
            else if (key === 'mark_as_c') {
                markasComplete(id, customer_id, customer_name);
            }
            else if (key === 'print') {
                window.open($('#liveSite').val() + "/index.php?r=sales/schedule/printSchedule&id=" + id, "_blank");
            }else if (key === 'transferprint') {
                window.open($('#liveSite').val() + "/index.php?r=iwarehouse/PrintDirectTransferPDF&id=" +ref_no, "_blank");
            }else if (key === 'transferexcel') {
                window.open($('#liveSite').val() + "/index.php?r=iwarehouse/PrintDirectTransferExcel&id=" +ref_no, "_blank");
            }
            
            else if (key === 'transfer') {
                if (service_status == 1)
                {
                    loadPopupModal(
                        'iwarehouse/createmachinetransfer&frm=JO&job_id=' + id + '&customer_id=' + customer_id,
                        'Transfer from Main Warehouse',
                        'xl'
                        );
                }
                else
                {
                    loadPopupModal(
                        'iwarehouse/createmeterial&frm=JO&job_id=' + id + '&customer_id=' + customer_id,
                        'Transfer from Main Warehouse',
                        'xl'
                        );
                }
            }else if(key === 'convert'){
                loadPopupModal(
                        'packaging/create&id=' + transfer_id,
                        'Transfer to Van',
                        'xl'
                        );
            }
            },
                    items: {
                        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn['jb_edit'])) { ?>

                        'edit': { name: 'Edit', icon: 'edit', disabled: status == 'Completed' },
                        <?php } ?>
                        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn['jb_view'])) { ?>

                        'view': { name: 'View', icon: 'fa-eye' },
                        <?php } ?>
                        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn['jb_print'])) { ?>
                         "fold-print": {
                            "name": "Print",
                            "icon": "fa-print",
                            "items": {
                                'print': { name: 'Job Print', icon: 'fa-print' },
                                'transferprint': { name: 'Transfer Print', icon: 'fa-print' },
                                'tansferexcel': { name: 'Transfer Excel', icon: 'fa-excel' },
                            }
                        },
                        <?php } ?>
                        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn['jb_edit'])) { ?>
                        'complete': {
                        name: 'Review Job Sheet',
                                icon: 'fa-check',
                                disabled: status == 'Completed'
                        },
                        <?php } ?>
                        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn['jb_view'])) { ?>
                        'mark_as_c': {
                        name: 'Mark as Completed',
                                icon: 'fa-ban',
                                disabled: status == 'Completed'
                        },
<?php } ?>
                        'transfer': {
                            name: 'Transfer',
                            icon: 'fa-retweet',
                            
                            disabled: function (key, opt) {
                                // this references the trigger element
                                if (ref_no!='') {//current_process!='Q' &&
                                return !this.data('transferDisabled');
                                }
                            }
                            
                            
                            /*disabled: function(i, e){
                            
                            console.log('');
                            console.log("disabled called" + ref_no);
                            return ref_no.length > 0;
                            }*/
                        },
                        'convert': {
                            name: 'Quality Check',
                            icon: 'fa-retweet',
                            
                            disabled: function (key, opt) {
                                // this references the trigger element
                                if (transfers_type=='Done' ) {//current_process!='Q' &&
                                return !this.data('convertDisabled');
                                }
                            }
                            
                            
                            /*disabled: function(i, e){
                            
                            console.log('');
                            console.log("disabled called" + ref_no);
                            return ref_no.length > 0;
                            }*/
                        }
                    }
            };
            }
    });
    });
    function updateStatus(id, customer_id, customer_name) {
    // if (confirm('Are you sure you want to change status?')) {
    const url = `sales/schedule/create&type=C&type_id=2&id=${id}&customer_id=${customer_id}`;
    const title = `Review Job Sheet: ${customer_name}`;
    loadPopupModal(url, title, 'xl');
    // }
    }
    function markasComplete(id, customer_id, customer_name) {
    if (confirm('Are you sure you want to Mark as Completed?')) {
    $.ajax({
    type: 'POST',
            url: $('#liveSite').val() + "/index.php?r=sales/schedule/markasComplete",
            data: {
            id: id,
                    customer_id: customer_id,
                    customer_name: customer_name
            },
            beforeSend: function () {
            // optional: you can show a loader here if needed
            },
            success: function (response) {
            try {
            let res = JSON.parse(response);
            if (res.status === 'success') {
            t8.success(res.message || 'Schedule marked as completed successfully.');
            reloadTable($("#tbl_customer"));
            } else {
            t8.error(res.message || 'Failed to mark schedule as completed.');
            }
            } catch (e) {
            t8.error('Unexpected server response.');
            }
            },
            error: function () {
            t8.error('Error while processing the request.');
            }
    });
    }
    }



</script>

<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <div class="row" style="align-items:center; display:flex;">

            <!-- Left Title -->
            <div class="col-sm-3">
                <span>Job Sheet</span>
            </div>

            <!-- Right Controls -->
            <div class="col-sm-9">
                <div class="row" style="display:flex; justify-content:flex-end; align-items:center; gap:14px;">

                    <!-- User Dropdown -->
                    <div class="col-md-2 pd-zero">
                        <select id="filter_user_id" class="form-control">
                            <option value="">-- Select User --</option>
                            <?php foreach (User::getUser() as $id => $name) { ?>
                                <option value="<?php echo $id; ?>"><?php echo $name; ?></option>
                            <?php } ?>
                        </select>
                    </div>

                    <!-- Schedule Date -->
                    <div class="col-md-2 pd-zero" style="width: 12%;display:none;">
                        <?php
                        echo CHtml::textField(
                                'schedule_date',
                                '',
                                array(
                                    'id' => 'schedule_date',
                                    'class' => 'form-control datepicker',
                                    'placeholder' => 'Schedule Date',
                                    'onkeypress' => 'return false'
                                )
                        );
                        ?>
                    </div>

                    <div class="col-md-1 pd-zero" style="display:none;">
                        <button class="btn btn-danger btn-xs" style=" position: relative;
                                right: 9px;
                                height: 33px;" title="Clear Schedule Date"
                                onclick="document.getElementById('schedule_date').value = ''; $('#tbl_customer').DataTable().ajax.reload(null, false);">
                            <i class="fa fa-close"></i>
                        </button>
                    </div>

                    <!-- Request Date -->
                    <div class="col-md-2 pd-zero" style="width: 12%;display:none;">
                        <?php
                        echo CHtml::textField(
                                'request_date',
                                '',
                                array(
                                    'id' => 'request_date',
                                    'class' => 'form-control datepicker',
                                    'placeholder' => 'Request Date',
                                    'onkeypress' => 'return false'
                                )
                        );
                        ?>
                    </div>

                    <div class="col-md-1 pd-zero" style="display:none;">
                        <button class="btn btn-danger btn-xs" style=" position: relative;
                                right: 9px;
                                height: 33px;" title="Clear Request Date"
                                onclick="document.getElementById('request_date').value = ''; $('#tbl_customer').DataTable().ajax.reload(null, false);">
                            <i class="fa fa-close"></i>
                        </button>
                    </div>

                    <!-- Status Filter -->
                    <div class="col-md-2 pd-zero" style="width: 14%;display:none">
                        <?php
                        echo CHtml::dropdownList(
                                'status_id',
                                '0',
                                ServiceStatus::getAll(),
                                array('class' => 'form-control', 'onChange' => 'reloadTable("#tbl_customer")', 'prompt' => '-All Status-')
                        );
                        ?>
                    </div>

                    <!-- Add Button -->
                    <div class="col-md-2 text-right pd-zero">
                        <?php if (isset(Yii::app()->user->havePermissionOn['jb_add']) || Yii::app()->user->authorised_user == 1) { ?>
                            <a class="ad-btn" id="add_popup"
                               onclick="loadPopupModal('sales/schedule/create', 'Add New Job Sheet', 'xl')" title="Add">
                                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                                     xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2"
                                      stroke-linecap="round" />
                                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2"
                                      stroke-linecap="round" />
                                </svg>
                            </a>
                        <?php } ?>
                    </div>

                </div>
            </div>

        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_customer" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>SI No</th>
                        <th>Job Id</th>
                        <th>File No</th>
                        <th>Order Id</th>
                        <th>Customer</th>
                        <th>Service Type</th>
                        <th>Planned Date</th>
                        <th>Assigned To</th>
                        <th>Status</th>
                        <th>Transfer No</th>
                        <th></th>
                        <th>QC</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
<script>
    // $('#schedule_date').datetimepicker({
    //     useCurrent: false,
    //     widgetPositioning: {
    //         horizontal: 'auto',
    //         vertical: 'bottom'
    //     }
    // });

    $(document).ready(function () {

    // Enable datepicker
    $('.datepicker').datetimepicker({
    format: 'DD/MM/YYYY',
            useCurrent: false,
            showClear: true,
            widgetPositioning: {
            horizontal: 'right',
                    vertical: 'bottom'
            }
    });
    $('#schedule_date').on('dp.change', function () {
    $("#tbl_customer").DataTable().ajax.reload(null, false);
    });
    $('#request_date').on('dp.change', function () {
    $("#tbl_customer").DataTable().ajax.reload(null, false);
    });
    });


</script>
s