<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'sales-repair-request-form',
    'enableAjaxValidation' => false,
));
?>

<?php echo $form->hiddenField($model, 'id'); ?>

<ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
    <li class="active"><a href="#cutomer_tab1" data-toggle="tab">Service</a></li>
    <li><a href="#cutomer_tab2" data-toggle="tab">Request</a></li>
</ul>

<div class="tab-content">

    <div class="tab-pane active" id="cutomer_tab1">
        <?php
        $this->renderPartial('job_service', array('model' => $model, 'form' => $form, 'type' => $type,'frm'=>$frm));
        ?>
    </div>

    <div class="tab-pane" id="cutomer_tab2">
        <?php
        $this->renderPartial('job_request_item', array('model' => $model, 'form' => $form, 'modelMachine' => $modelMachine, 'type' => $type,'frm'=>$frm));
        ?>
    </div>

    <div class="modal-footer">

        <button type="button" class="btn btn-danger" id="service-request_close" data-dismiss="modal">Close</button>

        <?php
        if ($type != 'C' && $type != 'view'):
            $url = Yii::app()->createUrl('sales/schedule/Save');

            echo CHtml::ajaxSubmitButton('Save', $url, array(
                'dataType' => 'json',
                'type' => 'post',
                'success' => "function(data) {
                    $('#loader').hide();

                    if(data.status=='success'){
                        t8.success('Details Saved successfully!');
                        $('#service-request_close').click();
                        reloadTable($('#table_service'));
                        reloadTable($('#tbl_customer'));
                        location.reload();
                    } else {
                        $('#service-request-form .service-request-save-btn').prop('disabled', false);
                        $('#service-request-form .service-request-save-btn')
                            .removeClass('btn_loding')
                            .addClass('btn btn-theme');

                        var messages = data.message;
                        $.each(messages, function(field, errors) {
                            var msg = errors.join(', ');
                            $('#service-request-form #' + field + '_em_').text('\"' + msg + '\"').show();
                            t8.error('\"' + msg + '\"');
                        });
                    }
                }",
                'beforeSend' => "function(){
                    $('#loader').show();
                    $('.toast8-error').hide();
                    $('#service-request-form .service-request-save-btn').prop('disabled', true);
                    $('#service-request-form .service-request-save-btn')
                        .addClass('btn_loding')
                        .removeClass('btn-theme');
                }"
            ), array('id' => 'mybtn' . rand(), 'class' => 'service-request-save-btn btn btn-theme'));
        endif;
        ?>

        <?php if ($type == 'C'): ?>
            <button type="button" class="btn btn-primary" id="submit-selected-machines">
                Complete
            </button>

            <script>
                // --- FIXED SCRIPT TO PREVENT MULTIPLE CALLS ---
                (function() {
                    // Remove any previous handler (important for AJAX-loaded modals)
                    $(document).off('click', '#submit-selected-machines');

                    // Bind only once
                    $(document).on('click', '#submit-selected-machines', function () {
                        function getSelectedMachines() {
                            var machines = [];
                            $('.machine-check:checked').each(function () {
                                var id = $(this).val();
                                var nameAttr = $(this).attr('name');
                                var match = nameAttr.match(/\[(\d+)\]/);
                                var index = match ? match[1] : null;
                                var serial = '';
                                if (index !== null) {
                                    serial = $('#SalesRepairRequestItem_' + index + '_serial_no').val() || '';
                                }
                                machines.push({ id: id, serial_no: serial });
                            });
                            return machines;
                        }

                        var selectedMachines = getSelectedMachines();
                        var header_id = $('#SaleRepairRequest_id').val();
                        var customer_id = $('#SaleRepairRequest_customer_id').val();


                        if (selectedMachines.length === 0) {
                            t8.error('Please select at least one machine.');
                            return;
                        }

                        var selectedIds = selectedMachines.map(m => m.id);
                        var serialNumbers = selectedMachines.map(m => m.serial_no);

                        $.ajax({
                            type: 'POST',
                            url: $('#liveSite').val() + 'index.php?r=sales/schedule/isComplated',
                            data: {
                                machine_id: selectedIds,
                                serial_no: serialNumbers,
                                customer_id: customer_id,
                                header_id: header_id
                            },
                            cache: false,
                            success: function (data) {
                                if (data === 'fail') {
                                    t8.error('Status Update failed!');
                                } else {
                                    $('#tbl_customer').DataTable().ajax.reload();
                                    $('#service-request_close').click();
                                    t8.success('Status Updated successfully!');
                                }
                            },
                            error: function () {
                                t8.error('AJAX request failed!');
                            }
                        });
                    });
                })();
            </script>
        <?php endif; ?>

    </div>
</div>

<?php $this->endWidget(); ?>
