<?php

$form = $this->beginWidget('CActiveForm', array(
    'id' => 'services-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
?>

<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-6">
                <input type="hidden" name="from" id="from" value="<?php echo $from; ?>">
                <?php echo $form->hiddenField($model, 'id'); ?>

                <?php echo $form->textField($model, 'code', array(
                    'data-label' => 'Code *',
                    'data-validation' => 'required',
                )); ?>
                <?php echo $form->error($model, 'code'); ?>
            </li>

            <li class="col-sm-6">
                <?php echo $form->textField($model, 'name', array(
                    'data-label' => 'Service Name *',
                    'data-validation' => 'required',
                )); ?>
                <?php echo $form->error($model, 'name'); ?>
            </li>

            <li class="col-sm-6">
                <?php echo $form->dropdownList($model, 'isActive', array('Y' => 'Yes', 'N' => 'No'), array(
                    'data-label' => 'Is Active?',
                )); ?>
                <?php echo $form->error($model, 'isActive'); ?>
            </li>
        </ul>
    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>

    <?php 
        $url = Yii::app()->createUrl('sales/masServices/SaveService');

        echo CHtml::ajaxSubmitButton('Save', $url, array(
            'dataType' => 'json',
            'type' => 'post',
            'success' => 'function(data) {
                $("#loader").hide();
                if(data.status=="success"){  
                    t8.success("Service Saved Successfully!");

                    if(data.from != ""){
                        loadPopupModal(data.from+"/create&service="+data.id, "Add New Lead", "lg");
                    } else {
                        $(".x.close").click();
                        reloadTable("#tbl_services");
                    }

                } else { 
                    $("#services-form .services-save-btn").prop("disabled", false);                      
                    $("#services-form .services-save-btn").addClass("btn-theme").removeClass("btn_loding"); 
                    $.each(data, function(key, val) {
                        $("#services-form #"+key+"_em_").text(val).show(); 
                        t8.error(""+val+""); 
                    }); 
                } 
            }',
            'beforeSend' => 'function(){
                $("#loader").show();
                $("#services-form .services-save-btn").prop("disabled", true);                      
                $("#services-form .services-save-btn").addClass("btn_loding").removeClass("btn-theme"); 
                $(".toast8-error").hide(); 
            }'
        ), array('id' => 'btnSaveService'.rand(), 'class' => 'services-save-btn btn btn-theme'));
    ?>
</div>

<?php $this->endWidget(); ?>
