<?php
$readonly = false;
$disabled = false;
$service_type = array(1 => 'Trial', 2 => "Sales", 3 => "Contract");
if ($type == 'return') {
    $readonly = true;
    $disabled = true;
    $service_type = array(4 => "Return to Warehouse", 5 => "Return to Lead Owner");
}
?>
<div class="table-responsive">
    <table class="table table-hover table-bordered" id="tbl_repair_request">
        <thead>
            <tr>
                <th style="width:5%;">#</th>
                <th style="width:20%;">Serial Number</th>
                <th style="width:20%;">Machine</th>
                <th style="width:20%;">Location</th>
                <th style="width:25%;">Return Remarks</th>
                <?php if ($type !== 'view'): ?>
                    <th class="text-center">
                        <button type="button" class="btn btn-success btn-sm" id="add_row">
                            <i class="fa fa-plus"></i>
                        </button>
                    </th>
                <?php endif; ?>
            </tr>
        </thead>
        <tbody>
            <?php $m = 1;
            foreach ($modelIssueItem as $i => $eachmachine): ?>
                <tr data-index="<?php echo $i; ?>">
                    <td class="srno"><?php
                    /*echo CHtml::checkBox(
                        "ServiceMasCustomerMachinesItem[{$i}][selected]", // name for tabular form
                        false, // default unchecked
                        [
                            'value' => $eachmachine->id ?? $i,  // checkbox value (e.g., machine ID or index)
                            'class' => 'machine-check',         // optional class for JS use
                            'data-label' => "Select Machine #{$m}"
                        ]
                    );*/
                    ?><?php echo $m++;
                    echo $form->hiddenField($eachmachine, "[$i]id"); 
                    //echo $form->hiddenField($eachmachine, "[$i]stock_ledger_id"); 
                    echo $form->hiddenField($eachmachine, "[$i]description"); 
                    ?></td>


                    <td id="div_leadownermachinesserialno_<?php echo $i; ?>">
                        <?php
                        if ($eachmachine->id <= 0) {
                            echo $form->dropDownList(
                                $eachmachine,
                                "[$i]serial_no",
                                [],
                                [
                                    'class' => 'form-control serial-dropdown',
                                    'onchange' => 'leadownerMachinesdetails(this);',
                                    'data-search' => true
                                ]
                            );
                        } else {
                            echo $form->textField($eachmachine, 'serial_no', [
                                'class' => 'form-control',
                                'title' => 'Machine Serial No',
                                'readonly' => $readonly
                            ]);
                        }
                        ?>
                    </td>

                    <td id="div_leadownermachines_<?php echo $i; ?>">
                        <?php
                        /*echo $form->dropDownList(
                            $eachmachine,
                            "[$i]product_id",
                            ($eachmachine->product_id > 0)
                            ? StockLedger::getLeadownerMachinebySerialno($eachmachine->product_id)
                            : [],
                            [
                                'class' => 'form-control machine-dropdown',
                                'data-search' => true,
                                'empty' => '--Select Machine--'
                            ]
                        );*/
                        echo $form->textField($eachmachine, 'product_name', [
                                'class' => 'form-control',
                                'title' => 'Machine Serial No',
                                'readonly' => $readonly
                            ]);
                        echo $form->hiddenField($eachmachine, "[$i]product_id");
                        ?>
                    </td>

                    <td id="div_customerlocation_<?php echo $i; ?>">
                        <?php
                        echo $form->dropDownList(
                            $eachmachine,
                            "[$i]location_id",
                            ($model->customer_id > 0)
                            ? ServiceCustomerLocation::getLocationCustomerByOutlet(
                                $model->customer_id,
                                $model->outlet_id
                            )
                            : [],
                            [
                                'class' => 'form-control',
                                'title' => 'Customer Location',
                                'data-label' => 'Customer Location <span style="color:red">*</span>',
                                'data-search' => true,
                                'empty' => '--Select--'
                            ]
                        );
                        ?>
                    </td>

                    <td>
                        <?php echo $form->textField(
                            $eachmachine,
                            "[$i]description",
                            [
                                'class' => 'form-control',
                                'placeholder' => 'Return Remarks',
                            ]
                        ); ?>
                    </td>
                    <?php /*if ($type !== 'view'): ?>
                        <td class="text-center">
                            <button type="button" class="btn btn-danger btn-sm remove-row">
                                <i class="fa fa-trash"></i>
                            </button>
                        </td>
                    <?php endif;*/ ?>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<script>
    $(document).ready(function () {

        // ✅ Add Row
        $('#add_row').click(function () {
            var table = $('#tbl_repair_request tbody');
            var lastRow = table.find('tr:last');
            var newIndex = table.find('tr').length;
            var newRow = lastRow.clone();

            newRow.attr('data-index', newIndex);

            // Update all IDs and Names correctly
            newRow.find('input, select, textarea, [id]').each(function () {
                var $this = $(this);

                // Update name like [0] → [1]
                var name = $this.attr('name');
                if (name) {
                    name = name.replace(/\[\d+\]/g, '[' + newIndex + ']');
                    $this.attr('name', name);
                }

                // Update ID like _0 → _1
                var id = $this.attr('id');
                if (id) {
                    id = id.replace(/_\d+$/, '_' + newIndex);
                    $this.attr('id', id);
                }

                // Clear value for text/select/textarea
                if ($this.is('select')) {
                    $this.val('');
                } else if ($this.is('input[type="text"], textarea, input[type="hidden"]')) {
                    $this.val('');
                }
            });

            // Update visible serial number
            newRow.find('.srno').text(newIndex + 1);

            table.append(newRow);

            console.log('✅ Added new row with index', newIndex);
        });

        // ✅ Remove Row
        $(document).on('click', '.remove-row', function () {
            var table = $('#tbl_repair_request tbody');
            if (table.find('tr').length > 1) {
                $(this).closest('tr').remove();
                table.find('tr').each(function (i) {
                    $(this).find('.srno').text(i + 1);
                    $(this).attr('data-index', i);
                });
            }
        });

        // ✅ When Lead Owner changes, refresh all machine dropdowns
        $('#ServiceMasCustomerMachines_lead_owner_id').change(function () {
            var leadOwnerId = $(this).val();
            var customerId = $('#ServiceMasCustomerMachines_customer_id').val();

            if (!leadOwnerId || !customerId) {
                alert('Please select both Customer and Lead Owner.');
                return;
            }

            $('#tbl_repair_request tbody tr').each(function (index, tr) {
                var $row = $(tr);
                var rowIndex = $row.data('index') || index;

                $.ajax({
                    url: 'index.php?r=sales/servicecustomermachine/GetLeadownerMachineDetails',
                    type: 'GET',
                    dataType: 'json',
                    data: {
                        lead_owner_id: leadOwnerId,
                        customer_id: customerId,
                        row_index: rowIndex
                    },
                    success: function (data) {
                        if (data.status === 'success') {
                            $('#div_leadownermachinesserialno_' + rowIndex).html(data.dt);
                        } else {
                            alert('Failed to load machine details');
                        }
                    },
                    error: function () {
                        console.error('Failed to load machines for row ' + (rowIndex + 1));
                    }
                });
            });
        });
    });

    // ✅ Load machines for selected serial
    function leadownerMachinesdetails(selectElement) {
        var $row = $(selectElement).closest('tr');
        var rowIndex = $row.data('index');
        var serial_id = $(selectElement).val();
        var lead_owner_id = $('#ServiceMasCustomerMachines_lead_owner_id').val();
        var customerId = $('#ServiceMasCustomerMachines_customer_id').val();

        if (!serial_id) return;

        $.ajax({
            url: 'index.php?r=sales/servicecustomermachine/GetLeadownerMachineDetailsbyserailNo',
            type: 'GET',
            dataType: 'json',
            data: {
                serial_id: serial_id,
                lead_owner_id: lead_owner_id,
                customer_id: customerId,
                row_index: rowIndex
            },
            success: function (data) {
                if (data.status === 'success') {
                    $('#div_leadownermachines_' + rowIndex).html(data.dt);
                } else {
                    alert('Failed');
                }
            },
            error: function () {
                alert('Error fetching machine details.');
            }
        });
    }

    // ✅ Get Outlet Location Details
    function getOutletLocationDetails() {
        var outlet_id = $('#ServiceMasCustomerMachines_customer_shipping_id').val();
        var customer_id = $('#ServiceMasCustomerMachines_customer_id').val();
        if (!outlet_id) return;

        $('#tbl_repair_request tbody tr').each(function (index, tr) {
            var $row = $(tr);
            var rowIndex = $row.data('index') || index;

            if (window['ajaxReqRow' + rowIndex]) {
                window['ajaxReqRow' + rowIndex].abort();
            }

            window['ajaxReqRow' + rowIndex] = $.ajax({
                url: 'index.php?r=sales/servicecustomermachine/getOutletLocationDetails',
                type: 'GET',
                dataType: 'json',
                data: {
                    outlet_id: outlet_id,
                    customer_id: customer_id,
                    row_index: rowIndex
                },
                success: function (data) {
                    $('#div_customerlocation_' + rowIndex).html(data.dtloc);
                },
                error: function () {
                    alert('Error loading location for row ' + (rowIndex + 1));
                },
                complete: function () {
                    window['ajaxReqRow' + rowIndex] = null;
                }
            });
        });
    }
</script>