<?php
$form = $this->beginWidget('CActiveForm', [
    'id' => 'service-goods-receipt-return-form',
    'enableAjaxValidation' => true,
    'htmlOptions' => [
        'class' => 'form-horizontal',
        'enctype' => 'multipart/form-data',
    ],
]); ?>
<ul class="clearfix form-ul material">
    <?php
    $customer_name = '';
    if ($model->customer_id > 0) {
        $customer_name = $model->customer->customer_name;
        echo $form->hiddenField($model, 'id');
        echo $form->hiddenField($model, 'lead_owner_id');
    } ?>
    <!-- Customer -->
    <li class="col-sm-4">
        <?php echo $form->textField($model, 'customer_name', [
            'class' => 'tooltipster',
            'title' => 'Please choose a customer',
            'data-label' => 'Customer <span style="color:red">*</span>',
            'onkeyup' => 'autoCompleteMachineCustomer(this.id,"Machine");',
            'value' => $customer_name,
        ]); ?>
        <?php echo $form->hiddenField($model, 'customer_id'); ?>
    </li>
    <!-- Lead Owner (Hidden Multi-Select) -->
    <li class="col-sm-4">
        <?php echo $form->dropDownList($model, 'lead_owner_id', User::getUser(), [
            'class' => 'tooltipster',
            'title' => 'Technician',
            'data-label' => 'Technician <span style="color:red">*</span>',
            'data-search' => true,
            'prompt' => 'Select',
            'multiple' => false,
            'id' => 'InventoryGoodsReceipt_lead_owner_id',
        ]); ?>
    </li>
    <!-- Customer Outlet Location -->
    <div id="div_customershippimg">
        <li class="col-sm-4">
            <?php
            echo $form->dropDownList(
                $model,
                'outlet_id',
                ($model->customer_id > 0) ? CustomerOutletLocation::getShippingLocation($model->customer_id) : [],
                [
                    'data-label' => 'Outlet Location',
                    'prompt' => 'Select',
                    'id' => 'InventoryGoodsIssue_outlet_id',
                ]
            );
            ?>
        </li>
    </div>
    <!-- Machine Table -->
    <li class="col-sm-12">
        <div id="div_customerMachineList"></div>
    </li>
</ul>
<!-- Footer Buttons -->
<div class="modal-footer">
    <div class="text-center mt-3" style="float: right;">
        <?php echo CHtml::ajaxSubmitButton(
            'Return',
            Yii::app()->createUrl('sales/Inventorygoodsreceipt/ReturnMachineMultiple'),
            [
                'type' => 'POST',
                'dataType' => 'json',
                'success' => 'function(response){
                    if(response.status == "success"){
                        t8.success(response.message);
                        $(".close").click();
                        reloadTable("#tbl_to_be_returned_machines");
                        reloadTable("#tbl_returned_machines");
                        //window.location.reload();
                    } else {
                        t8.error(response.message);
                    }
                }',
            ],
            ['class' => 'btn btn-primary']
        ); ?>
    </div>
</div>

<?php $this->endWidget(); ?>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("returnMachineScripts", "function autoCompleteMachineCustomer(field_id, frm) {
    var url = '" . Yii::app()->createUrl('customer/GetCustomerDetails') . "' + '&frm=' + frm;
    $('#' + field_id).autocomplete({
        minLength: 1,
        source: function (request, response) {
            autoCompleteSource(request, response, url);
        },
        select: function (event, ui) {
            event.preventDefault();
            var customerId = ui.item.value;
            $('#InventoryGoodsReceipt_customer_id').val(customerId);
            $('#' + field_id).val(ui.item.label);
            // Load outlet locations for the selected customer
            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: '" . Yii::app()->createUrl('sales/Inventorygoodsreceipt/getCustomerShippingdetailsReturn') . "',
                data: { id: customerId },
                success: function (data) {
                    $('#div_customershippimg').html(data.dtship);
                    // Optional: trigger loadReturnMachines automatically if first outlet is selected
                    if ($('#InventoryGoodsIssue_outlet_id').val()) {
                        loadReturnMachines();
                    }
                }
            });
            // Load returnable machines immediately
            loadReturnMachines();
        }
    });
    // Clear customer_id if input is cleared manually
    $('#' + field_id).on('change keyup', function() {
        if ($(this).val() === '') {
            $('#InventoryGoodsReceipt_customer_id').val('');
            $('#div_customerMachineList').html('');
            $('#div_customershippimg').html('');
        }
    });
}

// Load returnable machines based on selected customer
function loadReturnMachines() {
    var customerId = $('#InventoryGoodsReceipt_customer_id').val();
    var outlet_id = $('#InventoryGoodsIssue_outlet_id').val();
    if (!customerId) {
        $('#div_customerMachineList').html('');
        return;
    }
    $.ajax({
        type: 'POST',
        url: '" . Yii::app()->createUrl('sales/Inventorygoodsreceipt/getReturnMachines') . "',
        data: { 'InventoryGoodsReceipt[customer_id]': customerId,'outlet_id' : outlet_id },
        beforeSend: function() {
            $('#div_customerMachineList').html('<div class=\"text-center p-3\"><i class=\"fa fa-spinner fa-spin\"></i> Loading...</div>');
        },
        success: function(response) {
            $('#div_customerMachineList').html(response);
        },
        error: function() {
            t8.error('Failed to load returnable machines.');
            $('#div_customerMachineList').html('');
        }
    });
}

// Trigger loadReturnMachines when outlet location changes
$(document).on('change', '#InventoryGoodsIssue_outlet_id', function() {
    loadReturnMachines();
});

// Optional: Enhance multi-select dropdown with Select2
/*$(document).ready(function() {
    if ($.fn.select2) {
        $('#InventoryGoodsReceipt_lead_owner_id').select2({
            placeholder: 'Select one or more Lead Owners',
            allowClear: true,
            width: '100%'
        });
    }
});*/
", CClientScript::POS_END); ?>