<?php
$readonly = false;
$disabled = false;
$service_type = array(1 => 'Trial', 2 => "Sales", 3 => "Contract");
if ($type == 'return') {
    $readonly = true;
    $disabled = true;
    $service_type = array(4 => "Return to Warehouse", 5 => "Return to Lead Owner");
} ?>
<div class="table-responsive">
    <table class="table table-hover table-bordered" id="tbl_repair_request">
        <thead>
            <tr>
                <th style="width:5%;">#</th>
                <th style="width:20%;">Serial Number</th>
                <th style="width:20%;">Machine</th>
                <th style="width:20%;">Location</th>
                <th style="width:25%;">Remarks</th>
                <?php if ($type !== 'view'): ?>
                    <th class="text-center">
                        <button type="button" class="btn btn-success btn-sm" id="add_row">
                            <i class="fa fa-plus"></i>
                        </button>
                    </th>
                <?php endif; ?>
            </tr>
        </thead>
        <tbody>
            <?php $m = 1;
            foreach ($modelIssueItem as $i => $eachmachine): ?>
                <tr data-index="<?php echo $i; ?>">
                    <td class="srno"><?php echo $m++; ?></td>
                    <td id="div_leadownermachinesserialno_<?php echo $i; ?>">
                        <?php
                        if ($eachmachine->id <= 0) {
                            echo $form->dropDownList(
                                $eachmachine,
                                "[$i]serial_no",
                                [],
                                [
                                    'class' => 'form-control serial-dropdown',
                                    'onchange' => 'leadownerMachinesdetails(this);',
                                    'data-search' => true,
                                    'empty' => '--Select Serial No--'
                                ]
                            );
                        } else {
                            echo $form->textField($eachmachine, 'serial_no', [
                                'class' => 'form-control',
                                'title' => 'Machine Serial No',
                                'readonly' => $readonly
                            ]);
                        } ?>
                    </td>
                    <td id="div_leadownermachines_<?php echo $i; ?>">
                        <?php
                        echo $form->dropDownList(
                            $eachmachine,
                            "[$i]product_id",
                            ($eachmachine->serial_no > 0)
                            ? InventoryGoodsIssueItem::getLeadownerMachinebySerialno($model->id, $eachmachine->serial_no)
                            : ($eachmachine->product_name?$eachmachine->product_name:[]),
                            [
                                'class' => 'form-control machine-dropdown',
                                'data-search' => true,
                                'style' => 'pointer-events:none; background-color:#f5f5f5;'
                            ]
                        );
                        echo $form->hiddenField($eachmachine, "[$i]id"); ?>
                    </td>
                    <td id="div_customerlocation_<?php echo $i; ?>">
                        <?php
                        echo $form->dropDownList(
                            $eachmachine,
                            "[$i]location_id",
                            ($model->customer_id > 0)
                            ? ServiceCustomerLocation::getLocationCustomerByOutlet(
                                $model->customer_id,
                                $model->outlet_id
                            )
                            : [],
                            [
                                'class' => 'form-control',
                                'title' => 'Customer Location',
                                'data-label' => 'Customer Location <span style="color:red">*</span>',
                                'data-search' => true,
                                'empty' => '--Select--'
                            ]
                        ); ?>
                    </td>
                    <td>
                        <?php echo $form->textField(
                            $eachmachine,
                            "[$i]description",
                            [
                                'class' => 'form-control',
                                'placeholder' => 'Description',
                            ]
                        ); ?>
                    </td>
                    <?php if ($type !== 'view'): ?>
                        <td class="text-center">
                            <button type="button" class="btn btn-danger btn-sm remove-row">
                                <i class="fa fa-trash"></i>
                            </button>
                        </td>
                    <?php endif; ?>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
<script>
    $(document).ready(function () {
        $('#add_row').off('click').on('click', function () {
            var $table = $('#tbl_repair_request tbody');
            var newIndex = $table.find('tr').length; // next index
            var $lastRow = $table.find('tr:last');
            var $newRow = $lastRow.clone(false, false); // clone structure only
            $newRow.attr('data-index', newIndex);
            // Update attributes and clear values
            $newRow.find('input, select, textarea, div[id]').each(function () {
                var $el = $(this);
                var name = $el.attr('name');
                if (name) {
                    // replace [0] → [newIndex]
                    $el.attr('name', name.replace(/\[\d+\]/, '[' + newIndex + ']'));
                }
                var id = $el.attr('id');
                if (id) {
                    // replace _0_ → _newIndex_
                    $el.attr('id', id.replace(/_\d+_/, '_' + newIndex + '_'));
                }
                // clear values for new row
                if ($el.is('select')) {
                    destroySelectPlugin($el);
                    $el.val('');
                } else if ($el.is('input[type="text"], textarea, input[type="hidden"]')) {
                    $el.val('');
                }
            });
            // Update wrapper divs (very important)
            $newRow.find('[id^="div_leadownermachinesserialno_"]').attr('id', 'div_leadownermachinesserialno_' + newIndex);
            $newRow.find('[id^="div_leadownermachines_"]').attr('id', 'div_leadownermachines_' + newIndex);
            $newRow.find('[id^="div_customerlocation_"]').attr('id', 'div_customerlocation_' + newIndex);
            // Update row number
            $newRow.find('.srno').text(newIndex + 1);
            // Append the row and rebind event
            $table.append($newRow);
            // Rebind onchange event to new dropdown
            $newRow.find('.serial-dropdown').off('change').on('change', function () {
                leadownerMachinesdetails(this);
            });
            setTimeout(() => updateSerialDropdowns(), 100);
        });
        // ✅ Remove Row
        $(document).off('click', '.remove-row').on('click', '.remove-row', function () {
            var $table = $('#tbl_repair_request tbody');
            if ($table.find('tr').length > 1) {
                $(this).closest('tr').remove();
                $table.find('tr').each(function (i) {
                    $(this).attr('data-index', i);
                    $(this).find('.srno').text(i + 1);
                    $(this).find('input, select, textarea').each(function () {
                        var $el = $(this);
                        var name = $el.attr('name');
                        if (name) $el.attr('name', name.replace(/\[\d+\]/, '[' + i + ']'));
                        var id = $el.attr('id');
                        if (id) $el.attr('id', id.replace(/_\d+$/, '_' + i));
                    });
                });
                updateSerialDropdowns();
            }
        });
        // ✅ Refresh serial dropdown uniqueness
        $(document).off('change', '.serial-dropdown').on('change', '.serial-dropdown', function () {
            updateSerialDropdowns(this);
        });
        // ✅ When Lead Owner changes
    });
    // ✅ AJAX fetch details by serial
    function leadownerMachinesdetails(selectElement) {
        var $row = $(selectElement).closest('tr');
        var selectId = $(selectElement).attr('id');
        var rowIndex = 0;
        // Match the number before _serial_no
        var match = selectId.match(/InventoryGoodsIssueItem_(\d+)_serial_no/);
        if (match) {
            rowIndex = parseInt(match[1]);
        } else if ($row.data('index') !== undefined) {
            rowIndex = $row.data('index');
        }
        // console.log('Resolved rowIndex:', rowIndex);
        var serial_id = $(selectElement).val();
        var lead_owner_id = $('#InventoryGoodsIssue_lead_owner_id').val();
        var customer_id = $('#InventoryGoodsIssue_customer_id').val();
        if (!serial_id) return;
        $.ajax({
            url: 'index.php?r=sales/Inventorygoodsissue/GetLeadownerMachineDetailsbyserailNo',
            type: 'GET',
            dataType: 'json',
            data: {
                serial_id: serial_id,
                lead_owner_id: lead_owner_id,
                customer_id: customer_id,
                row_index: rowIndex
            },
            success: function (data) {
                if (data.status === 'success') {
                    $('#div_leadownermachines_' + rowIndex).html(data.dt);
                    updateSerialDropdowns();
                }
            }
        });
    }
    // ✅ Outlet Location AJAX
    function getOutletLocationDetails() {
        var outlet_id = $('#InventoryGoodsIssue_outlet_id').val();
        var customer_id = $('#InventoryGoodsIssue_customer_id').val();
        if (!outlet_id) return;
        $('#tbl_repair_request tbody tr').each(function (index, tr) {
            if (window['ajaxReqRow' + index]) window['ajaxReqRow' + index].abort();
            window['ajaxReqRow' + index] = $.ajax({
                url: 'index.php?r=sales/Inventorygoodsissue/getOutletLocationDetails',
                type: 'GET',
                dataType: 'json',
                data: {
                    outlet_id: outlet_id,
                    customer_id: customer_id,
                    row_index: index
                },
                success: function (data) {
                    $('#div_customerlocation_' + index).html(data.dtloc);
                    updateSerialDropdowns();
                },
                complete: function () {
                    window['ajaxReqRow' + index] = null;
                }
            });
        });
    }
    // ✅ Helpers
    function refreshSelectPlugin($select) {
        if ($select.hasClass('select2-hidden-accessible')) {
            try { $select.trigger('change.select2'); } catch (e) { }
        }
        if (typeof $select.selectpicker === 'function' && $select.closest('.bootstrap-select').length) {
            try { $select.selectpicker('refresh'); } catch (e) { }
        }
        if ($select.hasClass('chosen-select')) {
            try { $select.trigger('chosen:updated'); } catch (e) { }
        }
    }
    function destroySelectPlugin($select) {
        if ($select.hasClass('select2-hidden-accessible')) {
            try { $select.select2('destroy'); } catch (e) { }
        }
        if (typeof $select.selectpicker === 'function' && $select.closest('.bootstrap-select').length) {
            try { $select.selectpicker('destroy'); } catch (e) { }
        }
        if ($select.hasClass('chosen-select')) {
            try { $select.trigger('chosen:updated'); } catch (e) { }
        }
    }
    function updateSerialDropdowns(changedDropdown) {
        var selectedSerials = [];
        $('.serial-dropdown').each(function () {
            var v = $(this).val();
            if (v) selectedSerials.push(String(v));
        });
        $('.serial-dropdown').each(function () {
            var $select = $(this);
            var currentVal = String($select.val() || '');
            $select.find('option').each(function () {
                var $opt = $(this);
                var optVal = String($opt.val() || '');
                if (!optVal) return $opt.prop('disabled', false).prop('hidden', false);
                $opt.prop('disabled', selectedSerials.includes(optVal) && optVal !== currentVal);
                $opt.prop('hidden', selectedSerials.includes(optVal) && optVal !== currentVal);
            });

            refreshSelectPlugin($select);
        });
        if (changedDropdown) refreshSelectPlugin($(changedDropdown));
    }
</script>