<ul class="clearfix form-ul material">
    <?php $customer_name = ($model->customer_id > 0) ? $model->customer->customer_name : ''; ?>
    <li class="col-sm-3">
        <?php echo CHtml::textField('customer_name', $customer_name, [
            'class' => 'tooltipster',
            'title' => 'Please choose a customer',
            'data-label' => 'Customer <span style="color:red">*</span>',
            'onKeyup' => 'js:autoCompleteMachineCustomer(this.id,"Machine");',
            'readonly' => $readonly
        ]); ?>
        <?php echo $form->hiddenField($model, 'customer_id'); ?>
    </li>
    <div id="div_customershippimg">
        <li class="col-sm-2">
            <?php
            echo $form->dropDownList(
                $model,
                'outlet_id',
                ($model->customer_id > 0) ? CustomerOutletLocation::getShippingLocation($model->customer_id) : [],
                [
                    'data-label' => 'Outlet Location',
                    'prompt' => 'Select',
                    'onChange' => 'js:getOutletLocationDetails(this.id,"Machine");'
                ]
            ); ?>
        </li>
    </div>
    <div id="div_InvoiceFileList">
        <li class="col-sm-2">
            <?php
            $invoiceList = [];
            // If editing or viewing existing record — preload available invoices
            if ((int) $model->id > 0 && (int) $model->customer_id > 0) {
                $condition = '1=1';
                $condition .= ' AND customer_id=' . (int) $model->customer_id;
                if (!empty($model->type_of_invoice)) {
                    $condition .= ' AND order_type="' . $model->type_of_invoice . '"';
                }
                $orders = Order::model()->findAll([
                    'select' => 'id,file_id',
                    'condition' => $condition,
                    'limit' => 200,
                ]);
                foreach ($orders as $order) {
                    $invoiceList[$order->id] = $order->file_id . ' : ' . $order->id;
                }
            }
            echo $form->dropDownList(
                $model,
                'file_id',
                $invoiceList,
                [
                    'class' => 'tooltipster',
                    'data-label' => 'Service Order',
                    'prompt' => '--Select Order--',
                    'onchange' => 'js:setInvoiceId(this);'
                ]
            );
            echo $form->hiddenField($model, 'production_order_id');?>
        </li>
    </div>
    <div id="">
        <li class="col-sm-2">
            <?php
            $modMasIssueType = new MasIssueType();
            $arr_TypeGroup = $modMasIssueType->getMachineIssueType();
            $modMasSalesGroup = new MasSalesGroup();
            $arr_TypeGroup = $modMasSalesGroup->getSalesGroup(3);
            echo $form->dropDownList(
                $model,
                "issue_type",
                $arr_TypeGroup,
                [
                    'empty' => '--Select Type--',
                    'data-label' => 'Issue Type'
                ]
            ); ?>
        </li>
    </div>
    <!-- <div id="div_customerlocation">
        <li class="col-sm-6">
            <?php
            // echo $form->dropDownList(
            //     $model,
            //     'location_id',
            //     ($model->customer_id > 0) ? ServiceCustomerLocation::getLocationCustomer($model->customer_id) : [],
            //     [
            //         'class' => 'tooltipster',
            //         'title' => 'Customer Location',
            //         'data-label' => 'Customer Location <span style="color:red">*</span>',
            //         'data-search' => true,
            //         'empty' => '--Select--'
            //     ]
            // );
            ?>
        </li>
    </div> -->
    <li class="col-sm-3">
        <?php echo $form->dropDownList($model, 'lead_owner_id', User::getUser(), [
            'class' => 'tooltipster',
            'title' => 'Assigned User',
            'data-label' => 'Assigned User <span style="color:red">*</span>',
            'data-search' => true,
            'empty' => '--Select--',
            'onChange' => 'getMachineDetailsList()'
        ]); ?>
    </li>
</ul>