<?php
$cs = Yii::app()->getClientScript();


$baseUrl = Yii::app()->baseUrl;
?>
<script>
    $(document).ready(function () {
        var table_id = "#tbl_customer_history";
        var table = $(table_id).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            order: [[0, "DESC"]],
             columnDefs: [
            {
            "targets": [10],
                    "visible": false,
            }],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('sales/customerVisit/Getlist') ?>",
                type: "POST",
                cache: false,
                data: function (d) {
                    d.name = $("#name").val();
                }
            },
            serverSide: true,
            fixedColumns: true,
            fnCreatedRow: function (nRow, aData) {
                $(nRow).addClass('context-menu').data('rowData', aData);
            }
        });
        


       // Define context menu globally
$.contextMenu({
    selector: '.context-menu',
    build: function ($trigger) {

        var data = $trigger.data('rowData') || [];
        var id = data[1] || 0;
        var transfer_id = data[10].transfer_id || 0;
        var service_type = data[10].type || 0;

        return {
            callback: function (key) {

                if (key === 'view') {
                    loadPopupModal(
                        'sales/customerVisit/view&id=' + id,
                        'View ' + id,
                        'lg'
                    );
                }
                else if (key === 'print') {
                    window.open(
                        $('#liveSite').val() + "/index.php?r=sales/customerVisit/print&type=2&id=" + id, 
                        "_blank"
                    );
                }else if (key === 'printoilissue') {
                    window.open(
                        $('#liveSite').val() + "/index.php?r=iwarehouse/PrintMachine&id=" + transfer_id, 
                        "_blank"
                    );
                }

            },
            items: {

                <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn['customer_visit_view'])) { ?>
                    view: { name: 'View', icon: 'fa-eye' },
                <?php } ?>

                <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn['customer_visit_print'])) { ?>
                    print: { name: 'Print', icon: 'fa-print' },
                    //if(service_type==1){
                    printoilissue: { name: 'Print Oil Issual', icon: 'fa-print',
                    
                        disabled: function (key, opt) {
                            // this references the trigger element
                            if (service_type!=1 ) {//current_process!='Q' &&
                            return !this.data('printoilissueDisabled');
                            }
                        }
                    },
                    //}
                <?php } ?>

            }
        };
    }
});

    });

</script>
<script>
    function deletemachinetype(id) {
        var r = confirm('Are you sure to delete this?');
        if (r) {
            jQuery.ajax({
                'type': 'post',
                'data': 'id=' + id,
                'url': $('#liveSite').val() + 'index.php?r=fragrance/delete',
                'cache': false,
                'success': function (data) {
                    if (data == 'fail') {
                        t8.error('Deletion failed!');
                    } else {
                        reloadTable($("#tbl_machinetype"));
                        t8.success('Deleted!');
                    }
                }
            });
        }
    }
</script>
<section class="panel" >
    <header class="panel-heading clearfix panel-theame">
        <i class="material-icons"></i>Customer Visit
        <!--<div class="pull-right">
            <button class="btn btn-sm btn-theme" onclick="loadPopupModal('Customermeeting/create', 'Add', 'lg')"><i class="fa fa-plus"></i> ADD</button>
        </div>-->
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_customer_history" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>SI No</th>
                        <th>#</th>
                        <th>Customer</th>
                        <th>Outlet Location</th>
                        <th>Employee Name</th>
                        <th>Date</th>
                        
                        <th>Start Time</th>
                        <th>End Time</th>
                        <th>Remarks</th>
                        <th>Service Type</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>

</section>
