<?php

/**
 * This is the model class for table "{{repair_request_item}}".
 *
 * The followings are the available columns in table '{{repair_request_item}}':
 * @property integer $id
 * @property integer $machine_id
 * @property string $date
 * @property integer $service_type
 * @property integer $header_id
 */
class SalesRepairRequestItem extends CActiveRecord {

    public $machine_name = '';
    public $description = '';

    public $location;
    public $part_number;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{sales_repair_request_item}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('machine_id, date, service_id, header_id', 'required'),
            array('machine_id,service_id,fragrance_id, service_type, liquid_id, header_id, status_id', 'numerical', 'integerOnly' => true),
            array('file_name, sign, before_image', 'length', 'max' => 256),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, machine_id, date,fragrance_id,service_id,location_id, service_type, liquid_id, header_id, file_name, sign', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'machine' => array(self::BELONGS_TO, 'Store', 'machine_id'),
            'type' => array(self::BELONGS_TO, 'ServiceType', 'service_type'),
            'status' => array(self::BELONGS_TO, 'ServiceStatus', 'status_id'),
            'fragrance' => array(self::BELONGS_TO, 'MasFragrance', 'fragrance_id'),
            'new_fragrance' => array(self::BELONGS_TO, 'MasFragrance', 'new_fragrance_id'),
            // this is unused
            'service' => array(self::BELONGS_TO, 'MasServices', 'service_id'),
            'repair' => array(self::BELONGS_TO, 'SaleRepairRequest', 'header_id'),
            'outlet_location' => array(self::BELONGS_TO, 'ServiceCustomerLocation', 'location_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'machine_id' => 'Machine',
            'date' => 'Date',
            'service_type' => 'Service Type',
            'header_id' => 'Header',
            'file_name' => 'File name',
            'sign' => 'sign'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('machine_id', $this->machine_id);
        $criteria->compare('date', $this->date, true);
        $criteria->compare('service_type', $this->service_type);
        $criteria->compare('header_id', $this->header_id);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return RepairRequestItem the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
