<?php

/**
 * This is the model class for table "{{repair_request}}".
 *
 * The followings are the available columns in table '{{repair_request}}':
 * @property integer $id
 * @property integer $customer_id
 * @property string $request_date
 * @property integer $status_id
 * @property string $completed_date
 * @property integer $assigned_id
 * @property string $remark
 * @property integer $created_by
 */
class SaleRepairRequest extends CActiveRecord
{

    public $customer_name = "";

    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{sale_repair_request}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('customer_id, request_date, status_id,service_id, assigned_id, type_id,  created_by', 'required'),
            array('customer_id, status_id, assigned_id, created_by', 'numerical', 'integerOnly' => true),
            array('sign,sign_person,remark', 'length', 'max' => 256),
            array('submit_invoice', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, customer_id, request_date, status_id,is_completed, service_id,completed_by,completed_date_time,is_Visited,completed_date,copy_id,service_id, customer_shipping_id,assigned_id, remark, created_by,submit_invoice', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'assigned' => [self::BELONGS_TO, 'User', 'assigned_id'],
            'created' => [self::BELONGS_TO, 'User', 'created_by'],
            'customer' => [self::BELONGS_TO, 'Customer', 'customer_id'],
            'status' => [self::BELONGS_TO, 'ServiceStatus', 'status_id'],
            'type' => [self::BELONGS_TO, 'RepairType', 'type_id'],
            'sales_cust' => [self::BELONGS_TO, 'Customer', 'customer_id'],
            'customer_shiiping' => array(self::BELONGS_TO, 'CustomerShippingDetails', 'customer_shipping_id'),
            'customer_outlet' => array(self::BELONGS_TO, 'CustomerOutletLocation', 'customer_shipping_id'),
            'service' => array(self::BELONGS_TO, 'MasServices', 'service_id'),
            'order_det' => array(self::BELONGS_TO, 'Order', 'service_order_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'customer_id' => 'Customer',
            'request_date' => 'Request Date',
            'status_id' => 'Status',
            'completed_date' => 'Completed Date',
            'assigned_id' => 'Assigned',
            'remark' => 'Remark',
            'created_by' => 'Created By',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('customer_id', $this->customer_id);
        $criteria->compare('request_date', $this->request_date, true);
        $criteria->compare('status_id', $this->status_id);
        $criteria->compare('completed_date', $this->completed_date, true);
        $criteria->compare('assigned_id', $this->assigned_id);
        $criteria->compare('remark', $this->remark, true);
        $criteria->compare('created_by', $this->created_by);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return RepairRequest the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }

    public function afterFind()
    {
        parent::afterFind();
        $this->customer_name = empty($this->customer) ? "" : $this->customer->customer_name;
    }

}
