<?php

class ScheduleMaintenanceController extends Controller
{
	public function accessRules()
	{
		return array(
			array(
				'allow', // allow all users to perform 'index' and 'view' actions
				'actions' => array('login', 'error', 'logout'),
				'users' => array('*'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('Index', 'getlist', 'ScheduleRequest'),
				'expression' => '$user->isMember()',
			),
			array(
				'deny', // deny all users
				'users' => array('*'),
			),
		);
	}
	public function filters()
	{
		return array('accessControl'); // perform access control for CRUD operations
	}
	public function actionIndex()
	{
		$this->render('index');
	}
	
	public function actiongetlist()
	{
	    
	    $model = new SaleRepairRequest();

        $draw = isset($_POST['draw']) ? (int) $_POST['draw'] : 1;
        $offset = isset($_POST['start']) ? (int) $_POST['start'] : 0;
        $limit = isset($_POST['length']) ? (int) $_POST['length'] : 10;
        $user_id = isset($_POST['user_id']) ? (int) $_POST['user_id'] : 0;
        $status_id = isset($_POST['status_id']) ? (int) $_POST['status_id'] : 0;
        $schedule_date = isset($_POST['schedule_date']) ? $_POST['schedule_date'] : '';
        $request_date = isset($_POST['request_date']) ? $_POST['request_date'] : '';

        $columns = [
            0 => 't.id',
            1 => 't.id',//job
            2 => 'order_det.file_id',
            3 => 't.service_order_id',
            4 => 'sales_cust.customer_name',
            5 => 'status.status_name',
            6 => 'status.status_name',
            7 => 'status.status_name',
            8 => 'status.status_name'
        ];

        $orderColumnIndex = isset($_POST['order'][0]['column']) ? (int) $_POST['order'][0]['column'] : 0;
        $orderDirection = isset($_POST['order'][0]['dir']) ? strtolower($_POST['order'][0]['dir']) : 'asc';
        $orderDirection = $orderDirection === 'desc' ? 'desc' : 'asc';
        $filterColumn = isset($columns[$orderColumnIndex]) ? $columns[$orderColumnIndex] : 't.id';
        $orderBy = 't.id desc';

       // $condition = "1=1 AND assigned_id>0 AND status_id=2 AND is_completed='Y' ";
        
         $condition = "assigned_id=0 AND (status_id=1) AND is_completed='N' ";
        
        //$condition = " status_id=1 AND is_completed='N' ";

        // Restrict data by user permissions
        if (Yii::app()->user->authorised_user != 1) {
            $condition .= " AND (t.assigned_id = " . (int) Yii::app()->user->id . " OR t.created_by = " . (int) Yii::app()->user->id . ")";
        }

        if ($user_id > 0) {
            $condition .= " AND t.assigned_id = {$user_id}";
        }


        if ($status_id > 0) {
            $condition .= " AND t.status_id = {$status_id}";
        }
       

        if (!empty($_POST['search']['value'])) {
            $search = trim($_POST['search']['value']);
            $condition .= " AND (
            sales_cust.customer_name LIKE :search 
            OR sales_cust.customer_phone_no LIKE :search
            OR t.remark LIKE :search
            OR t.service_order_id LIKE  :search
        )";
        }

        $count = $model->with(['sales_cust', 'status'])->count([
            'condition' => $condition,
            'params' => !empty($search) ? [':search' => "%$search%"] : []
        ]);

        $records = $model->with(['sales_cust', 'status'])->findAll([
            'condition' => $condition,
            'params' => !empty($search) ? [':search' => "%$search%"] : [],
            'limit' => $limit,
            'offset' => $offset,
            'order' => $orderBy,
        ]);

        $rowData = [];
        $m = 1;
        
        foreach ($records as $key => $row) {
		    //echo "test"."<br>";
		    
			$id = $row->id;
			$machine_count= (int) SalesRepairRequestItem::model()->count(['condition'=>'header_id='.$id,'group'=>'machine_id']);
			$btn = "";
			if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["schedule_maintenance_edit"])) {
				$btn .= '<button class="btn btn-primary  btn-xs" onclick="loadPopupModal(\'sales/schedule/create&type_id=2&id=' . $id . '&customer_id=' . $row['customer_id'] . '\',\'Edit Schedule Maintenance \',\'xl\')"><i class="fa fa-edit"></i></button> ';
			}
			$btn = "<div class='btn-wrap text-center'>{$btn}</div>";
			
			if($row->service_id==2){
			    $service_type = "Machine Issual";
			}
			else{
			    $service_type = "Oil Issual";
			}
			
			$rowData[] = [
				($offset + $key + 1),//0
				$row->id,
				$row->order_det->file_id,
				$row->service_order_id,//3
				$row->customer->customer_name,
				$row->customer_outlet->outlet_location,
				$service_type,//6
				date('d/m/Y', strtotime($row->schedule_date)),
			    //$machine_count,
				$btn,//8
				array('customer_id'=>$row['customer_id'])//9
			];
		}
		
		echo json_encode([
            'draw' => $draw,
            'recordsTotal' => $count,
            'recordsFiltered' => $count,
            'data' => $rowData
        ]);
      /*  
        
        
        
        
        
        foreach ($records as $key => $row) {
            if ($row->request_from != 'MI') {
                $scheduleDate = (!empty($row->schedule_date) && $row->schedule_date != '0000-00-00')
                    ? date('d/m/Y', strtotime($row->schedule_date))
                    : '';
            } else {
                $scheduleDate = '';
            }

            $actualDate = (!empty($row->completed_date) && $row->completed_date != '0000-00-00')
                ? date('d/m/Y', strtotime($row->completed_date))
                : (!empty($row->completed_date_time && $row->completed_date_time != '0000-00-00 00:00:00') ? date('d/m/Y', strtotime($row->completed_date_time)) : '');



            $statusIcon = '';

            if ($row->status->name == 'Completed') {
                $statusIcon = '<img src="uploads/correct.png" height="20" width="20" title="Completed" style="color:red;"/>';
            } elseif ($row->status->name == 'Pending') {
                $statusIcon = '<img src="uploads/stop.png" height="20" width="20" title="Pending"/>';
            } elseif ($row->status->name == 'Working') {
                $statusIcon = '<img src="uploads/tools.png" height="20" width="20" title="Working"/>';
            }
            $assigned_to = (!empty($row->assigned_id) && $row->assigned) ? $row->assigned->first_name . ' ' . $row->assigned->last_name : '';
            $service_status=0;
            if($row->service_id==MasServices::MIR)
            $service_status=1;
            $rowData[] = [
                $m++, // 0 => slno
                $row->id,
                CHtml::encode($row->sales_cust->customer_name), // 1=>customer name
                CHtml::encode($row->service ? $row->service->name : ''), // 2 => service type
                $scheduleDate, // 3=> planned date
                $actualDate, // 4=> actual date
                $assigned_to, //  5 = > status icons
                $statusIcon, //  6 = > status icons
                json_encode(['customer_id' => $row->customer_id, 'type_id' => $row->type_id, 'status' => $row->status->name, 'id' => $row->id,'service_status'=>$service_status]) // 7=> array
            ];
        }

        echo json_encode([
            'draw' => $draw,
            'recordsTotal' => $count,
            'recordsFiltered' => $count,
            'data' => $rowData
        ]);*/
	}
	
/*	public function actiongetlist()
	{
		$model = new Customer();
		$draw = $_POST['draw'];
		$offset = $_POST['start'];
		$limit = $_POST['length'];
		$frm = $_POST['frm'];
		$columns = array(0 => 't.customer_name', 1 => 't.customer_name', 2 => 'repair_request_det.schedule_date');
		$filterColumn = $columns[$_POST['order'][0]['column']];
		$filterOrder = $_POST['order'][0]['dir'];
		$orderBy = $filterColumn . " " . $filterOrder;
		$condition = "repair_request_det.schedule_status = 'S' AND repair_request_det.assigned_id=0";
		// && Yii::app()->user->user_group >2
	/*	if (Yii::app()->user->authorised_user != 1) {
			$condition .= ' AND t.isActive= "Y" AND (FIND_IN_SET("' . Yii::app()->user->id . '",lead_owner_id)  OR t.created_by="' . Yii::app()->user->id . '")';
		}
		if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
			$searchString = $_POST['search']['value'];
			$condition .= " AND  (customer_name LIKE '%" . $searchString . "%' OR customer_phone_no LIKE '%" . $searchString . "%' )";
		}
		
		//cho $condition;
		$count = $model->with('repair_request_det')->count(array('condition' => $condition));
		$model = $model->with('repair_request_det')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
		echo $count;
		echo '<pre>';
		print_r($model);
		
		$recordsTotal = $count;
		$recordsFiltered = $count;
		$data['draw'] = $draw;
		$data['recordsTotal'] = $recordsTotal;
		$data['recordsFiltered'] = $recordsFiltered;
		$rowData = array();
		foreach ($model as $key => $row) {
		    echo "test"."<br>";
		    
		/*	$id = $row->repair_request_det->id;
			$machine_count= (int)SalesRepairRequestItem::model()->count(['condition'=>'header_id='.$id,'group'=>'machine_id']);
			$btn = "";
			if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["schedule_maintenance_edit"])) {
				$btn .= '<button class="btn btn-primary  btn-xs" onclick="loadPopupModal(\'sales/schedule/create&type_id=2&id=' . $id . '&customer_id=' . $row['id'] . '\',\'Edit Schedule Maintenance \',\'xl\')"><i class="fa fa-edit"></i></button> ';
			}
			$btn = "<div class='btn-wrap text-center'>{$btn}</div>";
			//    $end_contract_date= ($row->end_contract_date== '0000-00-00')? "" : date('d/m/Y', strtotime($row->end_contract_date));
			$rowData[] = [
				($offset + $key + 1),
				$row->repair_request_det->id,
				$row->customer_name,
				$row->repair_request_det->customer_outlet->outlet_location,
				date('d/m/Y', strtotime($row->repair_request_det->schedule_date)),
			    $machine_count,
				$btn
			];
		}
		//$data['data'] = $rowData;
		
		echo json_encode([
            'draw' => $draw,
            'recordsTotal' => $count,
            'recordsFiltered' => $count,
            'data' => $rowData
        ]);
		//echo json_encode($data);
	}*/
	public function actionScheduleRequest()
	{
		$model = new SaleRepairRequest();
		$condition = 'status_id = 2 AND schedule_status!= "S" AND service_id=1';// AND flag_type=0
		$modelExistSaleRepairRequest = $model->with('customer')->findAll(array('condition' => $condition, 'order' => 't.id desc'));
		foreach($modelExistSaleRepairRequest as $eachSaleRepairRequest){
		    $no_of_days = $eachSaleRepairRequest->customer->no_of_days;
		    $last_order_date=$eachSaleRepairRequest->completed_date;
		    $next_service_date = DateModel::addDays($last_order_date, $no_of_days);
			$compare = DateModel::compare3Dates($next_service_date);
			if ($compare == 1) {
				if (!empty($eachSaleRepairRequest)) {
					$condition = 'copy_id= "' . $eachSaleRepairRequest->id . '" ';
					$scheduleExist = SaleRepairRequest::model()->find(array(
						'condition' => 'copy_id = :cid',
						'params' => [':cid' => $eachSaleRepairRequest->id]
					));

					if (empty($scheduleExist)) {

					    
						$modelNewSaleRepairRequest = new SaleRepairRequest();
						$modelNewSaleRepairRequest->type_id = 2;
						$modelNewSaleRepairRequest->service_id = $eachSaleRepairRequest->service_id;
						$modelNewSaleRepairRequest->status_id = 1;
						$modelNewSaleRepairRequest->customer_id = $eachSaleRepairRequest->customer_id;
						$modelNewSaleRepairRequest->location_id = $eachSaleRepairRequest->location_id;
						$modelNewSaleRepairRequest->service_order_id= $eachSaleRepairRequest->service_order_id;
						$modelNewSaleRepairRequest->transfer_id=0;
						//customer_shipping_id added by nisha on 02-04-2024
						$modelNewSaleRepairRequest->customer_shipping_id = $eachSaleRepairRequest->customer_shipping_id;
						$modelNewSaleRepairRequest->copy_id = $eachSaleRepairRequest->id;
						$modelNewSaleRepairRequest->completed_date = '0000-00-00';
						$modelNewSaleRepairRequest->created_by = $eachSaleRepairRequest->created_by;
						$modelNewSaleRepairRequest->created_date_time = date('Y-m-d H:i:s');
						$modelNewSaleRepairRequest->is_Visited = 'N';
						$modelNewSaleRepairRequest->remaining_ressigned = 'N';
						$modelNewSaleRepairRequest->schedule_date = $next_service_date ? $next_service_date : date('Y-m-d');
						$modelNewSaleRepairRequest->request_date = date('Y-m-d');
						$modelNewSaleRepairRequest->submit_invoice = 'N';
						$modelNewSaleRepairRequest->assigned_id = 0;
						$modelNewSaleRepairRequest->remark = 'Schedule Maintanance';
						$modelNewSaleRepairRequest->schedule_status = "S";
						$modelNewSaleRepairRequest->flag_type = 1;//to identify from scchedule
						
						$modelNewSaleRepairRequest->save(false);
						$f++;
						$condition1 = 'header_id= "' . $eachSaleRepairRequest->id . '"';
						$modelExistItems = SalesRepairRequestItem::model()->findAll(array('condition' => $condition1));

						foreach ($modelExistItems as $k => $eachExistItem) {
							$modelNewItems = new SalesRepairRequestItem;
							$modelNewItems->header_id = $modelNewSaleRepairRequest->id;
							$modelNewItems->machine_id = $eachExistItem->machine_id;
							$modelNewItems->serial_no = $eachExistItem->serial_no;
							$modelNewItems->location_id = $eachExistItem->location_id;
							$modelNewItems->quantity = $eachExistItem->quantity;
							$modelNewItems->remark = $eachExistItem->remark;
							$modelNewItems->new_fragrance_id = $eachExistItem->new_fragrance_id;
							$modelNewItems->liquid_id = $eachExistItem->liquid_id;
							$modelNewItems->old_volume = $eachExistItem->old_volume;
							$modelNewItems->new_volume = $eachExistItem->new_volume;
							$modelNewItems->maintenance_id = $eachExistItem->maintenance_id;
							$modelNewItems->activity_changed = $eachExistItem->activity_changed;
							$modelNewItems->scanned_type = $eachExistItem->scanned_type;
							$modelNewItems->service_id = 1;
							$modelNewItems->service_type = 1;
							$modelNewItems->status_id = 3;
							$modelNewItems->date = date('Y-m-d');								;
							$succ = $modelNewItems->save(false);

						}

						$jsonData['status'] = 'success';
						$jsonData['count'] = $f;

					} else {
						$jsonData['status'] = 'error';
						$jsonData['count'] = 0;
					}
				}
			}
		}
		echo CJSON::encode($jsonData);
		/*$jsonData = array();
		$modelCustomer = new Customer();
		if (Yii::app()->user->authorised_user == 1 || $_POST['schedule_mainta_view'] == 1) {
			$condition = 't.isActive= "Y" AND repair_request.schedule_status!= "S"';
		} else if (User::isSalesman() == 'Y') {
			$condition = 't.isActive= "Y" AND repair_request.schedule_status!= "S" AND FIND_IN_SET("' . Yii::app()->user->id . '",lead_owner_id)';
		} else {  // IN(".$pending_leaves.")"
			$condition = 't.isActive= "Y" AND repair_request.schedule_status!= "S" AND FIND_IN_SET("' . Yii::app()->user->id . '",lead_owner_id)';
		}
		$modelCustomer = $modelCustomer->with('repair_request')->findAll(array('condition' => $condition));
		$f = 0;
		// echo '<pre>';
		// print_r($modelCustomer);die;
		foreach ($modelCustomer as $row) {

			$compare = '';
			$SQL = 'SELECT `completed_date` FROM {{sale_repair_request}} WHERE customer_id=' . $row['id'] . ' AND status_id = 2 order by id desc LIMIT 1';

			$arr_last_order_date = Yii::app()->db->createCommand($SQL)->queryRow();
			$last_order_date = $arr_last_order_date['completed_date'];

			if ($last_order_date == '0000-00-00') {
				$last_order_date = '';
			}

			if (!empty($last_order_date)) {

				$no_of_days = $row->no_of_days;
				$next_service_date = DateModel::addDays($last_order_date, $no_of_days);
				$compare = DateModel::compareDate($next_service_date);


				if ($compare == 1) {
					$modelExistSaleRepairRequest = new SaleRepairRequest();
					$id = 0;
					$condition = 'customer_id= "' . $row['id'] . '" AND status_id = 2 AND schedule_status!= "S" AND flag_type=0';
					$modelExistSaleRepairRequest = $modelExistSaleRepairRequest->find(array('condition' => $condition, 'order' => 'id desc'));
;



					if (!empty($modelExistSaleRepairRequest)) {
						$condition = 'copy_id= "' . $modelExistSaleRepairRequest->id . '" ';
						$scheduleExist = SaleRepairRequest::model()->find(array(
							'condition' => 'copy_id = :cid',
							'params' => [':cid' => $modelExistSaleRepairRequest->id]
						));

						if (empty($scheduleExist)) {
							$modelNewSaleRepairRequest = new SaleRepairRequest();
							$modelNewSaleRepairRequest->type_id = 2;
							$modelNewSaleRepairRequest->status_id = 1;
							$modelNewSaleRepairRequest->customer_id = $modelExistSaleRepairRequest->customer_id;
							//customer_shipping_id added by nisha on 02-04-2024
							$modelNewSaleRepairRequest->customer_shipping_id = $modelExistSaleRepairRequest->customer_shipping_id;
							$modelNewSaleRepairRequest->copy_id = $modelExistSaleRepairRequest->id;
							$modelNewSaleRepairRequest->completed_date = '0000-00-00';
							$modelNewSaleRepairRequest->created_by = $modelExistSaleRepairRequest->created_by;
							$modelNewSaleRepairRequest->created_date_time = date('Y-m-d H:i:s');
							$modelNewSaleRepairRequest->is_Visited = 'N';
							$modelNewSaleRepairRequest->remaining_ressigned = 'N';
							$modelNewSaleRepairRequest->schedule_date = $next_service_date ? $next_service_date : date('Y-m-d');
							$modelNewSaleRepairRequest->request_date = date('Y-m-d');
							$modelNewSaleRepairRequest->submit_invoice = 'N';
							$modelNewSaleRepairRequest->assigned_id = 0;
							$modelNewSaleRepairRequest->remark = 'Schedule Maintanance';
							$modelNewSaleRepairRequest->schedule_status = "S";
							$modelNewSaleRepairRequest->flag_type = 1;//to identify from scchedule
							// var_dump($modelNewSaleRepairRequest->copy_id);
							// die;
							$modelNewSaleRepairRequest->save(false);
							$f++;
							$condition1 = 'header_id= "' . $modelExistSaleRepairRequest->id . '"';
							$modelExistItems = SalesRepairRequestItem::model()->findAll(array('condition' => $condition1));

							foreach ($modelExistItems as $k => $eachExistItem) {
								$modelNewItems = new SalesRepairRequestItem;
								$modelNewItems->header_id = $modelNewSaleRepairRequest->id;
								$modelNewItems->machine_id = $eachExistItem->machine_id;
								$modelNewItems->serial_no = $eachExistItem->serial_no;
								$modelNewItems->location_id = $eachExistItem->location_id;
								$modelNewItems->location_id = $eachExistItem->location_id;
								$modelNewItems->remark = $eachExistItem->remark;
								$modelNewItems->new_fragrance_id = $eachExistItem->new_fragrance_id;
								$modelNewItems->liquid_id = $eachExistItem->liquid_id;
								$modelNewItems->old_volume = $eachExistItem->old_volume;
								$modelNewItems->new_volume = $eachExistItem->new_volume;
								$modelNewItems->maintenance_id = $eachExistItem->maintenance_id;
								$modelNewItems->activity_changed = $eachExistItem->activity_changed;
								$modelNewItems->scanned_type = $eachExistItem->scanned_type;
								$modelNewItems->service_id = 1;
								$modelNewItems->service_type = 1;
								$modelNewItems->status_id = 3;
								$modelNewItems->date = date('Y-m-d');
								// echo 'hii';
								// $modelNewItems->created_by = $modelExistSaleRepairRequest->created_by;
								// $modelNewItems->created_date_time = date('Y-m-d H:i:s');
								$succ = $modelNewItems->save(false);

							}

							$jsonData['status'] = 'success';
							$jsonData['count'] = $f;

						} else {
							$jsonData['status'] = 'error';
							$jsonData['count'] = 0;
						}
					}

				}
			}

		}

		echo CJSON::encode($jsonData);*/
	}

}
?>