<?php

class InventorygoodsreceiptController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'GetList',
                    'Create',
                    'getCustomerShippingdetailsReturn',
                    'getReturnMachines',
                    'ReturnMachineMultiple',
                    'View',
                    'getReturnMachinesByLeadOwner',
                    'Approve',
                    'PrintMachine',
                    'SaveApprovel',
                    'GetListApproved'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public $title = "Service Customer Machine";
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex()
    {
        $this->render('index');
    }

    public function actionGetList()
    {
        $model = new InventoryGoodsReceiptItem();
        $draw = (int) $_POST['draw'];
        $offset = (int) $_POST['start'];
        $limit = (int) $_POST['length'];
        $columns = [
            0 => 't.id',
            1 => 'inventorygoodsreceipt.id',
            2 => 'inventorygoodsreceipt.customer_id',
            3 => 'inventorygoodsreceipt.lead_owner_id',
            4 => 'inventorygoodsreceipt.outlet_id',
            5 => 't.serial_no',
            6 => 't.product_name',
            7 => 'inventorygoodsreceipt.goods_receipt_date',
        ];
        $orderColumnIndex = (int) $_POST['order'][0]['column'];
        $orderDirection = $_POST['order'][0]['dir'] === 'desc' ? 'DESC' : 'ASC';
        $orderBy = 't.id DESC';
        $condition = " inventorygoodsreceipt.receipt_type = 'MH' AND t.isApproved = 'N' ";
        if (Yii::app()->user->authorised_user != 1) {
            $condition .= ' AND (inventorygoodsreceipt.lead_owner_id = "' . Yii::app()->user->id . '" OR t.created_by = "' . Yii::app()->user->id . '")';
        }
        $params = array();
        if (!empty($_POST['search']['value'])) {
            $search = trim($_POST['search']['value']);
            $condition .= " AND (t.serial_no LIKE :search)";
            $params[':search'] = '%' . $search . '%';
        }
        $criteria = new CDbCriteria;
        $criteria->condition = $condition;
        $criteria->params = $params;
        $criteria->limit = $limit;
        $criteria->offset = $offset;
        $criteria->order = $orderBy;
        $criteria->with = array('inventorygoodsreceipt');//inventorygoodsreceipt
        $criteria->together = true;
        $recordsTotal = $model->count($criteria);
        $rows = $model->findAll($criteria);
        $data = array();
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsTotal;
        $rowData = array();
        $m = 1;
        foreach ($rows as $row) {
            $buttons = '<button title="View" class="btn btn-primary btn-xs" onclick="viewReturn(' . $row->inventorygoodsreceipt->id . ')"><i class="fa fa-eye"></i></button> ';
            if ($row->isApproved == 'N') {
                $buttons .= '<button title="Approve" class="btn btn-primary btn-xs" onclick="approveReturn(' . $row->inventorygoodsreceipt->id . ')"><i class="fa fa-check"></i></button> ';
            }
            $buttons .= '<button title="Print" class="btn btn-primary btn-xs" onclick="printReturn(' . $row->inventorygoodsreceipt->id . ')"><i class="fa fa-print"></i></button>';
            $rowData[] = array(
                $m,
                $row->inventorygoodsreceipt->id,
                isset($row->inventorygoodsreceipt->customer_id) ? $row->inventorygoodsreceipt->customer->customer_name : '',
                isset($row->inventorygoodsreceipt->lead_owner_id) ? $row->inventorygoodsreceipt->owner->first_name . ' ' . $row->inventorygoodsreceipt->owner->last_name : '',
                isset($row->inventorygoodsreceipt->outlet_id) ? $row->inventorygoodsreceipt->outlet->outlet_location : '',
                isset($row->serial_no) ? $row->serial_no : '',
                isset($row->product_name) ? $row->product_name : '',
                isset($row->inventorygoodsreceipt->goods_receipt_date) ? date('d/m/Y', strtotime($row->inventorygoodsreceipt->goods_receipt_date)) : '',
                '<div class="btn-wrap">' . $buttons . '</div>',
                $row->inventorygoodsreceipt->isActive,
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate()
    {
        $type = Yii::app()->request->getParam('type');
        $id = (int) Yii::app()->request->getParam('id');
        $model = new InventoryGoodsReceipt();
        $modelIssueItem = [new InventoryGoodsReceiptItem()];
        if ($id > 0) {
            $existingModel = InventoryGoodsReceipt::model()->findByPk($id);
            if ($existingModel !== null) {
                $model = $existingModel;
            } else {
                throw new CHttpException(404, 'The requested record does not exist.');
            }
            // ✅ Fetch only items not yet returned (return_stock_ledger_id = 0)
            $criteria = new CDbCriteria();
            $criteria->addCondition('goods_receipt_id = :header_id');
            $criteria->params = [':header_id' => $id];
            $existingIssueItems = InventoryGoodsReceiptItem::model()->findAll($criteria);
            if (!empty($existingIssueItems)) {
                $modelIssueItem = $existingIssueItems;
            }
        }
        Yii::app()->clientScript->scriptMap = ['*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false ];
        // ✅ Render partial view
        $this->renderPartial('create', [ 'model' => $model, 'modelIssueItem' => $modelIssueItem, 'type' => $type ], false, true);
    }

    public function actiongetCustomerShippingdetailsReturn()
    {
        $id = Yii::app()->request->getparam("id");
        $row_index = Yii::app()->request->getParam("row_index", 0);
        $model = new InventoryGoodsIssue();
        $models = CustomerOutletLocation::getShippingLocation($id);
        $drop = '<li class="col-sm-4">';
        $drop .= CHtml::activedropDownList($model, "outlet_id", $models, array('class' => '', 'title' => 'Please Select Outlet', 'data-label' => 'Outlet Location', 'data-search' => true, 'empty' => '--Choose Outlet--'));
        $drop .= '</li>';
        $status = array("dtship" => $drop);
        echo CJSON::encode($status);
    }

    public function actionGetReturnMachines()
    {
        $customer_id = Yii::app()->request->getPost('InventoryGoodsReceipt')['customer_id'] ?? null;
        $outlet_id = (int) Yii::app()->request->getPost('outlet_id') ?? null;
        $criteria = new CDbCriteria();
        $criteria->alias = 't';
        $criteria->addCondition('is_issued = :is_issued');
        $criteria->params[':is_issued'] = 'Y';
        $criteria->addCondition('inventorygoodsissue.issue_type = :issue_type');
        $criteria->params[':issue_type'] = "MH";
        $criteria->addCondition('inventorygoodsissue.customer_id = :customer_id');
        $criteria->params[':customer_id'] = $customer_id;
        if ($outlet_id > 0) {
            $criteria->addCondition('inventorygoodsissue.outlet_id = :outlet_id');
            $criteria->params[':outlet_id'] = $outlet_id;
        }
        $criteria->with = ['inventorygoodsissue', 'location'];
        //$criteria->group = 'inventorygoodsissue.id, t.product_id';
        $machineList = InventoryGoodsIssueItem::model()->findAll($criteria);
        if (empty($machineList)) {
            echo "<div class='alert alert-info'>No machines available for return under this customer and selected lead owner(s).</div>";
            Yii::app()->end();
        }
        $form = new CActiveForm(); // reuse form helpers
        $this->renderPartial('return_machine_table', [ 'machineList' => $machineList, 'form' => $form ], false, true);
    }

    public function actionReturnMachineMultiple()
    {
        $model = new InventoryGoodsReceipt();
        if (!isset($_POST['InventoryGoodsReceipt'])) {
            echo CJSON::encode(['status' => 'error', 'message' => 'Invalid request.']);
            Yii::app()->end();
        }
        $model->attributes = $_POST['InventoryGoodsReceipt'];
        $customer_name = $_POST['InventoryGoodsReceipt']['customer_name'];
        $model_id = $_POST['InventoryGoodsReceipt']['id'];
        $customer_id = (int) $model->customer_id;
        $lead_owner_ids = (array) ($_POST['InventoryGoodsReceipt']['lead_owner_id'] ?? []);
        $lead_owner_id = (int) ($_POST['InventoryGoodsReceipt']['lead_owner_id'] ?? '');
        $outlet_id = $_POST['InventoryGoodsIssue']['outlet_id'];
        $selectedItems = $_POST['InventoryGoodsReceiptItem'] ?? [];
        if (!$customer_name) {
            echo CJSON::encode(['status' => 'error', 'message' => 'No customer selected for return.']);
            Yii::app()->end();
        }
        if (!$lead_owner_id) {
            echo CJSON::encode(['status' => 'error', 'message' => 'No user selected for return.']);
            Yii::app()->end();
        }
        if (!$outlet_id) {
            echo CJSON::encode(['status' => 'error', 'message' => 'No outlet selected for return.']);
            Yii::app()->end();
        }
        if (($selectedItems)) {
            $itemSelected = false;
            foreach ($selectedItems as $id => $item) {
                if (($item['selected'])) {
                    $itemSelected = true;
                    continue;
                }
            }
            if (empty($itemSelected)) {
                echo CJSON::encode(['status' => 'error', 'message' => 'No machines selected for return.']);
                Yii::app()->end();
            }
        } else {
            echo CJSON::encode(['status' => 'error', 'message' => 'No machines selected for return.']);
            Yii::app()->end();
        }
        // Get warehouse (return location)
        $warehouse = MasInventoryWarehouse::model()->getWarehouseIdByCode('RUW');
        $warehouseName = MasInventoryWarehouse::model()->getWarehouseName($warehouse);
        if (!$warehouse) {
            echo CJSON::encode(['status' => 'error', 'message' => 'Return warehouse not configured (RUW missing).']);
            Yii::app()->end();
        }
        $rack = new MasInvRack();
        $bin = new MasInvBin();
        $defaultRackId = $rack->getDefaultRackId();
        $defaultBinId = $bin->getDefaultBinId();


        $modelReceipt = new InventoryGoodsReceipt();
        $modelReceipt->goods_receipt_date = date('Y-m-d');
        $modelReceipt->customer_id = $customer_id;
        $modelReceipt->warehouse_id = $warehouse;
        $modelReceipt->outlet_id = $outlet_id;
        $modelReceipt->reference = 'MACHINE_RETURN';
        $modelReceipt->receipt_type = 'MH';
        $modelReceipt->reference_id = $model->reference_id;
        $modelReceipt->lead_owner_id = $lead_owner_id;
        $modelReceipt->created_by = Yii::app()->user->id;
        $modelReceipt->created_date_time = date('Y-m-d H:i:s');
        if (!$modelReceipt->save(false)) {
            echo '<pre>';
            print_r($modelReceipt->getErrors());
            echo '</pre>';
            Yii::app()->end();
        }
        foreach ($selectedItems as $id => $item) {
            if (($item['selected'])) {
            $modelReceiptItem = new InventoryGoodsReceiptItem();
            if (empty($item['selected'])) {
                continue;
            }
            $machineModel = InventoryGoodsIssueItem::model()->findByPk($id);
            if (!$machineModel) {
                echo CJSON::encode(['status' => 'error', 'message' => "Machine record not found for item ID {$id}."]);
                Yii::app()->end();
            }
            $machineModel->updateByPk($machineModel->id, [
                'is_issued' => 'N',
                'updated_by' => Yii::app()->user->id,
                'updated_date_time' => date('Y-m-d H:i:s'),
            ]);
            
            $SQL = 'SELECT id FROM `erp_stock_ledger` WHERE serial_no = "' . $machineModel->serial_no .'" ORDER BY master_stock_ledger_id DESC LIMIT 1 ';
            $stock_ledger_id = Yii::app()->db->createCommand($SQL)->queryScalar();
            $existingLedger = StockLedger::model()->findByPk($stock_ledger_id);
            if (!$existingLedger) {
                echo CJSON::encode(['status' => 'error', 'message' => "No stock ledger found for machine <b>{$machineModel->serial_no}</b>."]);
                Yii::app()->end();
            }
            $remarks = trim($item['return_remarks']) ? trim($item['return_remarks']) : 'MACHINE_RETURN/'.$machineModel->goods_issue_id.'/'.$existingLedger->customer_vendor_name;
            $return_lead_owner_id = (int) ($item['return_lead_owner_id'] ?? 0);
            if (empty($return_lead_owner_id) && !empty($lead_owner_ids)) {
                $return_lead_owner_id = reset($lead_owner_ids);
            }
            $modelReceiptItem->product_id = $machineModel->product_id;
            $modelReceiptItem->product_name = $machineModel->product_name;
            $modelReceiptItem->description = $machineModel->description;
            $modelReceiptItem->serial_no = $machineModel->serial_no;
            $modelReceiptItem->unit = $machineModel->unit;
            $modelReceiptItem->rate = $machineModel->rate;
            $modelReceiptItem->picked_qty = $machineModel->picked_qty;
            $modelReceiptItem->location_id = $machineModel->location_id;
            $modelReceiptItem->goods_receipt_id = $modelReceipt->id;
            $modelReceiptItem->created_by = Yii::app()->user->id;
            $modelReceiptItem->created_date_time = date('Y-m-d H:i:s');
            if (!$modelReceiptItem->save(false)) {
                echo '<pre>';
                print_r($modelReceiptItem->getErrors());
                echo '</pre>';
                Yii::app()->end();
            }
            // Create stock ledger entry (IN - Return)
            $stock = new StockLedger();
            $stock->attributes = [
                'file_id' => $modelReceipt->id,
                'header_id' => $modelReceipt->id,
                'header_item_id' => $modelReceiptItem->id,
                'customer_vendor_id' => $existingLedger->customer_vendor_id,
                'customer_vendor_name' => $existingLedger->customer_vendor_name,
                'product_id' => $machineModel->product_id,
                'product_name' => $machineModel->product_name,
                'product_description' => $machineModel->description,
                'brand_id' => $existingLedger->brand_id,
                'brand_name' => $existingLedger->brand_name,
                'warehouse_id' => $warehouse,
                'warehouse_name' => $warehouseName,
                'rack_id' => $defaultRackId,
                'rack_name' => $rack->getRackName($defaultRackId),
                'bin_id' => $defaultBinId,
                'bin_name' => $bin->getBinName($defaultBinId),
                'unit_id' => $existingLedger->unit_id,
                'unit_name' => $existingLedger->unit_name,
                'unit_factor' => $existingLedger->unit_factor,
                'quantity' => 1,
                'available_status' => 'A',
                'batch_no' => $existingLedger->batch_no,
                'serial_no' => $machineModel->serial_no,
                'cost_price' => 0,
                'transaction_date' => date('Y-m-d'),
                'transaction_from' => 'MACHINE_RETURN',
                'transaction_type' => 'IN',
                'master_stock_ledger_id' => $existingLedger->id,
                'stock_updated' => 'Y',
                'created_by' => Yii::app()->user->id,
                'created_date' => date('Y-m-d H:i:s'),
                'remarks' => $remarks,
                'lead_owner_id' => $return_lead_owner_id,
            ];
            if (!$stock->save(false)) {
                echo CJSON::encode(['status' => 'error', 'message' => "Failed to save return stock for serial <b>{$machineModel->serial_no}</b>."]);
                Yii::app()->end();
            }
            }
        }
        echo CJSON::encode(['status' => 'success', 'message' => 'Selected machines returned successfully.']);
        Yii::app()->end();
    }

    public function actionView()
    {
        $type = Yii::app()->request->getParam('type');
        $id = (int) Yii::app()->request->getParam('id');
        $model = new InventoryGoodsReceipt();
        $modelIssueItem = [new InventoryGoodsReceiptItem()];
        if ($id > 0) {
            $existingModel = InventoryGoodsReceipt::model()->findByPk($id);
            if ($existingModel !== null) {
                $model = $existingModel;
            } else {
                throw new CHttpException(404, 'The requested record does not exist.');
            }
            // ✅ Fetch only items not yet returned (return_stock_ledger_id = 0)
            $criteria = new CDbCriteria();
            $criteria->addCondition('goods_receipt_id = :header_id');
            $criteria->params = [':header_id' => $id];
            $existingIssueItems = InventoryGoodsReceiptItem::model()->findAll($criteria);
            if (!empty($existingIssueItems)) {
                $modelIssueItem = $existingIssueItems;
            }
        }
        Yii::app()->clientScript->scriptMap = ['*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false ];
        // ✅ Render partial view
        $this->renderPartial('view', [ 'model' => $model, 'modelIssueItem' => $modelIssueItem, 'type' => $type ], false, true);
    }

    public function actiongetReturnMachinesByLeadOwner()
    {
        $model = new InventoryDirectTransfer();
        $model_items = array(new InventoryDirectTransferItem());
        $warehouse_id = Yii::app()->request->getPost('warehouse_id') ?? null;
        $lead_owner_id = (int) Yii::app()->request->getPost('lead_owner_id') ?? null;
        $criteria = new CDbCriteria();
        $criteria->alias = 't';
        $criteria->addCondition('is_received = :is_received');
        $criteria->params[':is_received'] = 'N';
        $criteria->addCondition('inventorygoodsreceipt.receipt_type = :receipt_type');
        $criteria->params[':receipt_type'] = "MH";
        $criteria->addCondition('inventorygoodsreceipt.warehouse_id = :warehouse_id');
        $criteria->params[':warehouse_id'] = $warehouse_id;
        if ($lead_owner_id > 0) {
            $criteria->addCondition('inventorygoodsreceipt.lead_owner_id = :lead_owner_id');
            $criteria->params[':lead_owner_id'] = $lead_owner_id;
        }
        // ✅ Handle multiple lead owners
        $criteria->with = ['inventorygoodsreceipt', 'location'];
        $criteria->group = 'inventorygoodsreceipt.id, t.product_id';
        $machineList = InventoryGoodsReceiptItem::model()->findAll($criteria);
        if (empty($machineList)) {
            echo "<div class='alert alert-info'>No machines available for return under this customer and selected lead owner(s).</div>";
            Yii::app()->end();
        }
        foreach ($machineList as $mKey => $machine) {
            $modelProduct = Store::model()->findByPk($machine->product_id);
            $model_items[$mKey]->item_id = $machine->product_id;
            $model_items[$mKey]->item_name = $machine->product_name;
            $model_items[$mKey]->item_description = $machine->description;
            $model_items[$mKey]->transfer_qty = $machine->picked_qty;
            $model_items[$mKey]->available_qty = $machine->picked_qty;
            $model_items[$mKey]->unit = $machine->unit;
            $model_items[$mKey]->bar_code = $modelProduct->bar_code;
        }
        $form = new CActiveForm(); // reuse form helpers
        $this->renderPartial('transfer_machine_table', [ 'model' => $model, 'model_items' => $model_items, 'form' => $form ], false, true);
    }

    public function actionApprove()
    {
        $type = Yii::app()->request->getParam('type');
        $id = (int) Yii::app()->request->getParam('id');
        $model = new InventoryGoodsReceipt();
        $modelIssueItem = [new InventoryGoodsReceiptItem()];
        if ($id > 0) {
            $existingModel = InventoryGoodsReceipt::model()->findByPk($id);
            if ($existingModel !== null) {
                $model = $existingModel;
            } else {
                throw new CHttpException(404, 'The requested record does not exist.');
            }
            // ✅ Fetch only items not yet returned (return_stock_ledger_id = 0)
            $criteria = new CDbCriteria();
            $criteria->addCondition('goods_receipt_id = :header_id');
            $criteria->params = [':header_id' => $id];
            $existingIssueItems = InventoryGoodsReceiptItem::model()->findAll($criteria);
            if (!empty($existingIssueItems)) {
                $modelIssueItem = $existingIssueItems;
            }
        }
        Yii::app()->clientScript->scriptMap = ['*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false ];
        // ✅ Render partial view
        $this->renderPartial('approve', [ 'model' => $model, 'modelIssueItem' => $modelIssueItem, 'type' => $type ], false, true);
    }

    public function actionSaveApprovel()
    {
        $selectedItems = $_POST['InventoryGoodsReceiptItem'] ?? [];
        if (($selectedItems)) {
            $itemSelected = false;
            foreach ($selectedItems as $id => $item) {
                if (($item['selected'])) {
                    $itemSelected = true;
                    continue;
                }
            }
            if (empty($itemSelected)) {
                echo CJSON::encode(['status' => 'error', 'message' => 'No machines selected for approval.']);
                Yii::app()->end();
            }
        } else {
            echo CJSON::encode(['status' => 'error', 'message' => 'No machines selected for approval.']);
            Yii::app()->end();
        }
        // Get warehouse (return location)
        $warehouse = MasInventoryWarehouse::model()->getWarehouseIdByCode('UW');
        $warehouseName = MasInventoryWarehouse::model()->getWarehouseName($warehouse);
        if (!$warehouse) {
            echo CJSON::encode(['status' => 'error', 'message' => 'Return warehouse not configured (UW missing).']);
            Yii::app()->end();
        }
        $rack = new MasInvRack();
        $bin = new MasInvBin();
        $defaultRackId = $rack->getDefaultRackId();
        $defaultBinId = $bin->getDefaultBinId();
        $model = new InventoryGoodsReceipt();
        $model_id = $_POST['InventoryGoodsReceipt']['id'];
        $modelReceipt = InventoryGoodsReceipt::model()->findByPk($model_id);
        foreach ($selectedItems as $id => $item) {
            if (($item['selected'])) {
                $modelReceiptItem = new InventoryGoodsReceiptItem();
                if (empty($item['selected'])) {
                    continue;
                }
                $modelReceiptItem = InventoryGoodsReceiptItem::model()->findByPk($item['selected']);
                if (!$modelReceiptItem) {
                    echo CJSON::encode(['status' => 'error', 'message' => "Machine record not found for item ID {$item['selected']}."]);
                    Yii::app()->end();
                }
                $modelReceiptItem->updateByPk($modelReceiptItem->id, [
                    'isApproved' => 'Y',
                    'approved_by' => Yii::app()->user->id,
                    'approved_date_time' => date('Y-m-d H:i:s'),
                ]);
                $SQL = 'SELECT id FROM `erp_stock_ledger` WHERE serial_no = "' . $modelReceiptItem->serial_no .'" ORDER BY  master_stock_ledger_id DESC LIMIT 1 ';
                $stock_ledger_id = Yii::app()->db->createCommand($SQL)->queryScalar();
                $existingLedger = StockLedger::model()->findByPk($stock_ledger_id);
                if (!$existingLedger) {
                    echo CJSON::encode(['status' => 'error', 'message' => "No stock ledger found for machine <b>{$modelReceiptItem->serial_no}</b>."]);
                    Yii::app()->end();
                }
                $process_status = 'MACHINE_RETURN_APPROVED';
                $remarks = trim($item['return_remarks']) ? trim($item['return_remarks']) : $process_status.'/'.$modelReceiptItem->goods_receipt_id.'/'.$existingLedger->customer_vendor_name;
                $return_lead_owner_id = $modelReceipt->lead_owner_id;

                //InventoryDirectTransfer
                $modelDirectTransfer = new InventoryDirectTransfer();
                $modelDirectTransfer->from_warehouse_id = $modelReceipt->warehouse_id;
                $modelDirectTransfer->to_warehouse_id = $warehouse;
                $modelDirectTransfer->lead_owner_id = $return_lead_owner_id;
                $modelDirectTransfer->direct_transfer_description = $remarks;
                $modelDirectTransfer->reference = $process_status;
                $modelDirectTransfer->transfer_date = date('Y-m-d');
                $modelDirectTransfer->status = 'C';
                $modelDirectTransfer->added_from = 'DT';
                $modelDirectTransfer->type = 'T';
                $modelDirectTransfer->file_id = $modelReceipt->id;
                if (!$modelDirectTransfer->save(false)) {
                    echo '<pre>';
                    print_r($modelDirectTransfer->getErrors());
                    echo '</pre>';
                    Yii::app()->end();
                }
                $modelDirectTransferItem = new InventoryDirectTransferItem();
                $modelDirectTransferItem->direct_transfer_id = $modelDirectTransfer->id;
                $modelDirectTransferItem->item_id = $modelReceiptItem->product_id;
                $modelDirectTransferItem->item_name = $modelReceiptItem->product_name;
                $modelDirectTransferItem->item_description = $modelReceiptItem->description;
                $modelDirectTransferItem->transfer_qty = $modelReceiptItem->picked_qty;
                $modelDirectTransferItem->unit = $modelReceiptItem->unit;
                $modelDirectTransferItem->file_id = $modelReceiptItem->id;
                if (!$modelDirectTransferItem->save(false)) {
                    echo '<pre>';
                    print_r($modelDirectTransferItem->getErrors());
                    echo '</pre>';
                    Yii::app()->end();
                }
                // Create stock ledger entry (OUT - From Van Used Warehouse to Used Warehouse)
                $stock = new StockLedger();
                $stock->attributes = [
                    'file_id' => $modelReceipt->id,
                    'header_id' => $modelReceipt->id,
                    'header_item_id' => $modelReceiptItem->id,
                    'customer_vendor_id' => $existingLedger->customer_vendor_id,
                    'customer_vendor_name' => $existingLedger->customer_vendor_name,
                    'product_id' => $modelReceiptItem->product_id,
                    'product_name' => $modelReceiptItem->product_name,
                    'product_description' => $modelReceiptItem->description,
                    'brand_id' => $existingLedger->brand_id,
                    'brand_name' => $existingLedger->brand_name,
                    'warehouse_id' => $modelReceipt->warehouse_id,
                    'warehouse_name' => MasInventoryWarehouse::model()->getWarehouseName($modelReceipt->warehouse_id),
                    'rack_id' => $defaultRackId,
                    'rack_name' => $rack->getRackName($defaultRackId),
                    'bin_id' => $defaultBinId,
                    'bin_name' => $bin->getBinName($defaultBinId),
                    'unit_id' => $existingLedger->unit_id,
                    'unit_name' => $existingLedger->unit_name,
                    'unit_factor' => $existingLedger->unit_factor,
                    'quantity' => 1,
                    'available_status' => 'U',
                    'batch_no' => $existingLedger->batch_no,
                    'serial_no' => $modelReceiptItem->serial_no,
                    'cost_price' => 0,
                    'transaction_date' => date('Y-m-d'),
                    'transaction_from' => $process_status,
                    'transaction_type' => 'OUT',
                    'master_stock_ledger_id' => $existingLedger->id,
                    'stock_updated' => 'Y',
                    'created_by' => Yii::app()->user->id,
                    'created_date' => date('Y-m-d H:i:s'),
                    'remarks' => $remarks,
                    'lead_owner_id' => $return_lead_owner_id,
                ];
                if (!$stock->save(false)) {
                    echo CJSON::encode(['status' => 'error', 'message' => "Failed to save approval stock out for serial <b>{$modelReceiptItem->serial_no}</b>."]);
                    Yii::app()->end();
                }
                // Create stock ledger entry (IN - From Van Used Warehouse to Used Warehouse)
                $stock = new StockLedger();
                $stock->attributes = [
                    'file_id' => $modelReceipt->id,
                    'header_id' => $modelReceipt->id,
                    'header_item_id' => $modelReceiptItem->id,
                    'customer_vendor_id' => $existingLedger->customer_vendor_id,
                    'customer_vendor_name' => $existingLedger->customer_vendor_name,
                    'product_id' => $modelReceiptItem->product_id,
                    'product_name' => $modelReceiptItem->product_name,
                    'product_description' => $modelReceiptItem->description,
                    'brand_id' => $existingLedger->brand_id,
                    'brand_name' => $existingLedger->brand_name,
                    'warehouse_id' => $warehouse,
                    'warehouse_name' => $warehouseName,
                    'rack_id' => $defaultRackId,
                    'rack_name' => $rack->getRackName($defaultRackId),
                    'bin_id' => $defaultBinId,
                    'bin_name' => $bin->getBinName($defaultBinId),
                    'unit_id' => $existingLedger->unit_id,
                    'unit_name' => $existingLedger->unit_name,
                    'unit_factor' => $existingLedger->unit_factor,
                    'quantity' => 1,
                    'available_status' => 'A',
                    'batch_no' => $existingLedger->batch_no,
                    'serial_no' => $modelReceiptItem->serial_no,
                    'cost_price' => 0,
                    'transaction_date' => date('Y-m-d'),
                    'transaction_from' => $process_status,
                    'transaction_type' => 'IN',
                    'master_stock_ledger_id' => $existingLedger->id,
                    'stock_updated' => 'Y',
                    'created_by' => Yii::app()->user->id,
                    'created_date' => date('Y-m-d H:i:s'),
                    'remarks' => $remarks,
                    'lead_owner_id' => '',
                ];
                if (!$stock->save(false)) {
                    echo CJSON::encode(['status' => 'error', 'message' => "Failed to save approval stock in for serial <b>{$modelReceiptItem->serial_no}</b>."]);
                    Yii::app()->end();
                }
            }
        }
        echo CJSON::encode(['status' => 'success', 'message' => 'Selected machines approved successfully.']);
        Yii::app()->end();


        
        var_dump($_POST);
        exit;
        /*$model = new InventoryGoodsReceipt();
        if (!isset($_POST['InventoryGoodsReceipt'])) {
            echo CJSON::encode(['status' => 'error', 'message' => 'Invalid request.']);
            Yii::app()->end();
        }
        $model->attributes = $_POST['InventoryGoodsReceipt'];*/
        //$customer_name = $_POST['InventoryGoodsReceipt']['customer_name'];
        //$model_id = $_POST['InventoryGoodsReceipt']['id'];
        //$customer_id = (int) $model->customer_id;
        //$lead_owner_ids = (array) ($_POST['InventoryGoodsReceipt']['lead_owner_id'] ?? []);
        //$lead_owner_id = (int) ($_POST['InventoryGoodsReceipt']['lead_owner_id'] ?? '');
        //$outlet_id = $_POST['InventoryGoodsIssue']['outlet_id'];
        
        // if (!$customer_name) {
        //     echo CJSON::encode(['status' => 'error', 'message' => 'No customer selected for return.']);
        //     Yii::app()->end();
        // }
        // if (!$lead_owner_id) {
        //     echo CJSON::encode(['status' => 'error', 'message' => 'No user selected for return.']);
        //     Yii::app()->end();
        // }
        // if (!$outlet_id) {
        //     echo CJSON::encode(['status' => 'error', 'message' => 'No outlet selected for return.']);
        //     Yii::app()->end();
        // }
        
        
        


        /*$modelReceipt = new InventoryGoodsReceipt();
        $modelReceipt->goods_receipt_date = date('Y-m-d');
        $modelReceipt->customer_id = $customer_id;
        $modelReceipt->warehouse_id = $warehouse;
        $modelReceipt->outlet_id = $outlet_id;
        $modelReceipt->reference = 'MACHINE_RETURN';
        $modelReceipt->receipt_type = 'MH';
        $modelReceipt->reference_id = $model->reference_id;
        $modelReceipt->lead_owner_id = $lead_owner_id;
        $modelReceipt->created_by = Yii::app()->user->id;
        $modelReceipt->created_date_time = date('Y-m-d H:i:s');
        if (!$modelReceipt->save(false)) {
            echo '<pre>';
            print_r($modelReceipt->getErrors());
            echo '</pre>';
            Yii::app()->end();
        }*/
        foreach ($selectedItems as $id => $item) {
            if (($item['selected'])) {
            // $modelReceiptItem = new InventoryGoodsReceiptItem();
            // if (empty($item['selected'])) {
            //     continue;
            // }
            // $machineModel = InventoryGoodsIssueItem::model()->findByPk($id);
            // if (!$machineModel) {
            //     echo CJSON::encode(['status' => 'error', 'message' => "Machine record not found for item ID {$id}."]);
            //     Yii::app()->end();
            // }
            // $machineModel->updateByPk($machineModel->id, [
            //     'is_issued' => 'N',
            //     'updated_by' => Yii::app()->user->id,
            //     'updated_date_time' => date('Y-m-d H:i:s'),
            // ]);
            
            // $SQL = 'SELECT id FROM `erp_stock_ledger` WHERE serial_no = "' . $machineModel->serial_no .'" ORDER BY master_stock_ledger_id DESC LIMIT 1 ';
            // $stock_ledger_id = Yii::app()->db->createCommand($SQL)->queryScalar();
            // $existingLedger = StockLedger::model()->findByPk($stock_ledger_id);
            // if (!$existingLedger) {
            //     echo CJSON::encode(['status' => 'error', 'message' => "No stock ledger found for machine <b>{$machineModel->serial_no}</b>."]);
            //     Yii::app()->end();
            // }
            // $remarks = trim($item['return_remarks']) ? trim($item['return_remarks']) : 'MACHINE_RETURN/'.$machineModel->goods_issue_id.'/'.$existingLedger->customer_vendor_name;
            // $return_lead_owner_id = (int) ($item['return_lead_owner_id'] ?? 0);
            // if (empty($return_lead_owner_id) && !empty($lead_owner_ids)) {
            //     $return_lead_owner_id = reset($lead_owner_ids);
            // }
            $modelReceiptItem->product_id = $machineModel->product_id;
            $modelReceiptItem->product_name = $machineModel->product_name;
            $modelReceiptItem->description = $machineModel->description;
            $modelReceiptItem->serial_no = $machineModel->serial_no;
            $modelReceiptItem->unit = $machineModel->unit;
            $modelReceiptItem->rate = $machineModel->rate;
            $modelReceiptItem->picked_qty = $machineModel->picked_qty;
            $modelReceiptItem->location_id = $machineModel->location_id;
            $modelReceiptItem->goods_receipt_id = $modelReceipt->id;
            $modelReceiptItem->created_by = Yii::app()->user->id;
            $modelReceiptItem->created_date_time = date('Y-m-d H:i:s');
            if (!$modelReceiptItem->save(false)) {
                echo '<pre>';
                print_r($modelReceiptItem->getErrors());
                echo '</pre>';
                Yii::app()->end();
            }
            // // Create stock ledger entry (IN - Return)
            // $stock = new StockLedger();
            // $stock->attributes = [
            //     'file_id' => $modelReceipt->id,
            //     'header_id' => $modelReceipt->id,
            //     'header_item_id' => $modelReceiptItem->id,
            //     'customer_vendor_id' => $existingLedger->customer_vendor_id,
            //     'customer_vendor_name' => $existingLedger->customer_vendor_name,
            //     'product_id' => $machineModel->product_id,
            //     'product_name' => $machineModel->product_name,
            //     'product_description' => $machineModel->description,
            //     'brand_id' => $existingLedger->brand_id,
            //     'brand_name' => $existingLedger->brand_name,
            //     'warehouse_id' => $warehouse,
            //     'warehouse_name' => $warehouseName,
            //     'rack_id' => $defaultRackId,
            //     'rack_name' => $rack->getRackName($defaultRackId),
            //     'bin_id' => $defaultBinId,
            //     'bin_name' => $bin->getBinName($defaultBinId),
            //     'unit_id' => $existingLedger->unit_id,
            //     'unit_name' => $existingLedger->unit_name,
            //     'unit_factor' => $existingLedger->unit_factor,
            //     'quantity' => 1,
            //     'available_status' => 'A',
            //     'batch_no' => $existingLedger->batch_no,
            //     'serial_no' => $machineModel->serial_no,
            //     'cost_price' => 0,
            //     'transaction_date' => date('Y-m-d'),
            //     'transaction_from' => 'MACHINE_RETURN',
            //     'transaction_type' => 'IN',
            //     'master_stock_ledger_id' => $existingLedger->id,
            //     'stock_updated' => 'Y',
            //     'created_by' => Yii::app()->user->id,
            //     'created_date' => date('Y-m-d H:i:s'),
            //     'remarks' => $remarks,
            //     'lead_owner_id' => $return_lead_owner_id,
            // ];
            // if (!$stock->save(false)) {
            //     echo CJSON::encode(['status' => 'error', 'message' => "Failed to save return stock for serial <b>{$machineModel->serial_no}</b>."]);
            //     Yii::app()->end();
            // }
            }
        }
        // echo CJSON::encode(['status' => 'success', 'message' => 'Selected machines returned successfully.']);
        // Yii::app()->end();
    }

    public function actionApprove_26_11_26()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new InventoryGoodsReceipt();
        $model = $model->findByPk($id);
        $model->isApproved = "Y";
        $model->approved_by = Yii::app()->user->id;
        $model->approved_date_time = date('Y-m-d H:i:s');
        $model->save(false);
        echo json_encode(array("status" => "success"));
    }

    public function actionPrintMachine()
    {
        $model = new InventoryGoodsReceipt();
        $id = Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = new InventoryGoodsReceipt();
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.returned_machine', array('model' => $model, 'id' => $id, 'title' => $title), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionGetListApproved()
    {
        $model = new InventoryGoodsReceiptItem();
        $draw = (int) $_POST['draw'];
        $offset = (int) $_POST['start'];
        $limit = (int) $_POST['length'];
        $columns = [
            0 => 't.id',
            1 => 'inventorygoodsreceipt.id',
            2 => 'inventorygoodsreceipt.customer_id',
            3 => 'inventorygoodsreceipt.lead_owner_id',
            4 => 'inventorygoodsreceipt.outlet_id',
            5 => 't.serial_no',
            6 => 't.product_name',
            7 => 'inventorygoodsreceipt.goods_receipt_date',
            8 => 't.approved_by',
            9 => 't.approved_date_time'
        ];
        $orderColumnIndex = (int) $_POST['order'][0]['column'];
        $orderDirection = $_POST['order'][0]['dir'] === 'desc' ? 'DESC' : 'ASC';
        $orderBy = 't.id DESC';
        $condition = " inventorygoodsreceipt.receipt_type = 'MH' AND t.isApproved = 'Y' ";
        if (Yii::app()->user->authorised_user != 1) {
            $condition .= ' AND (inventorygoodsreceipt.lead_owner_id = "' . Yii::app()->user->id . '" OR t.created_by = "' . Yii::app()->user->id . '")';
        }
        $params = array();
        if (!empty($_POST['search']['value'])) {
            $search = trim($_POST['search']['value']);
            $condition .= " AND (t.serial_no LIKE :search)";
            $params[':search'] = '%' . $search . '%';
        }
        $criteria = new CDbCriteria;
        $criteria->condition = $condition;
        $criteria->params = $params;
        $criteria->limit = $limit;
        $criteria->offset = $offset;
        $criteria->order = $orderBy;
        $criteria->with = array('inventorygoodsreceipt');//inventorygoodsreceipt
        $criteria->together = true;
        $recordsTotal = $model->count($criteria);
        $rows = $model->findAll($criteria);
        $data = array();
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsTotal;
        $rowData = array();
        $m = 1;
        foreach ($rows as $row) {
            $buttons = '<button title="View" class="btn btn-primary btn-xs" onclick="viewReturn(' . $row->inventorygoodsreceipt->id . ')"><i class="fa fa-eye"></i></button> ';
            /*if ($row->isApproved == 'N') {
                $buttons .= '<button title="Approve" class="btn btn-primary btn-xs" onclick="approveReturn(' . $row->inventorygoodsreceipt->id . ')"><i class="fa fa-check"></i></button> ';
            }*/
            $buttons .= '<button title="Print" class="btn btn-primary btn-xs" onclick="printReturn(' . $row->inventorygoodsreceipt->id . ')"><i class="fa fa-print"></i></button>';
            $rowData[] = array(
                $m,
                $row->inventorygoodsreceipt->id,
                isset($row->inventorygoodsreceipt->customer_id) ? $row->inventorygoodsreceipt->customer->customer_name : '',
                isset($row->inventorygoodsreceipt->lead_owner_id) ? $row->inventorygoodsreceipt->owner->first_name . ' ' . $row->inventorygoodsreceipt->owner->last_name : '',
                isset($row->inventorygoodsreceipt->outlet_id) ? $row->inventorygoodsreceipt->outlet->outlet_location : '',
                isset($row->serial_no) ? $row->serial_no : '',
                isset($row->product_name) ? $row->product_name : '',
                isset($row->inventorygoodsreceipt->goods_receipt_date) ? date('d/m/Y', strtotime($row->inventorygoodsreceipt->goods_receipt_date)) : '',
                isset($row->approved_by) ? $row->approver->first_name . ' ' . $row->approver->last_name : '',
                isset($row->approved_date_time) ? date('d/m/Y', strtotime($row->approved_date_time)) : '',
                '<div class="btn-wrap">' . $buttons . '</div>',
                $row->inventorygoodsreceipt->isActive,
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
}