<?php

class InventorygoodsissueController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'GetList',
                    'Create',
                    'GetInvoiceDropdown',
                    'getCustomerShippingdetails',
                    'getOutletLocationDetails',
                    'GetLeadownerMachineDetails',
                    'GetLeadownerMachineDetailsbyserailNo',
                    'Save',


                    'Indexmeterial',
                    'GetListMeterial',
                    'CreateMeterial'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public $title = "Service Customer Machine";
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex()
    {
        $this->render('index');
    }

    public function actionGetList()
    {
        $model = new InventoryGoodsIssue();
        $draw = (int) $_POST['draw'];
        $offset = (int) $_POST['start'];
        $limit = (int) $_POST['length'];
        $columns = array(
            0 => 't.id',
            1 => 't.customer_id',
            2 => 'items.serial_no',
            3 => 't.lead_owner_id',
        );
        $orderColumnIndex = (int) $_POST['order'][0]['column'];
        $orderDirection = $_POST['order'][0]['dir'] === 'desc' ? 'DESC' : 'ASC';
        $orderBy = 't.id DESC';
        // ======================
        // ✅ Base condition
        // ======================
        $condition = " t.issue_type = 'MH' AND items.is_issued = 'Y' ";
        //$condition = 't.return_stock_ledger_id = 0 AND t.is_return_fully = "N"';
        if (Yii::app()->user->authorised_user != 1) {
            $condition .= ' AND (t.lead_owner_id = "' . Yii::app()->user->id . '" OR t.created_by = "' . Yii::app()->user->id . '")';
        }
        $params = array();
        // ======================
        // ✅ Global Search Filter
        // ======================
        if (!empty($_POST['search']['value'])) {
            $search = trim($_POST['search']['value']);
            $condition .= " AND (items.serial_no LIKE :search)";
            $params[':search'] = '%' . $search . '%';
        }
        // ======================
        // ✅ Fetch paginated records
        // ======================
        $criteria = new CDbCriteria;
        $criteria->condition = $condition;
        $criteria->params = $params;
        $criteria->limit = $limit;
        $criteria->offset = $offset;
        $criteria->order = $orderBy;
        $criteria->with = array('customer', 'items','outlet','owner');
        $criteria->together = true;
        $recordsTotal = $model->count($criteria);
        $rows = $model->findAll($criteria);
        // ======================
        // ✅ Build DataTable JSON
        // ======================
        $data = array();
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsTotal;
        $rowData = array();
        $m = 1;
        foreach ($rows as $row) {
            $buttons = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["machine_issue_view"])) {
                $buttons .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'sales/Inventorygoodsissue/create&type=view&id=' . $row->id . '\',\'View Machine\',\'xl\')"><i class="fa fa-eye"></i></button>';
            }
            $sales_group_id = Order::model()->findByPk($row->production_order_id)->sales_group_id;
            $rowData[] = array(
                $m,
                isset($row->customer) ? $row->customer->customer_name : '',
                isset($row->lead_owner_id) ? $row->owner->first_name . ' ' . $row->owner->last_name : '',
                isset($row->outlet_id) ? $row->outlet->outlet_location : '',
                isset($sales_group_id) ? MasSalesGroup::model()->findByPk($sales_group_id)->group_name: '',
                '<div class="btn-wrap">' . $buttons . '</div>',
                $row->isActive,
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate()
    {
        $type = Yii::app()->request->getParam('type');
        $id = (int) Yii::app()->request->getParam('id');
        $model = new InventoryGoodsIssue();
        $modelIssueItem = [new InventoryGoodsIssueItem()];
        if ($id > 0) {
            $existingModel = InventoryGoodsIssue::model()->findByPk($id);
            if ($existingModel !== null) {
                $model = $existingModel;
                $sales_group_id = Order::model()->findByPk($existingModel->production_order_id)->sales_group_id;
                $model->issue_type = $sales_group_id;
            } else {
                throw new CHttpException(404, 'The requested record does not exist.');
            }
            // Condition based on type
            $criteria = new CDbCriteria();
            $criteria->addCondition('goods_issue_id = :goods_issue_id');
            $criteria->params[':goods_issue_id'] = $id;
            $existingIssueItems = InventoryGoodsIssueItem::model()->findAll($criteria);
            if (!empty($existingIssueItems)) {
                $modelIssueItem = $existingIssueItems;
            }
        }
        // Prevent double inclusion of JS
        Yii::app()->clientScript->scriptMap = ['*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false];
        // Render partial with correct data
        $this->renderPartial( 'create', [ 'model' => $model, 'modelIssueItem' => $modelIssueItem, 'type' => $type ], false, true );
    }

    public function actionGetInvoiceDropdown()
    {
        $customer_id = Yii::app()->request->getParam('customer_id');
        $lead_owner_id = Yii::app()->request->getParam('lead_owner_id');
        $type_of_invoice = Yii::app()->request->getParam('type_of_invoice', 'service');
        $row_index = Yii::app()->request->getParam('row_index', 0); // for form indexing
        $warehouse_id = (int) Yii::app()->user->getState('user_warehouse_id');
        $condition = '1=1';
        /*if ((int) Yii::app()->user->authorised_user != 1 && $warehouse_id > 0) {
            $condition .= ' AND warehouse_id=' . $warehouse_id;
        }*/
        if ((int) $customer_id > 0) {
            $condition .= ' AND customer_id=' . $customer_id;
        }
        if (!empty($type_of_invoice)) {
            $condition .= ' AND order_type="' . $type_of_invoice . '"';
        }
        // Fetch invoices
        $modelInvoice = new Order();
        $invoices = $modelInvoice->findAll([
            'select' => 'id,file_id,sales_group_id,lead_owner_id',
            'condition' => $condition,
            'limit' => 200
        ]);
        // Prepare array for dropdown
        $invoiceArray = [];
        $salesGroupMap = [];
        $assignedUser = [];
        foreach ($invoices as $invoice) {
            $invoiceArray[$invoice->id] = $invoice->file_id . ' : ' . $invoice->id;
            $salesGroupMap[$invoice->id] = $invoice->sales_group_id;
            $assignedUser[$invoice->id] = $invoice->lead_owner_id;
        }
        // Create active dropdown
        $model = new InventoryGoodsIssue(); // or your form model that holds invoice_id
        $dropInvoice = '<li class="col-sm-2">';
        $dropInvoice .= CHtml::activeDropDownList(
            $model,
            "file_id",
            $invoiceArray,
            [
                'empty' => '-Select Order-',
                'class' => 'invoice-dropdown',
                'title' => 'Please select Order',
                'data-label' => 'Service Order',
                'data-search' => true,
                'onChange' => 'getMachineDetailsList();changeType(this)',
            ]
        );
        $dropInvoice .= '</li>';
        echo CJSON::encode(['dropdown' => $dropInvoice, 'sales_groups' => $salesGroupMap, 'assigned_users' => $assignedUser]);
        Yii::app()->end();
    }

    public function actiongetCustomerShippingdetails()
    {
        $id = Yii::app()->request->getparam("id");
        $row_index = Yii::app()->request->getParam("row_index", 0);
        $model = new InventoryGoodsIssue();
        $models = CustomerOutletLocation::getShippingLocation($id);
        $drop = '<li class="col-sm-2">';
        $drop .= CHtml::activedropDownList($model, "outlet_id", $models, array('class' => '', 'title' => 'Please Select Outlet', 'data-label' => 'Outlet Location', 'data-search' => true, 'onChange' => 'js:getOutletLocationDetails(this);'));
        $drop .= '</li>';
        $status = array("dtship" => $drop);
        echo CJSON::encode($status);
    }

    public function actiongetOutletLocationDetails()
    {
        $customer_id = Yii::app()->request->getparam("customer_id");
        $outlet_id = Yii::app()->request->getparam("outlet_id");
        $row_index = Yii::app()->request->getParam("row_index", 0);
        $model = new InventoryGoodsIssueItem;
        $customerlocationarray = ServiceCustomerLocation::getLocationCustomerByOutlet($customer_id, $outlet_id);
        $droploc = CHtml::activedropDownList($model, "[$row_index]location_id", $customerlocationarray, array('empty' => 'Select', 'class' => 'form-control machine-dropdown', 'title' => 'Please Select Location', 'data-label' => 'Location <span style="color:red">*</span>', 'data-search' => true, 'empty' => '-select-'));
        $status = array("dtloc" => $droploc);
        echo CJSON::encode($status);
    }

    public function actionGetLeadownerMachineDetails()
    {
        $lead_owner_id = Yii::app()->request->getParam("lead_owner_id");
        $customer_id = Yii::app()->request->getParam("customer_id");
        $file_id = Yii::app()->request->getParam("file_id");
        $row_index = Yii::app()->request->getParam("row_index", 0);
        $filter_text = Yii::app()->request->getParam("filter_text", ''); // optional filter term
        // 1. Get product IDs for this file
        $productIds = OrderItem::getProductIds($file_id);
        // 2. Get all available machine serial numbers
        $leadownermachinearray = array();
        if (!empty($file_id)) {
            $leadownermachinearray = StockLedger::getLeadownerMachineSerialnoByleadownerid($productIds, $lead_owner_id);
        }
        // 3. Apply filter if any (case-insensitive search)
        if (!empty($filter_text)) {
            $leadownermachinearray = array_filter($leadownermachinearray, function ($value) use ($filter_text) {
                return stripos($value, $filter_text) !== false;
            });
        }
        // 4. Build dropdown
        $model = new InventoryGoodsIssueItem;
        $drop = CHtml::activeDropDownList(
            $model,
            "[$row_index]serial_no",
            $leadownermachinearray,
            [
                'empty' => '--Select--',
                'class' => 'form-control machine-dropdown serial-dropdown',
                'title' => 'Please Select Serial No',
                'data-label' => 'Machine Serial No <span style="color:red">*</span>',
                'data-search' => true,
                'onchange' => 'leadownerMachinesdetails(this);',
            ]
        );
        echo CJSON::encode([
            'status' => 'success',
            'dt' => $drop,
        ]);
    }

    public function actionGetLeadownerMachineDetailsbyserailNo()
    {
        $lead_owner_id = Yii::app()->request->getParam("lead_owner_id");
        $serial_id = Yii::app()->request->getParam("serial_id");
        $row_index = Yii::app()->request->getParam("row_index", 0);

        $machineData = StockLedger::getLeadownerMachinebySerialno($serial_id);
        $machineName = '';
        $machineId = '';
        if (!empty($machineData) && is_array($machineData)) {
            // get first key/value pair (product_id => product_name)
            $machineId = key($machineData);
            $machineName = current($machineData);
        }
        // Model instance for indexed form binding
        $model = new InventoryGoodsIssueItem;
        // readonly text field for display
        $textField = CHtml::activeTextField(
            $model,
            "[$row_index]product_name",
            [
                'class' => 'form-control',
                'title' => 'Machine',
                'data-label' => 'Machine <span style="color:red">*</span>',
                'value' => $machineName,
                'readonly' => true,
            ]
        );
        // hidden field for actual machine_id
        $hiddenField = CHtml::activeHiddenField(
            $model,
            "[$row_index]product_id",
            ['value' => $machineId]
        );
        echo CJSON::encode([
            'status' => 'success',
            'dt' => $textField . $hiddenField, // append both fields
        ]);
    }

    public function actionSave()
    {
        $model = new InventoryGoodsIssue();
        $valid = true;
        $other = [];
        if (isset($_POST['InventoryGoodsIssue'])) {
            $id = (int) @$_POST['InventoryGoodsIssue']['id'];
            $isUpdate = $id > 0;
            if ($isUpdate) {
                $model = InventoryGoodsIssue::model()->findByPk($id);
                if (!$model) {
                    echo CJSON::encode(['status' => 'error', 'message' => 'Record not found']);
                    Yii::app()->end();
                }
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
                $audit_type = 'UPDATED';
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $audit_type = 'CREATED';
            }
            $model->goods_issue_date = date('Y-m-d');
            $model->issue_type = 'MH';
            /*** Manual mapping ***/
            $model->customer_id = $_POST['InventoryGoodsIssue']['customer_id'];
            $model->outlet_id = $_POST['InventoryGoodsIssue']['outlet_id'];
            $model->lead_owner_id = $_POST['InventoryGoodsIssue']['lead_owner_id'];
            $model->file_id = $_POST['InventoryGoodsIssue']['file_id'];
            $model->production_order_id = $_POST['InventoryGoodsIssue']['file_id'];
            $model->reference = 'MACHINE_ISSUE';
            if (empty($model->lead_owner_id)) {
                echo CJSON::encode([
                    'status' => 'error',
                    'message' => 'Salesman cannot be blank'
                ]);
                Yii::app()->end();
            }
            $itemRows = $_POST['InventoryGoodsIssueItem'] ?? [];
            if (empty($itemRows)) {
                echo CJSON::encode([
                    'status' => 'error',
                    'message' => 'No machine items found.'
                ]);
                Yii::app()->end();
            }
            $itemModels = [];
            $stockLedgers = [];
            /*** Validate and Prepare Each Item ***/
            foreach ($itemRows as $i => $itemData) {
                $machine_id = (int) ($itemData['product_id'] ?? 0);
                $serial_no_input = $itemData['serial_no'] ?? null;
                $modelStore = $machine_id ? Store::model()->findByPk($machine_id) : null;
                if (!$modelStore) {
                    echo CJSON::encode([
                        'status' => 'error',
                        'message' => "Invalid product selected at row " . ($i + 1)
                    ]);
                    Yii::app()->end();
                }
                if ((int) $itemData['location_id'] <= 0) {
                    echo CJSON::encode([
                        'status' => 'error',
                        'message' => "Please enter location for row " . ($i + 1)
                    ]);
                    Yii::app()->end();
                }
                // stock_ledger_id is passed as serial_no in the submitted data
                $stock_ledger_id = (int) $serial_no_input;
                $sql = 'SELECT serial_no,id,unit_id,warehouse_id FROM erp_stock_ledger L where L.id="' . $stock_ledger_id . '"';
                $modelStockLedger = Yii::app()->db->createCommand($sql)->queryRow();
                if (!$modelStockLedger) {
                    $valid = false;
                    $other[] = "Invalid stock ledger reference for item " . ($i + 1);
                    // push placeholder so indexes remain consistent but skip further processing for this row
                    $stockLedgers[] = null;
                    $itemModels[] = null;
                    Yii::app()->end();
                }
                $modelUOM = UnitOfMeasurement::model()->findByPk((int) $modelStockLedger['unit_id']);
                $serial_no = $modelStockLedger['serial_no'];
                if (empty($serial_no)) {
                    $valid = false;
                    $other[] = "Serial number missing for item " . ($i + 1);
                }
                // Either load existing or create new item
                if ($isUpdate) {
                    $modelIssueItem = InventoryGoodsIssueItem::model()->find(
                        'header_id=:hid AND product_id=:mid',
                        [':hid' => $model->id, ':mid' => $machine_id]
                    );
                    if (!$modelIssueItem)
                        $modelIssueItem = new InventoryGoodsIssueItem();
                    $modelIssueItem->updated_by = Yii::app()->user->id;
                    $modelIssueItem->updated_date_time = date('Y-m-d H:i:s');
                } else {
                    $modelIssueItem = new InventoryGoodsIssueItem();
                    $modelIssueItem->created_by = Yii::app()->user->id;
                    $modelIssueItem->created_date_time = date('Y-m-d H:i:s');
                }
                $modelIssueItem->product_id = $machine_id;
                $modelIssueItem->product_name = $modelStore ? $modelStore->part_number : '';
                $modelIssueItem->unit = (int) $modelStockLedger['unit_id'];
                $modelIssueItem->description = $itemData['description'] ? $itemData['description']: ($modelStore ? $modelStore->description : '');
                $modelIssueItem->location_id = $itemData['location_id'] ?? null;
                $modelIssueItem->picked_qty = 1;
                $modelIssueItem->rate = 0; // temp
                $modelIssueItem->serial_no = $serial_no;
                $customer = Customer::model()->findByPk($model->customer_id);
                $no_of_days = 30;
                if ($customer && !empty($customer->no_of_days) && $customer->no_of_days > 0) {
                    $no_of_days = (int) $customer->no_of_days;
                }
                $lastService = date('Y-m-d');
                $nextService = date('Y-m-d', strtotime("+{$no_of_days} days", strtotime($lastService)));
                $valid = $modelIssueItem->validate();
                $itemModels[] = $modelIssueItem;
                $stockLedgers[] = $modelStockLedger;
                // Assign warehouse_id from last item
                $model->warehouse_id = $modelStockLedger['warehouse_id'];
            }
            // validate header model too
            $valid = $model->validate();
        } else {
            $valid = false;
            $other[] = 'Form not posted';
        }
        if ($valid) {
            // Save header
            if (!$model->save(false)) {
                echo '<pre>';
                print_r($model->getErrors());
                echo '</pre>';
                Yii::app()->end();
            }
            /*** Save All Items and Corresponding Stock Ledgers ***/
            foreach ($itemModels as $index => $itemModel) {
                // skip rows that were invalid earlier
                if (!$itemModel || !isset($stockLedgers[$index]) || !$stockLedgers[$index]) {
                    Yii::app()->end();
                }
                $itemModel->goods_issue_id = $model->id;
                $ledger = $stockLedgers[$index]; // associative array from queryRow
                $uom = UnitOfMeasurement::model()->findByPk((int) $ledger['unit_id']);
                /************** UPDATE ORIGINAL STOCK LEDGER TO MARK ISSUED **************/
                // Use the existing ledger id to update (that is the row we are issuing)
                $existingLedgerId = (int) $ledger['id'];
                $customerNameForRemarks = ($model->customer && !empty($model->customer->customer_name)) ? $model->customer->customer_name : '';
                $remarksUpdate = 'MACHINE_ISSUED' . '/' . $model->id . '/' . $customerNameForRemarks;
                // Update original ledger entry
                StockLedger::model()->updateByPk($existingLedgerId, [
                    'customer_vendor_id' => $model->customer_id,
                    'customer_vendor_name' => $customerNameForRemarks,
                    'customer_location_id' => $model->outlet_id,
                    'remarks' => $remarksUpdate,
                    'available_status' => 'U'
                ]);
                /************** STOCK LEDGER (OUT) ENTRY FOR MACHINE_ISSUE **************/
                $existingLedger = (object) $ledger; // cast for ->property access convenience
                $remarks = 'MACHINE_ISSUED/' . $model->id . '/' . $customerNameForRemarks;
                $warehouse = $existingLedger->warehouse_id;
                // Get warehouse name
                $warehouseName = '';
                $warehouseModel = MasInventoryWarehouse::model()->findByPk($warehouse);
                if ($warehouseModel) {
                    $warehouseName = $warehouseModel->warehouse_name;
                }
                // Prepare new stock ledger OUT entry
                $stock = new StockLedger();
                $stock->file_id = $model->file_id;
                $stock->header_id = $model->id;
                $stock->header_item_id = $itemModel->id;
                $stock->customer_vendor_id = $model->customer_id;
                $stock->customer_vendor_name = $customerNameForRemarks;
                $stock->product_id = $itemModel->product_id;
                $stock->product_name = $itemModel->product_name;
                $stock->product_description = $itemModel->description;
                // Try to pull brand info from store if available
                $storeModel = Store::model()->findByPk($itemModel->product_id);
                $stock->brand_id = $storeModel ? ($storeModel->brand_class_id ?? null) : null;
                $stock->brand_name = ($storeModel && isset($storeModel->brand_detail)) ? $storeModel->brand_detail->brand_name : null;
                $stock->warehouse_id = $warehouse;
                $stock->warehouse_name = $warehouseName;
                // Default rack/bin
                $rack = new MasInvRack();
                $stock->rack_id = $rack->getDefaultRackId();
                $stock->rack_name = $rack->getRackName($stock->rack_id);
                $bin = new MasInvBin();
                $stock->bin_id = $bin->getDefaultBinId();
                $stock->bin_name = $bin->getBinName($stock->bin_id);
                // UOM and stock details
                $stock->unit_id = $existingLedger->unit_id;
                $uomModel = UnitOfMeasurement::model()->findByPk($existingLedger->unit_id);
                $stock->unit_name = $uomModel ? $uomModel->name : '';
                $stock->unit_factor = $uomModel ? $uomModel->factor : 1;
                $stock->quantity = -1;
                $stock->available_status = 'U'; // Mark unavailable as item is issued
                $stock->batch_no = '';
                $stock->serial_no = $existingLedger->serial_no;
                $stock->cost_price = 0;
                $stock->transaction_date = date('Y-m-d');
                $stock->transaction_from = "MACHINE_ISSUE";
                $stock->transaction_type = "OUT";
                $stock->master_stock_ledger_id = $existingLedger->id;
                $stock->stock_updated = 'Y';
                $stock->created_by = Yii::app()->user->id;
                $stock->created_date = date('Y-m-d H:i:s');
                $stock->remarks = $remarks;
                $stock->lead_owner_id = $model->lead_owner_id;
                if (!$stock->save(false)) {
                    Yii::log("Failed to save stock ledger (OUT) for issued machine ID {$itemModel->product_id}", CLogger::LEVEL_ERROR);
                    Yii::app()->end();
                }
                // Now link the newly created stock ledger id to the item and save the item
                if (!$itemModel->save(false)) {
                    Yii::log("Failed to save InventoryGoodsIssueItem for machine ID {$itemModel->product_id}", CLogger::LEVEL_ERROR);
                    echo '<pre>';
                    print_r($itemModel->getErrors());
                    echo '</pre>';
                    Yii::app()->end();
                }
            }
            $currentTime = date('H:i:s');
            /************** CREATE REPAIR REQUEST **************/
            $modelRequest = new SaleRepairRequest();
            $modelRequest->type_id = 2;
            $modelRequest->customer_id = $model->customer_id;
            $modelRequest->customer_shipping_id = $model->outlet_id;
            $modelRequest->service_id = MasServices::getIdByCode('S2');
            $modelRequest->request_date = date('Y-m-d');
            $modelRequest->schedule_date = date('Y-m-d');
            $modelRequest->start_time = date('Y-m-d H:i:s');
            $modelRequest->end_time = date('Y-m-d H:i:s');
            $modelRequest->status_id = 2;
            $modelRequest->completed_date = date('Y-m-d');
            $modelRequest->assigned_id = $model->lead_owner_id;
            $modelRequest->submit_invoice = 'Y';
            $modelRequest->technician_status = 'Y';
            $modelRequest->is_Visited = 'Y';
            $modelRequest->schedule_status = 'C';
            $modelRequest->request_from = 'MI';
            $modelRequest->created_by = Yii::app()->user->id;
            $modelRequest->created_date_time = date('Y-m-d H:i:s');
            $modelRequest->save(false);
            // InventoryGoodsIssue::model()->updateByPk($model->id, ['job_sheet_id' => $modelRequest->id]);
            /************** CREATE REPAIR REQUEST ITEMS **************/
            foreach ($itemModels as $itemModel) {
                // skip invalid rows
                if (!$itemModel)
                    Yii::app()->end();
                $repairItem = new SalesRepairRequestItem();
                $repairItem->machine_id = $itemModel->product_id;
                $repairItem->serial_no = $itemModel->serial_no;
                $repairItem->issue_item_id = $itemModel->id;
                $repairItem->location_id = $itemModel->location_id;
                $repairItem->status_id = 2;
                $repairItem->service_id = MasServices::getIdByCode('S2');
                $repairItem->header_id = $modelRequest->id;
                $repairItem->activity_changed = 'N';
                $repairItem->save(false);
            }
            /************** AUDIT LOG **************/
            AuditLog::saveAuditLogs($audit_type, 'InventoryGoodsIssue', $model->id);
            echo CJSON::encode(['status' => 'success', 'id' => $model->id]);
        } else {
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            // Merge CActiveForm errors with manual $other errors; make sure both are arrays
            $errorsMerged = array_merge_recursive((array) $error1, (array) $other);
            echo CJSON::encode($errorsMerged);
        }
    }














    public function actionIndexMeterial()
    {
        $this->render('indexmeterial');
    }

    public function actionGetListMeterial()
    {
        $model = new InventoryGoodsIssue();
        $draw = (int) $_POST['draw'];
        $offset = (int) $_POST['start'];
        $limit = (int) $_POST['length'];
        $columns = array(
            0 => 't.id',
            1 => 't.customer_id',
            2 => 'items.serial_no',
            3 => 't.lead_owner_id',
        );
        $orderColumnIndex = (int) $_POST['order'][0]['column'];
        $orderDirection = $_POST['order'][0]['dir'] === 'desc' ? 'DESC' : 'ASC';
        $orderBy = 't.id DESC';
        // ======================
        // ✅ Base condition
        // ======================
        $condition = " t.issue_type = 'MH' AND is_issued = 'Y' ";
        //$condition = 't.return_stock_ledger_id = 0 AND t.is_return_fully = "N"';
        if (Yii::app()->user->authorised_user != 1) {
            $condition .= ' AND (t.lead_owner_id = "' . Yii::app()->user->id . '" OR t.created_by = "' . Yii::app()->user->id . '")';
        }
        $params = array();
        // ======================
        // ✅ Global Search Filter
        // ======================
        if (!empty($_POST['search']['value'])) {
            $search = trim($_POST['search']['value']);
            $condition .= " AND (items.serial_no LIKE :search)";
            $params[':search'] = '%' . $search . '%';
        }
        // ======================
        // ✅ Fetch paginated records
        // ======================
        $criteria = new CDbCriteria;
        $criteria->condition = $condition;
        $criteria->params = $params;
        $criteria->limit = $limit;
        $criteria->offset = $offset;
        $criteria->order = $orderBy;
        $criteria->with = array('customer', 'items','outlet','owner');
        $criteria->together = true;
        $recordsTotal = $model->count($criteria);
        $rows = $model->findAll($criteria);
        // ======================
        // ✅ Build DataTable JSON
        // ======================
        $data = array();
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsTotal;
        $rowData = array();
        $m = 1;
        foreach ($rows as $row) {
            $buttons = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["machine_issue_view"])) {
                $buttons .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'sales/Inventorygoodsissue/create&type=view&id=' . $row->id . '\',\'View Machine\',\'xl\')"><i class="fa fa-eye"></i></button>';
            }
            $sales_group_id = Order::model()->findByPk($row->production_order_id)->sales_group_id;
            $rowData[] = array(
                $m,
                isset($row->customer) ? $row->customer->customer_name : '',
                isset($row->lead_owner_id) ? $row->owner->first_name . ' ' . $row->owner->last_name : '',
                isset($row->outlet_id) ? $row->outlet->outlet_location : '',
                isset($sales_group_id) ? MasSalesGroup::model()->findByPk($sales_group_id)->group_name: '',
                '<div class="btn-wrap">' . $buttons . '</div>',
                $row->isActive,
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreateMeterial()
    {
        $type = Yii::app()->request->getParam('type');
        $id = (int) Yii::app()->request->getParam('id');
        $model = new InventoryGoodsIssue();
        $modelIssueItem = [new InventoryGoodsIssueItem()];
        if ($id > 0) {
            $existingModel = InventoryGoodsIssue::model()->findByPk($id);
            if ($existingModel !== null) {
                $model = $existingModel;
                $sales_group_id = Order::model()->findByPk($existingModel->production_order_id)->sales_group_id;
                $model->issue_type = $sales_group_id;
            } else {
                throw new CHttpException(404, 'The requested record does not exist.');
            }
            // Condition based on type
            $criteria = new CDbCriteria();
            $criteria->addCondition('goods_issue_id = :goods_issue_id');
            $criteria->params[':goods_issue_id'] = $id;
            $existingIssueItems = InventoryGoodsIssueItem::model()->findAll($criteria);
            if (!empty($existingIssueItems)) {
                $modelIssueItem = $existingIssueItems;
            }
        }
        // Prevent double inclusion of JS
        Yii::app()->clientScript->scriptMap = ['*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false];
        // Render partial with correct data
        $this->renderPartial( 'createmeterial', [ 'model' => $model, 'modelIssueItem' => $modelIssueItem, 'type' => $type ], false, true );
    }
}