<?php

/**
 * This is the model class for table "{{project_task_breakup}}".
 *
 * The followings are the available columns in table '{{project_task_breakup}}':
 * @property integer $id
 * @property integer $project_id
 * @property integer $task_category_id
 * @property integer $task_subcategory_id
 * @property string $task_start_date
 * @property string $task_end_date
 * @property integer $assigned_person
 * @property string $task_cost
 * @property string $percent_of_completion
 * @property string $budget_task_hours
 * @property integer $variance
 * @property string $variance_notes
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class TaskBreakup extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{project_task_breakup}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('project_id, task_category_id, task_subcategory_id, task_start_date, task_end_date, assigned_person, task_cost, percent_of_completion, budget_task_hours, variance, variance_notes', 'required'),
			array('project_id, task_category_id, task_subcategory_id, assigned_person, variance, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('task_cost', 'length', 'max'=>15),
			array('percent_of_completion', 'length', 'max'=>3),
			array('budget_task_hours', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, project_id, task_category_id, task_subcategory_id, task_start_date, task_end_date, assigned_person, task_cost, percent_of_completion, budget_task_hours, variance, variance_notes, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'project_id' => 'Project',
			'task_category_id' => 'Task Category',
			'task_subcategory_id' => 'Task Subcategory',
			'task_start_date' => 'Task Start Date',
			'task_end_date' => 'Task End Date',
			'assigned_person' => 'Assigned Person',
			'task_cost' => 'Task Cost',
			'percent_of_completion' => 'Percent Of Completion',
			'budget_task_hours' => 'Budget Task Hours',
			'variance' => 'Variance',
			'variance_notes' => 'Variance Notes',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('project_id',$this->project_id);
		$criteria->compare('task_category_id',$this->task_category_id);
		$criteria->compare('task_subcategory_id',$this->task_subcategory_id);
		$criteria->compare('task_start_date',$this->task_start_date,true);
		$criteria->compare('task_end_date',$this->task_end_date,true);
		$criteria->compare('assigned_person',$this->assigned_person);
		$criteria->compare('task_cost',$this->task_cost,true);
		$criteria->compare('percent_of_completion',$this->percent_of_completion,true);
		$criteria->compare('budget_task_hours',$this->budget_task_hours,true);
		$criteria->compare('variance',$this->variance);
		$criteria->compare('variance_notes',$this->variance_notes,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProjectTaskBreakup the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
