<?php

/**
 * This is the model class for table "{{project_material_issue_items}}".
 *
 * The followings are the available columns in table '{{project_material_issue_items}}':
 * @property integer $id
 * @property integer $project_material_issue_id
 * @property integer $product_id
 * @property string $product_name
 * @property string $description
 * @property string $unit
 * @property string $rate
 * @property string $picked_qty
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_date_time
 * @property string $updated_date_time
 */
class MaterialIssueItems extends CActiveRecord
{ 
        //public $total_qty;
        //public $balanceqty;
        public $unit_name;
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{project_material_issue_items}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('project_material_issue_id, product_id, product_name, description, unit, rate, created_by, updated_by, created_date_time, updated_date_time', 'required'),
			array('project_material_issue_id, product_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('product_name, description', 'length', 'max'=>255),
			array('unit', 'length', 'max'=>20),
			array('rate', 'length', 'max'=>15),
			array('picked_qty', 'length', 'max'=>13),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, project_material_issue_id, product_id, product_name, description, unit, rate, picked_qty, created_by, updated_by, created_date_time, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'project_material_issue_id' => 'foreign key to project material issue table',
			'product_id' => 'Product',
			'product_name' => 'Product Name',
			'description' => 'Description',
			'unit' => 'Unit',
			'rate' => 'Rate',
			'picked_qty' => 'Picked Qty',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'created_date_time' => 'Created Date Time',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('project_material_issue_id',$this->project_material_issue_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('product_name',$this->product_name,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('unit',$this->unit,true);
		$criteria->compare('rate',$this->rate,true);
		$criteria->compare('picked_qty',$this->picked_qty,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProjectMaterialIssueItems the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
