<?php

/**
 * This is the model class for table "{{project_actual_material_details}}".
 *
 * The followings are the available columns in table '{{project_actual_material_details}}':
 * @property integer $id
 * @property integer $project_id
 * @property integer $project_phase_id
 * @property string $actual_date
 * @property integer $item_id
 * @property string $description
 * @property string $size
 * @property integer $brand
 * @property integer $quantity
 * @property integer $unit
 * @property string $material_price
 * @property string $unit_price
 * @property string $total_material_cost
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class ActualMaterialDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
     
  public $product_name;
  public $unit_name;
  public $brand_name;
	public function tableName()
	{
		return '{{project_actual_material_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('project_id, project_phase_id, actual_date, item_id, description, size, brand, quantity, unit, material_price, unit_price, total_material_cost', 'required'),
			array('project_id, project_phase_id, item_id, brand, quantity, unit, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('description, size', 'length', 'max'=>255),
			array('material_price, unit_price, total_material_cost', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, project_id, project_phase_id, actual_date, item_id, description, size, brand, quantity, unit, material_price, unit_price, total_material_cost, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'brand_detail' => array(self::BELONGS_TO, 'ProductClass','brand'),
                    'unit_detail' => array(self::BELONGS_TO, 'Unit', 'unit'),
                    'phase_detail' => array(self::BELONGS_TO, 'ProjectPhaseDetails','project_phase_id'),
	
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'project_id' => 'Project',
			'project_phase_id' => 'primary key of crm_project_phase_details',
			'actual_date' => 'Actual Date',
			'item_id' => 'Item',
			'description' => 'Description',
			'size' => 'Size',
			'brand' => 'Brand',
			'quantity' => 'Quantity',
			'unit' => 'Unit',
			'material_price' => 'Material Price',
			'unit_price' => 'Unit Price',
			'total_material_cost' => 'Total Material Cost',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('project_id',$this->project_id);
		$criteria->compare('project_phase_id',$this->project_phase_id);
		$criteria->compare('actual_date',$this->actual_date,true);
		$criteria->compare('item_id',$this->item_id);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('size',$this->size,true);
		$criteria->compare('brand',$this->brand);
		$criteria->compare('quantity',$this->quantity);
		$criteria->compare('unit',$this->unit);
		$criteria->compare('material_price',$this->material_price,true);
		$criteria->compare('unit_price',$this->unit_price,true);
		$criteria->compare('total_material_cost',$this->total_material_cost,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProjectActualMaterialDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
