<?php

/**
 * This is the model class for table "{{project_actual_labour_details}}".
 *
 * The followings are the available columns in table '{{project_actual_labour_details}}':
 * @property integer $id
 * @property integer $project_id
 * @property integer $project_phase_id
 * @property string $actual_date
 * @property string $description
 * @property integer $no_of_workers
 * @property string $hours_per_person
 * @property string $each_labour_cost
 * @property string $total_cost_for_labour
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class ActualLabourDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{project_actual_labour_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('project_id, project_phase_id, actual_date, description, no_of_workers, hours_per_person, each_labour_cost, total_cost_for_labour', 'required'),
			array('project_id, project_phase_id, no_of_workers, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('description', 'length', 'max'=>255),
			array('hours_per_person, each_labour_cost, total_cost_for_labour', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, project_id, project_phase_id, actual_date, description, no_of_workers, hours_per_person, each_labour_cost, total_cost_for_labour, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'phase_detail' => array(self::BELONGS_TO, 'ProjectPhaseDetails','project_phase_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'project_id' => 'Project',
			'project_phase_id' => 'primary key of crm_project_phase_details',
			'actual_date' => 'Actual Date',
			'description' => 'Description',
			'no_of_workers' => 'No Of Workers',
			'hours_per_person' => 'Hours Per Person',
			'each_labour_cost' => 'Each Labour Cost',
			'total_cost_for_labour' => 'Total Cost For Labour',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('project_id',$this->project_id);
		$criteria->compare('project_phase_id',$this->project_phase_id);
		$criteria->compare('actual_date',$this->actual_date,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('no_of_workers',$this->no_of_workers);
		$criteria->compare('hours_per_person',$this->hours_per_person,true);
		$criteria->compare('each_labour_cost',$this->each_labour_cost,true);
		$criteria->compare('total_cost_for_labour',$this->total_cost_for_labour,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProjectActualLabourDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
