<?php

/**
 * This is the model class for table "{{project_details}}".
 *
 * The followings are the available columns in table '{{project_details}}':
 * @property integer $id
 * @property integer $production_order_id
 * @property integer $category_id
 * @property integer $process_id
 * @property string $process_name
 * @property integer $quantity
 * @property string $start_date
 * @property string $end_date
 * @property string $remarks
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class ProductionOrderDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{production_order_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('production_order_id, category_id, process_name, quantity, start_date, end_date, created_by, created_date_time', 'required'),
			array('production_order_id, category_id, process_id, quantity, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('process_name, remarks', 'length', 'max'=>150),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, production_order_id, category_id, process_id, process_name, quantity, start_date, end_date, remarks, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    "process_det" => [self::BELONGS_TO, "MasProcessList", "process_id"],
		    "category_det" => [self::BELONGS_TO, "MasCategoryLevel1", "category_id"],
		   // "project_det" => [self::BELONGS_TO, "Project", "production_order_id"]
		    "project_det" => [self::BELONGS_TO, "ProductionOrder", "production_order_id"]
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'production_order_id' => 'Production',
			'category_id' => 'Category',
			'process_id' => 'Process',
			'process_name' => 'Process Name',
			'quantity' => 'Quantity',
			'start_date' => 'Start Date',
			'end_date' => 'End Date',
			'remarks' => 'Remarks',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('production_order_id',$this->production_order_id);
		$criteria->compare('category_id',$this->category_id);
		$criteria->compare('process_id',$this->process_id);
		$criteria->compare('process_name',$this->process_name,true);
		$criteria->compare('quantity',$this->quantity);
		$criteria->compare('start_date',$this->start_date,true);
		$criteria->compare('end_date',$this->end_date,true);
		$criteria->compare('remarks',$this->remarks,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProductionOrderDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
