<?php

/**
 * This is the model class for table "{{project}}".
 *
 * The followings are the available columns in table '{{project}}':
 * @property integer $id
 * @property integer $customer_id
 * @property string $ref_no
 * @property string $brand_name
 * @property string $product_name
 * @property string $product_type
 * @property string $variant_name
 * @property string $fragrance_type
 * @property string $sample_code
 * @property integer $quantity
 * @property string $quantity_notes
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class ProductionOrder extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{production_order}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_name, fragrance_type, quantity, isActive, created_by, created_date_time,expected_start_date,expected_end_date,pro_ord_type', 'required'),
			array('customer_id, quantity, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('ref_no, brand_name, product_type, fragrance_type, sample_code', 'length', 'max'=>50),
			array('product_name, variant_name', 'length', 'max'=>100),
			array('quantity_notes', 'length', 'max'=>250),
			array('isActive', 'length', 'max'=>1),
			array('pro_ord_type', 'length', 'max'=>10),
			array('customer_id', 'validateCustomer'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_id, ref_no, brand_name, product_name, product_type, variant_name, fragrance_type, sample_code, quantity, quantity_notes, isActive, created_by, created_date_time, updated_by, updated_date_time,pro_ord_type,expected_start_date,expected_end_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		 "cust" => [self::BELONGS_TO, "Customer", "customer_id"],
		  'product' => array(self::BELONGS_TO, 'Store', 'product_id'),

	
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_id' => 'Customer',
			'ref_no' => 'Ref No',
			'brand_name' => 'Brand Name',
			'product_name' => 'Product Name',
			'product_type' => 'Product Type',
			'variant_name' => 'Variant Name',
			'fragrance_type' => 'Fragrance Type',
			'sample_code' => 'Sample Code',
			'quantity' => 'Quantity',
			'quantity_notes' => 'Quantity Notes',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'pro_ord_type' => 'Production Order Type',
			'expected_end_date' => 'Expected End Date',
			'expected_start_date' => 'Expected Start Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('ref_no',$this->ref_no,true);
		$criteria->compare('brand_name',$this->brand_name,true);
		$criteria->compare('product_name',$this->product_name,true);
		$criteria->compare('product_type',$this->product_type,true);
		$criteria->compare('variant_name',$this->variant_name,true);
		$criteria->compare('fragrance_type',$this->fragrance_type,true);
		$criteria->compare('sample_code',$this->sample_code,true);
		$criteria->compare('quantity',$this->quantity);
		$criteria->compare('quantity_notes',$this->quantity_notes,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Project the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public function validateCustomer($attribute, $params)
	{
    
		$condition = "isActive='Y' ";
		// if($this->id>0){
		// 	$condition .=" AND id!='".$this->id."' ";
		// }
	   // $categoryId = $this->level1_category_id;
	    $id = $this->$attribute;
	    $condition .= " AND id='" . $id . "'";
	 	$exst_model = Customer::model()->find(array('condition' => $condition));
		    if (empty($exst_model)) {
		        $this->addError($attribute, 'Customer does not Exist!');
		    }
		
	}
}
