<?php

class ProductionorderController extends Controller {

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create', 'Save', 'GetProcess',
                    'UpdateJobStatus', 'ProgressList', 'GetJobs', 'deleteProductionOrderRow',
                    'ProductionOrderDetailList', 'GetProductionOrderDeailList','CreatePL','CreateStock','ProductionOrderReportPdf','SavePrivateLabel','SaveStockDetails',
                        'ProductionOrderBOMReportPdf'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function actionGetList() {
        $model = new ProductionOrder();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.ref_no',
            2 => 't.brand_name',
            3 => 't.product_name',
            4 => 't.product_type',
            5 => 't.variant_name',
            6 => 't.fragrance_type',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "t.isActive='Y'";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (ref_no LIKE '%" . $searchString . "%' OR brand_name LIKE '%" . $searchString . "%' OR
            product_name LIKE '%" . $searchString . "%' OR variant_name LIKE '%" . $searchString . "%' OR
            product_type LIKE '%" . $searchString . "%' OR fragrance_type LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            if ($row->isActive == 'Y') {
                $status = 1;
            } else {
                $status = 0;
            }
            //if (isset(Yii::app()->user->havePermissionOn['mas_department_edit']) || Yii::app()->user->authorised_user == 1) {
            if($row->pro_ord_type=='PL'){
            $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'production/productionorder/createpl&id=' . $row['id'] . '&type=PL\',\'Production Order - Private Labelling\',\'xl\')"><i class="fa fa-list" title="Private Labelling"></i></button>';
            $div .= ' <button class="btn btn-primary btn-xs" onclick="exportpdf(' . $row['id'] . ')"><i class="fa fa-file-pdf" title="Print Private Labelling"></i></button>';
            }
            else{
             $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'production/productionorder/createstock&id=' . $row['id'] . '&type=PL\',\'Production Order - Stock\',\'xl\')"><i class="fa fa-shopping-cart" title="Stock"></i></button>';
            $div .= ' <button class="btn btn-primary btn-xs" onclick="exportBOMpdf(' . $row['id'] . ')"><i class="fa fa-print" title="Print Stock"></i></button>';
                
            }
            
             
                
              
             
             // $div .= ' <button class="btn btn-primary btn-xs" onclick="convert_purchase_enquiry(' . $row['id'] . ')"><i class="fa fa-convert" title="Convert"></i></button>';
            //}
            // if ($row->isActive == 'Y') {
            //     $div .= ' <a href ="#" class="btn btn-success btn-xs" onclick="disabledCustomer(' . $row['id'] . ',' . $status . ')"><i class="fa fa-toggle-on" title="Disable"></i></a>';
            // }
            // if ($row->isActive == 'N') {
            //     $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="enabledCustomer(' . $row['id'] . ',' . $status . ')"><i class="fa fa-ban" title="Enable"></i></a>';
            // }
            $rowData[] = array(
                $m,
                // $row->ref_no,
                $row->cust->customer_name,
                $row->cust->customer_phone_no,
                $row->ref_no,
                $row->product_name,
                $row->product_type,
                $row->fragrance_type,
                $row->quantity,
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row->id, 'status' => $row->isActive,'po_order_type'=>$row->pro_ord_type)
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new ProductionOrder();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }
    
     public function actionCreatePL() {
        $model = new ProductionOrder();
        $id = (int) Yii::app()->request->getParam('id');
        $modelProductionOrderComponentDetails=array(new ProductionOrderComponentDetails());
        $modelProductionOrderRequisitionDetails=array(new ProductionOrderRequsition());
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelProductionOrderComponentDetails = ProductionOrderComponentDetails::model()->findAll(array('condition'=>'production_order_id='.$id));
            if(empty($modelProductionOrderComponentDetails)){
                $modelProductionOrderComponentDetails=array(new ProductionOrderComponentDetails());   
            }
            $modelProductionOrderRequisitionDetails = ProductionOrderRequsition::model()->findAll(array('condition'=>'production_order_id='.$id));
            if(empty($modelProductionOrderRequisitionDetails)){
                $modelProductionOrderRequisitionDetails=array(new ProductionOrderRequsition());   
            }

        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create_private_label', array('model' => $model,'modelProductionOrderComponentDetails'=>$modelProductionOrderComponentDetails,'modelProductionOrderRequisitionDetails'=>$modelProductionOrderRequisitionDetails), false, false);
    }
    
    public function actionCreateStock() {
        $model = new ProductionOrder();
        $id = (int) Yii::app()->request->getParam('id');
        $modelProductionOrderBomDetails=array(new ProductionOrderBomDetails());
        $modelProductionOrderRequisitionDetails=array(new ProductionOrderRequsition());

        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelProductionOrderBomDetails = ProductionOrderBomDetails::model()->findAll(array('condition'=>'production_order_id='.$id));
            if(empty($modelProductionOrderBomDetails)){
                $modelProductionOrderBomDetails=array(new ProductionOrderBomDetails());   
            }
            $modelProductionOrderRequisitionDetails = ProductionOrderRequsition::model()->findAll(array('condition'=>'production_order_id='.$id));
            if(empty($modelProductionOrderRequisitionDetails)){
                $modelProductionOrderRequisitionDetails=array(new ProductionOrderRequsition());   
            }
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create_stock', array('model' => $model,'modelProductionOrderBomDetails'=>$modelProductionOrderBomDetails,'modelProductionOrderRequisitionDetails'=>$modelProductionOrderRequisitionDetails), false, false);
    }

    /*public function actionSave() {
        $valid = true;
        $model = new ProductionOrder();
        if (isset($_POST['ProductionOrder'])) {
            if ((int) @$_POST['ProductionOrder']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $id = (int) @$_POST['ProductionOrder']['id'];
                $model->updateBypk($id, array('updated_by' => $model->updated_by, 'updated_date_time' => $model->updated_date_time));
                $model = $model->findByPk($id);
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $model->isActive = 'Y';
                $model->scenario = 'add';
            }
            $model->attributes = $_POST['ProductionOrder'];
            $model->sales_man_id = $_POST['ProductionOrder']['sales_man_id'];
            if($_POST['ProductionOrder']['expected_start_date']!=''){
            $date1= str_replace('/', '-',$_POST['ProductionOrder']['expected_start_date']);

            $model->expected_start_date=date("Y-m-d", strtotime($date1));
            }
            if($_POST['ProductionOrder']['expected_end_date']!=''){
            $date2= str_replace('/', '-',$_POST['ProductionOrder']['expected_end_date']);
            // echo $date2;exit;
            $model->expected_end_date=date("Y-m-d", strtotime($date2));
            }
            $valid = $model->validate(false);
            if (isset($_POST['ProductionOrderDetails']) && $valid) {

                $modelCategoryLevel1 = MasCategoryLevel1::model()->findAll(array('select' => array('id', 'level1_category_name'), 'condition' => $condition, 'order' => 'level1_category_name'));
                ;
                foreach ($modelCategoryLevel1 as $eachCategoryLevel) {
                    $category_id = $eachCategoryLevel->id;

                    $modelMasProcessList = new MasProcessList();
                    $count = count($_POST['ProductionOrderDetails'][$category_id]);
                    $arr_process_list = $modelMasProcessList->findAll(array('condition' => 'category_id=' . $category_id . ' AND isActive="Y"'));
                    for ($i = 0; $i < $count; $i++) {
                        //foreach($arr_process_list as $i=>$eachProcessList){
                        $modelProductionOrderDetails[$category_id][$i] = new ProductionOrderDetails();
                        if (($_POST['ProductionOrderDetails'][$category_id][$i]['quantity']) != "") {
                            $process_id = $_POST['ProductionOrderDetails'][$category_id][$i]['process_id'];
                            if (empty($_POST['ProductionOrderDetails'][$category_id][$i]['process_id'])) {
                                $modelprocess = new MasProcessList();
                                $modelprocess->created_by = Yii::app()->user->id;

                                $modelprocess->created_date_time = date('Y-m-d h:i:s');
                                $modelprocess->process_name = trim($_POST['ProductionOrderDetails'][$category_id][$i]['process_name']);
                                $modelprocess->process_sort_order = $count;
                                $modelprocess->category_id = $category_id;
                                $modelprocess->attributes = $_POST['MasProcessList'];
                                $modelprocess->save();
                                $process_id = $modelprocess->id;
                            }


                            if ((int) @$_POST['ProductionOrderDetails'][$category_id][$i]['id'] > 0) {

                                $modelProductionOrderDetails[$category_id][$i]->updated_by = Yii::app()->user->id;
                                $modelProductionOrderDetails[$category_id][$i]->updated_date_time = date('Y-m-d h:i:s');
                                $details_id = (int) @$_POST['ProductionOrderDetails'][$category_id][$i]['id'];
                                $modelProductionOrderDetails[$category_id][$i]->updateBypk($details_id, array('updated_by' => $modelProductionOrderDetails[$category_id][$i]->updated_by, 'updated_date_time' => $modelProductionOrderDetails[$category_id][$i]->updated_date_time));
                                $modelProductionOrderDetails[$category_id][$i] = $modelProductionOrderDetails[$category_id][$i]->findByPk($details_id);
                            } else {

                                $modelProductionOrderDetails[$category_id][$i]->created_by = Yii::app()->user->id;
                                $modelProductionOrderDetails[$category_id][$i]->created_date_time = date('Y-m-d h:i:s');
                            }

                            $start_date = str_replace("/", "-", $_POST['ProductionOrderDetails'][$category_id][$i]['start_date']);

                            $end_date = str_replace("/", "-", $_POST['ProductionOrderDetails'][$category_id][$i]['end_date']);
                            $modelProductionOrderDetails[$category_id][$i]->process_name = trim($_POST['ProductionOrderDetails'][$category_id][$i]['process_name']);
                            $modelProductionOrderDetails[$category_id][$i]->category_id = $category_id;
                            $modelProductionOrderDetails[$category_id][$i]->pro_order_id = $model->id;

                            $modelProductionOrderDetails[$category_id][$i]->process_id = $process_id;
                            $modelProductionOrderDetails[$category_id][$i]->attributes = $_POST['ProductionOrderDetails'][$category_id][$i];
                            $modelProductionOrderDetails[$category_id][$i]->start_date = date('Y-m-d', strtotime($start_date));
                            $modelProductionOrderDetails[$category_id][$i]->end_date = date('Y-m-d', strtotime($end_date));

                            // $valid = $valid && $modelProductionOrderDetails[$category_id][$i]->validate();
                            // if($valid)
                            // {
                            //     $modelProductionOrderDetails[$category_id][$i]->ProductionOrder_id= $model->id;

                            $modelProductionOrderDetails[$category_id][$i]->save();
                            //  }
                        }
                    }
                }
            }
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }*/
    
    
    public function actionSavePrivateLabel() {
        $valid = true;
        $model = new ProductionOrder();
        if (isset($_POST['ProductionOrder'])) {
            if ((int) @$_POST['ProductionOrder']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $id = (int) @$_POST['ProductionOrder']['id'];
                $model->updateBypk($id, array('updated_by' => $model->updated_by, 'updated_date_time' => $model->updated_date_time));
                $model = $model->findByPk($id);
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $model->isActive = 'Y';
                $model->scenario = 'add';
            }
            $model->attributes = $_POST['ProductionOrder'];
            $model->sales_man_id = $_POST['ProductionOrder']['sales_man_id'];
            if($_POST['ProductionOrder']['expected_start_date']!=''){
            $date1= str_replace('/', '-',$_POST['ProductionOrder']['expected_start_date']);

            $model->expected_start_date=date("Y-m-d", strtotime($date1));
            }
            if($_POST['ProductionOrder']['expected_end_date']!=''){
            $date2= str_replace('/', '-',$_POST['ProductionOrder']['expected_end_date']);
            // echo $date2;exit;
            $model->expected_end_date=date("Y-m-d", strtotime($date2));
            }
            $valid = $model->validate();
           // if($valid){
            if (isset($_POST['ProductionOrderDetails']) && $valid) {

                $modelCategoryLevel1 = MasCategoryLevel1::model()->findAll(array('select' => array('id', 'level1_category_name'), 'condition' => $condition, 'order' => 'level1_category_name'));
                //code to save new code start

                  $p=0;
                if (is_array($_POST['ProductionOrderDetails'])) {
                   
                    foreach ($_POST['ProductionOrderDetails'] as $i => $order_item) {  
                       
                        foreach ($order_item as $eachOrderItem) {
                        
                            if ($eachOrderItem['id'] > 0) {
                                $ProductionOrderDetails[$p] = ProductionOrderDetails::model()->findByPK($eachOrderItem['id']); 
                                $ProductionOrderDetails[$p]->updated_by = Yii::app()->user->id;
                                $ProductionOrderDetails[$p]->updated_date_time = date('Y-m-d h:i:s');

                            } else {
                                $ProductionOrderDetails[$p] = new ProductionOrderDetails;
                                $ProductionOrderDetails[$p]->created_by = Yii::app()->user->id;
                                $ProductionOrderDetails[$p]->created_date_time = date('Y-m-d h:i:s'); 
                            }
                            $process_id = $eachOrderItem['process_id'];
                            if (empty($eachOrderItem['process_id'])) {
                                $modelprocess = new MasProcessList();
                                $modelprocess->created_by = Yii::app()->user->id;
                                $modelprocess->created_date_time = date('Y-m-d h:i:s');
                                $modelprocess->process_name = trim($eachOrderItem['process_name']);
                                $modelprocess->process_sort_order = 1;
                                $modelprocess->category_id = $eachOrderItem['category_id'];
                                //$modelprocess->attributes = $_POST['MasProcessList'];
                                $modelprocess->save();
                                $process_id = $modelprocess->id;
                            }
                            //$ProductionOrderDetails[$p]->attributes  =   $item[$i];
                            $ProductionOrderDetails[$p]->process_name = $eachOrderItem['process_name'];
                            $ProductionOrderDetails[$p]->quantity = $eachOrderItem['quantity'];
                            $ProductionOrderDetails[$p]->category_id = $eachOrderItem['category_id'];
                            $ProductionOrderDetails[$p]->process_id =  $process_id;
                            if($eachOrderItem['start_date']!=''){
                                $start_date = str_replace("/", "-", $eachOrderItem['start_date']);
                                $ProductionOrderDetails[$p]->start_date = date('Y-m-d', strtotime($start_date));
                            }
                            if($eachOrderItem['end_date']!=''){
                                $end_date = str_replace("/", "-", $eachOrderItem['end_date']);
                                $ProductionOrderDetails[$p]->end_date = date('Y-m-d', strtotime($end_date));
                            }
                            $ProductionOrderDetails[$p]->availabe_qty =  trim($eachOrderItem['availabe_qty']);
                            $ProductionOrderDetails[$p]->balance_qty =  trim($eachOrderItem['balance_qty']);
                          // $valid = $ProductionOrderDetails[$p]->validate() && $valid;
                           $p++;
                             
                        }

                    } 
                } 
                //end code
            }

                //end code 20-10-2023 end
               /* foreach ($modelCategoryLevel1 as $eachCategoryLevel) {
                    $category_id = $eachCategoryLevel->id;

                    $modelMasProcessList = new MasProcessList();
                    $count = count($_POST['ProductionOrderDetails'][$category_id]);
                    $arr_process_list = $modelMasProcessList->findAll(array('condition' => 'category_id=' . $category_id . ' AND isActive="Y"'));
                    for ($i = 0; $i < $count; $i++) {
                        //foreach($arr_process_list as $i=>$eachProcessList){
                        $modelProductionOrderDetails[$category_id][$i] = new ProductionOrderDetails();
                        if (($_POST['ProductionOrderDetails'][$category_id][$i]['quantity']) != "") {
                            $process_id = $_POST['ProductionOrderDetails'][$category_id][$i]['process_id'];
                            if (empty($_POST['ProductionOrderDetails'][$category_id][$i]['process_id'])) {
                                $modelprocess = new MasProcessList();
                                $modelprocess->created_by = Yii::app()->user->id;

                                $modelprocess->created_date_time = date('Y-m-d h:i:s');
                                $modelprocess->process_name = trim($_POST['ProductionOrderDetails'][$category_id][$i]['process_name']);
                                $modelprocess->process_sort_order = $count;
                                $modelprocess->category_id = $category_id;
                                $modelprocess->attributes = $_POST['MasProcessList'];
                                $modelprocess->save();
                                $process_id = $modelprocess->id;
                            }


                            if ((int) @$_POST['ProductionOrderDetails'][$category_id][$i]['id'] > 0) {

                                $modelProductionOrderDetails[$category_id][$i]->updated_by = Yii::app()->user->id;
                                $modelProductionOrderDetails[$category_id][$i]->updated_date_time = date('Y-m-d h:i:s');
                                $details_id = (int) @$_POST['ProductionOrderDetails'][$category_id][$i]['id'];
                                $modelProductionOrderDetails[$category_id][$i]->updateBypk($details_id, array('updated_by' => $modelProductionOrderDetails[$category_id][$i]->updated_by, 'updated_date_time' => $modelProductionOrderDetails[$category_id][$i]->updated_date_time));
                                $modelProductionOrderDetails[$category_id][$i] = $modelProductionOrderDetails[$category_id][$i]->findByPk($details_id);
                            } else {

                                $modelProductionOrderDetails[$category_id][$i]->created_by = Yii::app()->user->id;
                                $modelProductionOrderDetails[$category_id][$i]->created_date_time = date('Y-m-d h:i:s');
                            }

                            
                            $modelProductionOrderDetails[$category_id][$i]->process_name = trim($_POST['ProductionOrderDetails'][$category_id][$i]['process_name']);
                            $modelProductionOrderDetails[$category_id][$i]->category_id = $category_id;
                            $modelProductionOrderDetails[$category_id][$i]->production_order_id = $model->id;

                            $modelProductionOrderDetails[$category_id][$i]->process_id = $process_id;
                            $modelProductionOrderDetails[$category_id][$i]->attributes = $_POST['ProductionOrderDetails'][$category_id][$i];
                          
                            //if($_POST['ProductionOrderDetails'][$category_id][$i]['start_date']!=''){
                                $start_date = str_replace("/", "-", $_POST['ProductionOrderDetails'][$category_id][$i]['start_date']);
                         
                                $modelProductionOrderDetails[$category_id][$i]->start_date = date('Y-m-d', strtotime($start_date));
                                $modelProductionOrderDetails[$category_id][$i]->start_date = '2023-03-24';
                                // echo $modelProductionOrderDetails[$category_id][$i]->start_date;exit;
                            //}
                           // if($_POST['ProductionOrderDetails'][$category_id][$i]['end_date']!=''){
                                $end_date = str_replace("/", "-", $_POST['ProductionOrderDetails'][$category_id][$i]['end_date']);
                           
                                $modelProductionOrderDetails[$category_id][$i]->end_date = date('Y-m-d', strtotime($end_date));
                            //}
                            $modelProductionOrderDetails[$category_id][$i]->availabe_qty =  trim($_POST['ProductionOrderDetails'][$category_id][$i]['availabe_qty']);
                            $modelProductionOrderDetails[$category_id][$i]->balance_qty =  trim($_POST['ProductionOrderDetails'][$category_id][$i]['balance_qty']);

                            // $valid = $valid && $modelProductionOrderDetails[$category_id][$i]->validate();
                            // if($valid)
                            // {
                            //     $modelProductionOrderDetails[$category_id][$i]->ProductionOrder_id= $model->id;
 //echo '<pre>';print_r($modelProductionOrderDetails[$category_id][$i]->attributes);exit;
                             $modelProductionOrderDetails[$category_id][$i]->save();
                            //  }
                        }
                    }
                }
            } */
            // saving to components
            $p = 0;
             if (is_array($_POST['ProductionOrderComponentDetails'])) {

                foreach ($_POST['ProductionOrderComponentDetails'] as $i => $item) { 
                    
                 if ($item['product_name'] !='') {
                         $modelComponentOrderItem[$p] = new ProductionOrderComponentDetails();
                        $modelComponentOrderItem[$p]->product_id             =0;
                        $modelComponentOrderItem[$p]->product_name           = $item['product_name'];
                        $modelComponentOrderItem[$p]->product_description    = $item['product_description'];
                        $modelComponentOrderItem[$p]->unit_id                = 0;
                        $modelComponentOrderItem[$p]->unit_name               = $item['unit_name'];;
                        $modelComponentOrderItem[$p]->quantity               = $item['quantity'];
                        $valid1 = $modelComponentOrderItem[$p]->validate() && $valid;
                        $p++;
                    }
                }
            }

                  // saving to requisition

                 $p = 0;

                 if (is_array($_POST['ProductionOrderRequsition'])) {



                foreach ($_POST['ProductionOrderRequsition'] as $i => $item) { 
                    
                 if ($item['product_name'] !='') {

                         $modelRequsitionItem[$p] = new ProductionOrderRequsition();
                        $modelRequsitionItem[$p]->product_id             =0;
                        $modelRequsitionItem[$p]->product_name           = $item['product_name'];
                        $modelRequsitionItem[$p]->product_description    = $item['product_description'];
                        $modelRequsitionItem[$p]->unit_id                = 0;
                        $modelRequsitionItem[$p]->unit_name               = $item['unit_name'];;
                        $modelRequsitionItem[$p]->quantity               = $item['quantity'];
                        $modelRequsitionItem[$p]->supplier_name               = $item['supplier_name'];
                        $modelRequsitionItem[$p]->purchase_order_no               = $item['purchase_order_no'];
                    $modelRequsitionItem[$p]->po_component_id   = $item
                    ['po_component_id'];
                    if($item['expected_date']!=''){
                                $expected_date = str_replace("/", "-", $item['expected_date']);
                    $modelRequsitionItem[$p]->expected_date = date('Y-m-d', strtotime($expected_date));

                    $modelRequsitionItem[$p]->updated_by  = Yii::app()->user->id;
                $modelRequsitionItem[$p]->updated_date_time = date('Y-m-d h:i:s');
                 $modelRequsitionItem[$p]->created_by = Yii::app()->user->id;
                 $modelRequsitionItem[$p]->created_date_time = date('Y-m-d h:i:s');
                            }



                        //$valid2 = $modelRequsitionItem[$p]->validate() && $valid;
                        $p++;
                    }
                }
            }
            // code end


            if ($valid) {

                //data saved to productorder
                $model->save();


                //save compnet
                 
                if(!empty($modelComponentOrderItem)){
                    ProductionOrderComponentDetails::model()->deleteAll('production_order_id=:refer_id', array(':refer_id' => $model->id));
                    //print_r($modelComponentOrderItem);
                    foreach ($modelComponentOrderItem as $eachModel) {
                        $eachModel->production_order_id = $model->id;
                        $eachModel->save(false);
                    }
                }

                 if(!empty($modelRequsitionItem)){
                    //print_r($modelRequsitionItem);
                     ProductionOrderRequsition::model()->deleteAll('production_order_id=:refer_id', array(':refer_id' => $model->id));
                    foreach ($modelRequsitionItem as $eachRequsitionModel) {
                        $eachRequsitionModel->production_order_id = $model->id;
                        $eachRequsitionModel->save(false);
                    }
                }

                if(!empty($ProductionOrderDetails)){
                   
                    foreach ($ProductionOrderDetails as $eachProductModel) {
                        $eachProductModel->production_order_id = $model->id;
                        $eachProductModel->save(false);
                    }
                }
                
                //end code
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    
    public function actionSaveStockDetails() {

        $valid = true;
        $model = new ProductionOrder();
        if (isset($_POST['ProductionOrder'])) {
            if ((int) @$_POST['ProductionOrder']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $id = (int) @$_POST['ProductionOrder']['id'];
                $model->updateBypk($id, array('updated_by' => $model->updated_by, 'updated_date_time' => $model->updated_date_time));
                $model = $model->findByPk($id);
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $model->isActive = 'Y';
                $model->scenario = 'add';
            }
            $model->attributes = $_POST['ProductionOrder'];
            $model->sales_man_id = $_POST['ProductionOrder']['sales_man_id'];
             $model->product_id = $_POST['ProductionOrder']['product_id'];  
            $model->pro_ord_type = "S";
            if($_POST['ProductionOrder']['expected_start_date']!=''){
            $date1= str_replace('/', '-',$_POST['ProductionOrder']['expected_start_date']);

            $model->expected_start_date=date("Y-m-d", strtotime($date1));
            }
            if($_POST['ProductionOrder']['expected_end_date']!=''){
            $date2= str_replace('/', '-',$_POST['ProductionOrder']['expected_end_date']);
            // echo $date2;exit;
            $model->expected_end_date=date("Y-m-d", strtotime($date2));
            }
            $valid = $model->validate();

            $p = 0;
             if (is_array($_POST['ProductionOrderBomDetails'])) {

                foreach ($_POST['ProductionOrderBomDetails'] as $i => $item) { 
                    
                    /*echo '<pre>';
                    print_r($item);*/
                    
                    if ($item['product_id'] > 0) {
                         $modelOrderItem[$p] = new ProductionOrderBomDetails();
                        $modelOrderItem[$p]->product_id             = $item['product_id'];
                        $modelOrderItem[$p]->product_name           = $item['product_name'];
                        $modelOrderItem[$p]->product_description    = $item['product_description'];
                        $modelOrderItem[$p]->unit_id                = $item['unit_id'];
                        $modelOrderItem[$p]->quantity               = $item['quantity'];
                        $modelOrderItem[$p]->available_qty          = $item['available_qty'];
                        $modelOrderItem[$p]->cost_rate              = $item['cost_rate'];
                        $modelOrderItem[$p]->bom_qty                = $item['bom_qty'];
                        $valid = $modelOrderItem[$p]->validate() && $valid;
                        $p++;
                    }
                }
            }
            // saving to requisition

            $p = 0;

            if (is_array($_POST['ProductionOrderRequsition'])) {
                foreach ($_POST['ProductionOrderRequsition'] as $i => $item) { 
                     if ($item['product_name'] !='') {
                        $modelRequsitionItem[$p] = new ProductionOrderRequsition();
                        $modelRequsitionItem[$p]->product_id             =  $item['product_id'];
                        $modelRequsitionItem[$p]->product_name           =  $item['product_name'];
                        $modelRequsitionItem[$p]->product_description    =  $item['product_description'];
                        $modelRequsitionItem[$p]->unit_id                =  $item['unit_id'];
                        $modelRequsitionItem[$p]->unit_name              =  $item['unit_name'];;
                        $modelRequsitionItem[$p]->quantity               =  $item['quantity'];
                        $modelRequsitionItem[$p]->supplier_name          =  $item['supplier_name'];
                        $modelRequsitionItem[$p]->purchase_order_no      =  $item['purchase_order_no'];
                        $modelRequsitionItem[$p]->po_component_id        =  $item['po_component_id'];
                        if(!empty($item['requisition_flag'])){
                            $modelRequsitionItem[$p]->requisition_flag       =  $item['requisition_flag'];
                        }
                        else{
                            $modelRequsitionItem[$p]->requisition_flag       =  'N';
                        }
                        if($item['expected_date']!=''){
                            $expected_date = str_replace("/", "-", $item['expected_date']);
                            $modelRequsitionItem[$p]->expected_date = date('Y-m-d', strtotime($expected_date));
        
                            $modelRequsitionItem[$p]->updated_by  = Yii::app()->user->id;
                            $modelRequsitionItem[$p]->updated_date_time = date('Y-m-d h:i:s');
                            $modelRequsitionItem[$p]->created_by = Yii::app()->user->id;
                            $modelRequsitionItem[$p]->created_date_time = date('Y-m-d h:i:s');
                        }
                            $p++;
                        }
                    }
            }
            // code end
            
   //print_r( $modelOrderItem);exit;
            $valid = $valid && !empty($modelOrderItem[0]->product_id);
            if ($valid) {
                $model->save();
                
                if(!empty($modelOrderItem)){
                    ProductionOrderBomDetails::model()->deleteAll('production_order_id=:refer_id', array(':refer_id' => $model->id));
                    foreach ($modelOrderItem as $eachModel) {
                        $eachModel->production_order_id = $model->id;
                        $eachModel->save(false);
                    }
                }
                
                 if(!empty($modelRequsitionItem)){
                    //print_r($modelRequsitionItem);
                    ProductionOrderRequsition::model()->deleteAll('production_order_id=:refer_id', array(':refer_id' => $model->id));
                    foreach ($modelRequsitionItem as $eachRequsitionModel) {
                        $eachRequsitionModel->production_order_id = $model->id;
                        $eachRequsitionModel->save(false);
                    }
                }

                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);

                if (!empty($modelOrderItem[0]->product_id))
                    $error2 = json_decode(CActiveForm::validateTabular($modelOrderItem, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";

                $error = CJSON::encode(array_merge_recursive($error1, $error2));

                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionUpdateJobStatus() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');

        $model = new ProductionOrderDetails();
        $model = $model->findByPk($id);
        if ($status == 'Y') {
            $model->actual_start_date = date('Y-m-d');
            $result = "success";
        } elseif ($status == 'N') {
            $model->actual_end_date = date('Y-m-d');
            $result = "success";
        } elseif ($status == 'R') {
            $model->actual_start_date = date('Y-m-d');
            $model->actual_end_date = "0000-00-00";
            $result = "success";
        } else {
            $model->actual_end_date = date('Y-m-d');
            $result = "fail";
        }
        //echo $model->actual_start_date;exit;
        $model->save();
        echo json_encode(array("status" => $result));
    }

    public function actionProgressList() {

        $model = new ProductionOrder();
        $condition = '1=1';
        // $SQL="SELECT * FROM crm_ProductionOrder INNER JOIN `crm_ProductionOrder_details` on crm_ProductionOrder.id=crm_ProductionOrder_details.ProductionOrder_id
        //         WHERE CURRENT_DATE=start_date OR CURRENT_DATE=actual_start_date ORDER BY crm_ProductionOrder.id";
        //   $model = Yii::app()->db->createCommand($SQL)->queryAll();
        $model = $model->findAll(array('condition' => $condition, 'order' => 't.id'));

        $this->render('ProductionOrder_details_report', array('model' => $model));
    }

    public function actionGetJobs() {
        $type = Yii::app()->request->getparam("type");

        $model = new ProductionOrder();
        $condition = '1=1';

        $model = $model->findAll(array('condition' => $condition, 'order' => 't.id'));

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('process_list', array('model' => $model, 'type' => $type));
    }

    public function actiondeleteProductionOrderRow() {
        $id = (int) Yii::app()->request->getparam("id");
        $modelProductionOrderDet = new ProductionOrderDetails();
        if ($id > 0) {
            $modelProductionOrderDetbyID = $modelProductionOrderDet->findByPk($id);
            $modelProductionOrderDet->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionProductionOrderDetailList() {

        $this->render('index_ProductionOrder_details');
    }

    public function actionGetProductionOrderDeailList() {
        $model = new ProductionOrderDetails();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.ProductionOrder_id',
            2 => 't.category_id',
            3 => 't.process_name',
            4 => 't.quantity',
            5 => 't.start_date',
            6 => 't.end_date',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "1=1";
        if (isset($_POST['job_status']) && $_POST['job_status'] != "") {
            $select_status = $_POST['job_status'];

            if ($select_status == 'T') {
                $condition .= "  AND (start_date=CURRENT_DATE  OR actual_start_date=CURRENT_DATE)";
            } else if ($select_status == 'P') {
                $condition .= "  AND (actual_start_date < CURRENT_DATE AND actual_start_date!='0000-00-00')";
            }
        }
        if (isset($_POST['job_filter']) && $_POST['job_filter'] != "") {
            $select_filter_status = $_POST['job_filter'];

            if ($select_filter_status == 'L') {
                $condition .= "  AND (actual_start_date!='0000-00-00' AND actual_end_date='0000-00-00'  )";
            } else if ($select_filter_status == 'C') {
                $condition .= "  AND (actual_end_date !='0000-00-00' AND actual_start_date!='0000-00-00')";
            } else if ($select_filter_status == 'O') {
                $condition .= "  AND  ( end_date <= CURRENT_DATE AND actual_end_date ='0000-00-00')";
            } else if ($select_filter_status == 'P') {
                $condition .= "  AND (start_date <= CURRENT_DATE
                AND actual_start_date='0000-00-00')";
            }
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (ProductionOrder_det.ref_no LIKE '%" . $searchString . "%' OR category_det.level1_category_name LIKE '%" . $searchString . "%' OR
            process_det.process_name LIKE '%" . $searchString . "%' OR t.quantity LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('process_det', 'category_det', 'ProductionOrder_det')->count(array('condition' => $condition));
        $model = $model->with('process_det', 'category_det', 'ProductionOrder_det')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            $color = '';
            if ($row->start_date != "0000-00-00" && $row->actual_start_date == "0000-00-00") {
                $color = "cls-light-red";
                $div .= ' <a href ="#" class="
                btn btn-success btn-xs" onclick="start_job(\'' . $row->id . '\',\'Y\' )"><i class="fa fa-toggle-on" title="Start Job"></i></a>';
            }
            // if($row->actual_start_date!="0000-00-00")
            if ($row->actual_end_date == "0000-00-00" && $row->actual_start_date != "0000-00-00") {
                $color = "cls-yellow";
                $div .= '<a href ="#" class="btn btn-danger btn-xs" onclick="end_job(\'' . $row->id . '\',\'N\' )"><i class="fa fa-ban" title="End Job"></i></a>';
                $div .= '  <a href ="#" class="btn btn-success btn-xs" onclick="restart_job(\'' . $row->id . '\',\'R\' )"><i class="fa fa-toggle-on" title="Restart Job"></i></a>';
            }
            if ($row->actual_end_date != "0000-00-00" && $row->actual_start_date != "0000-00-00") {
                $color = "cls-light-green";
                $div .= '<a style="cursor: auto;" href ="#" class="btn btn-info btn-xs"><i class="fa fa-ban" title="Job Done"></i></a>';
            }
            $start_date = date("d/m/Y", strtotime($row->start_date));
            $end_date = date("d/m/Y", strtotime($row->end_date));
            $rowData[] = array(
                $m,
                $row->ProductionOrder_det->ref_no,
                $row->category_det->level1_category_name,
                $row->process_det->process_name,
                $row->quantity,
                $start_date,
                $end_date,
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row->id, 'color' => $color)
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionProductionOrderReportPdf() {
        $id = Yii::app()->request->getParam('id');

        $model = new ProductionOrder();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        //$stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML('', 1);
        $param = array('model' => $model);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.production.views.productionorder.pdf.customer_production_orderpdf', $param, true));
        $mPDF1->Output("Customer Production Order Details.pdf", 'I');
    }


     public function actionProductionOrderBOMReportPdf() {
       
        $id = Yii::app()->request->getParam('id');

        $model = new ProductionOrder();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $param = array('model' => $model);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.production.views.productionorder.pdf.customer_stockpdf', $param, true));
        $mPDF1->Output("Customer Stock Details.pdf", 'I');
    }

}
