<?php

class GoodsReceiptController extends Controller
{


	 public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails','Updatedefaulthrs'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetGoodsReceipt','CreateGoodsReceipt','SaveGR'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

	public function actionIndex()
	{
		$this->render('index');
	}

	    public function actionGetGoodsReceipt() {
        $model = new ProductionGoodsReceipt();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'order.id',
            2 => 't.product_name',
            3 => 't.description',
            4 => 't.quantity',
            5 => 'order.productionorder_date',
            6 => 'order.end_date',
            7 => 't.id',
            
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1 AND is_updated_store="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (t.product_name LIKE '%" . $searchString . "%' OR t.description LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('order')->count(array('condition' => $condition));
        $model = $model->with('order')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $current = strtotime(date('y-m-d'));
        foreach ($model as $row)
        {
            $div = '';
           
            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["prod_gr_print"])){
                $div .= ' <a class="btn btn-primary btn-xs" title="Print BOM" target="_blank" href="index.php?r=production/PrintProductionGRPDF&id=' . $row['id'] .' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            }
            
            $rowData[] = array($row['id'],
                $row['order']['id'],
                $row['product_name'],
                $row['description'],
                $row['quantity'],
                date('d/m/Y',strtotime($row['order']['productionorder_date']))
                ,date('d/m/Y',strtotime($row['order']['end_date'])),
                '<div class="btn-wrap text-center">'.$div.'</div>',
                array('id' => $row['id'],'code'=>'Goods receipt print'));
          
        } 
        
        $data['data'] = $rowData;
        echo json_encode($data);
    
    }

    public function actionCreateGoodsReceipt(){
        $model = new ProductionGoodsReceipt();
        $modelItems = array(new ProductionGoodsReceiptItem());
        $modelGoodsIssueReturn = array(new ProductionGoodsIssueReturnItem());
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create', array('model' => $model,'modelItems' =>$modelItems,'modelGoodsIssueReturn'=>$modelGoodsIssueReturn));
    }
    
    public function actionSaveGR() {
        $model = new ProductionGoodsReceipt();
        if (isset($_POST['ProductionGoodsReceipt'])) {
            if((int) @$_POST['ProductionGoodsReceipt']['id'] > 0){
                $model = $model->findByPK($_POST['ProductionGoodsReceipt']['id']);
                $audit_type = 'UPDATED';
            }else{
                $model->crm_user_id = Yii::app()->user->id;
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime = date('Y-m-d h:i:s');
                $audit_type = 'CREATED';    
            }
            $model->attributes          = $_POST['ProductionGoodsReceipt'];
            $model->product_name          = $_POST['ProductionGoodsReceipt']['product_name'];
            $model->notes               =  $_POST['ProductionGoodsReceipt']['notes'];
            $model->remarks             =  $_POST['ProductionGoodsReceipt']['remarks'];
            $model->reference           =  $_POST['ProductionGoodsReceipt']['reference'];
            $model->variants      =  $_POST['ProductionGoodsReceipt']['variants'];
            $model->terms_and_conditions       =  $_POST['ProductionGoodsReceipt']['terms_and_conditions'];
            if($_POST['ProductionGoodsReceipt']['goods_receipt_date']!='')
            {
                    $model->goods_receipt_date = str_replace('/', '-', $_POST['ProductionGoodsReceipt']['goods_receipt_date']);
                    $model->goods_receipt_date= date("Y-m-d", strtotime($model->goods_receipt_date));
            }
           
            $model->updated_by  = Yii::app()->user->id;
            $model->updated_datetime = date('Y-m-d h:i:s');
            $valid = $model->validate();
            if (!empty($_POST['ProductionGoodsReceiptItem'])) {
                $other_errors=array();
                 foreach ($_POST['ProductionGoodsReceiptItem'] as $k => $rowItem) {
                    if(empty($rowItem['id']))
                    {
                         $modelItem[$k] = new ProductionGoodsReceiptItem();
                         $modelItem[$k]->created_by = Yii::app()->user->id;
                         $modelItem[$k]->created_datetime = date('Y-m-d h:i:s');
                    }else{
                        $modelItem[$k] = ProductionGoodsReceiptItem::model()->findByPk($rowItem['id']);
                    }
                    $modelItem[$k]->attributes = $_POST['ProductionGoodsReceiptItem'][$k];                    
                    $modelItem[$k]->production_goods_receipt_id = 0;
                    $modelItem[$k]->updated_by  = Yii::app()->user->id;
                    $modelItem[$k]->updated_datetime = date('Y-m-d h:i:s');
                    $modelItem[$k]->product_id =$rowItem['product_id'];
                    $valid = $modelItem[$k]->validate() && $valid; 
                }      
            } 
            if (!empty($_POST['ProductionGoodsIssueReturnItem'])) {
                 foreach ($_POST['ProductionGoodsIssueReturnItem'] as $z => $rowItemReturn) {  
                    if($rowItemReturn['return_qty']>0){
                        if(empty($rowItemReturn['id'])){
                             $modelItem_return[$z] = new ProductionGoodsIssueReturnItem();
    
                        }else{
    
                          $modelItem_return[$z] = ProductionGoodsIssueReturnItem::model()->findByPk($rowItemReturn['id']);
    
                        }
    
                        $modelItem_return[$z]->attributes = $_POST['ProductionGoodsIssueReturnItem'][$z];
                        $modelItem_return[$z]->po_item_id = $rowItemReturn['po_item_id'];                       
                        $modelItem_return[$z]->product_id = $rowItemReturn['product_id'];
    
                        $modelItem_return[$z]->product_name  = $rowItemReturn['product_name'];
    
                        $modelItem_return[$z]->description = $rowItemReturn['description'];
                        
                        $modelItem_return[$z]->quantity = $rowItemReturn['quantity'];
    
                        $modelItem_return[$z]->return_qty =$rowItemReturn['return_qty'];
                        
                        $modelItem_return[$z]->rate =$rowItemReturn['rate'];
                        
                        $modelItem_return[$z]->amount =$rowItemReturn['amount'];
    
                        $modelItem_return[$z]->unit =$rowItemReturn['unit'];    
                    }

                }

            }           
            if ($valid){ 
              
                if($model->save())
                {
                   
                    AuditLog::saveAuditLogs(
                        'GOODS_RECEIPT',
                        Yii::app()->user->id,
                        $audit_type,
                        " with Checking No: - {$model->id}  "
                    );
                    $row    = $_POST['ProductionGoodsReceipt']['production_order_id'];
                  //  $rowid  = $_POST['ProductionGoodsReceipt']['rowid'];                    
                      ProductionOrder::model()->updateByPk($row, array('goods_receipt_id' => $model->id));
                    $sum = 0;
                    if (!empty($modelItem)) {
                        foreach ($modelItem as $eachItem) {
                            $eachItem->production_goods_receipt_id = $model->id;
                            $sum += $eachItem->amount;
                            $eachItem->save();
                          //  ProductionOrderBomDetails::model()->updateByPk($row, array('goods_receipt_item_id' => $eachItem->id));
                        }
                    }
                    
                    //ProductionOrderBomDetails::model()->updateAll( array('goods_receipt_item_id' => $eachItem->id,'invoice_id IN(' . $model->id . ')'));

                    if (!empty($modelItem_return)) {
                        foreach ($modelItem_return as $eachReturnItem) {   
                            $eachReturnItem->production_goods_receipt_id = $model->id;
                            $eachReturnItem->save(false);
                          //  ProductionOrder::model()->updateByPk($row, array('goods_receipt_id' => $eachReturnItem->id));                                                       
                        }
                    }
                   
                   
                    $model->updateByPk($model->id, array('grand_total' => $sum));
                    
                    $jsonData['id'] = $model->id;
                    $jsonData['po'] = $model->findByPk($model->id);
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                }
            }
            else   //$model_stock_item_issue
            {
                $error1 = array();$error2 =array();
                $error3 =array();
                $error4 =array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                
                if ($modelItem[0]->product_id != '')
                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                else
                    $error2[] = "Please add atleast one item ".$modelItem[0]->product_id;
                $error = CJSON::encode(array_merge_recursive($error2,$error1,$error3,$error4));
                if ($error != '[]')
                    echo $error;
            }
        }
    }



	
}