<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadData", '
    function filterDataTable(date_from,date_to,team_employee_id)
    {
        var table_id ="#tbl_teamleavae_history_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/teamleavebalance/GetLeaveHistory') . '",
                type: "POST",
                cache : false,
                "data" : {
                    "from_date" : date_from,
                    "date_to" : date_to,
                    "team_employee_id" : team_employee_id,
            },
            },
             "columnDefs": [
                { "orderable": false, "targets": [0,1,2,3,4,7,8,9] }
            ],
            order: [[ 5, "desc" ]],
            serverSide:     true,
            fixedColumns:   true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
             } );
        $(".dataTables_scrollFoot").hide();
        }
        $(document).ready(function() { 
        var team_employee_id    = $("#employee_team_id_leave").val();
        var from_date    = $("#team_from_date").val();
        var date_from = from_date.split("/").reverse().join("-");
        var to_date    = $("#team_to_date").val();
        var date_to = to_date.split("/").reverse().join("-");
      filterDataTable(date_from,date_to,team_employee_id);
    });', CClientScript::POS_HEAD);
$cs->registerScript("loadTeamHistory", "function loadTeamHistory(){  
    $('#tbl_teamleavae_history_details').DataTable().destroy();
        var team_employee_id    = $('#employee_team_id_leave').val();
        var from_date    = $('#team_from_date').val();
        var date_from = from_date.split('/').reverse().join('-');
        var to_date    = $('#team_to_date').val();
        var date_to = to_date.split('/').reverse().join('-');
    filterDataTable(date_from,date_to,team_employee_id);
};", CClientScript::POS_HEAD);
$empid = User::model()->findbypk(Yii::app()->user->id)->employee_id;
?>
<style>
    #employeeteambalanceindexdropdown .material-select-label {
        display: none;
    }
</style>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        Team Leave History
        <div class="pull-right dis-flx">
            <div class="material col-sm-12 pd-zero" id="employeeteambalanceindexdropdown">
                <span class="col-sm-3 pull-right"> 
                    <?php echo CHtml::dropdownlist('employee_team_id_leave', '', Employee::getsubordinateemployees($empid), array('empty' => 'All Employees', 'title' => 'Please Select Employee', 'data-search' => true,'onchange'=>'loadTeamHistory();')); ?>                   
                </span>
            </div>   
            <div class="col-sm-3 pd-zero">     
                <?php echo CHtml::textField('team_to_date', date("31/12/Y"), array('class' => 'datepicker col-sm-2 form-control_1', 'data-label' => 'Date')); ?>          
            </div>
            <div class="col-sm-3 pd-zero">         
                <?php echo CHtml::textField('team_from_date', date("01/01/Y"), array('class' => 'datepicker col-sm-2 form-control_1', 'data-label' => 'Date')); ?>            
            </div>  
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_teamleavae_history_details" style="font-size: 11px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Code</th>
                        <th>Name</th> 
                        <th>Type of Leave</th>
                        <th>Apply Date</th>
                        <th>From Date</th>  
                        <th>To Date</th> 
                        <th>Days</th>                                                    
                        <th>Status</th>                                                    
                        <th>Leave Reason</th>  
                    </tr>
                </thead>
            </table>
        </div>

    </div>
</section>
<script type="text/javascript">
    $(function () {
        $('#team_from_date').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.change', function (e) {
            $('#team_to_date').data('DateTimePicker').minDate(e.date);  
            loadTeamHistory();
        });
        $('#team_to_date').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.change', function (e) {
            $('#team_from_date').data('DateTimePicker').maxDate(e.date);  
            loadTeamHistory();
        });
    });
</script>