<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadData", 'function filterDataTable() {
        var table_id ="#tbl_teamleave_balance_details";
        var employee_id = $("#employee_id_leave").val();
        var table = $(table_id).DataTable({
            scrollY         : "645px",
            pageLength      : 50,
            processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/teamleavebalance/GetList') . '",
                type: "POST",
                data : {
                    "employee_id":employee_id               
                },
                cache : false,
            },
            columns: [            
                {className: "" },
                {className: ""},
                {className: "" },
                {className: ""}, 
                {className: "text-right"}
            ],
            "columnDefs": [
                { "orderable": false, "targets": [0,1,4] }
            ],
            order: [[ 2, "asc" ], [3, "asc"]],
            serverSide:     true,
            fixedColumns:   true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        });
        $(".dataTables_scrollFoot").hide();
    }
    $(document).ready(function() {  		
        filterDataTable();
        $("#grid_sort_by").on("change", function () {
        var table = $("#tbl_teamleave_balance_details").DataTable();
        var sortBy = $(this).val();
        if (sortBy == 2) {
            table.order([[2, "asc"], [3, "asc"]]).draw();
        } else if (sortBy == 3) {
            table.order([[3, "asc"], [2, "asc"]]).draw();
        }
        });
         materializing(".material");   
    })', CClientScript::POS_HEAD);
$cs->registerScript("leavebalancedetails", "function leavebalancedetails(){  
    $('#tbl_teamleave_balance_details').DataTable().destroy();
    filterDataTable();  
};", CClientScript::POS_HEAD);
$cs->registerScript("sortleavebalance", "function sortleavebalance() {
    var sortBy = $('#grid_sort_by').val();
    var table = $('#tbl_teamleave_balance_details').DataTable();
    if (sortBy == 2) {
        // Sort by Employee column
        table.order([[2, 'asc'], [3, 'asc']]).draw();
    } else if (sortBy == 3) {
        // Sort by Leave Type column
        table.order([[3, 'asc'], [2, 'asc']]).draw();
    }
};", CClientScript::POS_HEAD);
$empid = User::model()->findbypk(Yii::app()->user->id)->employee_id;
?>
<style>
    #employeeleavebalanceindexdropdown .material-select-label {
        display: none;
    }
</style>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-calendar"></i> Leave Balance
        <div class="pull-right dis-flx">
            <div class="material col-sm-12 pd-zero" id="employeeleavebalanceindexdropdown">
                <span class="col-sm-3 pull-right">
                    <?php echo CHtml::dropdownlist('grid_sort_by', 2, array(2 => 'Sort By Employee', 3 => 'Sort By Leave Type'), array('title' => 'Employee Status', 'data-search' => true)); ?>                   
                </span>
                <span class="col-sm-4 pull-right">
                    <?php echo CHtml::dropdownlist('employee_id_leave', '', Employee::getsubordinateemployees($empid), array('empty' => 'All Employees', 'title' => 'Please Select Employee', 'onchange' => 'leavebalancedetails();', 'data-search' => true)); ?>                   
                </span>
            </div>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_teamleave_balance_details" style="font-size: 11px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Code</th>
                        <th>Name</th> 
                        <th>Leave Type</th> 
                        <th>Balance</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>