<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("deleteShift", "function deleteShift(id){
    var r = confirm('Are you sure to delete this?');
    if(r==true)
    {
        jQuery.ajax({
            'type'  : 'post',
            'dataType':'json',
            'data'  : 'id=' + id,
            'url'  : $('#liveSite').val()+'index.php?r=hr/shift/DeleteShift',
            'cache': false,
            'success':function(data){
                  if(data.status=='success'){ 
                      t8.success('Deleted SuccessFully!');
                      reloadTable('#tbl_shift_time_details');
                  }else{
                      t8.error('Error while Delete');
                  }

             }
        });
    }
};", CClientScript::POS_HEAD);
$cs->registerScript("loaddata", 'function filterDataTable(){
        var shift_id= $("#shift_id").val();
        var employee_id= $("#shift_employee_id").val();	
        var table_id ="#tbl_shift_time_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
//            scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/shift/GetList') . '",
                type: "POST",
                "data" : {
                    "shift_id" : shift_id,"employee_id" : employee_id           
                },
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,  
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        });
        $(".dataTables_scrollFoot").hide();
    }	
    $(document).ready(function() {  	 	
        filterDataTable();
         materializing(".material"); 
    });', CClientScript::POS_HEAD);
$cs->registerScript("employeeshiftdetails", "function employeeshiftdetails(){  
    $('#tbl_shift_time_details').DataTable().destroy();
    filterDataTable(); 
};", CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[7].edit_shift !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/shift/editshift&id=" + datas[7].id, 'Edit Shift Details', "xl");
                }
            };
        }
        if (datas[7].view_shift !== 0) {
            items.view = {
                name: "View",
                icon: "fa-eye",
                callback: function () {
                    loadPopupModal("hr/shift/viewshift&id=" + datas[7].id, "View Shift Details", "xl");
                }
            };
        }
        if (datas[7].delete !== 0) {
            items.delete = {
                name: "Delete",
                icon: "fa-trash-o",
                callback: function () {
                    deleteShift(datas[7].id);
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<style>
    #employeeshiftindexdropdown .material-select-label {
        display: none;
    }
</style>
<?php
$model_upload_shift = HrMasterUpload::model()->findByPK(12);
?>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">Shift
        <div class="pull-right dis-flx">
            <div class="material col-sm-12 pd-zero" id="employeeshiftindexdropdown"> 

                <span class="col-sm-3 pull-right"> 
                    <?php echo CHtml::dropdownlist('shift_employee_id', '', Employee::getEmployee(), array('empty' => 'All Employees', 'title' => 'Please Select Employee', 'data-search' => true, 'onchange' => 'employeeshiftdetails();', 'style' => 'width:150px;')); ?>                                                  
                </span>
                <span class="col-sm-3 pull-right">         
                    <?php echo CHtml::dropdownlist('shift_id', '', MasShift::getShift(), array('empty' => 'All Shift', 'title' => 'Please Select Shift', 'data-search' => true, 'onchange' => 'employeeshiftdetails();', 'style' => 'width:100px;')); ?>                   
                </span>
            </div>
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_att_employee_shift_add']) || Yii::app()->user->authorised_user == 1) { ?>
                <a class="ad-btn" style=" position: relative;top: 5px;" onclick="loadPopupModal('hr/shift/create', 'Add New Shift', 'lg')" title="Add">
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
                <?php
            }
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_att_employee_shift_upload']) || Yii::app()->user->authorised_user == 1) && ($model_upload_shift->isActive == 'Y')) {
                ?>
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/shift/uploadshift', 'Upload Shift', 'lg')" title="Upload Shift Details"><i class="fa fa-upload"></i></button>  
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_shift_time_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Branch</th>
                        <th>Shift</th>
                        <th>From Date</th>
                        <th>To Date</th>
                        <th>Start Time</th>
                        <th>End Time</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
