<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'employee-shift-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material" id="shiftDropdown">
                <li class="col-sm-3">                     
                    <?php echo CHtml::dropdownlist('branch_id','',MasCompanyBranchSponsor::getCompanyBranches(),  array('prompt' => '--Select--','class' => 'tooltipster', 'title' => 'Please select Branch','data-search' => true,'data-label'=>'Branch<span style="color : red;"> * </span>')); ?>
                </li>
                <li class="col-sm-3">                       
                    <?php echo CHtml::dropdownlist('branch_shift_id','',MasShift::getShift(),  array('prompt' => '--Select--','class' => 'tooltipster', 'title' => 'Please select Shift','data-search' => true,'data-label'=>'Shift<span style="color : red;"> * </span>','onchange'=>'getshiftime(this.value);')); ?>
                </li>
                <li class="col-sm-3">                       
                    <?php echo CHtml::textField('shift_from_date','',array('class' => 'tooltipster datepicker', 'title' => 'Please select Date','data-label'=>'From Date<span style="color : red;"> *</span>','onkeypress' => 'return false;')); ?>
                </li>
                <li class="col-sm-3">                       
                    <?php echo CHtml::textField('shift_to_date','',array('class' => 'tooltipster datepicker', 'title' => 'Please select Date','data-label'=>'To Date<span style="color : red;"> *</span>','onkeypress' => 'return false;')); ?>
                </li>
                <li class="col-sm-3">                       
                    <?php echo CHtml::textField('shift_start_time','',array('class' => 'tooltipster', 'title' => 'Shift Start Time','data-label'=>'Shift Start Time','readonly'=>true)); ?>
                </li>
                <li class="col-sm-3">                       
                    <?php echo CHtml::textField('shift_end_time','',array('class' => 'tooltipster', 'title' => 'Shift End Time','data-label'=>'Shift End Time','readonly'=>true)); ?>
                </li>
                <li class="col-sm-4">                       
                    <a href="javascript:void(0);" onclick="loademployeeshift();" class="btn btn-primary">Load</a>
                </li>
            
            </ul>

        </div>
        <div class="clear"></div>
        <div class="box-1" id="div_shift"></div>
    </div>




<?php $this->endWidget(); ?>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loademployeeshift", "function loademployeeshift() {
        var from_date = $('#shift_from_date').val();
        var date_from = from_date.split('/').reverse().join('-');
        var to_date = $('#shift_to_date').val();
        var to_date = to_date.split('/').reverse().join('-');
        var shift_id  = $('#branch_shift_id').val();
        
        var branch_id  = $('#branch_id').val();
        if(date_from!='' && shift_id !='' && branch_id !='' && to_date !=''){
            
            jQuery.ajax({
                'data' : {
                    'from_date':date_from,
                    'to_date':to_date,
                    'shift_id':shift_id,
                    'branch_id':branch_id
                },
                'type':'post',
                'url': '" . Yii::app()->createUrl('hr/shift/loademployeeshift') . "',
                'cache': false,
                'success': function(data) {
                    $('#div_shift').html(data);
                },
                'beforeSend':function(){                         
                    $('#loader').show();
                },
                'complete':function(){
                    $('#loader').hide();
                }  
        });
        }else{
            t8.error('Select all required field');
        }
    };", CClientScript::POS_HEAD);
$cs->registerScript("getshiftime", "function getshiftime(shift_id) {
    jQuery.ajax({
            'data' : {'shift_id':shift_id},
            'type':'post',
            'dataType':'json',
            'url': '" . Yii::app()->createUrl('hr/shift/getshiftime') . "',
            'cache': false,
            'success': function(data) {
                $('#shift_start_time').val(data.starttime);
                $('#shift_start_time').addClass('filled');
                $('#shift_end_time').val(data.endtime);
                $('#shift_end_time').addClass('filled');
            },
            'beforeSend':function(){                         
                $('#loader').show();
            },
            'complete':function(){
                $('#loader').hide();
            }  
    });
};", CClientScript::POS_HEAD);
$cs->registerScript("Checkstartdate", "
    $('#shift_from_date').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.change', function (e) {
        $('#shift_to_date').data('DateTimePicker').minDate(e.date);
        $('#shift_to_date').addClass('filled'); 
});", CClientScript::POS_HEAD);
?>

<script>
$(function(){
    materializing(".material");  
})
</script>








