<?php
date_default_timezone_set("Asia/Dubai");
Yii::import('application.modules.finance.models.*');
?>
<div class="table-responsive">
    <table id="salarypayment_creation_slip_table" class="table table-hover table-bordered personal-task" >
        <tr>   
            <th rowspan="2"><input type="checkbox" id="checksifAll"></th>
            <th class="text-center" rowspan="2">No</th>
            <th class="text-center"rowspan="2">Branch</th>
            <th class="text-center" rowspan="2">Employee Code</th>
            <th class="text-center" rowspan="2">Name</th> 
            <th class="text-center" colspan="7">Salary</th>  
            <th class="text-center" rowspan="2">Amount</th>  
            <?php
            if($type==2){
                ?>
            <th class="text-center" rowspan="2">Bank</th>  
            <?php
            }
            ?>
        </tr>
        <tr>
            <th class="text-center">Total</th> 
            <th class="text-center">Cash</th>
            <th class="text-center">Cheque</th>
            <th class="text-center">WPS</th>
            <th class="text-center">Exchange</th>
            <th class="text-center">Bank</th>
            <th class="text-center">Due</th>
        </tr>
        <?php
        if (!empty($arr_employee)) {
            $count_employee=0;
            $total_month_salary=0.00;
            $s=0;
            $salary_processing_id=0;
            $salary_month="";
            foreach ($arr_employee as $each) {
                $model_employee = Employee::model()->findByPK($each);   
                //Salary            
                $model_salary_slip= SalarySlip::model()->with('processing')->find(array('condition' => 'processing.payroll_status="2" and t.employee_id="'.$model_employee->id.'" and MONTH(processing.payroll_enddate)="'.$month.'" and YEAR(processing.payroll_enddate)="'.$year.'"'));
                if(!empty($model_salary_slip) && $model_salary_slip->id>0){
                    $employee_total_salary=$model_salary_slip->total_salary_amount; //Current Month total salary
                    $model_salary_sif_exist= MonthlySalarySifDetails::model()->with('salarysif')->find(array('select'=>'sum(total_salary_paid) as total_salary_paid','condition' => 'employee_id="'.$model_employee->id.'" and start_date="'.$model_salary_slip->processing->payroll_startdate.'" and end_date="'.$model_salary_slip->processing->payroll_enddate.'"'));
                    $salary_already_transfered=0.00;
                    if(!empty($model_salary_sif_exist)){
                    $salary_already_transfered=$model_salary_sif_exist->total_salary_paid; //current month total transfered salary
                    }
                    $salary_processing_id=$model_salary_slip->processing->id; //Salary Processing table id
                    $salary_month=$model_salary_slip->processing->payroll_month; //Salary Processing month
                    $pending_salary=0.00;
                    if(!empty($salary_already_transfered) && $salary_already_transfered>0){
                        $pending_salary=$employee_total_salary-$salary_already_transfered;
                    }else{
                        $pending_salary=$employee_total_salary;
                    }
                    if($pending_salary>0){
                        if($model_salary_slip->processing->payroll_startdate!='' && $model_salary_slip->processing->payroll_startdate!='0000-00-00'){
                            $payroll_start=$model_salary_slip->processing->payroll_startdate;
                        }
                        if($model_salary_slip->processing->payroll_enddate!='' && $model_salary_slip->processing->payroll_enddate!='0000-00-00'){
                            $payroll_end=$model_salary_slip->processing->payroll_enddate;
                        }
                    ?>
                    <tr>
                        <td>
                            <input type="checkbox" name="arraycid[]" class="payment_checkbox" value="<?php echo $model_employee->id;?>" onclick="showhidesavebutton(); setunsettextfield(<?php echo $s; ?>);" id="checkbox_<?php echo $s; ?>">
                        </td>
                        <td><?php echo($s + 1); ?></td>
                        <td><?php echo $model_employee->branch_sponsor->branch_or_sponsor_name; ?></td>
                        <td><?php echo $this->ciphertext($model_employee->employee_code, "d"); ?></td>
                        <td><?php echo $this->ciphertext($model_employee->first_name, "d") . " " . $this->ciphertext($model_employee->last_name, "d"); ?></td>
                        <td class="text-right"><?php 
                        echo Yii::app()->numberFormatter->formatCurrency($employee_total_salary, " "); 
                        ?></td>
                        <td class="text-right"><?php 
                        $model_salary_cash= MonthlySalarySifDetails::model()->with('salarysif')->find(array('select'=>'sum(total_salary_paid) as total_salary_paid','condition' => 'employee_id="'.$model_employee->id.'" and start_date="'.$model_salary_slip->processing->payroll_startdate.'" and end_date="'.$model_salary_slip->processing->payroll_enddate.'" and salary_payment_mode="1"'));
                        if(!empty($model_salary_cash)){
                        echo Yii::app()->numberFormatter->formatCurrency($model_salary_cash->total_salary_paid, " "); 
                        }
                        ?></td>
                        <td class="text-right"><?php 
                        $model_salary_cheque= MonthlySalarySifDetails::model()->with('salarysif')->find(array('select'=>'sum(total_salary_paid) as total_salary_paid','condition' => 'employee_id="'.$model_employee->id.'" and start_date="'.$model_salary_slip->processing->payroll_startdate.'" and end_date="'.$model_salary_slip->processing->payroll_enddate.'" and salary_payment_mode="2"'));
                        if(!empty($model_salary_cheque)){
                        echo Yii::app()->numberFormatter->formatCurrency($model_salary_cheque->total_salary_paid, " "); 
                        }
                        ?></td>
                        <td class="text-right"><?php 
                        $model_salary_wps= MonthlySalarySifDetails::model()->with('salarysif')->find(array('select'=>'sum(total_salary_paid) as total_salary_paid','condition' => 'employee_id="'.$model_employee->id.'" and start_date="'.$model_salary_slip->processing->payroll_startdate.'" and end_date="'.$model_salary_slip->processing->payroll_enddate.'" and salary_payment_mode="3"'));
                        if(!empty($model_salary_wps)){
                        echo Yii::app()->numberFormatter->formatCurrency($model_salary_wps->total_salary_paid, " "); 
                        }
                        ?></td>
                        <td class="text-right"><?php 
                        $model_salary_exchange= MonthlySalarySifDetails::model()->with('salarysif')->find(array('select'=>'sum(total_salary_paid) as total_salary_paid','condition' => 'employee_id="'.$model_employee->id.'" and start_date="'.$model_salary_slip->processing->payroll_startdate.'" and end_date="'.$model_salary_slip->processing->payroll_enddate.'" and salary_payment_mode="4"'));
                        if(!empty($model_salary_exchange)){
                        echo Yii::app()->numberFormatter->formatCurrency($model_salary_exchange->total_salary_paid, " "); 
                        }
                        ?></td>
                        <td class="text-right"><?php 
                        $model_salary_bank= MonthlySalarySifDetails::model()->with('salarysif')->find(array('select'=>'sum(total_salary_paid) as total_salary_paid','condition' => 'employee_id="'.$model_employee->id.'" and start_date="'.$model_salary_slip->processing->payroll_startdate.'" and end_date="'.$model_salary_slip->processing->payroll_enddate.'" and salary_payment_mode="5"'));
                        if(!empty($model_salary_bank)){
                        echo Yii::app()->numberFormatter->formatCurrency($model_salary_bank->total_salary_paid, " "); 
                        }
                        ?></td>
                        <td><?php echo CHtml::textField("balance_salary_amount[".$s."]",$pending_salary, array('class'=>'form-control text-right','readonly'=>true)); ?>
                        </td>
                        <td>
                            <?php
                                echo CHtml::activetextField($model_sif_details, "[".$s."]salary_amount",array('class'=>'form-control text-right pending_amt','value'=>$pending_salary,'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'checksalaryamount(this.id);','readonly'=>true));
                                echo CHtml::activehiddenField($model_sif_details, "[".$s."]employee_id",array('value'=>$model_employee->id));
                                echo CHtml::activehiddenField($model_sif_details, "[".$s."]personal_file_no",array('value'=>$model_employee->personal_file_no));
                                echo CHtml::activehiddenField($model_sif_details, "[".$s."]iban_no",array('value'=>$model_employee->employee_iban_no));
                                echo CHtml::activehiddenField($model_sif_details, "[".$s."]employee_wpscode",array('value'=>0));
                                echo CHtml::activehiddenField($model_sif_details, "[".$s."]start_date",array('value'=>$payroll_start));
                                echo CHtml::activehiddenField($model_sif_details, "[".$s."]end_date",array('value'=>$payroll_end));
                                echo CHtml::activehiddenField($model_sif_details, "[".$s."]basic_salary",array('value'=>0));
                                echo CHtml::activehiddenField($model_sif_details, "[".$s."]total_days",array('value'=>0));
                                echo CHtml::activehiddenField($model_sif_details, "[".$s."]leave_days",array('value'=>0));
                            ?>
                        </td>               
                        <?php
                        if($type==2){
                            ?>
                        <td>
                            <?php echo CHtml::activeDropdownlist($model_sif_details,"[".$s."]bank_id",MasBank::getbanks(),array('class' => 'form-control class_bank_1','options' => array($bank_id=>array('selected'=>true)))); ?>                      
                        </td>
                        <?php
                        }
                        ?>
                    </tr>
                    <?php
                        $s++;
                    }
                }
            }       
            echo CHtml::activehiddenField($model, "wpscompany_id",array('value'=>0));
            echo CHtml::activehiddenField($model, "salary_processing_id",array('value'=>$salary_processing_id));
            echo CHtml::activehiddenField($model, "salary_month",array('value'=>$salary_month));
            echo CHtml::activehiddenField($model, "salary_payment_mode",array('value'=>$type));
        ?>
        <?php }else{?>
                <tr><th colspan="7" class="text-center">No Data Available</th></tr>
        <?php } ?>
                
    </table> 
</div>    
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="add_paymentfile_close" data-dismiss="modal">Close</button>
    <a href="javascript:void(0);" onclick="savecashchequepayment();" class="btn btn-primary" id="payment_salary_save" style="display: none;">Save</a>
</div>
<?php 
$cs = Yii::app()->getClientScript();
$cs->registerScript("savecashchequepayment", "function savecashchequepayment() {
    jQuery.ajax({
        'dataType':'json',
        'data' : $('#salarysif-form').serialize(),
        'type':'post',
        'url': '" . Yii::app()->createUrl('hr/salarysif/SaveSif') . "',
        'cache': false,
        'success': function(data) {
            if(data.status=='success'){  
                t8.success('Saved Successfully'); 
                $('#add_paymentfile_close').click();
                reloadTable('#tbl_salarysif_details');
            }else{
                $.each(data, function(key, val) {
                    t8.error(''+val+''); 
                }); 
            }
        },
        'beforeSend':function(){                                  
            var emp_count=$('input:checked').size();
            emp_count=emp_count-2;
            if(parseInt(emp_count)==0){
                notification('Select atleast one row','error');
                return false;
            }else{
                $('#loader').show();
            }
        },
        'complete':function(){
            $('#loader').hide();
        }  
    });

};", CClientScript::POS_HEAD);
$cs->registerScript("showhidesavebutton", "function showhidesavebutton() {
    var emp_count=$('#salarypayment_creation_slip_table input:checked').size();
     if(emp_count>0){
         $('#payment_salary_save').show();
     }else{
         $('#payment_salary_save').hide();
     }
    };", CClientScript::POS_HEAD);
 $cs->registerScript("checksalaryamount", "function checksalaryamount(field_id) {
        var arr_fields= field_id.split('_');
        var row_field=arr_fields[1];
        var salary_amount=$('#MonthlySalarySifDetails_'+row_field+'_salary_amount').val();  
        var pending_amount=$('#balance_salary_amount_'+row_field+'').val();  
        if(Number(salary_amount)>Number(pending_amount)){
            $('#MonthlySalarySifDetails_'+row_field+'_salary_amount').val(pending_amount);  
            t8.error('Amount cannot be greater than due amount'); 
        }else if(Number(salary_amount)<0){
            $('#MonthlySalarySifDetails_'+row_field+'_salary_amount').val(pending_amount); 
            t8.error('Amount must be greater than 0'); 
        }
    };", CClientScript::POS_HEAD);
 $cs->registerScript("setunsettextfield", "function setunsettextfield(row_field) {
        var value_checked = document.getElementById('checkbox_'+row_field+'').checked;
        if(value_checked==true){
           $('#MonthlySalarySifDetails_'+row_field+'_salary_amount').attr( 'readonly',false);
        }else{
           $('#MonthlySalarySifDetails_'+row_field+'_salary_amount').attr( 'readonly',true);
        } 
        
    };", CClientScript::POS_HEAD);
?>
<script>
$("#checksifAll").click(function () {
     $('input:checkbox').not(this).prop('checked', this.checked);
     var emp_count=$('#salarypayment_creation_slip_table input:checked').size();
     if(emp_count>0){
         $('.pending_amt').attr( 'readonly',false);
         $('#payment_salary_save').show();
     }else{
         $('.pending_amt').attr( 'readonly',true);
         $('#payment_salary_save').hide();
     }
 });
 </script>

