<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadDetails", '
    $(document).ready(function() {
        var table_id ="#tbl_salary_migration_details";
        var table = $(table_id).DataTable({
            scrollY         : "380px",
            scrollX         : "true",
           //scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
			
            ajax: {
                url: "' . Yii::app()->createUrl('salarymigration/GetSalaryList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }

        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
$cs->registerScript("deletesifdetail",  "function deletesifdetail(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {			
            jQuery.ajax({
              'type'  : 'post',
              'dataType':'json',
              'data'  : 'id=' + id,			  
              'url'  : $('#liveSite').val()+'index.php?r=salarysif/deletesiffile',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){                  
                    reloadTable('#tbl_salarysif_details');
                    t8.success('Deleted SuccessFully!');
                }else {
                     t8.error('Error while Delete');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);
?>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-file-text-o"></i> Salary List
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_salary_migration_add'])  || Yii::app()->user->authorised_user == 1) { ?>
            <?php echo CHtml::link('<i class="fa fa-download"></i>',array('salarymigration/downloadsalarytemplate'), array('target'=>'_blank','class'=>"btn btn-sm btn-theme",'title'=>"Download Salary Details Upload Template"));?>
            <button class="btn btn-sm btn-theme" onclick="loadPopupModal('salarymigration/uploadsalarydetails', 'Upload Salary Details', 'lg')" title="Upload Salary Details"><i class="fa fa-upload"></i></button> 
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_salary_migration_details" style="width: 100%;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Branch</th>
                        <th>Month</th>
                        <th>Year</th>  
                        <th>Total Amount</th>  
                        <th>Actions</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>