<?php

$cs = Yii::app()->getClientScript();

$cs->registerScript("filterDataTablewpsentity", '

    var table;  // Declare a variable to hold the DataTable instance



    function filterDataTablewpsentity(expstatus)

    {

        var table_id = "#tbl_wps_enitity_details";

        var branch_id = "' . $salary_branch_id . '"; // Ensure proper PHP variable embedding here

        var frmdate=$("#from_date").val();

        var todate=$("#to_date").val();



        if (!$.fn.dataTable.isDataTable(table_id)) {

            // Initialize DataTable only if it has not been initialized yet

            table = $(table_id).DataTable({

                pageLength: 50,

                processing: true,

                ordering: false,

                searching: false,

                ajax: {

                    url: "' . Yii::app()->createUrl('hr/salarychecker/GetwpsEntityDetails') . '",

                    type: "POST",

                    data: {"expstatus": expstatus, "branch_id": branch_id, "frmdate": frmdate, "todate": todate},

                    cache: false,

                },

                serverSide: true,

                fixedColumns: true,

                fixedHeader: {

                    headerOffset: $("header.main").outerHeight(),

                },

                autoWidth: false,

                

            });

        } else {

            // If DataTable is already initialized, just reload the data

            table.ajax.reload();

        }



        $(".dataTables_scrollFoot").hide();

    }



    $(document).ready(function() {

        var frmdate=$("#from_date").val();

        var todate=$("#to_date").val();

        filterDataTablewpsentity("",frmdate,todate);  // Initialize the table on page load

    });

', CClientScript::POS_HEAD);





$cs->registerScript("wpsentitydetails", "function wpsentitydetails(expstatus){  

    $('#tbl_wps_enitity_details').DataTable().destroy();

    

    filterDataTablewpsentity(expstatus);

   

};", CClientScript::POS_HEAD);





?>



<?php

// Fetch active employees with their WPS (company/department) info

$employeeModel = new Employee();

$employees = Employee::model()->findAll(array(
    'condition' => 't.isActive = "Y"',
    'with' => array('maswps'),  
));

$finalData = [];
$totalEmployeeCount = 0; // Initialize total employee count

// Initialize payment type counts (including the "All" option)
$paymentTypeCounts = [
    0 => 0,  // All (initialized to 0)
    1 => 0,  // Cash
    2 => 0,  // Cheque
    3 => 0,  // WPS
    4 => 0,  // Exchange
    5 => 0   // Bank
];

foreach ($employees as $employee) {


    $masWps = $employee->maswps; 

    if ($masWps) {
        $wps_company_id = $masWps->id; 
        $wps_company_name = $masWps->company_name;

        // Add new company data if it doesn't exist
        if (!isset($finalData[$wps_company_id])) {
            $finalData[$wps_company_id] = [
                'company_name' => $wps_company_name, 
                'employee_count' => 0, 
                'employees' => [],
                'payment_type_counts' => [0 => 0, 1 => 0, 2 => 0, 3 => 0, 4 => 0, 5 => 0]  // Payment type counts for each company
            ];
        }

        $finalData[$wps_company_id]['employee_count']++;
        $finalData[$wps_company_id]['employees'][] = $employee;

        // Increment total employee count
        $totalEmployeeCount++;

        // Track the payment type for the company
        $paymentType = $employee->payment_type;  // Assuming payment_type is a field in the Employee model
        if (isset($finalData[$wps_company_id]['payment_type_counts'][$paymentType])) {
            $finalData[$wps_company_id]['payment_type_counts'][$paymentType]++;
        }

        // Increment global payment type count
        if (isset($paymentTypeCounts[$paymentType])) {
            $paymentTypeCounts[$paymentType]++;
        }
    }
}

?>



<!-- HTML Table displaying company names, employee counts, and payment type counts -->
<span style="font-weight: bold;">Note :- </span><span style="color: red; font-style: italic; font-weight: bold;">** Below data not based on filtered date</span>
<br><br>

<div class="col-sm-2"></div>
<div class="col-sm-8" style="margin-top:10px">
    <table class="table table-hover table-bordered personal-task">
        <thead>
            <tr>
                <th>WPS Entity</th>
                <th>Employee Count</th>
                <th>Cash</th>
                <th>Cheque</th>
                <th>WPS</th>
                <th>Exchange</th>
                <th>Bank</th>
                <th>All</th> <!-- Added the All column -->
            </tr>
        </thead>
        <tbody>
            <?php foreach ($finalData as $companyData): ?>
                <tr>
                    <td><?=$companyData['company_name']?></td>
                    <td style="text-align:right;"><?= $companyData['employee_count'] ?></td>
                    <td style="text-align:right;"><?= $companyData['payment_type_counts'][1] ?></td> <!-- Cash -->
                    <td style="text-align:right;"><?= $companyData['payment_type_counts'][2] ?></td> <!-- Cheque -->
                    <td style="text-align:right;"><?= $companyData['payment_type_counts'][3] ?></td> <!-- WPS -->
                    <td style="text-align:right;"><?= $companyData['payment_type_counts'][4] ?></td> <!-- Exchange -->
                    <td style="text-align:right;"><?= $companyData['payment_type_counts'][5] ?></td> <!-- Bank -->
                    <td style="text-align:right;"><?= $companyData['payment_type_counts'][0] ?></td> <!-- All -->
                </tr>
            <?php endforeach; ?>

            <!-- Row to display total employee count -->
            <tr style="font-weight: bold;">
                <td>Total</td>
                <td style="text-align:right;"><?= $totalEmployeeCount ?></td>
                <td style="text-align:right;"><?= $paymentTypeCounts[1] ?></td> <!-- Total Cash -->
                <td style="text-align:right;"><?= $paymentTypeCounts[2] ?></td> <!-- Total Cheque -->
                <td style="text-align:right;"><?= $paymentTypeCounts[3] ?></td> <!-- Total WPS -->
                <td style="text-align:right;"><?= $paymentTypeCounts[4] ?></td> <!-- Total Exchange -->
                <td style="text-align:right;"><?= $paymentTypeCounts[5] ?></td> <!-- Total Bank -->
                <td style="text-align:right;"><?= $paymentTypeCounts[0] ?></td> <!-- Total All -->
            </tr>
        </tbody>
    </table>
</div>




<div class="col-sm-2"></div>



<div class="col-sm-12">

    <br/>

    <br/>

    <div id="content_tables" class="content_table10">

    

     <table class="table table-hover table-bordered personal-task" id="tbl_wps_enitity_details" style="font-size:13px;">

                    <thead>

                        <tr>

                           <th>No</th>

                           <th>Branch</th>

                            <th>Employee Code</th>  

                            <th>Employee Name</th>  

                        </tr>

                        </thead>

                    </table>

                </div>

            </div>

<!-- </div> -->



<style>

.dt-right{text-align: right;}

</style>